/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.diagnose.DiagnosticsBoard;
import agent.diagnose.causal.Diagnostics;
import agent.diagnose.diagnosis.Diagnosis;
import agent.diagnose.diagnosis.DiagnosisEvent;
import agent.diagnose.diagnosis.DiagnosisEventListener;
import agent.diagnose.symptom.SymptomEvent;
import agent.diagnose.symptom.SymptomEventListener;
import agent.simplest.Log;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class DiagnosisComponent
implements Serializable,
DiagnosisEventListener,
SymptomEventListener {
    private static int INUM = 0;
    protected static Diagnostics diagnostics;
    protected static DiagnosticsBoard board;
    protected static Log log;
    protected static int FAC_DIAG;
    private Vector instances;
    private Vector children;
    private Vector required;
    private String description;
    protected boolean initd = false;
    private transient Point loc;
    private transient boolean selected;
    private Rectangle rect;
    protected DiagnosisComponent placeholder;
    private ListenerVector listeners = new ListenerVector();
    private String name;
    private int sleep = 0;
    private Vector instancechildren = new Vector();
    private Diagnosis seed = null;
    private Diagnosis diagnosis = null;
    private boolean ev_firing = false;
    private Vector ev_queue = new Vector();
    private Integer ev_lock = new Integer(0);
    private boolean fired = false;

    public DiagnosisComponent() {
        String n = this.getClass().getName();
        this.setName(n.substring(n.lastIndexOf(".") + 1));
    }

    public void setDiagnostics(Diagnostics d) {
        diagnostics = d;
        board = d.board;
        log = d.log;
    }

    public Diagnostics getDiagnostics() {
        return diagnostics;
    }

    public DiagnosticsBoard getBoard() {
        return board;
    }

    public void init() {
        this.instances = new Vector();
        this.children = new Vector();
        this.required = new Vector(5);
        this.description = "No description";
        this.placeholder = this;
        this.addDiagnosisEventListener(diagnostics);
        this.getBoard().addSymptomEventListener(this);
        this.initd = true;
        log.log("New placeholder " + this.getName() + " initialized " + this.initd, 4, FAC_DIAG);
    }

    public void initInstance(DiagnosisComponent d) {
        if (d.isPlaceholder()) {
            this.placeholder = d;
            this.instances = this.placeholder.instances;
            this.children = this.placeholder.children;
            this.description = this.placeholder.description;
            this.required = this.placeholder.required;
            this.name = this.name + "_" + INUM++;
            this.sleep = 0;
            log.log("New instance " + this.getName() + " initialized", 4, FAC_DIAG);
        } else {
            System.err.println("Error: Non-placeholder node used to init instance");
        }
    }

    public synchronized void reset() {
        if (this.isPlaceholder()) {
            Enumeration e = this.instances();
            while (e.hasMoreElements()) {
                ((DiagnosisComponent)e.nextElement()).reset();
            }
            this.instances.removeAllElements();
            e = this.children();
            while (e.hasMoreElements()) {
                ((DiagnosisComponent)e.nextElement()).reset();
            }
        } else {
            this.setSeed(null);
            this.setDiagnosis(null);
            this.deactivateInstance();
        }
    }

    public Diagnosis checkTrigger() {
        if (!this.isPlaceholder()) {
            log.log("Error: Attempt to get trigger status from non-placeholder node", 0, FAC_DIAG);
        }
        return null;
    }

    public boolean isTriggerable() {
        return false;
    }

    public void diagnose() {
        if (this.isPlaceholder()) {
            log.log("Error: Attempt to diagnose with placeholder node", 0, FAC_DIAG);
        }
        this.deactivateInstance();
    }

    protected void addKey(Object k) {
        if (this.isPlaceholder()) {
            this.required.addElement(k);
        }
    }

    protected boolean checkKeys(Diagnosis d) {
        Enumeration e = this.required.elements();
        boolean ok = true;
        log.log("Checking data keys for " + this.getName() + "'s seed diagnosis", 5, FAC_DIAG);
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            log.log("  Checking key " + k, 5, FAC_DIAG);
            if (d.getData(k) != null) continue;
            log.log("Diagnosis (" + d + ") is missing key \"" + k + "\"", 0, FAC_DIAG);
            ok = false;
        }
        return ok;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public void addDiagnosisEventListener(DiagnosisEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeDiagnosisEventListener(DiagnosisEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    protected void startFireEvent(AgentEvent event) {
        this.ev_queue.addElement(event);
        if (this.ev_firing) {
            return;
        }
        Integer n = this.ev_lock;
        synchronized (n) {
            int time = (Integer)DiagnosisComponent.diagnostics.state.getProperty((Object)"Time");
            event.setTime(time);
            this.ev_firing = true;
            while (!this.ev_queue.isEmpty()) {
                AgentEvent ev = (AgentEvent)this.ev_queue.firstElement();
                this.ev_queue.removeElement(ev);
                this.fireEvent(ev);
            }
            this.ev_firing = false;
        }
    }

    private void fireEvent(AgentEvent event) {
        DiagnosisEvent e = (DiagnosisEvent)event;
        Enumeration enumeration = this.listeners.elements();
        log.log("Diagnosis component firing a diagnosis event", 4, FAC_DIAG);
        while (enumeration.hasMoreElements()) {
            DiagnosisEventListener l = (DiagnosisEventListener)enumeration.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0: {
                    l.diagnosisAdded(e);
                    break;
                }
                case 1: {
                    l.diagnosisRemoved(e);
                    break;
                }
                case 2: {
                    l.diagnosisChanged(e);
                    break;
                }
            }
        }
        log.log("Diagnosis component fired a diagnosis event", 5, FAC_DIAG);
    }

    public void diagnosisAdded(DiagnosisEvent e) {
        if (this.isPlaceholder()) {
            log.log("Placeholder " + this.getName() + " forwarding diagnostics event to instances.", 4, FAC_DIAG);
            Enumeration i = this.instances();
            while (i.hasMoreElements()) {
                DiagnosisComponent c = (DiagnosisComponent)i.nextElement();
                if (c == e.getDiagnosis().getSource()) continue;
                c.diagnosisAdded(e);
            }
        } else {
            log.log(this.getName() + " received diagnosis event.", 4, FAC_DIAG);
        }
    }

    public void diagnosisRemoved(DiagnosisEvent e) {
        if (this.isPlaceholder()) {
            log.log("Placeholder " + this.getName() + " forwarding diagnostics event to instances.", 4, FAC_DIAG);
            Enumeration i = this.instances();
            while (i.hasMoreElements()) {
                DiagnosisComponent c = (DiagnosisComponent)i.nextElement();
                if (c == e.getDiagnosis().getSource()) continue;
                c.diagnosisRemoved(e);
            }
        } else {
            log.log(this.getName() + " received diagnosis event.", 5, FAC_DIAG);
        }
    }

    public void diagnosisChanged(DiagnosisEvent e) {
        if (this.isPlaceholder()) {
            log.log("Placeholder " + this.getName() + " forwarding diagnostics event to instances.", 4, FAC_DIAG);
            Enumeration i = this.instances();
            while (i.hasMoreElements()) {
                DiagnosisComponent c = (DiagnosisComponent)i.nextElement();
                if (c == e.getDiagnosis().getSource()) continue;
                c.diagnosisChanged(e);
            }
        } else {
            log.log(this.getName() + " received diagnosis event.", 5, FAC_DIAG);
        }
    }

    public void symptomAdded(SymptomEvent e) {
    }

    public void symptomRemoved(SymptomEvent e) {
    }

    public void symptomChanged(SymptomEvent e) {
    }

    public void setDiagnosis(Diagnosis d) {
        this.setDiagnosis(d, true);
    }

    public void setDiagnosis(Diagnosis d, boolean fire) {
        Diagnosis olddiagnosis;
        int id;
        Diagnosis newdiagnosis = d;
        if (this.getDiagnosis() == null || this.fired) {
            id = 2;
            olddiagnosis = this.getDiagnosis();
        } else {
            id = 0;
            olddiagnosis = newdiagnosis;
        }
        d.setData("SourceAgent", DiagnosisComponent.diagnostics.state.getProperty((Object)"Name"));
        this.diagnosis = newdiagnosis;
        if (!fire) {
            return;
        }
        if (!this.isPlaceholder()) {
            this.fired = true;
        }
        DiagnosisEvent e = new DiagnosisEvent(this, olddiagnosis, newdiagnosis, id);
        this.startFireEvent(e);
        if (!this.isPlaceholder()) {
            this.placeholder.startFireEvent(e);
        }
    }

    public Diagnosis getDiagnosis() {
        return this.diagnosis;
    }

    public boolean isPlaceholder() {
        if (this.placeholder == null) {
            System.err.println("Warning: null placeholder enountered in " + this.getName());
        }
        return this.placeholder == this;
    }

    public DiagnosisComponent placeholder() {
        return this.placeholder;
    }

    public boolean isActive() {
        if (this.isPlaceholder()) {
            Enumeration i = this.instances();
            while (i.hasMoreElements()) {
                if (!((DiagnosisComponent)i.nextElement()).isActive()) continue;
                return true;
            }
            return false;
        }
        return diagnostics.isInstanceActive(this);
    }

    public boolean isAlive() {
        return this.isPlaceholder() || this.instances.contains(this);
    }

    /*
     * WARNING - void declaration
     */
    public DiagnosisComponent activateNewInstance(Diagnosis d) {
        try {
            void e;
            DiagnosisComponent o = (DiagnosisComponent)this.getClass().newInstance();
            o.initInstance(this.placeholder());
            o.setSeed(d);
            o.activateInstance();
            o.addDiagnosisEventListener(this.placeholder);
            log.log("Activated new instance of " + o.getName(), 4, FAC_DIAG);
            return e;
        }
        catch (InstantiationException e) {
            log.log("Error: Activating instance. " + e, 0, FAC_DIAG);
        }
        catch (IllegalAccessException e) {
            log.log("Error: Activating instance. " + e, 0, FAC_DIAG);
        }
        return null;
    }

    public void activateInstance() {
        if (this.isPlaceholder()) {
            log.log("Error: attempt to activate placeholder node", 0, FAC_DIAG);
        }
        this.addInstance(this);
        this.resumeInstance();
    }

    public void deactivateInstance() {
        if (this.isPlaceholder()) {
            log.log("Error: attempt to deactivate placeholder node", 0, FAC_DIAG);
        }
        log.log("Deactivating node " + this.getName(), 3, FAC_DIAG);
        this.suspendInstance();
        this.removeInstance(this);
        this.listeners.removeAllElements();
    }

    public void resumeInstance() {
        if (this.isPlaceholder()) {
            log.log("Error: attempt to resume placeholder node", 0, FAC_DIAG);
        }
        log.log("Resuming node " + this.getName(), 3, FAC_DIAG);
        diagnostics.makeInstanceActive(this);
    }

    public void suspendInstance() {
        if (this.isPlaceholder()) {
            log.log("Error: attempt to suspend placeholder node", 0, FAC_DIAG);
        }
        log.log("Suspending node " + this.getName(), 3, FAC_DIAG);
        diagnostics.makeInstanceInactive(this);
    }

    public void sleepInstance(int s) {
        if (this.isPlaceholder()) {
            log.log("Error: attempt to sleep placeholder node", 0, FAC_DIAG);
        }
        log.log("Node " + this.getName() + " going to sleep for " + s + " clicks", 3, FAC_DIAG);
        this.sleep = this.isAsleep() ? (this.sleep > s ? s : this.sleep) : s;
    }

    public boolean isSuspended() {
        return !this.isActive() && this.instances.contains(this);
    }

    public boolean isAsleep() {
        return this.sleep > 0;
    }

    public void sleep() {
        --this.sleep;
        log.log(this.getName() + " will sleep for for " + this.sleep + " more clicks", 5, FAC_DIAG);
    }

    public void activateChildNodes() {
        this.activateChildNodes(null);
    }

    public void activateChildNodes(Diagnosis d) {
        Enumeration e = this.children();
        log.log(this.getName() + " activating child nodes", 5, FAC_DIAG);
        while (e.hasMoreElements()) {
            DiagnosisComponent c = (DiagnosisComponent)e.nextElement();
            DiagnosisComponent i = c.activateNewInstance(d);
            if (i == null) continue;
            i.addDiagnosisEventListener(this);
            this.addDiagnosisEventListener(i);
            this.instancechildren.addElement(i);
        }
    }

    public void addChildNode(DiagnosisComponent c) {
        this.children.addElement(c);
        log.log("Added child " + c.getName() + " to " + this.getName(), 3, FAC_DIAG);
    }

    public void removeChildNode(DiagnosisComponent c) {
        if (this.children.removeElement(c)) {
            log.log("Removed child " + c.getName() + " from " + this.getName(), 3, FAC_DIAG);
        }
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public boolean hasChild(DiagnosisComponent d) {
        return this.children.contains(d.placeholder());
    }

    public boolean hasLivingChildren() {
        Enumeration e = this.instancechildren.elements();
        while (e.hasMoreElements()) {
            DiagnosisComponent d = (DiagnosisComponent)e.nextElement();
            if (!d.isAlive()) continue;
            return true;
        }
        return false;
    }

    private void addInstance(DiagnosisComponent c) {
        this.instances.addElement(c);
    }

    private void removeInstance(DiagnosisComponent c) {
        this.instances.removeElement(c);
    }

    public Enumeration instances() {
        return this.instances.elements();
    }

    public int numInstances() {
        return this.instances.size();
    }

    public void setSeed(Diagnosis d) {
        if (this.checkKeys(d)) {
            this.seed = d;
        } else {
            log.log("Warning, seed diagnosis not added (key check failed) - trace follows", 1, FAC_DIAG);
            new Throwable().printStackTrace();
        }
    }

    public void removeSeed() {
        this.seed = null;
    }

    public Diagnosis getSeed() {
        return this.seed;
    }

    public boolean hasSeed() {
        return this.seed != null;
    }

    public void setLocation(Point p) {
        this.loc = p;
    }

    public Point getLocation() {
        return this.loc;
    }

    public Dimension getSize(Graphics g) {
        Dimension d = new Dimension();
        FontMetrics fm = g.getFontMetrics();
        String name = this.getName();
        if (this.numInstances() != 0) {
            name = name + " : " + this.numInstances();
        }
        d.width = fm.stringWidth(name) + 10;
        d.height = fm.getHeight() + 4;
        return d;
    }

    public void paint(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        Dimension d = this.getSize(g);
        int w = d.width;
        int h = d.height;
        int x = this.loc.x;
        int y = this.loc.y;
        String name = this.getName();
        if (this.numInstances() != 0) {
            name = name + " : " + this.numInstances();
        }
        this.setColor(g);
        g.fillRect(x - w / 2, y - h / 2, w, h);
        g.setColor(Color.black);
        g.drawRect(x - w / 2, y - h / 2, w, h);
        g.drawString(name, x - fm.stringWidth(name) / 2, y - (h - 4) / 2 + fm.getAscent());
        this.rect = new Rectangle(x - w / 2, y - h / 2, w, h);
    }

    public void setSelected(boolean s) {
        this.selected = s;
    }

    public boolean contains(Point p) {
        if (this.rect != null) {
            return this.rect.contains(p);
        }
        return false;
    }

    public Rectangle getBounds() {
        return this.rect;
    }

    protected void setColor(Graphics g) {
        if (this.selected) {
            g.setColor(Color.yellow);
        } else if (this.isActive()) {
            g.setColor(Color.green);
        } else if (this.isTriggerable()) {
            g.setColor(Color.cyan);
        } else {
            g.setColor(Color.white);
        }
    }
}

