/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.causal.SimpleConfidenceCheck;
import agent.diagnose.diagnosis.Diagnosis;
import agent.diagnose.symptom.ActionEnded;
import agent.diagnose.symptom.SymptomEvent;
import agent.diagnose.symptom.SymptomEventListener;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import taems.ScheduleElement;
import utilities.Distribution;

public class CompletionTimeDelayed
extends DiagnosisComponent
implements SymptomEventListener {
    public static float THRESH = 1.15f;

    public CompletionTimeDelayed() {
        this.setDescription("No description yet");
    }

    public void init() {
        this.getBoard().addSymptomEventListener(this);
        super.init();
    }

    public void symptomRemoved(SymptomEvent e) {
    }

    public void symptomChanged(SymptomEvent e) {
    }

    public void symptomAdded(SymptomEvent e) {
        Action a;
        if (e.getSymptom() instanceof ActionEnded && (a = (Action)e.getSymptom().getValue()) instanceof TaemsAction) {
            int afin;
            TaemsAction t = (TaemsAction)a;
            if (t.getScheduleElement() == null) {
                DiagnosisComponent.log.log("Error: CTD diagnosis requires schedule element", 1, DiagnosisComponent.FAC_DIAG);
                return;
            }
            ScheduleElement se = t.getScheduleElement();
            Distribution efin = se.getFinishTime();
            if (!efin.containsValue((float)(afin = t.getFinish()), THRESH)) {
                float conf = SimpleConfidenceCheck.calculateConfidence(efin.findClosestValue((float)afin), afin, THRESH);
                Diagnosis d = new Diagnosis(this, "Action " + a.getName() + " had different completion time (" + afin + ") than expected (" + efin + ")", conf);
                d.setData("Action", a);
                d.addSupport(e.getSymptom());
                this.activateChildNodes(d);
                this.setDiagnosis(d);
            } else {
                DiagnosisComponent.log.log("Method " + a.getName() + " had normal completion time (" + afin + ")", 4, DiagnosisComponent.FAC_DIAG);
            }
        }
    }
}

