/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.simplest.Log;
import agent.simplest.LogEvent;
import agent.simplest.LogEventListener;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Vector;

public class EventLogger
extends AgentComponent
implements PropertyEventListener,
LogEventListener {
    static final long serialVersionUID = 1234567890L;
    private static final int SLOT_VECSIZE = 25;
    private Vector events = new Vector(this.bound);
    private int time = -1;
    private int base = 0;
    private int bound = 10;
    protected Log log;
    protected int FAC_EVLOG;
    protected State state;

    public EventLogger() {
        this.enforceBound();
        this.addDependency("State");
        State.addParameterInfo((String)"EventLogBound", (String)"Integer", (String)"Initial size of event log");
    }

    public void init() {
        this.state = (State)State.findComponent((String)"State");
        this.log = (Log)State.findComponent((String)"Log");
        this.FAC_EVLOG = this.log.getFacilityID((AgentComponent)this);
        this.state.addPropertyEventListener((PropertyEventListener)this);
        this.log.addLogEventListener((LogEventListener)this);
        super.init();
    }

    public void reset() {
        this.events.removeAllElements();
        this.base = 0;
        super.reset();
    }

    public int getBound() {
        return this.bound;
    }

    public void setBound(int b) {
        if (this.bound == b) {
            return;
        }
        this.bound = b;
        this.events.ensureCapacity(b);
        this.enforceBound();
        if (this.state != null) {
            this.state.setProperty((Object)"EventLogBound", (Object)new Integer(this.bound));
        }
    }

    private void enforceBound() {
        while (this.time - this.base >= this.bound) {
            if (!this.events.isEmpty()) {
                this.events.removeElementAt(0);
            }
            ++this.base;
        }
        this.events.setSize(this.bound);
    }

    private int toIndex(int i) {
        if (i < 0) {
            return 0;
        }
        return i - this.base;
    }

    public void addEvent(AgentEvent e) {
        int index = this.toIndex(this.time);
        if (this.events.elementAt(index) == null) {
            this.events.setElementAt(new Vector(25), index);
        }
        ((Vector)this.events.elementAt(index)).addElement(e);
    }

    public Enumeration getEvents(int i) {
        int index = this.toIndex(i);
        if (index < 0) {
            return null;
        }
        if (index > this.time) {
            return null;
        }
        if (this.events.elementAt(index) == null) {
            this.events.setElementAt(new Vector(0), index);
        }
        return ((Vector)this.events.elementAt(index)).elements();
    }

    public Enumeration getCurrentEvents() {
        return this.getEvents(this.time);
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase("Time")) {
            if (this.time >= 0) {
                int count = 0;
                if (!this.events.isEmpty() && this.events.elementAt(this.toIndex(this.time)) != null) {
                    count = ((Vector)this.events.elementAt(this.toIndex(this.time))).size();
                }
                this.log.log(count + " events logged during time " + this.time, 4, this.FAC_EVLOG);
            }
            this.time = (Integer)e.getProperty();
            this.enforceBound();
        }
        if (key.equalsIgnoreCase("EventLogBound")) {
            this.setBound((Integer)e.getProperty());
        }
    }

    public void errorLog(LogEvent e) {
    }

    public void eventLog(LogEvent e) {
    }

    public void stringLog(LogEvent e) {
    }

    public void objectLog(LogEvent e) {
    }

    public void eventReflection(AgentEvent e) {
        this.addEvent(e);
    }
}

