/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.diagnose.BoardObject;
import agent.diagnose.causal.Diagnostics;
import agent.diagnose.diagnosis.Diagnosis;
import agent.diagnose.diagnosis.DiagnosisEvent;
import agent.diagnose.diagnosis.DiagnosisEventListener;
import agent.diagnose.reaction.Reaction;
import agent.diagnose.reaction.ReactionEvent;
import agent.diagnose.reaction.ReactionEventListener;
import agent.diagnose.symptom.Symptom;
import agent.diagnose.symptom.SymptomEvent;
import agent.diagnose.symptom.SymptomEventListener;
import agent.simplest.Communicate;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.Observe;
import agent.simplest.State;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import utilities.EnumerationEnumeration;
import utilities.KQMLMessage;
import utilities.Message;

public class DiagnosticsBoard
extends AgentComponent
implements SymptomEventListener,
DiagnosisEventListener,
ReactionEventListener,
MessageEventListener,
MouseListener {
    static final long serialVersionUID = 1234567890L;
    protected Log log;
    protected State state;
    protected Communicate communicate;
    protected Diagnostics diagnostics;
    protected Observe observe;
    private PopupMenu menu = new PopupMenu("Board Contents");
    protected Hashtable symptoms = new Hashtable(100);
    protected Vector slisteners = new Vector();
    protected Hashtable diagnoses = new Hashtable(100);
    protected Vector dlisteners = new Vector();
    protected Hashtable reactions = new Hashtable(100);
    protected Vector rlisteners = new Vector();
    protected int FAC_DIAGBOARD;

    public DiagnosticsBoard() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Communicate");
        this.addDependency("Diagnostics");
        this.addDependency("Observe");
        ((Component)((Object)this)).addMouseListener(this);
        MenuItem m = new MenuItem("Symptoms (Current)");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosticsBoard.this.printSymptoms(1);
            }
        });
        this.menu.add(m);
        m = new MenuItem("Symptoms (Last 5)");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosticsBoard.this.printSymptoms(5);
            }
        });
        this.menu.add(m);
        m = new MenuItem("Symptoms (All)");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosticsBoard.this.printSymptoms(0);
            }
        });
        this.menu.add(m);
        this.menu.addSeparator();
        m = new MenuItem("Diagnoses (Current)");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosticsBoard.this.printDiagnoses(1);
            }
        });
        this.menu.add(m);
        m = new MenuItem("Diagnoses (Last 5)");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosticsBoard.this.printDiagnoses(5);
            }
        });
        this.menu.add(m);
        m = new MenuItem("Diagnoses (All)");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosticsBoard.this.printDiagnoses(0);
            }
        });
        this.menu.add(m);
        this.menu.addSeparator();
        m = new MenuItem("Reactions (Current)");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosticsBoard.this.printReactions(1);
            }
        });
        this.menu.add(m);
        m = new MenuItem("Reactions (Last 5)");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosticsBoard.this.printReactions(5);
            }
        });
        this.menu.add(m);
        m = new MenuItem("Reactions (All)");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiagnosticsBoard.this.printReactions(0);
            }
        });
        this.menu.add(m);
        ((Component)((Object)this)).add(this.menu);
    }

    public void init() {
        this.log = (Log)State.findComponent((String)"Log");
        this.state = (State)State.findComponent((String)"State");
        this.communicate = (Communicate)State.findComponent((String)"Communicate");
        this.diagnostics = (Diagnostics)State.findComponent((String)"Diagnostics");
        this.observe = (Observe)State.findComponent((String)"Observe");
        this.FAC_DIAGBOARD = this.log.getFacilityID((AgentComponent)this);
        this.communicate.addMessageEventListener((MessageEventListener)this);
        this.diagnostics.addDiagnosisEventListener(this);
    }

    public void begin() {
        super.begin();
    }

    public void pulse() {
    }

    public void reset() {
        super.reset();
        this.diagnoses = new Hashtable();
    }

    protected void addObject(BoardObject o, Hashtable l) {
        if (o == null) {
            return;
        }
        Integer t = new Integer(o.getCreationTime());
        Vector<BoardObject> v = (Vector<BoardObject>)l.get(t);
        if (v == null) {
            v = new Vector<BoardObject>();
            l.put(t, v);
        }
        if (!v.contains(o)) {
            v.addElement(o);
            this.log.log("Object added: " + o.toString(), 5, this.FAC_DIAGBOARD);
        }
    }

    protected void removeObject(BoardObject o, Hashtable l) {
        if (o == null) {
            return;
        }
        Integer t = new Integer(o.getCreationTime());
        Vector v = (Vector)l.get(t);
        if (v != null) {
            v.removeElement(o);
        }
    }

    protected Enumeration getObjects(int t, Hashtable l) {
        Integer i = new Integer(t);
        Vector v = (Vector)l.get(i);
        this.log.log("Getting objects from time " + t, 5, this.FAC_DIAGBOARD);
        if (v != null) {
            return v.elements();
        }
        return new Vector(0).elements();
    }

    protected Enumeration getObjects(Hashtable l) {
        Vector enums = new Vector();
        this.log.log("Getting all objects", 5, this.FAC_DIAGBOARD);
        Enumeration e = l.elements();
        while (e.hasMoreElements()) {
            Vector v = (Vector)e.nextElement();
            enums.addElement(v.elements());
        }
        return new EnumerationEnumeration(enums);
    }

    protected Enumeration getObjects(String s, Hashtable l) {
        Vector<BoardObject> r = new Vector<BoardObject>();
        this.log.log("Getting " + s + " objects", 5, this.FAC_DIAGBOARD);
        Enumeration e1 = l.elements();
        while (e1.hasMoreElements()) {
            Vector v = (Vector)e1.nextElement();
            Enumeration e2 = v.elements();
            while (e2.hasMoreElements()) {
                BoardObject b = (BoardObject)e2.nextElement();
                if (b.getDescription().equals(s)) {
                    r.addElement(b);
                    continue;
                }
                if (!b.getName().equals(s)) continue;
                r.addElement(b);
            }
        }
        return r.elements();
    }

    protected Enumeration getObjects(Object s, Hashtable l) {
        Vector<BoardObject> r = new Vector<BoardObject>();
        this.log.log("Getting " + s.getClass().getName() + " objects", 5, this.FAC_DIAGBOARD);
        Enumeration e1 = l.elements();
        while (e1.hasMoreElements()) {
            Vector v = (Vector)e1.nextElement();
            Enumeration e2 = v.elements();
            while (e2.hasMoreElements()) {
                BoardObject b = (BoardObject)e2.nextElement();
                if (b.getSource() == null) continue;
                if (b.getClass().isInstance(s)) {
                    r.addElement(b);
                    continue;
                }
                if (!b.getSource().getClass().isInstance(s)) continue;
                r.addElement(b);
            }
        }
        return r.elements();
    }

    protected void printObjects(int t, Hashtable l) {
        int time = (Integer)this.state.getProperty((Object)"Time");
        if (t == 0) {
            t = time + 1;
        }
        int i = time;
        while (i > time - t && i >= 0) {
            Enumeration e = this.getObjects(i, l);
            System.err.println(" ==> Objects from time slot " + i);
            while (e.hasMoreElements()) {
                System.err.println(">> " + e.nextElement().toString());
            }
            --i;
        }
    }

    protected void fireEvent(AgentEvent event) {
        if (event instanceof SymptomEvent) {
            this.fireSymptomEvent(event);
        } else if (event instanceof DiagnosisEvent) {
            this.fireDiagnosisEvent(event);
        } else if (event instanceof ReactionEvent) {
            this.fireReactionEvent(event);
        }
    }

    public void addSymptom(Symptom s) {
        this.log.log("Symptom " + s + " being added", 2, this.FAC_DIAGBOARD);
        this.addObject(s, this.symptoms);
        this.startFireEvent(new SymptomEvent(this, s, 0));
    }

    public void removeSymptom(Symptom s) {
        this.log.log("Symptom " + s + " being removed", 2, this.FAC_DIAGBOARD);
        this.removeObject(s, this.symptoms);
        this.startFireEvent(new SymptomEvent(this, s, 1));
    }

    protected Enumeration getSymptoms() {
        return this.getObjects(this.symptoms);
    }

    public Enumeration getSymptoms(int t) {
        return this.getObjects(t, this.symptoms);
    }

    public Enumeration getSymptoms(String s) {
        return this.getObjects(s, this.symptoms);
    }

    public Enumeration getSymptoms(Object s) {
        return this.getObjects(s, this.symptoms);
    }

    public void printSymptoms(int t) {
        this.printObjects(t, this.symptoms);
    }

    public void symptomAdded(SymptomEvent e) {
        this.addSymptom(e.getSymptom());
    }

    public void symptomRemoved(SymptomEvent e) {
        this.removeSymptom(e.getSymptom());
    }

    public void symptomChanged(SymptomEvent e) {
    }

    public void addSymptomEventListener(SymptomEventListener l) {
        this.slisteners.addElement(l);
    }

    public void removeSymptomEventListener(SymptomEventListener l) {
        this.slisteners.removeElement(l);
    }

    protected void fireSymptomEvent(AgentEvent event) {
        SymptomEvent e = (SymptomEvent)event;
        Enumeration enumeration = this.slisteners.elements();
        this.log.log("Firing a symptom event", 4, this.FAC_DIAGBOARD);
        while (enumeration.hasMoreElements()) {
            SymptomEventListener l = (SymptomEventListener)enumeration.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0: {
                    l.symptomAdded(e);
                    break;
                }
                case 1: {
                    l.symptomRemoved(e);
                    break;
                }
                case 2: {
                    l.symptomChanged(e);
                    break;
                }
            }
        }
        if (this.log != null) {
            this.log.log((Object)e, 2, this.FAC_DIAGBOARD);
        }
        this.log.log("Fired a symptom event", 5, this.FAC_DIAGBOARD);
    }

    public void addDiagnosis(Diagnosis d) {
        this.log.log("Diagnosis " + d + " being added", 2, this.FAC_DIAGBOARD);
        this.addObject(d, this.diagnoses);
        this.startFireEvent(new DiagnosisEvent(this, d, 0));
    }

    public void removeDiagnosis(Diagnosis d) {
        this.log.log("Diagnosis " + d + " being removed", 2, this.FAC_DIAGBOARD);
        this.removeObject(d, this.diagnoses);
        this.startFireEvent(new DiagnosisEvent(this, d, 1));
    }

    protected Enumeration getDiagnoses() {
        return this.getObjects(this.diagnoses);
    }

    public Enumeration getDiagnoses(int t) {
        return this.getObjects(t, this.diagnoses);
    }

    public Enumeration getDiagnoses(String s) {
        return this.getObjects(s, this.diagnoses);
    }

    public Enumeration getDiagnoses(Object s) {
        return this.getObjects(s, this.diagnoses);
    }

    public void printDiagnoses(int t) {
        this.printObjects(t, this.diagnoses);
    }

    public void diagnosisAdded(DiagnosisEvent e) {
        this.addDiagnosis(e.getDiagnosis());
    }

    public void diagnosisRemoved(DiagnosisEvent e) {
        this.removeDiagnosis(e.getDiagnosis());
    }

    public void diagnosisChanged(DiagnosisEvent e) {
        this.addDiagnosis(e.getDiagnosis());
    }

    public void addDiagnosisEventListener(DiagnosisEventListener l) {
        this.dlisteners.addElement(l);
    }

    public void removeDiagnosisEventListener(DiagnosisEventListener l) {
        this.dlisteners.removeElement(l);
    }

    protected void fireDiagnosisEvent(AgentEvent event) {
        DiagnosisEvent e = (DiagnosisEvent)event;
        Enumeration enumeration = this.dlisteners.elements();
        this.log.log("Firing a diagnosis event", 4, this.FAC_DIAGBOARD);
        while (enumeration.hasMoreElements()) {
            DiagnosisEventListener l = (DiagnosisEventListener)enumeration.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0: {
                    l.diagnosisAdded(e);
                    break;
                }
                case 1: {
                    l.diagnosisRemoved(e);
                    break;
                }
                case 2: {
                    l.diagnosisChanged(e);
                    break;
                }
            }
        }
        if (this.log != null) {
            this.log.log((Object)e, 2, this.FAC_DIAGBOARD);
        }
        this.log.log("Fired a diagnosis event", 5, this.FAC_DIAGBOARD);
    }

    public void addReaction(Reaction r) {
        this.log.log("Reaction " + r + " being added", 2, this.FAC_DIAGBOARD);
        this.addObject(r, this.reactions);
        this.startFireEvent(new ReactionEvent(this, r, 0));
    }

    public void removeReaction(Reaction r) {
        this.log.log("Reaction " + r + " being removed", 2, this.FAC_DIAGBOARD);
        this.removeObject(r, this.reactions);
        this.startFireEvent(new ReactionEvent(this, r, 1));
    }

    protected Enumeration getReactions() {
        return this.getObjects(this.reactions);
    }

    public Enumeration getReactions(int t) {
        return this.getObjects(t, this.reactions);
    }

    public Enumeration getReactions(String s) {
        return this.getObjects(s, this.reactions);
    }

    public Enumeration getReactions(Object s) {
        return this.getObjects(s, this.reactions);
    }

    public void printReactions(int t) {
        this.printObjects(t, this.reactions);
    }

    public void reactionAdded(ReactionEvent e) {
        this.addReaction(e.getReaction());
    }

    public void reactionRemoved(ReactionEvent e) {
        this.removeReaction(e.getReaction());
    }

    public void reactionChanged(ReactionEvent e) {
    }

    public void addReactionEventListener(ReactionEventListener l) {
        this.rlisteners.addElement(l);
    }

    public void removeReactionEventListener(ReactionEventListener l) {
        this.rlisteners.removeElement(l);
    }

    protected void fireReactionEvent(AgentEvent event) {
        ReactionEvent e = (ReactionEvent)event;
        Enumeration enumeration = this.rlisteners.elements();
        this.log.log("Firing a reaction event", 4, this.FAC_DIAGBOARD);
        while (enumeration.hasMoreElements()) {
            ReactionEventListener l = (ReactionEventListener)enumeration.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0: {
                    l.reactionAdded(e);
                    break;
                }
                case 1: {
                    l.reactionRemoved(e);
                    break;
                }
                case 2: {
                    l.reactionChanged(e);
                    break;
                }
            }
        }
        if (this.log != null) {
            this.log.log((Object)e, 2, this.FAC_DIAGBOARD);
        }
        this.log.log("Fired a reaction event", 5, this.FAC_DIAGBOARD);
    }

    public void messageSent(MessageEvent e) {
    }

    public void messageReceived(MessageEvent e) {
        if (e.getConnection().getType() != 1) {
            return;
        }
        KQMLMessage m = (KQMLMessage)e.getMessage();
        String perf = m.getPerformative();
        if (perf.equalsIgnoreCase("reply") || perf.equalsIgnoreCase("tell") || perf.equalsIgnoreCase("ask")) {
            // empty if block
        }
    }

    public boolean hasPopupMenu() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 || e.isPopupTrigger()) {
            this.menu.show((Component)((Object)this), e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public long sendDiagnosisQuery(String agent, String type) {
        this.log.log("Sending diagnosis query for " + type, 2, this.FAC_DIAGBOARD);
        String content = "(DiagnosisQuery " + type + ")";
        KQMLMessage mess = new KQMLMessage("ask", (Object)content, agent);
        long id = State.getRandom().nextLong();
        mess.addField("reply-with", String.valueOf(id));
        this.log.log("Sending query to " + mess.getDestAddr(), 3, this.FAC_DIAGBOARD);
        return id;
    }

    public void handleDiagnosisQuery(KQMLMessage m) {
        this.log.log("Handling diagnosis query from " + m.getDestAddr(), 2, this.FAC_DIAGBOARD);
        String content = m.contentData();
        StringTokenizer tok = new StringTokenizer(content);
        String type = tok.nextToken();
        Vector<Diagnosis> v = new Vector<Diagnosis>();
        Enumeration e = this.getDiagnoses(type);
        while (e.hasMoreElements()) {
            Diagnosis d = (Diagnosis)e.nextElement();
            v.addElement(d);
        }
        KQMLMessage mess = new KQMLMessage("reply", (Object)"", m.getSourceAddr());
        mess.addField("in-reply-to", m.getField("reply-with"));
        if (v.isEmpty()) {
            this.log.log("No matching agent.diagnoses found", 3, this.FAC_DIAGBOARD);
            String str = "(DiagnosisQuery None)";
            mess.setContent((Object)str);
            this.communicate.sendMessage((Message)mess);
            return;
        }
        this.log.log("" + v.size() + " matching diagnoses found", 3, this.FAC_DIAGBOARD);
        e = v.elements();
        while (e.hasMoreElements()) {
            Diagnosis d = (Diagnosis)e.nextElement();
            String str = "(DiagnosisQuery ";
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bout);
                out.writeObject(d);
                out.flush();
                out.close();
                str = str + bout.toString() + ")";
            }
            catch (IOException ex) {
                this.log.log("Error: " + ex, 0, this.FAC_DIAGBOARD);
            }
            mess.setContent((Object)str);
            this.log.log("Responding with diagnosis " + d, 3, this.FAC_DIAGBOARD);
            this.communicate.sendMessage((Message)mess);
        }
    }

    public Diagnosis decodeDiagnosisMessage(KQMLMessage m) {
        Diagnosis d = null;
        if (!m.contentWord().equals("DiagnosisQuery") || !m.getPerformative().equals("reply")) {
            return d;
        }
        String content = m.contentData();
        if (content.length() == 4 && content.equals("None")) {
            return null;
        }
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(content.getBytes());
            ObjectInputStream in = new ObjectInputStream(bin);
            d = (Diagnosis)in.readObject();
        }
        catch (Exception ex) {
            this.log.log("Error: " + ex, 0, this.FAC_DIAGBOARD);
        }
        return d;
    }
}

