/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose;

import agent.base.AgentComponent;
import agent.diagnose.BoardObject;
import agent.diagnose.DiagnosticsBoard;
import agent.diagnose.diagnosis.Diagnosis;
import agent.diagnose.diagnosis.DiagnosisEvent;
import agent.diagnose.diagnosis.DiagnosisEventListener;
import agent.diagnose.reaction.Reaction;
import agent.diagnose.reaction.ReactionEvent;
import agent.diagnose.reaction.ReactionEventListener;
import agent.diagnose.symptom.Symptom;
import agent.diagnose.symptom.SymptomEvent;
import agent.diagnose.symptom.SymptomEventListener;
import agent.mass.TaemsAction;
import agent.simplest.Communicate;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Vector;
import taems.Agent;
import taems.Interrelationship;
import taems.Method;
import taems.Node;
import taems.Resource;
import taems.Taems;
import taems.TaskBase;
import utilities.Base64;
import utilities.KQMLMessage;
import utilities.Message;

public class BoardRelay
extends AgentComponent
implements SymptomEventListener,
DiagnosisEventListener,
ReactionEventListener,
MessageEventListener,
PropertyEventListener {
    static final long serialVersionUID = 1234567890L;
    protected Log log;
    protected State state;
    protected Communicate communicate;
    protected DiagnosticsBoard board;
    protected Taems taems = null;
    protected int FAC_RELAY;

    public BoardRelay() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Communicate");
        this.addDependency("DiagnosticsBoard");
    }

    public void init() {
        this.log = (Log)State.findComponent((String)"Log");
        this.state = (State)State.findComponent((String)"State");
        this.communicate = (Communicate)State.findComponent((String)"Communicate");
        this.board = (DiagnosticsBoard)State.findComponent((String)"DiagnosticsBoard");
        this.FAC_RELAY = this.log.getFacilityID((AgentComponent)this);
        this.state.addPropertyEventListener((PropertyEventListener)this);
        this.communicate.addMessageEventListener((MessageEventListener)this);
        this.board.addSymptomEventListener(this);
        this.board.addDiagnosisEventListener(this);
        this.board.addReactionEventListener(this);
    }

    public void begin() {
        super.begin();
    }

    public void pulse() {
    }

    public void reset() {
    }

    public void symptomAdded(SymptomEvent e) {
        this.notifyRelays(e.getSymptom());
    }

    public void symptomRemoved(SymptomEvent e) {
    }

    public void symptomChanged(SymptomEvent e) {
    }

    public void diagnosisAdded(DiagnosisEvent e) {
        this.notifyRelays(e.getDiagnosis());
    }

    public void diagnosisRemoved(DiagnosisEvent e) {
    }

    public void diagnosisChanged(DiagnosisEvent e) {
    }

    public void reactionAdded(ReactionEvent e) {
        this.notifyRelays(e.getReaction());
    }

    public void reactionRemoved(ReactionEvent e) {
    }

    public void reactionChanged(ReactionEvent e) {
    }

    public void notifyRelays(BoardObject object) {
        Enumeration e;
        if (object == null) {
            return;
        }
        if (!object.isLocal()) {
            this.log.log("Ignoring nonlocal board object", 5, this.FAC_RELAY);
            return;
        }
        if (this.taems == null) {
            this.log.log("Warning, taems task structure is null, cannot determine relevant parties", 1, this.FAC_RELAY);
            return;
        }
        this.log.log("Looking for agents to notify about " + object, 5, this.FAC_RELAY);
        Vector relays = new Vector();
        if (object instanceof Diagnosis) {
            String r;
            int i;
            Vector v;
            Diagnosis d = (Diagnosis)object;
            TaemsAction a = (TaemsAction)d.getData("Action");
            if (a != null) {
                Interrelationship ir;
                Method m = a.getMethod();
                e = m.getOutInterrelationships();
                while (e.hasMoreElements()) {
                    ir = (Interrelationship)e.nextElement();
                    v = this.findRelatedParties(ir.getTo());
                    i = 0;
                    while (i < v.size()) {
                        relays.addElement(v.elementAt(i));
                        ++i;
                    }
                }
                e = m.getInInterrelationships();
                while (e.hasMoreElements()) {
                    ir = (Interrelationship)e.nextElement();
                    v = this.findRelatedParties(ir.getFrom());
                    i = 0;
                    while (i < v.size()) {
                        relays.addElement(v.elementAt(i));
                        ++i;
                    }
                }
            }
            if ((r = (String)d.getData("Resource")) != null) {
                Resource rs = (Resource)this.taems.findNode((Node)new Resource(r, null));
                v = this.findRelatedParties((Node)rs);
                i = 0;
                while (i < v.size()) {
                    relays.addElement(v.elementAt(i));
                    ++i;
                }
            }
        }
        Vector oldrelays = relays;
        relays = new Vector();
        e = oldrelays.elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            boolean hasit = false;
            Enumeration e2 = relays.elements();
            while (e2.hasMoreElements()) {
                String test = (String)e2.nextElement();
                if (!test.equals(name)) continue;
                hasit = true;
                break;
            }
            if (hasit) continue;
            relays.addElement(name);
        }
        this.log.log("Found " + relays.size() + " agents interested in that board object", 5, this.FAC_RELAY);
        e = relays.elements();
        while (e.hasMoreElements()) {
            String agent = (String)e.nextElement();
            KQMLMessage message = this.encodeMessage(object, agent);
            this.log.log("Sending board object to " + agent, 3, this.FAC_RELAY);
            this.communicate.sendMessage((Message)message);
        }
    }

    public Vector findRelatedParties(Node n) {
        String me = (String)this.state.getProperty((Object)"Name");
        Vector relays = new Vector();
        if (n != null) {
            TaskBase t;
            if (n instanceof Resource) {
                int i;
                Vector v;
                Interrelationship ir;
                Enumeration e = n.getOutInterrelationships();
                while (e.hasMoreElements()) {
                    ir = (Interrelationship)e.nextElement();
                    if (!(ir.getTo() instanceof TaskBase)) continue;
                    v = this.findRelatedParties(ir.getTo());
                    i = 0;
                    while (i < v.size()) {
                        relays.addElement(v.elementAt(i));
                        ++i;
                    }
                }
                e = n.getInInterrelationships();
                while (e.hasMoreElements()) {
                    ir = (Interrelationship)e.nextElement();
                    if (!(ir.getFrom() instanceof TaskBase)) continue;
                    v = this.findRelatedParties(ir.getFrom());
                    i = 0;
                    while (i < v.size()) {
                        relays.addElement(v.elementAt(i));
                        ++i;
                    }
                }
            } else if (n instanceof TaskBase && (t = (TaskBase)n).isNonLocal() && !t.getAgent().matches(new Agent(me))) {
                String name = t.getAgent().getLabel();
                relays.addElement(name);
            }
        }
        return relays;
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase("ConTaemsTask")) {
            this.taems = (Taems)e.getProperty();
        }
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void messageSent(MessageEvent e) {
    }

    public void messageReceived(MessageEvent e) {
        if (e.getConnection().getType() != 1) {
            return;
        }
        KQMLMessage m = (KQMLMessage)e.getMessage();
        String perf = m.getPerformative();
        if (perf.equalsIgnoreCase("reply") || perf.equalsIgnoreCase("tell")) {
            String word = m.contentWord();
            if (word.equals("DiagnosticsBoard")) {
                this.log.log("Got remote board object, decoding...", 2, this.FAC_RELAY);
                BoardObject o = this.decodeMessage(m);
                if (o != null) {
                    if (o instanceof Symptom) {
                        this.board.addSymptom((Symptom)o);
                    } else if (o instanceof Diagnosis) {
                        this.board.addDiagnosis((Diagnosis)o);
                    } else if (o instanceof Reaction) {
                        this.board.addReaction((Reaction)o);
                    } else {
                        this.log.log("Warning, unknown board object encountered: " + o.toString(), 1, this.FAC_RELAY);
                    }
                }
            }
        } else if (perf.equalsIgnoreCase("ask")) {
            // empty if block
        }
    }

    public KQMLMessage encodeMessage(BoardObject object, String agent) {
        KQMLMessage m = new KQMLMessage("tell", (Object)"", agent);
        String str = "(DiagnosticsBoard ";
        str = object == null ? str + "None)" : str + Base64.objectToString((Object)object) + ")";
        m.setContent((Object)str);
        return m;
    }

    public BoardObject decodeMessage(KQMLMessage m) {
        BoardObject o = null;
        String content = m.contentData();
        if (content.length() == 4 && content.equals("None")) {
            return null;
        }
        try {
            o = (BoardObject)Base64.stringToObject((String)content);
        }
        catch (Exception ex) {
            this.log.log("Error reading serialized data: " + ex, 0, this.FAC_RELAY);
        }
        o.setLocal(false);
        o.setSource(m.getSourceAddr());
        return o;
    }
}

