/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose;

import agent.base.AgentComponent;
import agent.diagnose.causal.DiagnosisComponent;
import agent.simplest.State;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BoardObject
implements Serializable {
    private long id;
    private String description;
    private Object source;
    private Hashtable data = new Hashtable(25);
    private Vector support = new Vector();
    private boolean local = true;
    private int ctime = -1;
    private int utime = -1;
    public static State state = null;

    public BoardObject(Object s, String d) {
        this.setID(State.getRandom().nextLong());
        this.source = s;
        this.description = d;
        if (this.description == null) {
            this.description = this.getName();
        }
        this.ctime = this.utime = this.getTime();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable temp = this.data;
        this.data = null;
        Vector temp2 = this.support;
        this.support = null;
        Object temp3 = this.source;
        this.source = this.source instanceof DiagnosisComponent ? ((DiagnosisComponent)this.source).getName() : (temp3 instanceof AgentComponent ? ((AgentComponent)this.source).getName() : new String("???"));
        out.defaultWriteObject();
        this.data = temp;
        this.support = temp2;
        this.source = temp3;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.data = new Hashtable(25);
    }

    public String getName() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
        this.updateUpdateTime();
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object s) {
        this.source = s;
    }

    public void setLocal(boolean l) {
        this.local = l;
    }

    public boolean isLocal() {
        return this.local;
    }

    public int getCreationTime() {
        return this.ctime;
    }

    public void setCreationTime(int t) {
        this.ctime = t;
        this.updateUpdateTime();
    }

    public int getUpdateTime() {
        return this.utime;
    }

    public void setUpdateTime(int t) {
        this.utime = t;
    }

    public void updateUpdateTime() {
        this.setUpdateTime(this.getTime());
    }

    public Enumeration getSupport() {
        return this.support.elements();
    }

    public void addSupport(BoardObject o) {
        if (!this.support.contains(o)) {
            this.support.addElement(o);
            this.updateUpdateTime();
        }
    }

    public void removeSupport(BoardObject o) {
        if (this.support.contains(o)) {
            this.support.removeElement(o);
            this.updateUpdateTime();
        }
    }

    public void removeAllSupport() {
        this.support.removeAllElements();
        this.updateUpdateTime();
    }

    public Hashtable getDataTable() {
        return this.data;
    }

    public Object getData(Object key) {
        return this.data.get(key);
    }

    public void setData(Object key, Object d) {
        this.data.put(key, d);
        this.updateUpdateTime();
    }

    public long getID() {
        return this.id;
    }

    public void setID(long i) {
        this.id = i;
        this.updateUpdateTime();
    }

    public int getTime() {
        if (state == null) {
            state = (State)State.findComponent((String)"State");
        }
        if (state != null) {
            return (Integer)state.getProperty((Object)"Time");
        }
        return -1;
    }

    public String toString() {
        return "[" + this.getID() + "] " + this.getName() + " - " + this.getDescription() + " (" + this.getCreationTime() + ":" + this.getUpdateTime() + ")";
    }
}

