/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.coordinate.FSM;
import agent.coordinate.FSMEvent;
import agent.coordinate.FSMEventListener;
import agent.coordinate.KQMLFSMEvent;
import agent.mass.State;
import agent.simplest.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import taems.Commitment;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.Taems;
import taems.TaskBase;
import taems.parser.ReadTTaems;
import utilities.Distribution;
import utilities.KQMLMessage;

public class TaskAssignResponser
extends FSM
implements Serializable {
    Long _lID;
    Vector _proposals;
    Vector _counters;
    Commitment _commitment;
    boolean accept;
    boolean firstPC;
    String responder;
    String initiator;
    int n;
    final int START = 0;
    final int START2 = 1;
    final int WAIT_AC = 2;
    final int EVAL_PC = 3;
    final int REFINE = 4;
    final int ACCEPT = 5;

    public TaskAssignResponser(Log l, State s, FSMEventListener list) {
        super(l, s, list);
        this.current_state = 0;
    }

    public static Object initiate(FSMEvent event, Log l, State s, FSMEventListener list) {
        if (event == null) {
            return null;
        }
        TaskAssignResponser newfsm = null;
        if (event.matchLabel("*:PoseContract")) {
            newfsm = new TaskAssignResponser(l, s, list);
            newfsm.initNegotiationEvent(event);
            return newfsm;
        }
        return newfsm;
    }

    public void fsmEventReceived(FSMEvent ce) {
        if (ce.matchLabel("event:Accepted") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:EvalPCoffer") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:PCAccept") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:PCReject") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:RefinePC") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:Counter") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:Redo") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:PCoffer") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Counteroffer") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Accept") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Reject") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:PoseContract")) {
            this.recvEvents.addElement(ce);
        }
    }

    public boolean final_state() {
        return this.current_state == 5;
    }

    public Vector enabledTransitions() {
        Vector<String> enabled = new Vector<String>();
        switch (this.current_state) {
            case 0: {
                if (!this.Event("PoseContract")) break;
                enabled.addElement("0");
                break;
            }
            case 1: {
                if (!this.rcvMsgPCoffer()) break;
                enabled.addElement("1");
                break;
            }
            case 2: {
                if (this.rcvEvtCounter()) {
                    enabled.addElement("4");
                    break;
                }
                if (!this.rcvEvtRedo()) break;
                enabled.addElement("5");
                break;
            }
            case 3: {
                if (this.rcvEvtPCAccept()) {
                    enabled.addElement("2");
                    break;
                }
                if (!this.rcvEvtPCReject()) break;
                enabled.addElement("3");
                break;
            }
            case 4: {
                if (this.rcvMsgReject()) {
                    enabled.addElement("6");
                    break;
                }
                if (!this.rcvMsgAccept()) break;
                enabled.addElement("7");
                break;
            }
        }
        return enabled;
    }

    public void fireTransition(String trans) {
        int tindex = Integer.parseInt(trans);
        switch (tindex) {
            case 0: {
                this.noOp();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state EVAL_PC", 2, this.FAC_FSM);
                break;
            }
            case 1: {
                this.sndEvtEvalPCoffer();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state EVAL_PC", 2, this.FAC_FSM);
                break;
            }
            case 2: {
                this.sndMsgAccept();
                this.current_state = 5;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state ACCEPT", 2, this.FAC_FSM);
                break;
            }
            case 3: {
                this.sndEvtRefinePC();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT_AC", 2, this.FAC_FSM);
                break;
            }
            case 4: {
                this.sndMsgCounter();
                this.current_state = 4;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state REFINE", 2, this.FAC_FSM);
                break;
            }
            case 5: {
                this.sndEvtRefinePC();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT_AC", 2, this.FAC_FSM);
                break;
            }
            case 6: {
                this.noOp();
                this.current_state = 1;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state START2", 2, this.FAC_FSM);
                break;
            }
            case 7: {
                this.noOp();
                this.current_state = 5;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state ACCEPT", 2, this.FAC_FSM);
            }
        }
    }

    public void sndEvtEvalPCoffer() {
        this.log.log("Sending EvalPCoffer", 2, this.FAC_FSM);
        Taems t = new Taems();
        TaskBase m = this._commitment.getTask();
        this.log.log("TAResp, EvalPCoffer, commitment contains: " + m.toString(), 2, this.FAC_FSM);
        t.addNode((Node)m);
        t.addCommitment(this._commitment);
        int ts = (Integer)this.state.getProperty((Object)"Time");
        FSMEvent evt = new FSMEvent(this, "EvalPCoffer", ts, 1);
        evt.setTaems(t);
        this.startFireEvent(evt);
    }

    public void sndEvtRefinePC() {
        Method m = (Method)this._commitment.getTaskVector().elementAt(0);
        if (this.firstPC) {
            this.firstPC = false;
            Commitment com = (Commitment)this._commitment.clone();
            com.setDeadline(-1);
            com.setEarliestStartTime(-1);
            com.setMinimumQuality(1.0f);
            Outcome outc = (Outcome)m.getOutcomes().nextElement();
            outc.setQuality(new Distribution(1.0f, 1.0f));
            this.log.log("TAResp, RefinePC m quality set to 1", 2, this.FAC_FSM);
            Vector<Method> v = new Vector<Method>();
            v.addElement(m);
            com.setTaskVector(v);
            Taems t = new Taems();
            t.addNode((Node)m);
            t.addCommitment(com);
            int ts = (Integer)this.state.getProperty((Object)"Time");
            FSMEvent evt = new FSMEvent(this, "RefinePC", ts, 1);
            evt.setTaems(t);
            this.startFireEvent(evt);
            return;
        }
        Commitment com2 = (Commitment)this._proposals.lastElement();
        int est1 = this._commitment.getEarliestStartTime();
        int est2 = com2.getEarliestStartTime();
        int est3 = 0;
        int dl1 = this._commitment.getDeadline();
        int dl2 = com2.getDeadline();
        int dl3 = 0;
        est3 = est1 > est2 ? (est1 + est2) / 2 : est1;
        dl3 = dl1 < dl2 ? (dl1 + dl2) / 2 : dl1;
        this.log.log("sndEvtRefinePC: dl1 = " + dl1 + " est1 " + est1 + " dl2 = " + dl2 + " est2 = " + est2 + " new dl = " + dl3 + " new est = " + est3, 2, this.FAC_FSM);
        this._proposals.addElement(this._commitment);
        this._commitment.setDeadline(dl3);
        this._commitment.setEarliestStartTime(est3);
        Taems t = new Taems();
        t.addNode((Node)m);
        t.addCommitment(this._commitment);
        int ts = (Integer)this.state.getProperty((Object)"Time");
        FSMEvent evt = new FSMEvent(this, "RefinePC", ts, 1);
        evt.setTaems(t);
        this.startFireEvent(evt);
    }

    public boolean rcvEvtPCAccept() {
        FSMEvent evt = this.EventReceived("PCAccept");
        return evt != null;
    }

    public boolean rcvEvtPCReject() {
        Commitment c;
        FSMEvent evt = this.EventReceived("PCReject");
        if (evt == null) {
            return false;
        }
        Taems t = evt.getTaems();
        this._commitment = c = t.getCommitment();
        return true;
    }

    public boolean rcvEvtRedo() {
        Commitment c;
        FSMEvent evt = this.EventReceived("Redo");
        if (evt == null) {
            return false;
        }
        Taems t = evt.getTaems();
        this._commitment = c = t.getCommitment();
        return true;
    }

    public boolean rcvEvtCounter() {
        FSMEvent evt = this.EventReceived("Counter");
        if (evt == null) {
            return false;
        }
        if (evt.getTaems() == null) {
            this.log.log("rcvEvtCounter: received event has no taems!", 0, this.FAC_FSM);
        }
        this.log.log("rcvEvtCounter: received Counter", 2, this.FAC_FSM);
        Enumeration e = evt.getTaems().getCommitments();
        Commitment c = (Commitment)e.nextElement();
        if (c != null) {
            this._commitment = c;
            this._counters.addElement(c);
        } else {
            this.log.log("rcvEvtCounter: received com is null!", 0, this.FAC_FSM);
        }
        return true;
    }

    public void sndMsgAccept() {
        Taems ta = new Taems();
        ta.addNode((Node)this._commitment.getTask());
        ta.addCommitment(this._commitment);
        String cn = ta.toString();
        KQMLMessage msgAccept = new KQMLMessage("tell", (Object)("(Accept " + cn + ")"), this.initiator);
        msgAccept.addField("reply-with", "" + this._commitment.getID());
        KQMLFSMEvent evt = new KQMLFSMEvent(this, msgAccept);
        evt.setType("Accept");
        this.sndEvtAcc();
        this.startFireEvent(evt);
    }

    public void sndMsgCounter() {
        Taems ta = new Taems();
        ta.addNode((Node)this._commitment.getTask());
        ta.addCommitment(this._commitment);
        String cn = ta.toString();
        KQMLMessage send = new KQMLMessage("tell", (Object)("(Counteroffer " + cn + ") "), this.initiator);
        send.addField("reply-with", "" + this._commitment.getID());
        KQMLFSMEvent evt = new KQMLFSMEvent(this, send);
        evt.setType("Counteroffer");
        this.startFireEvent(evt);
        this.log.log("Sending counteroffer to " + this.initiator, 2, this.FAC_FSM);
    }

    public boolean rcvMsgAccept() {
        KQMLFSMEvent evt = (KQMLFSMEvent)this.EventReceived("Accept");
        if (evt == null) {
            return false;
        }
        KQMLMessage msgAccept = evt.getMessage();
        if (msgAccept == null) {
            return false;
        }
        String data = msgAccept.contentData();
        ReadTTaems readTaems = new ReadTTaems(utilities.Log.getDefault());
        Taems t = readTaems.readTTaems((Reader)new StringReader(data));
        Enumeration e = t.getCommitments();
        this._commitment = (Commitment)e.nextElement();
        this.sndEvtAcc();
        return true;
    }

    public boolean rcvMsgReject() {
        KQMLFSMEvent evt = (KQMLFSMEvent)this.EventReceived("Reject");
        return evt != null;
    }

    public boolean rcvMsgPCoffer() {
        KQMLFSMEvent evt = (KQMLFSMEvent)this.EventReceived("PCoffer");
        if (evt == null) {
            return false;
        }
        KQMLMessage msg = evt.getMessage();
        if (msg == null) {
            return false;
        }
        String data = msg.contentData();
        ReadTTaems readTaems = new ReadTTaems(utilities.Log.getDefault());
        Taems t = readTaems.readTTaems((Reader)new StringReader(data));
        Enumeration e = t.getCommitments();
        this._commitment = (Commitment)e.nextElement();
        return true;
    }

    public void sndEvtAcc() {
        Taems t = new Taems();
        t.addCommitment(this._commitment);
        int ts = (Integer)this.state.getProperty((Object)"Time");
        FSMEvent evt = new FSMEvent(this, "Accepted", ts, 1);
        evt.setTaems(t);
        this.startFireEvent(evt);
    }

    public void evalCounteroffer() {
        if (this.n > 10) {
            this.accept = true;
        }
        ++this.n;
        this.log.log("Evaluating offer approval=" + this.accept + " iteration " + this.n, 2, this.FAC_FSM);
    }

    public void noOp() {
    }

    public void evalPCoffer() {
        this.accept = false;
        this.log.log("Evaluating offer approval=" + this.accept + " iteration " + this.n, 2, this.FAC_FSM);
    }

    protected boolean testCommitment(FSMEvent evt) {
        Commitment com;
        this.log.log("testCommitment: checking event " + evt, 2, this.FAC_FSM);
        Enumeration e = evt.getTaems().getCommitments();
        return e != null && (com = (Commitment)e.nextElement()).getID() == this._lID.longValue();
    }

    protected boolean testKQML(FSMEvent evt) {
        this.log.log("testKQML: checking event " + evt, 2, this.FAC_FSM);
        if (evt instanceof KQMLFSMEvent) {
            KQMLMessage m = ((KQMLFSMEvent)evt).getMessage();
            if (m == null) {
                return false;
            }
            return this.testMsg(m);
        }
        return false;
    }

    protected boolean testMsg(KQMLMessage m) {
        this.log.log("testMsg: checking msg " + m, 2, this.FAC_FSM);
        if (m.getField("in-reply-to") != null && Long.parseLong(m.getField("in-reply-to")) == this._lID) {
            this.log.log("testMsg: msg accepted: " + m, 2, this.FAC_FSM);
            return true;
        }
        if (m.getField("reply-with") != null && Long.parseLong(m.getField("reply-with")) == this._lID) {
            this.log.log("testMsg: msg accepted: " + m, 2, this.FAC_FSM);
            return true;
        }
        this.log.log("testMsg: msg rejected: msgID = " + Long.parseLong(m.getField("reply-with")) + " _lID = " + this._lID, 2, this.FAC_FSM);
        return false;
    }

    public void initNegotiationEvent(FSMEvent ce) {
        this.log.log("initNegotiationEvent: " + ce, 4, this.FAC_FSM);
        this._proposals = new Vector();
        this._counters = new Vector();
        try {
            KQMLMessage m = ((KQMLFSMEvent)ce).getMessage();
            if (!m.getDestAddr().equals((String)this.state.getProperty((Object)"Name"))) {
                return;
            }
            String data = m.contentData();
            this.log.log("TAResp KQML data : " + data, 2, this.FAC_FSM);
            try {
                File outputFile2 = new File("KQMLdata.txt");
                FileWriter out2 = new FileWriter(outputFile2);
                out2.write(data);
            }
            catch (IOException e) {
                this.log.log("IOException", 2, this.FAC_FSM);
            }
            ReadTTaems readTaems = new ReadTTaems(utilities.Log.getDefault());
            Taems t = readTaems.readTTaems((Reader)new StringReader(data));
            t.retargetCommitments();
            Enumeration e = t.getCommitments();
            this._commitment = (Commitment)e.nextElement();
            this.log.log("TAResp t.getComm : " + this._commitment.toString(), 2, this.FAC_FSM);
            this._lID = new Long(this._commitment.getID());
            this.log.log("init: commitmentID = " + this._commitment.getID(), 2, this.FAC_FSM);
        }
        catch (ClassCastException cce) {
            this.log.log((Object)cce, 1, this.FAC_FSM);
            this.current_state = 5;
            return;
        }
        catch (NullPointerException npe) {
            this.log.log((Object)npe, 1, this.FAC_FSM);
            this.current_state = 5;
            return;
        }
        this._proposals.addElement(this._commitment);
        this.accept = false;
        this.firstPC = true;
        this.n = 0;
        this.initiator = this._commitment.getFromAgent().getLabel();
        this.responder = this._commitment.getToAgent().getLabel();
        TaskBase m1 = this._commitment.getTask();
        this.log.log("TAResp, commitment contains: " + m1.toString(), 2, this.FAC_FSM);
        this.log.log("Initiating FSM", 2, this.FAC_FSM);
        this.log.log("About to send EvalPCoffer", 2, this.FAC_FSM);
        this.sndEvtEvalPCoffer();
        this.current_state = 3;
    }
}

