/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.coordinate.FSM;
import agent.coordinate.FSMEvent;
import agent.coordinate.FSMEventListener;
import agent.coordinate.KQMLFSMEvent;
import agent.mass.State;
import agent.simplest.Log;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import taems.Commitment;
import taems.Node;
import taems.Taems;
import taems.TaskBase;
import taems.parser.ReadTTaems;
import utilities.KQMLMessage;

public class TaskAssignInitiator
extends FSM
implements Serializable {
    Long _lID;
    Vector _proposals;
    Vector _counters;
    Vector _ACS;
    Commitment _commitment;
    boolean accept;
    String responder;
    String initiator;
    int n;
    final int START = 0;
    final int START2 = 1;
    final int WAIT = 2;
    final int WAIT_AC = 3;
    final int EVAL_COUNTEROFFER = 4;
    final int ACCEPT = 5;
    final int NEXT_OFFER = 6;

    public TaskAssignInitiator(Log l, State s, FSMEventListener list) {
        super(l, s, list);
        this.current_state = 0;
    }

    public static Object initiate(FSMEvent event, Log l, State s, FSMEventListener list) {
        if (event == null) {
            return null;
        }
        TaskAssignInitiator newfsm = null;
        if (event.matchLabel("event:TaskAssignRequest")) {
            newfsm = new TaskAssignInitiator(l, s, list);
            newfsm.initNegotiationEvent(event);
            return newfsm;
        }
        return newfsm;
    }

    public void fsmEventReceived(FSMEvent ce) {
        if (ce.matchLabel("event:Accepted") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:EvalCounteroffer") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:PCAccept") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:PCReject") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:ImprovePC") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:NextPC") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:Redo") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:PoseContract") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:PCoffer") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Counteroffer") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Accept") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Reject") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:TaskAssignRequest")) {
            this.recvEvents.addElement(ce);
        }
    }

    public boolean final_state() {
        return this.current_state == 5;
    }

    public Vector enabledTransitions() {
        Vector<String> enabled = new Vector<String>();
        switch (this.current_state) {
            case 0: {
                if (!this.Event("TaskAssignRequest")) break;
                enabled.addElement("0");
                break;
            }
            case 1: {
                enabled.addElement("1");
                break;
            }
            case 2: {
                if (this.rcvMsgAccept()) {
                    enabled.addElement("2");
                    break;
                }
                if (!this.rcvMsgCounteroffer()) break;
                enabled.addElement("3");
                break;
            }
            case 3: {
                if (this.rcvEvtNextPC()) {
                    enabled.addElement("7");
                    break;
                }
                if (!this.rcvEvtRedo()) break;
                enabled.addElement("8");
                break;
            }
            case 4: {
                if (this.rcvEvtPCAccept()) {
                    enabled.addElement("4");
                    break;
                }
                if (!this.rcvEvtPCReject()) break;
                enabled.addElement("5");
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                enabled.addElement("6");
            }
        }
        return enabled;
    }

    public void fireTransition(String trans) {
        int tindex = Integer.parseInt(trans);
        switch (tindex) {
            case 0: {
                this.noOp();
                this.current_state = 1;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state START2", 2, this.FAC_FSM);
                break;
            }
            case 1: {
                this.sndMsgPC();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT", 2, this.FAC_FSM);
                break;
            }
            case 2: {
                this.noOp();
                this.current_state = 5;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state ACCEPT", 2, this.FAC_FSM);
                break;
            }
            case 3: {
                this.sndEvtEvalCounteroffer();
                this.current_state = 4;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state EVAL_COUNTEROFFER", 2, this.FAC_FSM);
                break;
            }
            case 4: {
                this.sndMsgAccept();
                this.current_state = 5;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state ACCEPT", 2, this.FAC_FSM);
                break;
            }
            case 5: {
                this.sndMsgReject();
                this.current_state = 6;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state NEXT_OFFER", 2, this.FAC_FSM);
                break;
            }
            case 6: {
                this.sndEvtImprovePC();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT_AC", 2, this.FAC_FSM);
                break;
            }
            case 7: {
                this.sndMsgPCoffer();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT", 2, this.FAC_FSM);
                break;
            }
            case 8: {
                this.sndEvtImprovePC();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT_AC", 2, this.FAC_FSM);
            }
        }
    }

    public void sndMsgPC() {
        Taems ta = new Taems();
        ta.addNode((Node)this._commitment.getTask());
        ta.addCommitment(this._commitment);
        String cn = ta.toString();
        this.accept = false;
        KQMLMessage send = new KQMLMessage("tell", (Object)("(PoseContract " + cn + ") "), this.responder);
        send.addField("reply-with", "" + this._commitment.getID());
        KQMLFSMEvent evt = new KQMLFSMEvent(this, send);
        evt.setType("PoseContract");
        this.startFireEvent(evt);
        this.log.log("Starting negotiation between " + this.initiator + " and " + this.responder, 2, this.FAC_FSM);
    }

    public void sndMsgPCoffer() {
        Taems ta = new Taems();
        ta.addNode((Node)this._commitment.getTask());
        ta.addCommitment(this._commitment);
        String cn = ta.toString();
        KQMLMessage send = new KQMLMessage("tell", (Object)("(PCoffer " + cn + ") "), this.responder);
        send.addField("reply-with", "" + this._commitment.getID());
        KQMLFSMEvent evt = new KQMLFSMEvent(this, send);
        evt.setType("PCoffer");
        this.startFireEvent(evt);
        this.log.log("Sending PC offer ", 2, this.FAC_FSM);
    }

    public void sndMsgReject() {
        KQMLMessage msgReject = new KQMLMessage("tell", (Object)"(Reject)", this.responder);
        msgReject.addField("reply-with", "" + this._commitment.getID());
        KQMLFSMEvent evt = new KQMLFSMEvent(this, msgReject);
        evt.setType("Reject");
        this.startFireEvent(evt);
    }

    public void sndMsgAccept() {
        Taems ta = new Taems();
        ta.addNode((Node)this._commitment.getTask());
        ta.addCommitment(this._commitment);
        String cn = ta.toString();
        KQMLMessage msgAccept = new KQMLMessage("tell", (Object)("(Accept " + cn + ")"), this.responder);
        msgAccept.addField("reply-with", "" + this._commitment.getID());
        KQMLFSMEvent evt = new KQMLFSMEvent(this, msgAccept);
        evt.setType("Accept");
        this.sndEvtAcc();
        this.startFireEvent(evt);
    }

    public void sndEvtImprovePC() {
        Taems t = new Taems();
        Commitment com2 = (Commitment)this._proposals.lastElement();
        int est1 = this._commitment.getEarliestStartTime();
        int est2 = com2.getEarliestStartTime();
        int est3 = 0;
        int dl1 = this._commitment.getDeadline();
        int dl2 = com2.getDeadline();
        int dl3 = 0;
        est3 = est1 > est2 ? est1 / this.n + (this.n - 1) * est2 / this.n : est1;
        dl3 = dl1 < dl2 ? dl1 / this.n + (this.n - 1) * dl2 / this.n : dl1;
        this.log.log("sndEvtImprovePC: n = " + this.n + " dl1 = " + dl1 + " est1 " + est1 + " dl2 = " + dl2 + " est2 = " + est2 + " new dl = " + dl3 + " new est = " + est3, 2, this.FAC_FSM);
        this._commitment.setDeadline(dl3);
        this._commitment.setEarliestStartTime(est3);
        t.addCommitment(this._commitment);
        this._proposals.addElement(this._commitment);
        int ts = (Integer)this.state.getProperty((Object)"Time");
        FSMEvent evt = new FSMEvent(this, "ImprovePC", ts, 1);
        evt.setTaems(t);
        this.startFireEvent(evt);
    }

    public void sndEvtEvalCounteroffer() {
        Taems t = new Taems();
        boolean over = this.n > 5;
        ++this.n;
        this._commitment.setAttribute((Object)"ItersOver", (Object)new Boolean(over));
        t.addCommitment(this._commitment);
        int ts = (Integer)this.state.getProperty((Object)"Time");
        FSMEvent evt = new FSMEvent(this, "EvalCounteroffer", ts, 1);
        evt.setTaems(t);
        this.startFireEvent(evt);
    }

    public boolean rcvEvtRedo() {
        FSMEvent evt = this.EventReceived("Redo");
        if (evt == null) {
            return false;
        }
        this.n *= 2;
        this.log.log("rcvEvtRedo: n is " + this.n, 2, this.FAC_FSM);
        return true;
    }

    public boolean rcvEvtNextPC() {
        FSMEvent evt = this.EventReceived("NextPC");
        if (evt == null) {
            return false;
        }
        if (evt.getTaems() == null) {
            this.log.log("rcvEvtNextPC: received event has no taems!", 0, this.FAC_FSM);
        }
        this.log.log("rcvEvtNextPC: received NextPC", 2, this.FAC_FSM);
        Enumeration e = evt.getTaems().getCommitments();
        Commitment c = (Commitment)e.nextElement();
        if (c != null) {
            this._commitment = c;
            this._proposals.addElement(c);
        } else {
            this.log.log("rcvEvtNextPC: received com is null!", 0, this.FAC_FSM);
        }
        return true;
    }

    public boolean rcvEvtPCAccept() {
        boolean addACS;
        FSMEvent evt = this.EventReceived("PCAccept");
        if (evt == null) {
            return false;
        }
        Taems t = evt.getTaems();
        Commitment com = t.getCommitment();
        if (com.hasAttribute((Object)"AddACS") && (addACS = ((Boolean)com.getAttribute((Object)"AddACS")).booleanValue())) {
            this._ACS.addElement(com);
            this.log.log("Adding com to ACS: " + com, 2, this.FAC_FSM);
        }
        Enumeration acs = this._ACS.elements();
        int i = 0;
        int maxInd = 0;
        float marginalUtilityGain = 0.0f;
        float marginalUtilityCost = 0.0f;
        float max = 0.0f;
        float auxF = 0.0f;
        this.log.log("Choosing best com from ACS", 2, this.FAC_FSM);
        while (acs.hasMoreElements()) {
            com = (Commitment)acs.nextElement();
            if (!com.hasAttribute((Object)"marginalUtilityGain")) {
                this.log.log("Com " + i + " from ACS has no marginalUtilityGain attribute", 2, this.FAC_FSM);
                continue;
            }
            if (!com.hasAttribute((Object)"marginalUtilityCost")) {
                this.log.log("Com " + i + " from ACS has no marginalUtilityCost attribute", 2, this.FAC_FSM);
                continue;
            }
            marginalUtilityGain = ((Float)com.getAttribute((Object)"marginalUtilityGain")).floatValue();
            auxF = marginalUtilityGain + (marginalUtilityCost = ((Float)com.getAttribute((Object)"marginalUtilityCost")).floatValue());
            if (auxF > max) {
                max = auxF;
                maxInd = i;
            }
            ++i;
        }
        this._commitment = (Commitment)this._ACS.elementAt(maxInd);
        this.log.log("Commitment " + maxInd + " from ACS was chosen as best: " + this._commitment, 2, this.FAC_FSM);
        return true;
    }

    public boolean rcvEvtPCReject() {
        boolean addACS;
        FSMEvent evt = this.EventReceived("PCReject");
        if (evt == null) {
            return false;
        }
        Taems t = evt.getTaems();
        Commitment com = t.getCommitment();
        if (com.hasAttribute((Object)"AddACS") && (addACS = ((Boolean)com.getAttribute((Object)"AddACS")).booleanValue())) {
            this._ACS.addElement(com);
            this.log.log("Adding com to ACS: " + com, 2, this.FAC_FSM);
        }
        this._commitment = com;
        return true;
    }

    public boolean rcvMsgAccept() {
        KQMLFSMEvent evt = (KQMLFSMEvent)this.EventReceived("Accept");
        if (evt == null) {
            return false;
        }
        KQMLMessage msgAccept = evt.getMessage();
        if (msgAccept == null) {
            return false;
        }
        String data = msgAccept.contentData();
        ReadTTaems readTaems = new ReadTTaems(utilities.Log.getDefault());
        Taems t = readTaems.readTTaems((Reader)new StringReader(data));
        Enumeration e = t.getCommitments();
        this._commitment = (Commitment)e.nextElement();
        this.sndEvtAcc();
        return true;
    }

    public boolean rcvMsgCounteroffer() {
        KQMLFSMEvent evt = (KQMLFSMEvent)this.EventReceived("Counteroffer");
        if (evt == null) {
            return false;
        }
        KQMLMessage msg = evt.getMessage();
        if (msg == null) {
            return false;
        }
        String data = msg.contentData();
        ReadTTaems readTaems = new ReadTTaems(utilities.Log.getDefault());
        Taems t = readTaems.readTTaems((Reader)new StringReader(data));
        Enumeration e = t.getCommitments();
        Commitment c = (Commitment)e.nextElement();
        this._counters.addElement(this._commitment.clone());
        this._commitment = c;
        return true;
    }

    public void sndEvtAcc() {
        Taems t = new Taems();
        t.addCommitment(this._commitment);
        int ts = (Integer)this.state.getProperty((Object)"Time");
        FSMEvent evt = new FSMEvent(this, "Accepted", ts, 1);
        evt.setTaems(t);
        this.startFireEvent(evt);
    }

    public void noOp() {
    }

    protected boolean testCommitment(FSMEvent evt) {
        Commitment com;
        this.log.log("testCommitment: checking event " + evt, 2, this.FAC_FSM);
        Enumeration e = evt.getTaems().getCommitments();
        return e != null && (com = (Commitment)e.nextElement()).getID() == this._lID.longValue();
    }

    protected boolean testKQML(FSMEvent evt) {
        this.log.log("testKQML: checking event " + evt, 2, this.FAC_FSM);
        if (evt instanceof KQMLFSMEvent) {
            KQMLMessage m = ((KQMLFSMEvent)evt).getMessage();
            if (m == null) {
                return false;
            }
            return this.testMsg(m);
        }
        return false;
    }

    protected boolean testMsg(KQMLMessage m) {
        this.log.log("testMsg: checking msg " + m, 2, this.FAC_FSM);
        if (m.getField("in-reply-to") != null && Long.parseLong(m.getField("in-reply-to")) == this._lID) {
            this.log.log("testMsg: msg accepted: " + m, 2, this.FAC_FSM);
            return true;
        }
        if (m.getField("reply-with") != null && Long.parseLong(m.getField("reply-with")) == this._lID) {
            this.log.log("testMsg: msg accepted: " + m, 2, this.FAC_FSM);
            return true;
        }
        this.log.log("testMsg: msg rejected: msgID = " + Long.parseLong(m.getField("reply-with")) + " _lID = " + this._lID, 2, this.FAC_FSM);
        return false;
    }

    public void initNegotiationEvent(FSMEvent ce) {
        this.log.log("initNegotiationEvent: " + ce, 4, this.FAC_FSM);
        try {
            Enumeration e = ce.getTaems().getCommitments();
            this._commitment = (Commitment)e.nextElement();
            this._lID = new Long(this._commitment.getID());
            this.log.log("init: commitmentID = " + this._commitment.getID(), 2, this.FAC_FSM);
        }
        catch (ClassCastException cce) {
            this.log.log((Object)cce, 1, this.FAC_FSM);
            this.current_state = 5;
            return;
        }
        catch (NullPointerException npe) {
            this.log.log((Object)npe, 1, this.FAC_FSM);
            this.current_state = 5;
            return;
        }
        TaskBase m = this._commitment.getTask();
        this.log.log("TAIni, commitment contains: " + m.toString(), 2, this.FAC_FSM);
        this._proposals = new Vector();
        this._counters = new Vector();
        this._ACS = new Vector();
        this._proposals.addElement(this._commitment);
        this.accept = false;
        this.n = 1;
        this.initiator = this._commitment.getFromAgent().getLabel();
        this.responder = this._commitment.getToAgent().getLabel();
        this.log.log("Initiating FSM", 2, this.FAC_FSM);
        this.current_state = 1;
    }
}

