/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.coordinate.CoordinateEvent;
import agent.coordinate.CoordinateEventListener;
import agent.coordinate.FSMCoordination;
import agent.simplest.Communicate;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.Observe;
import agent.simplest.Observer;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import taems.Agent;
import taems.Commitment;
import taems.Taems;
import utilities.KQMLMessage;

public class SimpleCoordinate
extends AgentComponent
implements MessageEventListener {
    static final long serialVersionUID = 1234567890L;
    protected ListenerVector listeners = new ListenerVector();
    protected Communicate communicate;
    protected Log log;
    protected Observe observe;
    protected Hashtable commitments = new Hashtable();
    protected FSMCoordination fsm;
    protected int FAC_SC;
    public static final int RECVBROADCAST = 1;
    public static final int RECVCONTROL = 2;
    public static final int RECVPERSON = 3;
    public static final int EMITBROADCAST = 4;
    public static final int EMITCONTROL = 5;
    public static final int EMITPERSON = 6;
    public static final int RECVREQUESTRES = 7;
    public static final int RECVREQUEST = 8;
    public static final int RECVANSWEROK = 9;
    public static final int RECVANSWERCONF = 10;
    public static final int RECNULLIFY = 11;
    public static final int RECVREPLY = 12;
    public static final int EMITREQUESTRES = 13;
    public static final int EMITREQUEST = 14;
    public static final int EMITANSWEROK = 15;
    public static final int EMITANSWERCONF = 16;
    public static final int EMITNULLIFY = 17;
    public static final int EMITREPLY = 18;
    public static final int MAXCLASSES = 18;

    public SimpleCoordinate() {
        this.addDependency("Communicate");
        this.addDependency("Log");
        this.addDependency("Observe");
    }

    public void init() {
        super.init();
        this.communicate = (Communicate)State.findComponent((String)"Communicate");
        this.log = (Log)State.findComponent((String)"Log");
        this.observe = (Observe)State.findComponent((String)"Observe");
        this.fsm = (FSMCoordination)State.findComponent((String)"FSMCoordination");
        this.FAC_SC = this.log.getFacilityID((AgentComponent)this);
        this.communicate.addMessageEventListener((MessageEventListener)this);
    }

    public void begin() {
        if (this.observe != null) {
            this.postObserverJob();
        }
    }

    public void reset() {
        this.commitments.clear();
    }

    public void addCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    protected void fireEvent(AgentEvent event) {
        CoordinateEvent e = (CoordinateEvent)event;
        Enumeration enumeration = this.listeners.elements();
        this.log.log("Firing a coordinate event", 4, this.FAC_SC);
        while (enumeration.hasMoreElements()) {
            CoordinateEventListener l = (CoordinateEventListener)enumeration.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0x100000: {
                    l.coordinateEventReceived(e);
                    break;
                }
                case 0: {
                    l.coordinateEventSent(e);
                    break;
                }
            }
        }
        if (this.log != null) {
            this.log.log((Object)e, 2, this.FAC_SC);
        }
        this.log.log("Fired a coordinate event", 5, this.FAC_SC);
    }

    public void handleMessageEvent(MessageEvent me, boolean recv) {
        int eid;
        KQMLMessage m = (KQMLMessage)me.getMessage();
        String perf = m.getPerformative();
        int n = eid = recv ? 0x100000 : 0;
        if (perf.equalsIgnoreCase("ask")) {
            if (m.contentWord().equalsIgnoreCase("Need")) {
                if (this.fsm != null) {
                    try {
                        if (this.fsm.hasFSM(Class.forName("agent.coordinate.CSharpResponder"))) {
                            this.log.log("Ignoring message - it will most likely be handled by an FSM", 3, this.FAC_SC);
                            return;
                        }
                        if (this.fsm.hasFSM(Class.forName("agent.coordinate.DSharpResponder"))) {
                            this.log.log("Ignoring message - it will most likely be handled by an FSM", 3, this.FAC_SC);
                            return;
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        this.log.log("Whoops " + ex, 1, this.FAC_SC);
                    }
                }
                StringTokenizer s = new StringTokenizer(m.contentData());
                String resource = s.nextToken();
                int priority = Integer.parseInt(s.nextToken());
                float quantity = Float.valueOf(s.nextToken()).floatValue();
                s.nextToken();
                int start = Integer.parseInt(s.nextToken());
                int duration = Integer.parseInt(s.nextToken());
                long id = Long.parseLong(s.nextToken());
                Commitment c = new Commitment();
                c.setFromAgent(new Agent(m.getSourceAddr()));
                c.setImportance(priority);
                c.setResource(resource);
                c.setQuantity(quantity);
                c.setEarliestStartTime(start);
                c.setTimeSatisfied(start + duration);
                c.setID(id);
                this.commitments.put(new Long(id), c);
                Taems taems = new Taems();
                taems.addCommitment(c);
                CoordinateEvent ce = new CoordinateEvent((Object)this, eid |= 0x10, taems);
                ce.setCoordinateID(id);
                this.startFireEvent(ce);
            }
        } else if (perf.equalsIgnoreCase("reply")) {
            if (m.contentWord().equalsIgnoreCase("Accept") || m.contentWord().equalsIgnoreCase("Okay")) {
                StringTokenizer s = new StringTokenizer(m.contentData());
                String resource = s.nextToken();
                Long id = Long.valueOf(s.nextToken());
                Commitment c = (Commitment)this.commitments.get(id);
                if (c == null) {
                    this.log.log("No commitment " + id + " found", 1, this.FAC_SC);
                    return;
                }
                Taems taems = new Taems();
                taems.addCommitment(c);
                CoordinateEvent ce = new CoordinateEvent((Object)this, eid |= 1, taems);
                ce.setCoordinateID(id);
                this.startFireEvent(ce);
            } else if (m.contentWord().equalsIgnoreCase("NotAccept")) {
                StringTokenizer s = new StringTokenizer(m.contentData());
                String resource = s.nextToken();
                Long id = Long.valueOf(s.nextToken());
                Commitment c = (Commitment)this.commitments.get(id);
                if (c == null) {
                    this.log.log("No commitment " + id + " found", 1, this.FAC_SC);
                    return;
                }
                Taems taems = new Taems();
                taems.addCommitment(c);
                CoordinateEvent ce = new CoordinateEvent((Object)this, eid |= 0x1000, taems);
                ce.setCoordinateID(id);
                this.startFireEvent(ce);
            }
        } else if (perf.equalsIgnoreCase("tell") && m.contentWord().equalsIgnoreCase("Cancel")) {
            StringTokenizer s = new StringTokenizer(m.contentData());
            String resource = s.nextToken();
            Long id = Long.valueOf(s.nextToken());
            Commitment c = (Commitment)this.commitments.get(id);
            if (c == null) {
                this.log.log("No commitment " + id + " found", 1, this.FAC_SC);
                return;
            }
            Taems taems = new Taems();
            taems.addCommitment(c);
            CoordinateEvent ce = new CoordinateEvent((Object)this, eid |= 0x100, taems);
            ce.setCoordinateID(id);
            this.startFireEvent(ce);
        }
    }

    public void messageSent(MessageEvent me) {
        if (me.getConnection().getType() != 1) {
            return;
        }
        this.handleMessageEvent(me, false);
    }

    public void messageReceived(MessageEvent me) {
        if (me.getConnection().getType() != 1) {
            return;
        }
        this.handleMessageEvent(me, true);
    }

    protected void postObserverJob() {
        this.observe.addObserver(new Observer("RECV DIRECT", true){

            public boolean checkEvent(AgentEvent e) {
                State state = (State)State.findComponent((String)"State");
                String name = (String)state.getProperty((Object)"Name");
                return e instanceof MessageEvent && e.getID() == 1 && ((MessageEvent)e).getMessage().getDestAddr().equals(name);
            }
        });
        this.observe.addObserver(new Observer("RECV BROADCAST", true){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof MessageEvent && e.getID() == 1 && ((MessageEvent)e).getMessage().getDestAddr().equals("*");
            }
        });
        this.observe.addObserver(new Observer("RECV REQ RES.", true){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof MessageEvent && e.getID() == 1 && ((MessageEvent)e).getMessage().contentWord() != null && ((MessageEvent)e).getMessage().contentWord().equals("Need");
            }
        });
        this.observe.addObserver(new Observer("RECV ANS RES OK", true){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof MessageEvent && e.getID() == 1 && ((MessageEvent)e).getMessage().contentWord() != null && (((MessageEvent)e).getMessage().contentWord().equals("Accept") || ((MessageEvent)e).getMessage().contentWord().equals("Okay"));
            }
        });
        this.observe.addObserver(new Observer("RECV ANS RES CO", true){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof MessageEvent && e.getID() == 1 && ((MessageEvent)e).getMessage().contentWord() != null && (((MessageEvent)e).getMessage().contentWord().equals("NotAccept") || ((MessageEvent)e).getMessage().contentWord().equals("Conflict"));
            }
        });
        this.observe.addObserver(new Observer("REC NULL RES", true){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof MessageEvent && e.getID() == 1 && ((MessageEvent)e).getMessage().contentWord() != null && (((MessageEvent)e).getMessage().contentWord().equals("Release") || ((MessageEvent)e).getMessage().contentWord().equals("Cancel"));
            }
        });
        this.observe.addObserver(new Observer("RECV REQ NO RES", true){

            public boolean checkEvent(AgentEvent e) {
                KQMLMessage m;
                return e instanceof MessageEvent && e.getID() == 1 && (m = (KQMLMessage)((MessageEvent)e).getMessage()).getPerformative() != null && (m.getPerformative().equals("tell") || m.getPerformative().equals("ask")) && !((MessageEvent)e).getMessage().contentWord().equals("Need");
            }
        });
        this.observe.addObserver(new Observer("RECV REPLY", true){

            public boolean checkEvent(AgentEvent e) {
                KQMLMessage m;
                return e instanceof MessageEvent && e.getID() == 1 && (m = (KQMLMessage)((MessageEvent)e).getMessage()).getPerformative() != null && m.getPerformative().equals("reply");
            }
        });
        this.observe.addObserver(new Observer("RECV CONTROL", true){

            public boolean checkEvent(AgentEvent e) {
                KQMLMessage m;
                return e instanceof MessageEvent && e.getID() == 1 && (m = (KQMLMessage)((MessageEvent)e).getMessage()).getField("type") != null && m.getField("type").equals("control");
            }
        });
        this.observe.addObserver(new Observer("EMIT DIRECT", true){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof MessageEvent && e.getID() == 0 && (!((MessageEvent)e).getMessage().getDestAddr().equals("*") || !((MessageEvent)e).getMessage().getDestAddr().equals("simulator"));
            }
        });
        this.observe.addObserver(new Observer("EMIT BROADCAST", true){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof MessageEvent && e.getID() == 0 && ((MessageEvent)e).getMessage().getDestAddr().equals("*");
            }
        });
        this.observe.addObserver(new Observer("EMIT REQ RES", true){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof MessageEvent && e.getID() == 0 && ((MessageEvent)e).getMessage().contentWord() != null && ((MessageEvent)e).getMessage().contentWord().equals("Need");
            }
        });
        this.observe.addObserver(new Observer("EMIT ANS RES OK", true){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof MessageEvent && e.getID() == 0 && ((MessageEvent)e).getMessage().contentWord() != null && (((MessageEvent)e).getMessage().contentWord().equals("Accept") || ((MessageEvent)e).getMessage().contentWord().equals("Okay"));
            }
        });
        this.observe.addObserver(new Observer("EMIT ANS RES CO", true){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof MessageEvent && e.getID() == 0 && ((MessageEvent)e).getMessage().contentWord() != null && (((MessageEvent)e).getMessage().contentWord().equals("NotAccept") || ((MessageEvent)e).getMessage().contentWord().equals("Conflict"));
            }
        });
        this.observe.addObserver(new Observer("EMIT NULL RES", true){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof MessageEvent && e.getID() == 0 && ((MessageEvent)e).getMessage().contentWord() != null && (((MessageEvent)e).getMessage().contentWord().equals("Release") || ((MessageEvent)e).getMessage().contentWord().equals("Cancel"));
            }
        });
        this.observe.addObserver(new Observer("EMIT REQ NO RES", true){

            public boolean checkEvent(AgentEvent e) {
                KQMLMessage m;
                return e instanceof MessageEvent && e.getID() == 0 && (m = (KQMLMessage)((MessageEvent)e).getMessage()).getPerformative() != null && (m.getPerformative().equals("tell") || m.getPerformative().equals("ask")) && !((MessageEvent)e).getMessage().contentWord().equals("Need");
            }
        });
        this.observe.addObserver(new Observer("EMIT REPLY", true){

            public boolean checkEvent(AgentEvent e) {
                KQMLMessage m;
                return e instanceof MessageEvent && e.getID() == 0 && (m = (KQMLMessage)((MessageEvent)e).getMessage()).getPerformative() != null && m.getPerformative().equals("reply");
            }
        });
        this.observe.addObserver(new Observer("EMIT CONTROL", true){

            public boolean checkEvent(AgentEvent e) {
                KQMLMessage m;
                return e instanceof MessageEvent && e.getID() == 0 && (m = (KQMLMessage)((MessageEvent)e).getMessage()).getField("type") != null && m.getField("type").equals("control");
            }
        });
    }
}

