/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.coordinate.FSM;
import agent.coordinate.FSMEvent;
import agent.coordinate.FSMEventListener;
import agent.coordinate.KQMLFSMEvent;
import agent.mass.State;
import agent.simplest.Log;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import taems.Commitment;
import taems.Taems;
import taems.parser.ReadTTaems;
import utilities.KQMLMessage;

public class SSF_Mech4_Resp
extends FSM
implements Serializable {
    FSMEvent evtHPCR;
    Long _lID;
    Long coordID;
    Commitment facilitatesCommitment;
    Commitment infoComm;
    boolean offerApproved;
    String responder;
    String initiator;
    KQMLMessage curKQMLMsg;
    KQMLMessage msgHPCR;
    final int START = 0;
    final int START1 = 1;
    final int START2 = 2;
    final int WAIT_PS = 3;
    final int FINISH = 4;

    public SSF_Mech4_Resp(Log l, State s, FSMEventListener list) {
        super(l, s, list);
        this.current_state = 0;
    }

    public static Object initiate(FSMEvent event, Log l, State s, FSMEventListener list) {
        if (event == null) {
            return null;
        }
        SSF_Mech4_Resp newfsm = null;
        if (event.matchLabel("*:Request")) {
            newfsm = new SSF_Mech4_Resp(l, s, list);
            newfsm.initNegotiationEvent(event);
            return newfsm;
        }
        return newfsm;
    }

    public void fsmEventReceived(FSMEvent ce) {
        if (ce.matchLabel("event:Accepted") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:Rejected") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:EvalComm") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:StartSSFResp") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:StartedResp") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Accept") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Reject") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:Request")) {
            this.recvEvents.addElement(ce);
        }
    }

    public boolean final_state() {
        return this.current_state == 4;
    }

    public Vector enabledTransitions() {
        Vector<String> enabled = new Vector<String>();
        switch (this.current_state) {
            case 0: {
                if (!this.Event("Request")) break;
                enabled.addElement("0");
                break;
            }
            case 1: {
                enabled.addElement("1");
                break;
            }
            case 2: {
                if (!this.rcvEvtStartedResp()) break;
                enabled.addElement("2");
                break;
            }
            case 3: {
                if (this.rcvEvtAccepted()) {
                    enabled.addElement("3");
                    break;
                }
                if (!this.rcvEvtRejected()) break;
                enabled.addElement("4");
                break;
            }
        }
        return enabled;
    }

    public void fireTransition(String trans) {
        int tindex = Integer.parseInt(trans);
        switch (tindex) {
            case 0: {
                this.noOp();
                this.current_state = 1;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state START1", 2, this.FAC_FSM);
                break;
            }
            case 1: {
                this.sndEvtStartSSFResp();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state START2", 2, this.FAC_FSM);
                break;
            }
            case 2: {
                this.sndEvtEvalComm();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT_PS", 2, this.FAC_FSM);
                break;
            }
            case 3: {
                this.sndMsgAccept();
                this.current_state = 4;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISH", 2, this.FAC_FSM);
                break;
            }
            case 4: {
                this.sndMsgReject();
                this.current_state = 4;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISH", 2, this.FAC_FSM);
            }
        }
    }

    public void sndEvtEvalComm() {
        Taems t = new Taems();
        t.addCommitment(this.facilitatesCommitment);
        int ts = (Integer)this.state.getProperty((Object)"Time");
        FSMEvent evt = new FSMEvent(this, "EvalComm", ts, 1);
        evt.setTaems(t);
        this.startFireEvent(evt);
    }

    public void sndEvtStartSSFResp() {
        Taems t = new Taems();
        t.addCommitment(this.facilitatesCommitment);
        int ts = (Integer)this.state.getProperty((Object)"Time");
        FSMEvent evt = new FSMEvent(this, "StartSSFResp", ts, 1);
        this.log.log("SSF_M4_Resp: sending StartSSFResp", 4, this.FAC_FSM);
        evt.setTaems(t);
        evt.setCoordinateID(this.coordID);
        this.startFireEvent(evt);
    }

    public boolean rcvEvtStartedResp() {
        FSMEvent schedEvent = this.EventReceived("StartedResp");
        if (schedEvent == null) {
            return false;
        }
        this.log.log("SSF_M4_Resp: received StartedResp ", 4, this.FAC_FSM);
        return true;
    }

    public boolean rcvEvtAccepted() {
        FSMEvent schedEvent = this.EventReceived("Accepted");
        if (schedEvent == null) {
            return false;
        }
        Enumeration e = schedEvent.getTaems().getCommitments();
        if (e != null) {
            this.infoComm = (Commitment)e.nextElement();
        }
        return true;
    }

    public boolean rcvEvtRejected() {
        FSMEvent schedEvent = this.EventReceived("Rejected");
        if (schedEvent == null) {
            return false;
        }
        Enumeration e = schedEvent.getTaems().getCommitments();
        if (e != null) {
            this.infoComm = (Commitment)e.nextElement();
        }
        return true;
    }

    public void sndMsgReject() {
        String cn = this.infoComm.toString();
        KQMLMessage msg = new KQMLMessage("tell", (Object)("(Reject " + cn + ") "), this.initiator);
        msg.addField("reply-with", "" + this.facilitatesCommitment.getID());
        KQMLFSMEvent evt = new KQMLFSMEvent(this, msg);
        evt.setType("Reject");
        this.startFireEvent(evt);
    }

    public void sndMsgAccept() {
        String cn = this.infoComm.toString();
        KQMLMessage msg = new KQMLMessage("tell", (Object)("(Accept " + cn + ") "), this.initiator);
        msg.addField("reply-with", "" + this.facilitatesCommitment.getID());
        KQMLFSMEvent evt = new KQMLFSMEvent(this, msg);
        evt.setType("Accept");
        this.startFireEvent(evt);
    }

    public void noOp() {
    }

    protected boolean testCommitment(FSMEvent evt) {
        this.log.log("testCommitment: checking event " + evt, 2, this.FAC_FSM);
        Enumeration e = evt.getTaems().getCommitments();
        if (e != null) {
            Commitment com = (Commitment)e.nextElement();
            if (com == null) {
                this.log.log("testComm: comm is null ! ", 0, this.FAC_FSM);
                System.exit(0);
            }
            if (com.getID() == this._lID.longValue()) {
                return true;
            }
        }
        return false;
    }

    protected boolean testKQML(FSMEvent evt) {
        this.log.log("testKQML: checking event " + evt, 2, this.FAC_FSM);
        if (evt instanceof KQMLFSMEvent) {
            KQMLMessage m = ((KQMLFSMEvent)evt).getMessage();
            if (m == null) {
                return false;
            }
            return this.testMsg(m);
        }
        return false;
    }

    protected boolean testMsg(KQMLMessage m) {
        this.log.log("testMsg: checking msg " + m, 2, this.FAC_FSM);
        if (m.getField("in-reply-to") != null && Long.parseLong(m.getField("in-reply-to")) == this._lID) {
            this.log.log("testMsg: msg accepted: " + m, 2, this.FAC_FSM);
            return true;
        }
        if (m.getField("reply-with") != null && Long.parseLong(m.getField("reply-with")) == this._lID) {
            this.log.log("testMsg: msg accepted: " + m, 2, this.FAC_FSM);
            return true;
        }
        this.log.log("testMsg: msg rejected: msgID = " + Long.parseLong(m.getField("reply-with")) + " _lID = " + this._lID, 2, this.FAC_FSM);
        return false;
    }

    public void initNegotiationEvent(FSMEvent ce) {
        this.log.log("initNegotiationEvent: KQMLFSM " + ce, 4, this.FAC_FSM);
        KQMLMessage m = ((KQMLFSMEvent)ce).getMessage();
        if (m.getDestAddr().equals((String)this.state.getProperty((Object)"Name"))) {
            String data = m.contentData();
            ReadTTaems readTaems = new ReadTTaems(utilities.Log.getDefault());
            Taems t = readTaems.readTTaems((Reader)new StringReader(data));
            Enumeration e = t.getCommitments();
            this.facilitatesCommitment = (Commitment)e.nextElement();
            this._lID = new Long(this.facilitatesCommitment.getID());
            this.log.log("initNeg responder: commitmentID = " + this.facilitatesCommitment.getID(), 2, this.FAC_FSM);
            this.responder = this.facilitatesCommitment.getFromAgent().getLabel();
            this.initiator = this.facilitatesCommitment.getToAgent().getLabel();
            this.log.log("Starting responding FSM", 2, this.FAC_FSM);
            this.current_state = 1;
        } else {
            this.current_state = 4;
        }
    }
}

