/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.coordinate.FSM;
import agent.coordinate.FSMEvent;
import agent.coordinate.FSMEventListener;
import agent.coordinate.KQMLFSMEvent;
import agent.mass.State;
import agent.simplest.Log;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import taems.Commitment;
import taems.Taems;
import taems.parser.ReadTTaems;
import utilities.KQMLMessage;

public class SSF_Mech4_Ini
extends FSM
implements Serializable {
    FSMEvent evtHPCR;
    Long _lID;
    Commitment facilitatesCommitment;
    Commitment infoComm;
    boolean offerApproved;
    String responder;
    String initiator;
    KQMLMessage curKQMLMsg;
    KQMLMessage msgHPCR;
    final int START = 0;
    final int START2 = 1;
    final int WAIT_LEADER = 2;
    final int FINISH = 3;

    public SSF_Mech4_Ini(Log l, State s, FSMEventListener list) {
        super(l, s, list);
        this.current_state = 0;
    }

    public static Object initiate(FSMEvent event, Log l, State s, FSMEventListener list) {
        if (event == null) {
            return null;
        }
        SSF_Mech4_Ini newfsm = null;
        if (event.matchLabel("event:SSFacilitatesIni")) {
            newfsm = new SSF_Mech4_Ini(l, s, list);
            newfsm.initNegotiationEvent(event);
            return newfsm;
        }
        return newfsm;
    }

    public void fsmEventReceived(FSMEvent ce) {
        if (ce.matchLabel("event:Accepted") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:RejectedFrmResp") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Request") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Accept") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Reject") && this.testKQML(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:SSFacilitatesIni")) {
            this.recvEvents.addElement(ce);
        }
    }

    public boolean final_state() {
        return this.current_state == 3;
    }

    public Vector enabledTransitions() {
        Vector<String> enabled = new Vector<String>();
        switch (this.current_state) {
            case 0: {
                if (!this.Event("SSFacilitatesIni")) break;
                enabled.addElement("0");
                break;
            }
            case 1: {
                enabled.addElement("1");
                break;
            }
            case 2: {
                if (this.rcvMsgAccept()) {
                    enabled.addElement("2");
                    break;
                }
                if (!this.rcvMsgReject()) break;
                enabled.addElement("3");
                break;
            }
        }
        return enabled;
    }

    public void fireTransition(String trans) {
        int tindex = Integer.parseInt(trans);
        switch (tindex) {
            case 0: {
                this.noOp();
                this.current_state = 1;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state START2", 2, this.FAC_FSM);
                break;
            }
            case 1: {
                this.sndMsgRequest();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT_LEADER", 2, this.FAC_FSM);
                break;
            }
            case 2: {
                this.sndEvtAccepted();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISH", 2, this.FAC_FSM);
                break;
            }
            case 3: {
                this.sndEvtRejectedFrmResp();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISH", 2, this.FAC_FSM);
            }
        }
    }

    public void sndMsgRequest() {
        String cn = this.facilitatesCommitment.toString();
        KQMLMessage send = new KQMLMessage("tell", (Object)("(Request " + cn + ") "), this.responder);
        send.addField("reply-with", "" + this.facilitatesCommitment.getID());
        KQMLFSMEvent evt = new KQMLFSMEvent(this, send);
        evt.setType("Request");
        this.startFireEvent(evt);
        this.log.log("Starting negotiation between " + this.initiator + " and " + this.responder, 2, this.FAC_FSM);
    }

    public boolean rcvMsgReject() {
        KQMLFSMEvent evt = (KQMLFSMEvent)this.EventReceived("Reject");
        if (evt == null) {
            return false;
        }
        KQMLMessage m = evt.getMessage();
        if (m == null) {
            return false;
        }
        String data = m.contentData();
        ReadTTaems readTaems = new ReadTTaems(utilities.Log.getDefault());
        Taems t = readTaems.readTTaems((Reader)new StringReader(data));
        Enumeration e = t.getCommitments();
        this.infoComm = (Commitment)e.nextElement();
        return true;
    }

    public boolean rcvMsgAccept() {
        KQMLFSMEvent evt = (KQMLFSMEvent)this.EventReceived("Accept");
        if (evt == null) {
            return false;
        }
        KQMLMessage msgAccept = evt.getMessage();
        if (msgAccept == null) {
            return false;
        }
        String data = msgAccept.contentData();
        ReadTTaems readTaems = new ReadTTaems(utilities.Log.getDefault());
        Taems t = readTaems.readTTaems((Reader)new StringReader(data));
        Enumeration e = t.getCommitments();
        this.infoComm = (Commitment)e.nextElement();
        return true;
    }

    public void sndEvtAccepted() {
        this.log.log("sndEvtAccepted: about to send Accepted", 2, this.FAC_FSM);
        Taems t = new Taems();
        Float commRespUtility = (Float)this.infoComm.getAttribute((Object)"commRespUtility");
        Float origRespUtility = (Float)this.infoComm.getAttribute((Object)"origRespUtility");
        this.facilitatesCommitment.setAttribute((Object)"commRespUtility", (Object)commRespUtility);
        this.facilitatesCommitment.setAttribute((Object)"origRespUtility", (Object)origRespUtility);
        t.addCommitment(this.facilitatesCommitment);
        int ts = (Integer)this.state.getProperty((Object)"Time");
        FSMEvent evt = new FSMEvent(this, "Accepted", ts, 1);
        evt.setTaems(t);
        this.startFireEvent(evt);
    }

    public void sndEvtRejectedFrmResp() {
        this.log.log("sndEvtAccepted: about to send RejectedFrmResp", 2, this.FAC_FSM);
        Taems t = new Taems();
        Float commRespUtility = (Float)this.infoComm.getAttribute((Object)"commRespUtility");
        Float origRespUtility = (Float)this.infoComm.getAttribute((Object)"origRespUtility");
        this.facilitatesCommitment.setAttribute((Object)"commRespUtility", (Object)commRespUtility);
        this.facilitatesCommitment.setAttribute((Object)"origRespUtility", (Object)origRespUtility);
        t.addCommitment(this.facilitatesCommitment);
        int ts = (Integer)this.state.getProperty((Object)"Time");
        FSMEvent evt = new FSMEvent(this, "RejectedFrmResp", ts, 1);
        evt.setTaems(t);
        this.startFireEvent(evt);
    }

    public void noOp() {
    }

    protected boolean testCommitment(FSMEvent evt) {
        Commitment com;
        this.log.log("testCommitment: checking event " + evt, 2, this.FAC_FSM);
        Enumeration e = evt.getTaems().getCommitments();
        return e != null && (com = (Commitment)e.nextElement()).getID() == this._lID.longValue();
    }

    protected boolean testKQML(FSMEvent evt) {
        this.log.log("testKQML: checking event " + evt, 2, this.FAC_FSM);
        if (evt instanceof KQMLFSMEvent) {
            KQMLMessage m = ((KQMLFSMEvent)evt).getMessage();
            if (m == null) {
                return false;
            }
            return this.testMsg(m);
        }
        return false;
    }

    protected boolean testMsg(KQMLMessage m) {
        this.log.log("testMsg: checking msg " + m, 2, this.FAC_FSM);
        if (m.getField("in-reply-to") != null && Long.parseLong(m.getField("in-reply-to")) == this._lID) {
            this.log.log("testMsg: msg accepted: " + m, 2, this.FAC_FSM);
            return true;
        }
        if (m.getField("reply-with") != null && Long.parseLong(m.getField("reply-with")) == this._lID) {
            this.log.log("testMsg: msg accepted: " + m, 2, this.FAC_FSM);
            return true;
        }
        this.log.log("testMsg: msg rejected: msgID = " + Long.parseLong(m.getField("reply-with")) + " _lID = " + this._lID, 2, this.FAC_FSM);
        return false;
    }

    public void initNegotiationEvent(FSMEvent ce) {
        if (this.log == null) {
            System.err.println("SSF_M4_Ini: log is null !");
        } else {
            this.log.log("initNegotiationEvent: " + ce, 4, this.FAC_FSM);
        }
        try {
            Enumeration e = ce.getTaems().getCommitments();
            this.facilitatesCommitment = (Commitment)e.nextElement();
            this._lID = new Long(this.facilitatesCommitment.getID());
            this.log.log("init: commitmentID = " + this.facilitatesCommitment.getID(), 2, this.FAC_FSM);
        }
        catch (ClassCastException cce) {
            this.log.log((Object)cce, 1, this.FAC_FSM);
            this.current_state = 3;
            return;
        }
        catch (NullPointerException npe) {
            this.log.log((Object)npe, 1, this.FAC_FSM);
            this.current_state = 3;
            return;
        }
        this.offerApproved = false;
        if (this.facilitatesCommitment == null) {
            System.err.println("SSF_M4_Ini: no commitment passed !");
            this.current_state = 3;
            return;
        }
        if (this.facilitatesCommitment.getFromAgent() == null) {
            System.err.println("SSF_M4_Ini: from agent is null !");
            this.current_state = 3;
            return;
        }
        if (this.facilitatesCommitment.getToAgent() == null) {
            System.err.println("SSF_M4_Ini: to agent is null !");
            this.current_state = 3;
            return;
        }
        this.responder = this.facilitatesCommitment.getFromAgent().getLabel();
        this.initiator = this.facilitatesCommitment.getToAgent().getLabel();
        this.log.log("Starting initiating FSM", 2, this.FAC_FSM);
        this.current_state = 1;
    }
}

