/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.base.AgentEvent;
import agent.coordinate.FSM;
import java.io.Serializable;
import taems.Taems;

public class FSMEvent
extends AgentEvent
implements Serializable {
    protected String label;
    protected String type;
    protected int fsmID;
    protected Long coordinateID;
    protected Taems content;
    protected int timestamp;
    protected int lifetime;
    public static final int SENT = 0;
    public static final int RECEIVED = 1;

    public FSMEvent(Object source, int ts, int lt) {
        super(source, 1);
        this.timestamp = ts;
        this.lifetime = lt;
        this.label = "event:";
        if (source instanceof FSM) {
            this.setFsmID(((FSM)source).getID());
        }
    }

    public FSMEvent(Object source, String t, int ts, int lt) {
        this(source, ts, lt);
        this.type = t;
        this.label = "event:" + this.type;
    }

    public void setType(String s) {
        this.type = s;
        this.label = "event:" + this.type;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isType(String s) {
        return s.equals(this.type);
    }

    public void setFsmID(int i) {
        this.fsmID = i;
    }

    public int getFsmID() {
        return this.fsmID;
    }

    public Taems getTaems() {
        return this.content;
    }

    public void setTaems(Taems o) {
        this.content = o;
    }

    public Long getCoordinateID() {
        return this.coordinateID;
    }

    public void setCoordinateID(Long l) {
        this.coordinateID = l;
    }

    public void setCoordinateID(long l) {
        this.coordinateID = new Long(l);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        sb.append(this.label + " from " + this.type + " at time " + this.timestamp + " until " + this.lifetime);
        return sb.toString();
    }

    public boolean matchType(String check) {
        return check.equals(this.getType());
    }

    public boolean matchLabel(String check) {
        String substring;
        if (check.equals(this.getLabel())) {
            return true;
        }
        return check.startsWith("*") && (substring = check.trim().substring(2)).equals(this.type);
    }
}

