/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.coordinate.CoordinateEvent;
import agent.coordinate.CoordinateEventListener;
import agent.coordinate.CoordinateEventProducer;
import agent.coordinate.FSM;
import agent.coordinate.FSMEvent;
import agent.coordinate.FSMEventListener;
import agent.coordinate.FSMEventProducer;
import agent.coordinate.KQMLFSMEvent;
import agent.simplest.Communicate;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.State;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import utilities.KQMLMessage;
import utilities.Message;

public class FSMCoordination
extends AgentComponent
implements Serializable,
MessageEventListener,
FSMEventListener,
FSMEventProducer,
CoordinateEventListener,
CoordinateEventProducer,
MouseListener {
    static final long serialVersionUID = 1234567890L;
    Hashtable SharedVariables;
    Vector FSMlist;
    Vector FSMClasses;
    private Vector FSMdeadlist;
    protected static int nextID = 0;
    protected Communicate communicate;
    protected agent.mass.State state;
    protected Log log;
    protected int FAC_FSMCOORD;
    protected String description;
    protected Vector globalFSMEventQueue;
    protected Vector temporaryQueue;
    protected Hashtable coordination2FSM;
    protected ListenerVector listenersCoordinateEvent = new ListenerVector();
    protected ListenerVector listenersFSMEvent = new ListenerVector();
    private PopupMenu menu = new PopupMenu("Active FSMs");
    private boolean pulsing = false;
    static /* synthetic */ Class class$agent$coordinate$FSMEvent;
    static /* synthetic */ Class class$agent$simplest$Log;
    static /* synthetic */ Class class$agent$mass$State;
    static /* synthetic */ Class class$agent$coordinate$FSMEventListener;

    public FSMCoordination() {
        this.description = this.getClass().getName();
        if (this.description.lastIndexOf(46) != -1) {
            this.description = this.description.substring(this.description.lastIndexOf(46) + 1);
        }
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Communicate");
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).add(this.menu);
        this.FSMlist = new Vector();
        this.globalFSMEventQueue = new Vector();
        this.coordination2FSM = new Hashtable();
        this.SharedVariables = new Hashtable();
        this.FSMClasses = new Vector();
        this.FSMdeadlist = new Vector();
        this.temporaryQueue = new Vector();
        this.addFSMparameter();
    }

    public void init() {
        this.log = (Log)State.findComponent((String)"Log");
        this.state = (agent.mass.State)State.findComponent((String)"State");
        this.communicate = (Communicate)State.findComponent((String)"Communicate");
        this.communicate.addMessageEventListener((MessageEventListener)this);
        this.FAC_FSMCOORD = this.log.getFacilityID("FSMCoordination");
        this.initFSMClasses();
    }

    public static int assignID() {
        int i = nextID++;
        return i;
    }

    public void addCoordinateEventListener(CoordinateEventListener l) {
        if (this.listenersCoordinateEvent.contains((Object)l)) {
            return;
        }
        this.listenersCoordinateEvent.add((AgentListener)l);
        if (l instanceof CoordinateEventProducer) {
            if (this.log != null) {
                this.log.log("Setting up loopback event listener with " + l.toString(), 4, this.FAC_FSMCOORD);
            } else {
                System.err.println("Setting up loopback event listener with " + l.toString());
            }
            ((CoordinateEventProducer)((Object)l)).addCoordinateEventListener(this);
        }
    }

    public void removeCoordinateEventListener(CoordinateEventListener l) {
        this.listenersCoordinateEvent.remove((AgentListener)l);
        if (l instanceof CoordinateEventProducer) {
            this.log.log("Removing loopback event listener with " + l.toString(), 4, this.FAC_FSMCOORD);
            ((CoordinateEventProducer)((Object)l)).removeCoordinateEventListener(this);
        }
    }

    public Enumeration getCoordinateEventListeners() {
        return this.listenersCoordinateEvent.elements();
    }

    public void coordinateEventReceived(CoordinateEvent ce) {
    }

    public void coordinateEventSent(CoordinateEvent e) {
        this.log.log("commitmentEventSent: " + (Object)((Object)e), 5, this.FAC_FSMCOORD);
        if (this.pulsing) {
            this.temporaryQueue.addElement(e);
        } else {
            FSMEvent fe = this.convertCoordinateEventToFSMEvent(e);
            this.log.log("CoordinateEvent converted to FSMEvent: " + fe, 4, this.FAC_FSMCOORD);
            if (e.getCoordinateID() != null && this.coordination2FSM.containsKey(e.getCoordinateID())) {
                this.addLocalFSMEvent(fe, e.getCoordinateID());
                this.log.log("Delivered to a particular FSM " + e.getCoordinateID(), 4, this.FAC_FSMCOORD);
            } else {
                this.addGlobalFSMEvent(fe);
            }
        }
    }

    public void addFSMEventListener(FSMEventListener l) {
        this.listenersFSMEvent.add((AgentListener)l);
    }

    public void removeFSMEventListener(FSMEventListener l) {
        this.listenersFSMEvent.remove((AgentListener)l);
    }

    public void fsmEventReceived(FSMEvent e) {
        this.log.log("FSMEventReceived: " + e, 5, this.FAC_FSMCOORD);
        if (e instanceof KQMLFSMEvent) {
            KQMLFSMEvent ke = (KQMLFSMEvent)e;
            KQMLMessage msg = ke.getMessage();
            this.communicate.sendMessage((Message)msg);
        } else {
            CoordinateEvent ce = this.convertFSMEventToCoordinateEvent(e);
            this.log.log("CoordinateEvent converted to FSMEvent: " + (Object)((Object)ce), 5, this.FAC_FSMCOORD);
            this.startFireEvent(ce);
        }
    }

    public void fsmEventSent(FSMEvent e) {
        this.log.log("FSMEventSent: " + e, 5, this.FAC_FSMCOORD);
        if (e instanceof KQMLFSMEvent) {
            KQMLFSMEvent ke = (KQMLFSMEvent)e;
            KQMLMessage msg = ke.getMessage();
            this.communicate.sendMessage((Message)msg);
        }
    }

    protected void deliveredPulsingEvent() {
        Enumeration e = this.temporaryQueue.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof CoordinateEvent) {
                this.coordinateEventSent((CoordinateEvent)((Object)o));
            }
            if (!(o instanceof MessageEvent)) continue;
            this.messageReceived((MessageEvent)o);
        }
        this.temporaryQueue.removeAllElements();
    }

    public void messageSent(MessageEvent me) {
    }

    public void messageReceived(MessageEvent me) {
        if (this.pulsing) {
            this.temporaryQueue.addElement(me);
        } else {
            KQMLMessage m = (KQMLMessage)me.getMessage();
            KQMLFSMEvent kqml = new KQMLFSMEvent(this, m);
            Long ID = null;
            if (!m.getSourceAddr().equals("simulator")) {
                if (m.getField("reply-with") != null) {
                    ID = new Long(m.getField("reply-with"));
                } else if (m.getField("in-reply-to") != null) {
                    ID = new Long(m.getField("in-reply-to"));
                }
                if (ID != null) {
                    kqml.setCoordinateID(ID);
                    if (this.coordination2FSM.containsKey(ID)) {
                        this.addLocalFSMEvent(kqml, ID);
                        this.log.log("Deliver msg " + m.contentWord() + " to FSM in charge of " + ID, 3, this.FAC_FSMCOORD);
                    } else {
                        this.log.log("Unknown ID " + ID.toString(), 3, this.FAC_FSMCOORD);
                        this.addGlobalFSMEvent(kqml);
                    }
                }
            }
        }
    }

    protected void fireEvent(AgentEvent ev) {
        if (ev instanceof CoordinateEvent) {
            CoordinateEvent e = (CoordinateEvent)ev;
            Enumeration enumeration = this.listenersCoordinateEvent.elements();
            this.log.log("Firing a coord event", 4, this.FAC_FSMCOORD);
            while (enumeration.hasMoreElements()) {
                CoordinateEventListener l = (CoordinateEventListener)enumeration.nextElement();
                if (e.isActive()) {
                    if (e.wasReceived()) {
                        l.coordinateEventReceived(e);
                    }
                    if (!e.wasSent()) continue;
                    l.coordinateEventSent(e);
                    continue;
                }
                break;
            }
        } else if (ev instanceof FSMEvent) {
            FSMEvent fe = (FSMEvent)ev;
            Enumeration enumeration = this.listenersFSMEvent.elements();
            this.log.log("Firing an FSMEvent", 4, this.FAC_FSMCOORD);
            while (enumeration.hasMoreElements()) {
                FSMEventListener l = (FSMEventListener)enumeration.nextElement();
                l.fsmEventReceived(fe);
                switch (fe.getID()) {
                    case 1: {
                        l.fsmEventReceived(fe);
                        break;
                    }
                    case 0: {
                        l.fsmEventSent(fe);
                        break;
                    }
                }
            }
        } else {
            this.log.log("! only CoordinateEvent or FSMEvent", 4, this.FAC_FSMCOORD);
        }
        if (this.log != null) {
            this.log.log((Object)ev, 5, this.FAC_FSMCOORD);
        }
    }

    protected FSMEvent convertCoordinateEventToFSMEvent(CoordinateEvent ce) {
        int time = (Integer)this.state.getProperty((Object)"Time");
        int id = 0;
        if (ce.wasReceived()) {
            id = 1;
        }
        String type = null;
        if (ce.getType() != null) {
            type = ce.getType();
        } else {
            switch (ce.getID()) {
                case 1: {
                    type = "Accepted";
                    break;
                }
                case 4096: {
                    type = "Rejected";
                    break;
                }
                case 256: {
                    type = "Canceled";
                    break;
                }
                case 16: {
                    type = "Posed";
                    break;
                }
                case 65536: {
                    type = "Timeout";
                    break;
                }
                default: {
                    type = "Unknown";
                }
            }
        }
        FSMEvent fe = new FSMEvent(this, type, time, id);
        fe.setTaems(ce.getTaems());
        fe.setCoordinateID(ce.getCoordinateID());
        return fe;
    }

    protected CoordinateEvent convertFSMEventToCoordinateEvent(FSMEvent fe) {
        int time = (Integer)this.state.getProperty((Object)"Time");
        int id = fe.getID() == 0 ? 0 : 0x100000;
        if (fe.getType().equalsIgnoreCase("Accepted")) {
            id |= 1;
        } else if (fe.getType().equalsIgnoreCase("Rejected")) {
            id |= 0x1000;
        } else if (fe.getType().equalsIgnoreCase("Canceled")) {
            id |= 0x100;
        } else if (fe.getType().equalsIgnoreCase("Posed")) {
            id |= 0x10;
        } else if (fe.getType().equalsIgnoreCase("Timeout")) {
            id |= 0x10000;
        }
        CoordinateEvent ce = new CoordinateEvent(this, fe.getType(), id, fe.getTaems());
        ce.setCoordinateID(fe.getCoordinateID());
        ce.setFsmID(fe.getFsmID());
        return ce;
    }

    public void addFSMparameter() {
        State.addParameterInfo((String)(this.description + "-FSM"), (String)"Vector", (String)("FSM classes recognized by " + this.description + " bean"));
    }

    public void addGlobalFSMEvent(FSMEvent fe) {
        this.globalFSMEventQueue.addElement(fe);
    }

    public void addLocalFSMEvent(FSMEvent fe, Long fsmID) {
        FSM fsm = (FSM)this.coordination2FSM.get(fsmID);
        fsm.fsmEventReceived(fe);
    }

    public void addFSM(FSM f) {
        this.addFSMEventListener(f);
        this.FSMlist.addElement(f);
    }

    public int findFsmID(String desc) {
        Enumeration e = this.FSMlist.elements();
        while (e.hasMoreElements()) {
            FSM f = (FSM)e.nextElement();
            if (!f.getDescription().equals(desc)) continue;
            return f.ID;
        }
        return -1;
    }

    public FSM findFSMbyID(int fid) {
        Enumeration e = this.FSMlist.elements();
        while (e.hasMoreElements()) {
            FSM fm = (FSM)e.nextElement();
            if (fm.ID != fid) continue;
            return fm;
        }
        return null;
    }

    public void handleEventsUnknown() {
        int time = (Integer)this.state.getProperty((Object)"Time");
        this.log.log("Checking new events: " + this.globalFSMEventQueue, 2, this.FAC_FSMCOORD);
        if (this.globalFSMEventQueue == null) {
            return;
        }
        Enumeration evtlist = this.globalFSMEventQueue.elements();
        while (evtlist.hasMoreElements()) {
            FSMEvent ce = (FSMEvent)evtlist.nextElement();
            this.log.log("New event: " + ce.getType(), 2, this.FAC_FSMCOORD);
            boolean isMade = false;
            Enumeration e = this.FSMClasses.elements();
            while (e.hasMoreElements()) {
                Class cls = (Class)e.nextElement();
                this.log.log("Checking Class: " + cls, 3, this.FAC_FSMCOORD);
                Class[] parmlist = new Class[]{class$agent$coordinate$FSMEvent == null ? FSMCoordination.class$("agent.coordinate.FSMEvent") : class$agent$coordinate$FSMEvent, class$agent$simplest$Log == null ? FSMCoordination.class$("agent.simplest.Log") : class$agent$simplest$Log, class$agent$mass$State == null ? FSMCoordination.class$("agent.mass.State") : class$agent$mass$State, class$agent$coordinate$FSMEventListener == null ? FSMCoordination.class$("agent.coordinate.FSMEventListener") : class$agent$coordinate$FSMEventListener};
                Method m = null;
                try {
                    m = cls.getMethod("initiate", parmlist);
                }
                catch (Exception exc) {
                    this.log.log((Object)exc, 0, this.FAC_FSMCOORD);
                }
                Object[] arglist = new Object[]{ce, this.log, this.state, this};
                FSM retval = null;
                try {
                    retval = (FSM)m.invoke(null, arglist);
                }
                catch (InvocationTargetException ite) {
                    this.log.log(ite + "-- Exception in initiate():", 0, this.FAC_FSMCOORD);
                    this.log.log("Information about the offending target:", 0, this.FAC_FSMCOORD);
                    Throwable tgtex = ite.getTargetException();
                    tgtex.printStackTrace(System.err);
                }
                catch (Exception exc) {
                    this.log.log((Object)exc, 0, this.FAC_FSMCOORD);
                }
                if (retval != null) {
                    FSM f = retval;
                    this.log.log("New FSM created (id:" + f.getID() + ", coordID:" + ce.getCoordinateID() + ")", 1, this.FAC_FSMCOORD);
                    this.addFSM(f);
                    this.coordination2FSM.put(ce.getCoordinateID(), f);
                    isMade = true;
                    break;
                }
                this.log.log("FSM not created.", 5, this.FAC_FSMCOORD);
            }
            if (isMade) continue;
            this.log.log("No FSM created in response to this event: " + ce, 1, this.FAC_FSMCOORD);
        }
    }

    public void pulse() {
        this.pulsing = true;
        int time = (Integer)this.state.getProperty((Object)"Time");
        this.log.log("Pulsing " + this.description + " bean", 5, this.FAC_FSMCOORD);
        this.handleEventsUnknown();
        this.globalFSMEventQueue.removeAllElements();
        this.log.log("done with starting new FSMs", 3, this.FAC_FSMCOORD);
        this.log.log("Current FSM's: " + this.FSMlist, 4, this.FAC_FSMCOORD);
        this.FSMdeadlist.removeAllElements();
        Enumeration e = this.FSMlist.elements();
        while (e.hasMoreElements()) {
            FSM current = (FSM)e.nextElement();
            this.log.log((Object)current, 3, this.FAC_FSMCOORD);
            current.pulse(this.SharedVariables);
            if (!current.halted) continue;
            this.FSMdeadlist.addElement(current);
            this.removeFSMEventListener(current);
            current.removeFSMEventListener(this);
        }
        this.pulsing = false;
        this.deliveredPulsingEvent();
        int i = 0;
        while (i < this.FSMdeadlist.size()) {
            this.FSMlist.removeElement(this.FSMdeadlist.elementAt(i));
            Enumeration e1 = this.coordination2FSM.keys();
            while (e1.hasMoreElements()) {
                Long key = (Long)e1.nextElement();
                if (this.coordination2FSM.get(key) != this.FSMdeadlist.elementAt(i)) continue;
                this.coordination2FSM.remove(key);
            }
            ++i;
        }
    }

    public boolean hasFSM(Class cls) {
        Enumeration e = this.FSMClasses.elements();
        while (e.hasMoreElements()) {
            Class c = (Class)e.nextElement();
            if (!c.getName().equals(cls.getName())) continue;
            return true;
        }
        return false;
    }

    void initFSMClasses() {
        Vector classNames = (Vector)this.state.getProperty((Object)(this.description + "-FSM"));
        if (classNames == null) {
            this.log.log(this.description + "-FSM property not found", 0, this.FAC_FSMCOORD);
            return;
        }
        Enumeration e = classNames.elements();
        while (e.hasMoreElements()) {
            String name = ((String)e.nextElement()).trim();
            if (name.indexOf(46) == -1) {
                name = "agent.coordinate." + name;
            }
            try {
                Class<?> c = Class.forName(name);
                Method m = c.getMethod("getFsmID", new Class[0]);
                Object o = m.invoke(null, new Object[0]);
                this.log.log("Found FSM " + name + ", id: " + o, 2, this.FAC_FSMCOORD);
                this.FSMClasses.addElement(c);
            }
            catch (ClassNotFoundException ex) {
                this.log.log((Object)ex, 0, this.FAC_FSMCOORD);
            }
            catch (Exception ex) {
                this.log.log((Object)ex, 0, this.FAC_FSMCOORD);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void updateMenu() {
        this.menu.removeAll();
        e = this.FSMlist.elements();
        if (e.hasMoreElements()) ** GOTO lbl12
        m = new MenuItem("None");
        this.menu.add(m);
        return;
lbl-1000:
        // 1 sources

        {
            current = (FSM)e.nextElement();
            m = new MenuItem(current.toString() + " (id:" + current.getID() + ") - State:" + current.getCurrentState());
            this.menu.add(m);
lbl12:
            // 2 sources

            ** while (e.hasMoreElements())
        }
lbl13:
        // 1 sources

        this.menu.addSeparator();
        m = new MenuItem("Event ID -> FSM Mappings");
        this.menu.add(m);
        this.menu.addSeparator();
        e = this.coordination2FSM.keys();
        while (e.hasMoreElements()) {
            l = e.nextElement();
            m = new MenuItem(l.toString() + " -> " + this.coordination2FSM.get(l));
            this.menu.add(m);
        }
    }

    public boolean hasPopupMenu() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 || e.isPopupTrigger()) {
            this.updateMenu();
            this.menu.show((Component)((Object)this), e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

