/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.coordinate.FSMCoordination;
import agent.coordinate.FSMEvent;
import agent.coordinate.FSMEventListener;
import agent.coordinate.FSMEventProducer;
import agent.coordinate.KQMLFSMEvent;
import agent.mass.State;
import agent.simplest.Log;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import utilities.KQMLMessage;

public abstract class FSM
implements Serializable,
FSMEventListener,
FSMEventProducer {
    protected boolean halted;
    protected Vector recvEvents;
    protected int current_state;
    protected int ID;
    private static int FSMCOUNT = 0;
    private static int FSMID = -1;
    protected FSMEvent currentevent;
    protected KQMLMessage currentmsg;
    protected State state;
    protected Log log;
    protected int FAC_FSM;
    protected int timer;
    protected int time_out;
    protected ListenerVector fsmlisteners;
    protected int time;
    protected String description;
    private boolean ev_firing = false;
    private Vector ev_queue = new Vector();
    private Integer ev_lock = new Integer(0);

    FSM(Log l, State s, FSMEventListener list) {
        this.description = this.getClass().getName();
        if (this.description.lastIndexOf(46) != -1) {
            this.description = this.description.substring(this.description.lastIndexOf(46) + 1);
        }
        this.halted = false;
        this.recvEvents = new Vector();
        this.ID = FSMCoordination.assignID();
        this.timer = -1;
        this.time_out = -1;
        this.state = s;
        this.log = l;
        this.FAC_FSM = this.log.getFacilityID(this.getClass().getName().substring(17) + "-FSM");
        this.fsmlisteners = new ListenerVector();
        this.addFSMEventListener(list);
    }

    public int getID() {
        return this.ID;
    }

    protected static synchronized int getFsmCount() {
        return FSMCOUNT++;
    }

    public String getDescription() {
        return this.description;
    }

    public void setCurrentState(int s) {
        this.current_state = s;
    }

    public int getCurrentState() {
        return this.current_state;
    }

    public void fsmEventReceived(FSMEvent e) {
        this.recvEvents.addElement(e);
    }

    public void fsmEventSent(FSMEvent e) {
    }

    public void addFSMEventListener(FSMEventListener f) {
        this.fsmlisteners.add((AgentListener)f);
    }

    public void removeFSMEventListener(FSMEventListener f) {
        this.fsmlisteners.remove((AgentListener)f);
    }

    public void startFireEvent(AgentEvent event) {
        this.ev_queue.addElement(event);
        if (this.ev_firing) {
            return;
        }
        Integer n = this.ev_lock;
        synchronized (n) {
            this.ev_firing = true;
            while (!this.ev_queue.isEmpty()) {
                AgentEvent ev = (AgentEvent)this.ev_queue.firstElement();
                this.ev_queue.removeElement(ev);
                this.fireEvent(ev);
            }
            this.ev_firing = false;
        }
    }

    protected void fireEvent(AgentEvent e) {
        FSMEvent fe = (FSMEvent)e;
        if (!fe.isActive()) {
            return;
        }
        Enumeration en = this.fsmlisteners.elements();
        this.log.log("Firing an FSMEvent " + fe.getID(), 4, this.FAC_FSM);
        while (en.hasMoreElements()) {
            FSMEventListener fsmL = (FSMEventListener)en.nextElement();
            this.log.log("FSMEventListener = " + fsmL.getClass().getName(), 4, this.FAC_FSM);
            switch (fe.getID()) {
                case 1: {
                    fsmL.fsmEventReceived(fe);
                    break;
                }
                case 0: {
                    fsmL.fsmEventSent(fe);
                    break;
                }
            }
        }
    }

    public void startTimer(int to) {
        this.time_out = to;
    }

    public void startOffsetTimer(int to) {
        if (this.state == null) {
            this.log.log("Error: FSM (trying to start timer): state = null", 0, this.FAC_FSM);
        } else {
            this.timer = (Integer)this.state.getProperty((Object)"Time");
            this.time_out = this.timer + to;
        }
    }

    public boolean timeout() {
        if (this.timer == -1) {
            return false;
        }
        if (this.time_out == -1) {
            return false;
        }
        if (this.timer > this.time_out) {
            this.time_out = -1;
            return true;
        }
        return false;
    }

    public void noFunction(FSMEvent ce) {
    }

    public void noFunction(KQMLMessage msg) {
    }

    public boolean noCondition(FSMEvent ce) {
        return true;
    }

    public boolean noCondition(KQMLMessage msg) {
        return true;
    }

    public boolean checkFsmID(FSMEvent fe) {
        return fe.getFsmID() == this.ID;
    }

    public static int getFsmID() {
        if (FSMID < 0) {
            FSMID = FSM.getFsmCount();
        }
        return FSMID;
    }

    public void getSharedVariables(Hashtable sv) {
        Integer i = (Integer)sv.get("time");
        if (i != null) {
            this.time = i;
        }
    }

    public void putSharedVariables(Hashtable sv) {
    }

    public void pulse(Hashtable SharedVariables) {
        this.log.log("Pulsing FSM # " + this.ID + ": Current State: " + this.current_state, 2, this.FAC_FSM);
        this.getSharedVariables(SharedVariables);
        this.timer = (Integer)this.state.getProperty((Object)"Time");
        this.log.log("Time: " + this.timer + " Time Out: " + this.time_out, 2, this.FAC_FSM);
        Vector transitions = this.enabledTransitions();
        if (transitions == null) {
            this.log.log("Transitions = null!", 0, this.FAC_FSM);
            return;
        }
        if (transitions.isEmpty()) {
            this.log.log("No transitions possible from this state at this time", 2, this.FAC_FSM);
            this.putSharedVariables(SharedVariables);
            return;
        }
        this.log.log("Transitions possible: " + transitions, 3, this.FAC_FSM);
        String trans = (String)transitions.firstElement();
        this.log.log("Firing Transition " + trans, 3, this.FAC_FSM);
        if (trans != null) {
            this.fireTransition(trans);
        }
        this.halted = this.final_state();
        this.putSharedVariables(SharedVariables);
    }

    public void sendSimpleMessage(String type, String to) {
        KQMLMessage msg = new KQMLMessage("tell", (Object)("(" + type + ") "), to);
        this.FSMsendMessage(msg);
    }

    public void FSMsendMessage(KQMLMessage send) {
        this.log.log("FSM SendMessage!", 1, this.FAC_FSM);
        this.startFireEvent(new KQMLFSMEvent(this, send));
    }

    public void FSMsendEvent(FSMEvent ce) {
        ce.setFsmID(this.ID);
        this.startFireEvent(ce);
    }

    public void cleanEventQueue() {
        this.recvEvents.removeAllElements();
    }

    public KQMLMessage MessageReceived(String type) {
        if (this.recvEvents == null) {
            return null;
        }
        Enumeration e = this.recvEvents.elements();
        while (e.hasMoreElements()) {
            KQMLFSMEvent ke;
            KQMLMessage msg;
            FSMEvent fe = (FSMEvent)e.nextElement();
            if (!(fe instanceof KQMLFSMEvent) || !(msg = (ke = (KQMLFSMEvent)fe).getMessage()).contentWord().equals(type)) continue;
            this.recvEvents.removeElement(fe);
            this.currentmsg = msg;
            return msg;
        }
        return null;
    }

    public boolean Message(String type) {
        if (this.recvEvents == null) {
            return false;
        }
        Enumeration e = this.recvEvents.elements();
        while (e.hasMoreElements()) {
            KQMLFSMEvent ke;
            KQMLMessage msg;
            FSMEvent fe = (FSMEvent)e.nextElement();
            if (!(fe instanceof KQMLFSMEvent) || !(msg = (ke = (KQMLFSMEvent)fe).getMessage()).contentWord().equals(type)) continue;
            this.currentmsg = msg;
            return true;
        }
        return false;
    }

    public FSMEvent EventReceived(String type) {
        if (this.recvEvents == null) {
            return null;
        }
        if (this.recvEvents.isEmpty()) {
            return null;
        }
        Enumeration e = this.recvEvents.elements();
        while (e.hasMoreElements()) {
            FSMEvent ce = (FSMEvent)e.nextElement();
            if (!ce.isType(type)) continue;
            this.recvEvents.removeElement(ce);
            return ce;
        }
        return null;
    }

    public boolean Event(String type) {
        String label = type;
        if (type.indexOf(":") < 0) {
            label = "*:" + type;
        }
        Enumeration e = this.recvEvents.elements();
        while (e.hasMoreElements()) {
            FSMEvent ce = (FSMEvent)e.nextElement();
            if (!ce.matchLabel(label)) continue;
            this.currentevent = ce;
            if (ce instanceof KQMLFSMEvent) {
                this.currentmsg = ((KQMLFSMEvent)ce).getMessage();
            }
            return true;
        }
        return false;
    }

    public abstract Vector enabledTransitions();

    public abstract void fireTransition(String var1);

    public abstract boolean final_state();

    public void finalize() {
        Enumeration en = this.fsmlisteners.elements();
        while (en.hasMoreElements()) {
            Object l = en.nextElement();
            if (!(en instanceof FSMEventProducer)) continue;
            ((FSMEventProducer)l).removeFSMEventListener(this);
        }
    }
}

