/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.coordinate.FSM;
import agent.coordinate.FSMEvent;
import agent.coordinate.FSMEventListener;
import agent.coordinate.KQMLFSMEvent;
import agent.mass.State;
import agent.simplest.Log;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import taems.Commitment;
import taems.Taems;
import taems.parser.ReadTTaems;
import utilities.KQMLMessage;

public class DefaultCommitmentResponder
extends FSM
implements Serializable {
    Taems _taems;
    Long _lID;
    final int S0 = 0;
    final int WAIT = 1;
    final int CREATED = 2;
    final int FINISHED = 3;
    private static int FSMID = -1;

    public DefaultCommitmentResponder(Log l, State s, FSMEventListener list) {
        super(l, s, list);
        this.current_state = 0;
    }

    public static int getFsmID() {
        if (FSMID < 0) {
            FSMID = FSM.getFsmCount();
        }
        return FSMID;
    }

    public static Object initiate(FSMEvent event, Log l, State s, FSMEventListener list) {
        if (event == null) {
            return null;
        }
        DefaultCommitmentResponder newfsm = null;
        if (event.matchLabel("msg:DefaultCommitmentPose")) {
            newfsm = new DefaultCommitmentResponder(l, s, list);
            if (!newfsm.testProtocol(event)) {
                return null;
            }
            newfsm.handleRequestMsg(event);
            return newfsm;
        }
        return newfsm;
    }

    public void fsmEventReceived(FSMEvent ce) {
        if (ce.matchLabel("msg:DefaultCommitmentPose") && this.testProtocol(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:DefaultCommitmentPose")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:Accepted")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:Rejected")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Cancel")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:Canceled")) {
            this.recvEvents.addElement(ce);
        }
    }

    public boolean final_state() {
        return this.current_state == 3;
    }

    public Vector enabledTransitions() {
        Vector<String> enabled = new Vector<String>();
        switch (this.current_state) {
            case 0: {
                if (!this.Event("DefaultCommitmentPose")) break;
                enabled.addElement("0");
                break;
            }
            case 1: {
                if (this.Event("Accepted")) {
                    enabled.addElement("1");
                    break;
                }
                if (this.Event("Rejected")) {
                    enabled.addElement("2");
                    break;
                }
                if (!this.timeout()) break;
                enabled.addElement("3");
                break;
            }
            case 2: {
                if (this.Event("msg:Cancel")) {
                    enabled.addElement("4");
                    break;
                }
                if (!this.Event("event:Canceled")) break;
                enabled.addElement("5");
                break;
            }
        }
        return enabled;
    }

    public void fireTransition(String trans) {
        int tindex = Integer.parseInt(trans);
        switch (tindex) {
            case 0: {
                this.handleRequest();
                this.current_state = 1;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT", 2, this.FAC_FSM);
                break;
            }
            case 1: {
                this.sendAccept();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state CREATED", 2, this.FAC_FSM);
                break;
            }
            case 2: {
                this.sendReject();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 3: {
                this.sendReject();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 4: {
                this.handleCancel();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 5: {
                this.sendCancel();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
            }
        }
    }

    protected boolean testProtocol(FSMEvent evt) {
        if (evt instanceof KQMLFSMEvent) {
            KQMLFSMEvent ke = (KQMLFSMEvent)evt;
            KQMLMessage m = ke.getMessage();
            return m.getDestAddr().equals((String)this.state.getProperty((Object)"Name"));
        }
        return false;
    }

    public void handleRequestMsg(FSMEvent event) {
        if (event instanceof KQMLFSMEvent) {
            KQMLFSMEvent ke = (KQMLFSMEvent)event;
            KQMLMessage m = ke.getMessage();
            Object response = null;
            String content = m.contentData();
            this.log.log("DCR handleRequestMsg: " + content, 3, this.FAC_FSM);
            ReadTTaems reader = new ReadTTaems(utilities.Log.getDefault());
            this._taems = reader.readTTaems((Reader)new StringReader(content));
            Commitment _commitment = this._taems.getCommitment();
            if (_commitment == null) {
                this.log.log("Error: Could not find DC commitment in structure", 0, this.FAC_FSM);
            }
            this._lID = new Long(_commitment.getID());
            FSMEvent evt = new FSMEvent(this, "Posed", 1, 1);
            evt.setTaems(this._taems);
            evt.setCoordinateID(this._lID);
            evt.setFsmID(DefaultCommitmentResponder.getFsmID());
            this.startFireEvent(evt);
            this.startTimer(_commitment.getDeadline());
            this.setCurrentState(1);
        }
    }

    public void handleRequest() {
        this.log.log("DCR handleRequest", 2, this.FAC_FSM);
    }

    public void sendAccept() {
        this.log.log("DCR handleAccept", 2, this.FAC_FSM);
        Commitment _commitment = this._taems.getCommitment();
        KQMLMessage response = new KQMLMessage("reply", (Object)"(OK)", _commitment.getFromAgent().getLabel());
        response.addField("in-reply-to", String.valueOf(_commitment.getID()));
        this.startFireEvent(new KQMLFSMEvent(this, response));
    }

    public void sendReject() {
        this.log.log("DCR handleReject", 2, this.FAC_FSM);
        Commitment _commitment = this._taems.getCommitment();
        KQMLMessage response = new KQMLMessage("reply", (Object)"(NOK)", _commitment.getFromAgent().getLabel());
        response.addField("in-reply-to", String.valueOf(_commitment.getID()));
        this.startFireEvent(new KQMLFSMEvent(this, response));
    }

    public void handleCancel() {
        this.log.log("DCR handleCancel", 2, this.FAC_FSM);
        FSMEvent evt = new FSMEvent(this, "Canceled", this.time, 1);
        evt.setTaems(this._taems);
        evt.setCoordinateID(this._lID);
        evt.setFsmID(DefaultCommitmentResponder.getFsmID());
        this.startFireEvent(evt);
    }

    public void sendCancel() {
        Commitment _commitment = this._taems.getCommitment();
        KQMLMessage msg = new KQMLMessage("tell", (Object)"(Cancel)", _commitment.getFromAgent().getLabel());
        msg.addField("in-reply-to", String.valueOf(_commitment.getID()));
        this.startFireEvent(new KQMLFSMEvent(this, msg));
    }
}

