/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.coordinate.FSM;
import agent.coordinate.FSMEvent;
import agent.coordinate.FSMEventListener;
import agent.coordinate.KQMLFSMEvent;
import agent.mass.State;
import agent.simplest.Log;
import java.io.Serializable;
import java.util.Vector;
import taems.Commitment;
import taems.Taems;
import utilities.KQMLMessage;

public class DefaultCommitmentInitiator
extends FSM
implements Serializable {
    Taems _taems;
    Long _lID;
    final int S0 = 0;
    final int WAIT = 1;
    final int CREATED = 2;
    final int FINISHED = 3;
    private static int FSMID = -1;

    public DefaultCommitmentInitiator(Log l, State s, FSMEventListener list) {
        super(l, s, list);
        this.current_state = 0;
    }

    public static int getFsmID() {
        if (FSMID < 0) {
            FSMID = FSM.getFsmCount();
        }
        return FSMID;
    }

    public static Object initiate(FSMEvent event, Log l, State s, FSMEventListener list) {
        if (event == null) {
            return null;
        }
        DefaultCommitmentInitiator newfsm = null;
        if (event.matchLabel("event:DefaultCommitment")) {
            newfsm = new DefaultCommitmentInitiator(l, s, list);
            newfsm.initNegotiationEvent(event);
            return newfsm;
        }
        return newfsm;
    }

    public void fsmEventReceived(FSMEvent ce) {
        if (ce.matchLabel("*:DefaultCommitment")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:OK")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:NOK")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Cancel")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:Canceled")) {
            this.recvEvents.addElement(ce);
        }
    }

    public boolean final_state() {
        return this.current_state == 3;
    }

    public Vector enabledTransitions() {
        Vector<String> enabled = new Vector<String>();
        switch (this.current_state) {
            case 0: {
                if (!this.Event("DefaultCommitment")) break;
                enabled.addElement("0");
                break;
            }
            case 1: {
                if (this.Event("OK")) {
                    enabled.addElement("1");
                    break;
                }
                if (this.Event("NOK")) {
                    enabled.addElement("2");
                    break;
                }
                if (!this.timeout()) break;
                enabled.addElement("3");
                break;
            }
            case 2: {
                if (this.Event("msg:Cancel")) {
                    enabled.addElement("4");
                    break;
                }
                if (!this.Event("event:Canceled")) break;
                enabled.addElement("5");
                break;
            }
        }
        return enabled;
    }

    public void fireTransition(String trans) {
        int tindex = Integer.parseInt(trans);
        switch (tindex) {
            case 0: {
                this.startTimer(5);
                this.current_state = 1;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT", 2, this.FAC_FSM);
                break;
            }
            case 1: {
                this.handleAccept();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state CREATED", 2, this.FAC_FSM);
                break;
            }
            case 2: {
                this.handleReject();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 3: {
                this.handleReject();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 4: {
                this.handleCancel();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 5: {
                this.sendCancel();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
            }
        }
    }

    public void initNegotiationEvent(FSMEvent ce) {
        this.log.log("DCI initNegotiationEvent: " + ce, 2, this.FAC_FSM);
        this._taems = ce.getTaems();
        Commitment _commitment = this._taems.getCommitment();
        if (_commitment == null) {
            this.log.log("Error: Could not find DC commitment in structure", 0, this.FAC_FSM);
        }
        this._lID = new Long(_commitment.getID());
        KQMLMessage msg = new KQMLMessage("tell", (Object)("(DefaultCommitmentPose " + this._taems.toString() + ")"), _commitment.getToAgent().getLabel());
        msg.addField("reply-with", String.valueOf(_commitment.getID()));
        this.startFireEvent(new KQMLFSMEvent(this, msg));
        this.startTimer(_commitment.getDeadline());
        this.setCurrentState(1);
    }

    public void handleAccept() {
        this.log.log("DCI handleAccept", 2, this.FAC_FSM);
        FSMEvent evt = new FSMEvent(this, "Accepted", this.time, 1);
        evt.setTaems(this._taems);
        evt.setCoordinateID(this._lID);
        evt.setFsmID(DefaultCommitmentInitiator.getFsmID());
        this.startFireEvent(evt);
    }

    public void handleReject() {
        this.log.log("DCI handleReject", 2, this.FAC_FSM);
        FSMEvent evt = new FSMEvent(this, "Rejected", this.time, 1);
        evt.setTaems(this._taems);
        evt.setFsmID(DefaultCommitmentInitiator.getFsmID());
        evt.setCoordinateID(this._lID);
        this.startFireEvent(evt);
    }

    public void handleCancel() {
        this.log.log("DCI handleCancel", 2, this.FAC_FSM);
        FSMEvent evt = new FSMEvent(this, "Canceled", this.time, 1);
        evt.setTaems(this._taems);
        evt.setCoordinateID(this._lID);
        evt.setFsmID(DefaultCommitmentInitiator.getFsmID());
        this.startFireEvent(evt);
    }

    public void sendCancel() {
        Commitment _commitment = this._taems.getCommitment();
        KQMLMessage msg = new KQMLMessage("tell", (Object)"(Cancel)", _commitment.getToAgent().getLabel());
        msg.addField("in-reply-to", String.valueOf(_commitment.getID()));
        this.startFireEvent(new KQMLFSMEvent(this, msg));
    }
}

