/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.coordinate.FSM;
import agent.coordinate.FSMEvent;
import agent.coordinate.FSMEventListener;
import agent.coordinate.KQMLFSMEvent;
import agent.mass.State;
import agent.simplest.Log;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.Taems;
import utilities.KQMLMessage;

public class DSharpResponder
extends FSM
implements Serializable {
    Commitment _commitment;
    Commitment _myCommitment;
    KQMLMessage _currentMsg;
    Long _lID;
    final int S0 = 0;
    final int CONFLICT = 1;
    final int WAIT = 2;
    final int FINISHED = 3;
    private static int FSMID = -1;
    static boolean initialized = false;
    static Hashtable _allCommitments;

    public DSharpResponder(Log l, State s, FSMEventListener list) {
        super(l, s, list);
        this.current_state = 0;
    }

    public static int getFsmID() {
        if (FSMID < 0) {
            FSMID = FSM.getFsmCount();
        }
        return FSMID;
    }

    public static Object initiate(FSMEvent event, Log l, State s, FSMEventListener list) {
        if (event == null) {
            return null;
        }
        DSharpResponder newfsm = null;
        if (event.matchLabel("msg:Need")) {
            newfsm = new DSharpResponder(l, s, list);
            if (!newfsm.testProtocol(event)) {
                return null;
            }
            newfsm.evaluateRequestMsg(event);
            return newfsm;
        }
        return newfsm;
    }

    public void fsmEventReceived(FSMEvent ce) {
        if (ce.matchLabel("msg:Need") && this.testProtocol(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:Conflict")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:Nullify")) {
            this.recvEvents.addElement(ce);
        }
    }

    public boolean final_state() {
        return this.current_state == 3;
    }

    public Vector enabledTransitions() {
        Vector<String> enabled = new Vector<String>();
        switch (this.current_state) {
            case 0: {
                enabled.addElement("0");
                break;
            }
            case 1: {
                if (this.Event("Conflict")) {
                    enabled.addElement("1");
                    break;
                }
                if (!this.timeout()) break;
                enabled.addElement("2");
                break;
            }
            case 2: {
                if (this.timeout()) {
                    enabled.addElement("3");
                    break;
                }
                if (!this.Event("Nullify")) break;
                enabled.addElement("4");
                break;
            }
        }
        return enabled;
    }

    public void fireTransition(String trans) {
        int tindex = Integer.parseInt(trans);
        switch (tindex) {
            case 0: {
                this.current_state = 1;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state CONFLICT", 2, this.FAC_FSM);
                break;
            }
            case 1: {
                this.conflictFound();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT", 2, this.FAC_FSM);
                break;
            }
            case 2: {
                this.handleTimeout();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 3: {
                this.handleTimeout();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 4: {
                this.handleNullify();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
            }
        }
    }

    protected void init() {
        if (!initialized) {
            initialized = true;
            _allCommitments = new Hashtable();
        }
        this._currentMsg = null;
    }

    protected boolean testProtocol(FSMEvent evt) {
        if (evt instanceof KQMLFSMEvent) {
            KQMLFSMEvent ke = (KQMLFSMEvent)evt;
            KQMLMessage m = ke.getMessage();
            return m.getDestAddr().equals("*");
        }
        return false;
    }

    public void evaluateRequestMsg(FSMEvent event) {
        if (event instanceof KQMLFSMEvent) {
            KQMLFSMEvent ke = (KQMLFSMEvent)event;
            KQMLMessage m = ke.getMessage();
            this.init();
            this._currentMsg = m;
            String request = this._currentMsg.contentData();
            this.log.log("evaluateRequestMsg: " + request, 1, this.FAC_FSM);
            StringTokenizer s = new StringTokenizer(request);
            String resName = s.nextToken();
            int priority = Integer.parseInt(s.nextToken());
            float quantity = Float.valueOf(s.nextToken()).floatValue();
            float bound = Float.valueOf(s.nextToken()).floatValue();
            int start = Integer.parseInt(s.nextToken());
            int duration = Integer.parseInt(s.nextToken());
            long reqId = Long.parseLong(s.nextToken());
            String fromAgent = this._currentMsg.getSourceAddr();
            this._lID = new Long(reqId);
            if (_allCommitments.containsKey(this._lID)) {
                this.log.log("Attempt to negotiate a Commitment already under negotiation: ID=" + this._lID, 1, this.FAC_FSM);
                this.setCurrentState(3);
                return;
            }
            this._commitment = new Commitment("Coordination", resName, new Agent(fromAgent), new Agent((String)this.state.getProperty((Object)"Name")), null, priority, 0.0f, start, 5, start + duration);
            this._commitment.setQuantity(quantity);
            this._commitment.setResource(resName);
            this._commitment.setID(reqId);
            Taems t = new Taems();
            t.addCommitment(this._commitment);
            _allCommitments.put(new Long(reqId), this._commitment);
            FSMEvent evt = new FSMEvent(this, "Posed", 1, 1);
            evt.setTaems(t);
            evt.setFsmID(DSharpResponder.getFsmID());
            evt.setCoordinateID(this._lID);
            this.startOffsetTimer(5);
            this.log.log("Timer set to Offset 5", 1, this.FAC_FSM);
            this.startFireEvent(evt);
        }
    }

    public void conflictFound() {
        Taems t = this.currentevent.getTaems();
        Enumeration e = t.getCommitments();
        KQMLMessage response = null;
        this._myCommitment = (Commitment)e.nextElement();
        response = new KQMLMessage("reply", (Object)("(Conflict " + this._myCommitment.getResource() + " " + this._myCommitment.getImportance() + " " + this._myCommitment.getQuantity() + " " + this._myCommitment.getQuantity() + " " + this._myCommitment.getEarliestStartTime() + " " + (this._myCommitment.getTimeSatisfied() - this._myCommitment.getEarliestStartTime()) + " " + this._myCommitment.getID() + " " + this._commitment.getID() + ")"), this._currentMsg.getSourceAddr());
        response.addField("in-reply-to", this._currentMsg.getField("reply-with"));
        System.err.println(response);
        this.startFireEvent(new KQMLFSMEvent(this, response));
        this.startTimer(this._myCommitment.getTimeSatisfied());
    }

    protected void handleNullify() {
        String request = this.currentmsg.contentData();
        StringTokenizer s = new StringTokenizer(request);
        String resName = s.nextToken();
        int priority = Integer.parseInt(s.nextToken());
        String othersId = s.nextToken();
        long myId = Long.parseLong(s.nextToken());
        if (myId == this._commitment.getID()) {
            _allCommitments.remove(this._lID);
            FSMEvent evt = new FSMEvent(this, "Canceled", 1, 1);
            Taems t = new Taems();
            t.addCommitment(this._commitment);
            evt.setTaems(t);
            evt.setFsmID(DSharpResponder.getFsmID());
            evt.setCoordinateID(this._lID);
            this.startFireEvent(evt);
        }
    }

    protected void handleTimeout() {
        this.log.log("Timed out waiting for nullify response to potential conflict. I guess there was no conflict after all.", 3, this.FAC_FSM);
        _allCommitments.remove(this._lID);
        if (this._myCommitment != null) {
            FSMEvent evt = new FSMEvent(this, "Accepted", 1, 1);
            Taems t = new Taems();
            t.addCommitment(this._myCommitment);
            evt.setTaems(t);
            evt.setFsmID(DSharpResponder.getFsmID());
            evt.setCoordinateID(this._myCommitment.getID());
            this.startFireEvent(evt);
        }
    }
}

