/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.base.AgentEvent;
import agent.coordinate.FSM;
import agent.coordinate.FSMEvent;
import agent.coordinate.FSMEventListener;
import agent.coordinate.KQMLFSMEvent;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.Observe;
import agent.simplest.Observer;
import agent.simplest.State;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.Taems;
import utilities.KQMLMessage;

public class DSharpInitiator
extends FSM
implements Serializable {
    Commitment _commitment;
    Hashtable _conflictMessages;
    Hashtable _conflicts;
    Long _lID;
    final int S0 = 0;
    final int WAIT = 1;
    final int ANSWER = 2;
    final int FINISHED = 3;
    private static int FSMID = -1;
    static boolean initialized = false;
    static Hashtable _allCommitments;

    public DSharpInitiator(Log l, agent.mass.State s, FSMEventListener list) {
        super(l, s, list);
        this.current_state = 0;
    }

    public static int getFsmID() {
        if (FSMID < 0) {
            FSMID = FSM.getFsmCount();
        }
        return FSMID;
    }

    public static Object initiate(FSMEvent event, Log l, agent.mass.State s, FSMEventListener list) {
        if (event == null) {
            return null;
        }
        DSharpInitiator newfsm = null;
        if (event.matchLabel("event:DSharp")) {
            newfsm = new DSharpInitiator(l, s, list);
            newfsm.initNegotiationEvent(event);
            return newfsm;
        }
        return newfsm;
    }

    public void fsmEventReceived(FSMEvent ce) {
        if (ce.matchLabel("*:DSharp")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:Conflict")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:Accepted")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:Canceled")) {
            this.recvEvents.addElement(ce);
        }
    }

    public boolean final_state() {
        return this.current_state == 3;
    }

    public Vector enabledTransitions() {
        Vector<String> enabled = new Vector<String>();
        switch (this.current_state) {
            case 0: {
                if (!this.Event("DSharp")) break;
                enabled.addElement("0");
                break;
            }
            case 1: {
                if (this.timeout()) {
                    enabled.addElement("1");
                    break;
                }
                if (!this.Event("Conflict")) break;
                enabled.addElement("2");
                break;
            }
            case 2: {
                if (this.Event("Accepted")) {
                    enabled.addElement("3");
                    break;
                }
                if (this.Event("Canceled")) {
                    enabled.addElement("4");
                    break;
                }
                if (!this.timeout()) break;
                enabled.addElement("5");
                break;
            }
        }
        return enabled;
    }

    public void fireTransition(String trans) {
        int tindex = Integer.parseInt(trans);
        switch (tindex) {
            case 0: {
                this.startTimeOut();
                this.current_state = 1;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT", 2, this.FAC_FSM);
                break;
            }
            case 1: {
                this.endTimeOut();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state ANSWER", 2, this.FAC_FSM);
                break;
            }
            case 2: {
                this.handleConflict();
                this.current_state = 1;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT", 2, this.FAC_FSM);
                break;
            }
            case 3: {
                this.generateAnswer();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 4: {
                this.generateCancelation();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 5: {
                this.quit();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
            }
        }
    }

    protected void init() {
        this._conflictMessages = new Hashtable();
        this._conflicts = new Hashtable();
        if (!initialized) {
            initialized = true;
            _allCommitments = new Hashtable();
            Observe observe = (Observe)State.findComponent((String)"Observe");
            if (observe != null) {
                Observer observer = new Observer("Need Sent", true){

                    public boolean checkEvent(AgentEvent e) {
                        return e instanceof MessageEvent && e.getID() == 0 && ((KQMLMessage)((MessageEvent)e).getMessage()).contentWord().equals("Need");
                    }
                };
                observe.addObserver(observer);
            }
        }
    }

    public void startTimeOut() {
        this.startTimer(this._commitment.getDeadline());
    }

    protected boolean testCommitmentID(FSMEvent evt) {
        Commitment com;
        if (evt instanceof KQMLFSMEvent) {
            KQMLFSMEvent ke = (KQMLFSMEvent)evt;
            KQMLMessage m = ke.getMessage();
            return m.getField("in-reply-to") != null && Long.parseLong(m.getField("in-reply-to")) == this._lID;
        }
        Enumeration e = evt.getTaems().getCommitments();
        return e != null && (com = (Commitment)e.nextElement()).getID() == this._lID.longValue();
    }

    protected void insertConflict(Commitment c) {
        if (this._conflicts.containsKey(new Long(c.getID()))) {
            this.log.log("Attempt to negotiate a Commitment already under negotiation: ID=" + c.getID(), 1, this.FAC_FSM);
        } else {
            this._conflicts.put(new Long(c.getID()), c);
        }
    }

    protected void nullifyKillList(Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Commitment c = (Commitment)e.nextElement();
            KQMLMessage msg = new KQMLMessage("ask", (Object)("(Nullify " + this._commitment.getResource() + " " + this._commitment.getImportance() + " " + this._commitment.getID() + " " + c.getID() + ")"), c.getToAgent().getLabel());
            msg.addField("in-reply-to", ((KQMLMessage)this._conflictMessages.get(c)).getField("reply-with"));
            this.startFireEvent(new KQMLFSMEvent(this, msg));
        }
        _allCommitments.remove(this._lID);
        this.finalize();
    }

    public void endTimeOut() {
        this.log.log("endTimeOut", 4, this.FAC_FSM);
        Taems t = new Taems();
        Enumeration e = this._conflicts.keys();
        while (e.hasMoreElements()) {
            Commitment c = (Commitment)this._conflicts.get((Long)e.nextElement());
            t.addCommitment(c);
        }
        FSMEvent evt = new FSMEvent(this, "Timeout", this.time, 1);
        evt.setTaems(t);
        evt.setFsmID(DSharpInitiator.getFsmID());
        evt.setCoordinateID(this._lID);
        this.startFireEvent(evt);
        this.startTimer(this._commitment.getDeadline());
    }

    public void quit() {
    }

    public void initNegotiationEvent(FSMEvent ce) {
        this.log.log("initNegotiationEvent", 4, this.FAC_FSM);
        this.init();
        try {
            Enumeration e = ce.getTaems().getCommitments();
            this._commitment = (Commitment)e.nextElement();
            this._lID = new Long(this._commitment.getID());
        }
        catch (ClassCastException e) {
            this.log.log((Object)e, 1, this.FAC_FSM);
            this.current_state = 3;
            return;
        }
        catch (NullPointerException e) {
            this.log.log((Object)e, 1, this.FAC_FSM);
            this.current_state = 3;
            return;
        }
        if (_allCommitments.containsKey(this._lID)) {
            this.log.log("Attempt to negotiate a Commitment already under negotiation: ID=" + this._commitment.getID(), 1, this.FAC_FSM);
            this.current_state = 3;
            return;
        }
        _allCommitments.put(this._lID, this._commitment);
        String resource = this._commitment.getType();
        if (this._commitment.getResource() != null) {
            resource = this._commitment.getType();
        }
        this.insertConflict(this._commitment);
        KQMLMessage msg = new KQMLMessage("ask", (Object)("(Need " + resource + " " + this._commitment.getImportance() + " " + this._commitment.getQuantity() + " " + this._commitment.getQuantity() + " " + this._commitment.getEarliestStartTime() + " " + (this._commitment.getTimeSatisfied() - this._commitment.getEarliestStartTime()) + " " + this._commitment.getID() + ")"), "*");
        this.startOffsetTimer(this._commitment.getDeadline());
        msg.addField("reply-with", "" + this._commitment.getID());
        this.startFireEvent(new KQMLFSMEvent(this, msg));
        this.current_state = 1;
    }

    public void initNegotiation() {
        this.log.log("Error initNegotiation is called (shouldn't)", 0, this.FAC_FSM);
    }

    public void handleConflict() {
        this.log.log("handleConflict", 4, this.FAC_FSM);
        Object response = null;
        int handle = -1;
        String request = this.currentmsg.contentData();
        this.log.log("evaluateRequestMsg: " + request, 4, this.FAC_FSM);
        StringTokenizer s = new StringTokenizer(request);
        String resName = s.nextToken();
        int priority = Integer.parseInt(s.nextToken());
        float quantity = Float.valueOf(s.nextToken()).floatValue();
        float bound = Float.valueOf(s.nextToken()).floatValue();
        int start = Integer.parseInt(s.nextToken());
        int duration = Integer.parseInt(s.nextToken());
        long othersId = Long.parseLong(s.nextToken());
        long myId = Long.parseLong(s.nextToken());
        if (myId != this._commitment.getID()) {
            this.log.log("Conflict reported for incorrect commitment", 1, this.FAC_FSM);
            return;
        }
        Commitment conflict = new Commitment("Resource", resName, new Agent(this.currentmsg.getSourceAddr()), new Agent(this.currentmsg.getDestAddr()), null, priority, 0.0f, start, 0, start + duration);
        conflict.setID(othersId);
        conflict.setQuantity(quantity);
        this.insertConflict(conflict);
        this._conflictMessages.put(conflict, this.currentmsg);
        this.current_state = 1;
    }

    public void generateAnswer() {
        this.log.log("generateAnswer", 4, this.FAC_FSM);
    }

    public void generateCancelation() {
        this.log.log("generateCancelation", 4, this.FAC_FSM);
    }
}

