/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.base.AgentEvent;
import taems.Taems;

public class CoordinateEvent
extends AgentEvent {
    public static final int RECEIVED = 0x100000;
    public static final int SENT = 0;
    public static final int RMASK = 69905;
    public static final int ACCEPTED = 1;
    public static final int POSED = 16;
    public static final int CANCELED = 256;
    public static final int REJECTED = 4096;
    public static final int TIMEOUT = 65536;
    public static final int GPGP_FSM = 3;
    public static final int CN_FSM = 4;
    protected int fsmID;
    protected Long coordinateID;
    protected Taems data;
    protected String type;

    public CoordinateEvent(Object source, int id) {
        super(source, id);
    }

    public CoordinateEvent(Object source, int id, Taems taems) {
        this(source, id);
        this.setTaems(taems);
    }

    public CoordinateEvent(Object source, String t, int id, Taems taems) {
        this(source, id, taems);
        this.setType(t);
    }

    public Taems getTaems() {
        return this.data;
    }

    public void setTaems(Taems t) {
        this.data = t;
    }

    public void setFsmID(int i) {
        this.fsmID = i;
    }

    public int getFsmID() {
        return this.fsmID;
    }

    public Long getCoordinateID() {
        return this.coordinateID;
    }

    public void setCoordinateID(long l) {
        this.coordinateID = new Long(l);
    }

    public void setCoordinateID(Long l) {
        this.coordinateID = l;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String s) {
        this.type = s;
    }

    public int getID() {
        return super.getID() & 0x11111;
    }

    public boolean wasReceived() {
        return (super.getID() & 0x100000) != 0;
    }

    public boolean wasSent() {
        return !this.wasReceived();
    }

    public String toString() {
        return "(CoordinateEvent) " + this.getID() + ":" + this.getType() + ":" + this.getCoordinateID() + " " + this.data.toString();
    }
}

