/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.coordinate.FSM;
import agent.coordinate.FSMEvent;
import agent.coordinate.FSMEventListener;
import agent.coordinate.KQMLFSMEvent;
import agent.mass.PreprocessTaemsReader;
import agent.mass.State;
import agent.simplest.Log;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;
import taems.Commitment;
import taems.Taems;
import utilities.KQMLMessage;

public class ContractResponder
extends FSM
implements Serializable {
    Commitment _commitment;
    Hashtable _allCommitments;
    Long _lID;
    KQMLMessage msgrcv;
    KQMLMessage _message;
    FSMEvent evtrcv;
    Commitment myBid;
    int _timeout;
    final int S0 = 0;
    final int THINK = 1;
    final int ACCEPT = 2;
    final int WAITCONTRACTCOMPLETED = 3;
    final int FINISH = 4;
    static boolean initialized = false;

    public ContractResponder(Log l, State s, FSMEventListener list) {
        super(l, s, list);
        this.current_state = 0;
    }

    public static Object initiate(FSMEvent event, Log l, State s, FSMEventListener list) {
        if (event == null) {
            return null;
        }
        ContractResponder newfsm = null;
        if (event.matchLabel("msg:PoseContract")) {
            newfsm = new ContractResponder(l, s, list);
            newfsm.rcvNegotiationEvent(event);
            return newfsm;
        }
        return newfsm;
    }

    public void fsmEventReceived(FSMEvent ce) {
        if (ce.matchLabel("event:AcceptContract") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("event:RejectContract") && this.testCommitment(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:PoseContract")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:AcceptBid")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:RefuseBid")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:ContractCompleted")) {
            this.recvEvents.addElement(ce);
        }
    }

    public boolean final_state() {
        return this.current_state == 4;
    }

    public Vector enabledTransitions() {
        Vector<String> enabled = new Vector<String>();
        switch (this.current_state) {
            case 0: {
                if (!this.Event("msg:PoseContract")) break;
                enabled.addElement("0");
                break;
            }
            case 1: {
                if (this.Event("AcceptContract")) {
                    enabled.addElement("1");
                    break;
                }
                if (!this.Event("RejectContract")) break;
                enabled.addElement("2");
                break;
            }
            case 2: {
                if (this.timeout()) {
                    enabled.addElement("3");
                    break;
                }
                if (this.Event("msg:AcceptBid")) {
                    enabled.addElement("4");
                    break;
                }
                if (!this.Event("msg:RefuseBid")) break;
                enabled.addElement("5");
                break;
            }
            case 3: {
                if (!this.Event("ContractCompleted")) break;
                enabled.addElement("6");
                break;
            }
        }
        return enabled;
    }

    public void fireTransition(String trans) {
        int tindex = Integer.parseInt(trans);
        switch (tindex) {
            case 0: {
                this.rcvNegotiation();
                this.current_state = 1;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state THINK", 2, this.FAC_FSM);
                break;
            }
            case 1: {
                this.sendOutBid();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state ACCEPT", 2, this.FAC_FSM);
                break;
            }
            case 2: {
                this.sendReject();
                this.current_state = 4;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISH", 2, this.FAC_FSM);
                break;
            }
            case 3: {
                this.handleCancel();
                this.current_state = 4;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISH", 2, this.FAC_FSM);
                break;
            }
            case 4: {
                this.handleConfirm();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAITCONTRACTCOMPLETED", 2, this.FAC_FSM);
                break;
            }
            case 5: {
                this.handleCancel();
                this.current_state = 4;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISH", 2, this.FAC_FSM);
                break;
            }
            case 6: {
                this.handleCompleted();
                this.current_state = 4;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISH", 2, this.FAC_FSM);
            }
        }
    }

    protected void init() {
        if (!initialized) {
            this._allCommitments = new Hashtable();
            this.state.setProperty((Object)"TaskAssign:Commitments", (Object)this._allCommitments);
            initialized = true;
        } else {
            this._allCommitments = (Hashtable)this.state.getProperty((Object)"TaskAssign:Commitments");
        }
        this._timeout = 12;
    }

    protected boolean testCommitment(FSMEvent evt) {
        Commitment c = evt.getTaems().getCommitment();
        this.log.log("c.ID=" + c.getID() + "lID= " + this._lID, 0, this.FAC_FSM);
        if (c != null && c.getID() == this._lID.longValue()) {
            return true;
        }
        return true;
    }

    public void rcvNegotiationEvent(FSMEvent ce) {
        KQMLMessage m;
        this.log.log("rcvNegotiationEvent: " + ce, 3, this.FAC_FSM);
        this.init();
        if (!(ce instanceof KQMLFSMEvent)) {
            return;
        }
        this._message = m = ((KQMLFSMEvent)ce).getMessage();
        String perf = m.getPerformative();
        this.log.log(" Message received:" + m.contentWord() + " " + m.contentData(), 1, this.FAC_FSM);
        if (m.contentWord().equalsIgnoreCase("PoseContract")) {
            PreprocessTaemsReader reader = (PreprocessTaemsReader)agent.simplest.State.findComponent((String)"PreprocessTaemsReader");
            Taems tm = reader.readTTaems(new StringReader(m.contentData()));
            Commitment com = tm.getCommitment();
            this._lID = new Long(com.getID());
            Taems t = new Taems();
            t.addCommitment(com);
            FSMEvent evt = new FSMEvent(this, "Posed", 0x100000, 1);
            evt.setTaems(t);
            evt.setCoordinateID(this._lID);
            evt.setFsmID(4);
            evt.setType("GetContract");
            this.startFireEvent(evt);
            this.current_state = 1;
            this.log.log(" fire event: GetContract", 4, this.FAC_FSM);
        }
    }

    public void rcvNegotiation() {
        this.log.log("initNegotiation", 4, this.FAC_FSM);
    }

    public boolean rcvMessage(String type) {
        this.log.log("rcvMessage", 4, this.FAC_FSM);
        this.msgrcv = this.MessageReceived(type);
        if (this.msgrcv == null) {
            return false;
        }
        return this.msgrcv.getField("in-reply-to") != null && this.msgrcv.getField("in-reply-to").equalsIgnoreCase(String.valueOf(this._lID));
    }

    public void sendOutBid() {
        this.log.log("sendOutBid:", 0, this.FAC_FSM);
        this.myBid = this.currentevent.getTaems().getCommitment();
        KQMLMessage msg = new KQMLMessage("reply", (Object)("(Accept " + this.myBid.toString() + ")"), this.myBid.getToAgent().getLabel());
        msg.addField("reply-with", String.valueOf(this._lID));
        msg.addField("in-reply-to", String.valueOf(this._lID));
        this.startFireEvent(new KQMLFSMEvent(this, msg));
        this.startOffsetTimer(this._timeout);
        this.current_state = 2;
    }

    public void sendReject() {
        this.log.log("sendReject: ", 4, this.FAC_FSM);
        this.myBid = this.currentevent.getTaems().getCommitment();
        KQMLMessage msg = new KQMLMessage("reply", (Object)("(Reject " + this.myBid.getID() + ")"), this.myBid.getFromAgent().getLabel());
        msg.addField("reply-with", String.valueOf(this._lID));
        msg.addField("in-reply-to", String.valueOf(this._lID));
        this.startFireEvent(new KQMLFSMEvent(this, msg));
    }

    public boolean rcvFSMEvent(FSMEvent ce) {
        this.log.log("rcvFSMEvent", 4, this.FAC_FSM);
        this.evtrcv = ce;
        return this.evtrcv != null;
    }

    public void handleConfirm() {
        this.rcvMessage("AcceptBid");
        this.log.log("handleConfirm", 4, this.FAC_FSM);
        KQMLMessage msg = new KQMLMessage("reply", (Object)("(ConfirmBid " + this.myBid.getID() + ")"), this.myBid.getToAgent().getLabel());
        msg.addField("sender", this.myBid.getFromAgent().getLabel());
        msg.addField("reply-with", String.valueOf(this._lID));
        msg.addField("in-reply-to", String.valueOf(this._lID));
        this.log.log("Should be sending confirm bid of " + msg, 0, this.FAC_FSM);
        this.startFireEvent(new KQMLFSMEvent(this, msg));
        Taems t = new Taems();
        t.addCommitment(this.myBid);
        FSMEvent evt = new FSMEvent(this, "Accepted", 1, 1);
        evt.setTaems(t);
        evt.setCoordinateID(this._lID);
        evt.setFsmID(4);
        evt.setType("ConfirmBid");
        this.startFireEvent(evt);
    }

    public void handleCancel() {
        this.rcvMessage("RefuseBid");
        this.log.log("handleCancel", 4, this.FAC_FSM);
        Taems t = new Taems();
        t.addCommitment(this.myBid);
        FSMEvent evt = new FSMEvent(this, "Rejected", 4096, 1);
        evt.setTaems(t);
        evt.setFsmID(4);
        evt.setCoordinateID(this._lID);
        evt.setType("CancelBid");
        this.startFireEvent(evt);
    }

    public void handleCompleted() {
        KQMLMessage msg = new KQMLMessage("reply", (Object)("(ContractCompleted " + this.myBid.getID() + ")"), this.myBid.getToAgent().getLabel());
        msg.addField("sender", this.myBid.getFromAgent().getLabel());
        msg.addField("reply-with", String.valueOf(this._lID));
        msg.addField("in-reply-to", String.valueOf(this._lID));
        this.startFireEvent(new KQMLFSMEvent(this, msg));
    }

    public String getDescription() {
        return "TaskAssignResp";
    }
}

