/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.coordinate.FSM;
import agent.coordinate.FSMEvent;
import agent.coordinate.FSMEventListener;
import agent.coordinate.KQMLFSMEvent;
import agent.mass.State;
import agent.simplest.Log;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.Taems;
import utilities.KQMLMessage;

public class CSharpResponder
extends FSM
implements Serializable {
    Commitment _commitment;
    KQMLMessage _currentMsg;
    Long _lID;
    final int S0 = 0;
    final int RESERVED = 1;
    final int WAIT = 2;
    final int FINISHED = 3;
    private static int FSMID = -1;
    static boolean initialized = false;
    static Hashtable _allCommitments;

    public CSharpResponder(Log l, State s, FSMEventListener list) {
        super(l, s, list);
        this.current_state = 0;
    }

    public static int getFsmID() {
        if (FSMID < 0) {
            FSMID = FSM.getFsmCount();
        }
        return FSMID;
    }

    public static Object initiate(FSMEvent event, Log l, State s, FSMEventListener list) {
        if (event == null) {
            return null;
        }
        CSharpResponder newfsm = null;
        if (event.matchLabel("msg:Need")) {
            newfsm = new CSharpResponder(l, s, list);
            if (!newfsm.testProtocol(event)) {
                return null;
            }
            newfsm.evaluateRequestMsg(event);
            return newfsm;
        }
        return newfsm;
    }

    public void fsmEventReceived(FSMEvent ce) {
        if (ce.matchLabel("msg:Need") && this.testProtocol(ce)) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:Need")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:Priority")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:PSAccepted")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:PSNotAccepted")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:Release")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:CancelRequest")) {
            this.recvEvents.addElement(ce);
        }
    }

    public boolean final_state() {
        return this.current_state == 3;
    }

    public Vector enabledTransitions() {
        Vector<String> enabled = new Vector<String>();
        switch (this.current_state) {
            case 0: {
                if (!this.Event("Need")) break;
                enabled.addElement("0");
                break;
            }
            case 1: {
                if (this.Event("Priority")) {
                    enabled.addElement("1");
                    break;
                }
                if (this.timeout()) {
                    enabled.addElement("5");
                    break;
                }
                if (this.Event("Release")) {
                    enabled.addElement("6");
                    break;
                }
                if (!this.Event("CancelRequest")) break;
                enabled.addElement("7");
                break;
            }
            case 2: {
                if (this.Event("PSAccepted")) {
                    enabled.addElement("2");
                    break;
                }
                if (this.Event("PSNotAccepted")) {
                    enabled.addElement("3");
                    break;
                }
                if (!this.timeout()) break;
                enabled.addElement("4");
                break;
            }
        }
        return enabled;
    }

    public void fireTransition(String trans) {
        int tindex = Integer.parseInt(trans);
        switch (tindex) {
            case 0: {
                this.evaluateRequest();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT", 2, this.FAC_FSM);
                break;
            }
            case 1: {
                this.handleChangePriority();
                this.current_state = 1;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state RESERVED", 2, this.FAC_FSM);
                break;
            }
            case 2: {
                this.sendAcceptation();
                this.current_state = 1;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state RESERVED", 2, this.FAC_FSM);
                break;
            }
            case 3: {
                this.sendNotAccepted();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 4: {
                this.end();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 5: {
                this.handleReleaseRequest();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 6: {
                this.handleReleaseRequest();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 7: {
                this.sendCancellation();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
            }
        }
    }

    protected void init() {
        if (!initialized) {
            initialized = true;
            _allCommitments = new Hashtable();
        }
        this._currentMsg = null;
    }

    protected boolean testProtocol(FSMEvent evt) {
        if (evt instanceof KQMLFSMEvent) {
            KQMLFSMEvent ke = (KQMLFSMEvent)evt;
            KQMLMessage m = ke.getMessage();
            return m.getDestAddr().equals((String)this.state.getProperty((Object)"Name"));
        }
        return false;
    }

    public void evaluateRequestMsg(FSMEvent event) {
        if (event instanceof KQMLFSMEvent) {
            KQMLFSMEvent ke = (KQMLFSMEvent)event;
            KQMLMessage m = ke.getMessage();
            this.init();
            this._currentMsg = m;
            Object response = null;
            int handle = -1;
            String request = m.contentData();
            this.log.log("CSharpResponder (evaluateRequestMsg): " + request, 4, this.FAC_FSM);
            StringTokenizer s = new StringTokenizer(request);
            String resName = s.nextToken();
            int priority = Integer.parseInt(s.nextToken());
            float quantity = Float.valueOf(s.nextToken()).floatValue();
            float bound = Float.valueOf(s.nextToken()).floatValue();
            int start = Integer.parseInt(s.nextToken());
            int duration = Integer.parseInt(s.nextToken());
            long reqId = Long.parseLong(s.nextToken());
            String fromAgent = this._currentMsg.getSourceAddr();
            if (_allCommitments.containsKey(new Long(reqId))) {
                this.log.log("Attempt to negotiate a Commitment already under negotiation: ID=" + reqId, 1, this.FAC_FSM);
                this.setCurrentState(3);
                return;
            }
            this._commitment = new Commitment("Coordination", resName, new Agent(fromAgent), new Agent((String)this.state.getProperty((Object)"Name")), null, priority, 0.0f, start, 5, start + duration);
            this._commitment.setID(reqId);
            this._commitment.setQuantity(quantity);
            this._commitment.setResource(resName);
            this._lID = new Long(reqId);
            Taems t = new Taems();
            t.addCommitment(this._commitment);
            _allCommitments.put(new Long(reqId), this._commitment);
            FSMEvent evt = new FSMEvent(this, "Posed", 1, 1);
            evt.setTaems(t);
            evt.setCoordinateID(this._lID);
            evt.setFsmID(CSharpResponder.getFsmID());
            this.startFireEvent(evt);
            this.startOffsetTimer(5);
            this.setCurrentState(2);
        }
    }

    public void sendAcceptation() {
        KQMLMessage response = new KQMLMessage("reply", (Object)("(Accept " + this._commitment.getResource() + " " + this._commitment.getID() + ")"), this._commitment.getFromAgent().getLabel());
        response.addField("in-reply-to", this._currentMsg.getField("reply-with"));
        this.startFireEvent(new KQMLFSMEvent(this, response));
    }

    public void sendNotAccepted() {
        KQMLMessage response = new KQMLMessage("reply", (Object)("(NotAccept " + this._commitment.getResource() + " " + this._commitment.getID() + ")"), this._commitment.getFromAgent().getLabel());
        response.addField("in-reply-to", this._currentMsg.getField("reply-with"));
        this.startFireEvent(new KQMLFSMEvent(this, response));
    }

    public void evaluateRequest() {
        this.log.log("evaluateRequest", 4, this.FAC_FSM);
    }

    public void handleChangePriority() {
        this.log.log("handleChangePriority", 4, this.FAC_FSM);
        String request = this.currentmsg.contentData();
        StringTokenizer s = new StringTokenizer(request);
        int priority = Integer.parseInt(s.nextToken());
        long reqId = Long.parseLong(s.nextToken());
        if (this._commitment.getID() == reqId) {
            this._commitment.setImportance(priority);
        }
    }

    public void handleReleaseRequest() {
        this.log.log("handleReleaseRequest", 4, this.FAC_FSM);
        _allCommitments.remove(this._lID);
        FSMEvent evt = new FSMEvent(this, "Release", 1, 1);
        Taems t = new Taems();
        t.addCommitment(this._commitment);
        evt.setTaems(t);
        evt.setFsmID(CSharpResponder.getFsmID());
        evt.setCoordinateID(this._lID);
        this.startFireEvent(evt);
    }

    public void end() {
    }

    public void sendCancellation() {
        this.log.log("sendCancellation", 4, this.FAC_FSM);
        KQMLMessage msg = new KQMLMessage("tell", (Object)("(Cancel " + this._commitment.getResource() + " " + this._commitment.getID() + ")"), this._commitment.getFromAgent().getLabel());
        msg.addField("in-reply-to", this._currentMsg.getField("reply-with"));
        this.startFireEvent(new KQMLFSMEvent(this, msg));
        _allCommitments.remove(this._lID);
    }
}

