/*
 * Decompiled with CFR 0.152.
 */
package agent.coordinate;

import agent.coordinate.FSM;
import agent.coordinate.FSMEvent;
import agent.coordinate.FSMEventListener;
import agent.coordinate.KQMLFSMEvent;
import agent.mass.State;
import agent.simplest.Log;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.Commitment;
import taems.Taems;
import utilities.KQMLMessage;

public class CSharpInitiator
extends FSM
implements Serializable {
    Commitment _commitment;
    Long _lID;
    final int S0 = 0;
    final int WAIT = 1;
    final int RESERVED = 2;
    final int FINISHED = 3;
    private static int FSMID = -1;
    static Hashtable _allCommitments;
    static boolean initialized;

    public CSharpInitiator(Log l, State s, FSMEventListener list) {
        super(l, s, list);
        this.current_state = 0;
    }

    public static int getFsmID() {
        if (FSMID < 0) {
            FSMID = FSM.getFsmCount();
        }
        return FSMID;
    }

    public static Object initiate(FSMEvent event, Log l, State s, FSMEventListener list) {
        if (event == null) {
            return null;
        }
        CSharpInitiator newfsm = null;
        if (event.matchLabel("event:CSharp")) {
            newfsm = new CSharpInitiator(l, s, list);
            newfsm.initNegotiationEvent(event);
            return newfsm;
        }
        return newfsm;
    }

    public void fsmEventReceived(FSMEvent ce) {
        if (ce.matchLabel("*:CSharp")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:NotAccept")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("msg:Accept")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:ChangePriority")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:TaskCompleted")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:ReleaseRequest")) {
            this.recvEvents.addElement(ce);
        }
        if (ce.matchLabel("*:Cancel")) {
            this.recvEvents.addElement(ce);
        }
    }

    public boolean final_state() {
        return this.current_state == 3;
    }

    public Vector enabledTransitions() {
        Vector<String> enabled = new Vector<String>();
        switch (this.current_state) {
            case 0: {
                if (!this.Event("CSharp")) break;
                enabled.addElement("0");
                break;
            }
            case 1: {
                if (this.Event("msg:NotAccept")) {
                    enabled.addElement("1");
                    break;
                }
                if (this.timeout()) {
                    enabled.addElement("2");
                    break;
                }
                if (!this.Event("msg:Accept")) break;
                enabled.addElement("3");
                break;
            }
            case 2: {
                if (this.Event("ChangePriority")) {
                    enabled.addElement("4");
                    break;
                }
                if (this.Event("TaskCompleted")) {
                    enabled.addElement("5");
                    break;
                }
                if (this.Event("ReleaseRequest")) {
                    enabled.addElement("6");
                    break;
                }
                if (this.Event("Cancel")) {
                    enabled.addElement("7");
                    break;
                }
                if (!this.timeout()) break;
                enabled.addElement("8");
                break;
            }
        }
        return enabled;
    }

    public void fireTransition(String trans) {
        int tindex = Integer.parseInt(trans);
        switch (tindex) {
            case 0: {
                this.startTimeOut();
                this.current_state = 1;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state WAIT", 2, this.FAC_FSM);
                break;
            }
            case 1: {
                this.handleRejection();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 2: {
                this.endTimeOut();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 3: {
                this.handleAcceptance();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state RESERVED", 2, this.FAC_FSM);
                break;
            }
            case 4: {
                this.handleChangePriority();
                this.current_state = 2;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state RESERVED", 2, this.FAC_FSM);
                break;
            }
            case 5: {
                this.handleTaskCompleted();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 6: {
                this.handleReleaseRequest();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 7: {
                this.handleRequestCanceled();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
                break;
            }
            case 8: {
                this.end();
                this.current_state = 3;
                this.log.log("[FSM" + this.ID + "] Executing Transition " + trans + ". Moving to state FINISHED", 2, this.FAC_FSM);
            }
        }
    }

    public void init() {
        if (!initialized) {
            initialized = true;
            _allCommitments = new Hashtable();
        }
    }

    public void startTimeOut() {
        this.startTimer(this._commitment.getDeadline());
    }

    public void initNegotiationEvent(FSMEvent ce) {
        this.log.log("initNegotiationEvent: " + ce, 4, this.FAC_FSM);
        this.init();
        try {
            Enumeration e = ce.getTaems().getCommitments();
            this._commitment = (Commitment)e.nextElement();
            this._lID = new Long(this._commitment.getID());
        }
        catch (ClassCastException cce) {
            this.log.log((Object)cce, 1, this.FAC_FSM);
            this.setCurrentState(3);
            return;
        }
        catch (NullPointerException npe) {
            this.log.log((Object)npe, 1, this.FAC_FSM);
            this.setCurrentState(3);
            return;
        }
        if (_allCommitments.containsKey(this._lID)) {
            this.log.log("Attempt to negotiate a Commitment already under negotiation: ID=" + this._commitment.getID(), 1, this.FAC_FSM);
            this.setCurrentState(3);
            return;
        }
        _allCommitments.put(this._lID, this._commitment);
        String resource = this._commitment.getType();
        if (this._commitment.getResource() != null) {
            resource = this._commitment.getType();
        }
        KQMLMessage msg = new KQMLMessage("ask", (Object)("(Need " + resource + " " + this._commitment.getImportance() + " " + this._commitment.getQuantity() + " " + this._commitment.getQuantity() + " " + this._commitment.getEarliestStartTime() + " " + (this._commitment.getTimeSatisfied() - this._commitment.getEarliestStartTime()) + " " + this._commitment.getID() + ")"), this._commitment.getToAgent().getLabel());
        this.startOffsetTimer(this._commitment.getDeadline());
        msg.addField("reply-with", "" + this._commitment.getID());
        this.startFireEvent(new KQMLFSMEvent(this, msg));
        this.setCurrentState(1);
    }

    public void endTimeOut() {
        this.log.log("endTimeOut", 4, this.FAC_FSM);
        Taems t = new Taems();
        t.addCommitment(this._commitment);
        FSMEvent evt = new FSMEvent(this, "Rejected", this.time, 1);
        evt.setTaems(t);
        evt.setFsmID(CSharpInitiator.getFsmID());
        evt.setCoordinateID(this._lID);
        this.startFireEvent(evt);
        _allCommitments.remove(this._lID);
        this.finalize();
    }

    public void end() {
    }

    public void handleRejection() {
        this.log.log("handleRejection", 4, this.FAC_FSM);
        Taems t = new Taems();
        t.addCommitment(this._commitment);
        FSMEvent evt = new FSMEvent(this, "Rejected", this.time, 1);
        evt.setTaems(t);
        evt.setFsmID(CSharpInitiator.getFsmID());
        evt.setCoordinateID(this._lID);
        this.startFireEvent(evt);
        _allCommitments.remove(this._lID);
        this.finalize();
    }

    public void handleAcceptance() {
        this.log.log("handleAcceptance", 4, this.FAC_FSM);
        Taems t = new Taems();
        t.addCommitment(this._commitment);
        FSMEvent evt = new FSMEvent(this, "Accepted", this.time, 1);
        evt.setTaems(t);
        evt.setCoordinateID(this._lID);
        evt.setFsmID(CSharpInitiator.getFsmID());
        this.startFireEvent(evt);
        this.startTimer(this._commitment.getTimeSatisfied());
    }

    public void handleChangePriority() {
        this.log.log("handleChangePriority", 4, this.FAC_FSM);
    }

    public void handleTaskCompleted() {
        this.log.log("handleTaskCompleted", 4, this.FAC_FSM);
        this.handleReleaseRequest();
    }

    public void handleReleaseRequest() {
        this.log.log("handleReleaseRequest", 4, this.FAC_FSM);
        _allCommitments.remove(this._lID);
        this.finalize();
    }

    public void handleRequestCanceled() {
        this.log.log("handleRequestCanceled", 4, this.FAC_FSM);
        Taems t = new Taems();
        t.addCommitment(this._commitment);
        FSMEvent evt = new FSMEvent(this, "Canceled", this.time, 1);
        evt.setTaems(t);
        evt.setFsmID(CSharpInitiator.getFsmID());
        evt.setCoordinateID(this._lID);
        this.startFireEvent(evt);
        _allCommitments.remove(this._lID);
        this.finalize();
    }

    static {
        initialized = false;
    }
}

