/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.base.AgentComponent;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.awt.CheckboxMenuItem;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFrame;

public class WindowManager
extends AgentComponent
implements ActionListener,
MouseListener,
ItemListener,
PropertyEventListener,
WindowListener {
    static final long serialVersionUID = 1234567890L;
    protected State state = null;
    protected static Hashtable wmapping = new Hashtable();
    protected static Hashtable mmapping = new Hashtable();
    private static boolean winvis;
    private static PopupMenu menu;
    private static int count;
    public static final String WINVIS = "WinVis";

    public WindowManager() {
        this.addDependency("State");
        State.addParameterInfo(WINVIS, "Boolean", "If true, registered windows will be visibile by default", Boolean.FALSE);
        this.addMouseListener(this);
        MenuItem m = new MenuItem("Show All");
        m.addActionListener(this);
        menu.add(m);
        m = new MenuItem("Hide All");
        m.addActionListener(this);
        menu.add(m);
        menu.addSeparator();
        this.add(menu);
    }

    public void init() {
        this.state = (State)State.findComponent("State");
        this.state.addPropertyEventListener(this);
    }

    public boolean getWinVis() {
        return winvis;
    }

    public void setWinVis(boolean w) {
        winvis = w;
        if (this.state != null) {
            this.state.setProperty(WINVIS, new Boolean(winvis));
        }
    }

    public JFrame createWindow(String title) {
        JFrame f = new JFrame(title);
        this.addWindow(f);
        return f;
    }

    public void addWindow(Window w) {
        String key = "Window__" + count++;
        CheckboxMenuItem m = new CheckboxMenuItem(this.getWindowTitle(w), winvis);
        w.addWindowListener(this);
        m.setActionCommand(key);
        m.addItemListener(this);
        menu.add(m);
        wmapping.put(key, w);
        mmapping.put(w, m);
        this.setWindowState(w, winvis);
    }

    public void removeWindow(Window w) {
        CheckboxMenuItem m = (CheckboxMenuItem)mmapping.remove(w);
        w.removeWindowListener(this);
        m.removeItemListener(this);
        menu.remove(m);
        wmapping.remove(m.getActionCommand());
    }

    public Window getWindow(String t) {
        Enumeration ws = wmapping.elements();
        while (ws.hasMoreElements()) {
            Window w = (Window)ws.nextElement();
            if (!t.equals(this.getWindowTitle(w))) continue;
            return w;
        }
        return null;
    }

    public String getWindowTitle(Window w) {
        String title = null;
        if (w instanceof JFrame) {
            title = ((JFrame)w).getTitle();
        } else if (w instanceof Frame) {
            title = ((Frame)w).getTitle();
        } else if (w instanceof Dialog) {
            title = ((Dialog)w).getTitle();
        }
        if (title == null) {
            title = new String(w.toString());
        }
        return title;
    }

    public void setWindowState(Window w, boolean visible) {
        if (w != null) {
            w.setVisible(visible);
            if (visible) {
                w.setVisible(true);
            } else {
                w.setVisible(true);
            }
            CheckboxMenuItem m = (CheckboxMenuItem)mmapping.get(w);
            m.setState(visible);
        }
    }

    public void toggleWindowState(Window w) {
        if (w != null) {
            this.setWindowState(w, !w.isShowing());
        }
    }

    public void showAllWindows() {
        Enumeration ws = wmapping.elements();
        while (ws.hasMoreElements()) {
            Window w = (Window)ws.nextElement();
            if (w.isShowing()) continue;
            this.setWindowState(w, true);
        }
    }

    public void hideAllWindows() {
        Enumeration ws = wmapping.elements();
        while (ws.hasMoreElements()) {
            Window w = (Window)ws.nextElement();
            if (!w.isShowing()) continue;
            this.setWindowState(w, false);
        }
    }

    public boolean hasPopupMenu() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 || e.isPopupTrigger()) {
            menu.show(this, e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Show All")) {
            this.showAllWindows();
        } else if (command.equals("Hide All")) {
            this.hideAllWindows();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        CheckboxMenuItem m = (CheckboxMenuItem)e.getItemSelectable();
        String command = m.getActionCommand();
        this.setWindowState((Window)wmapping.get(command), m.getState());
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.setWindowState(e.getWindow(), false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void propertyChanged(PropertyEvent e) {
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyAdded(PropertyEvent e) {
        if (e.getKey().toString().equalsIgnoreCase(WINVIS)) {
            winvis = (Boolean)e.getProperty();
        }
    }

    static {
        menu = new PopupMenu("Window List");
        count = 0;
    }
}

