/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.simplest.LogViewer;
import agent.simplest.LogViewerEntry;
import agent.simplest.LogViewerEntrySlot;
import agent.simplest.LogViewerFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ViewerPanel
extends JPanel
implements MouseMotionListener,
MouseListener,
ChangeListener {
    public int TICKWIDTH = 3;
    public int TICKINC = 50 / this.TICKWIDTH;
    public final int PAD = 5;
    public final int LINE = 15;
    LogViewer viewer;
    LegendCanvas lc;
    TimelineCanvas tc;
    JLabel foot;
    JTextArea text1;
    JTextArea text2;
    JScrollPane tcscroll;
    JScrollPane textscroll1;
    JScrollPane textscroll2;
    Point spot;
    JSlider widthslider;
    JSplitPane textsplit;
    String blank = " ";
    Color hilightcolor = new Color(225, 225, 225);
    Color althilightcolor = new Color(255, 255, 150);
    Color searchcolor = new Color(175, 255, 255);
    JTextField search;
    boolean resizescroll = true;
    LogViewerEntrySlot highlighted = null;
    LogViewerEntrySlot althighlighted = null;
    protected Vector searched = new Vector();
    String helpText = "Brief Instructions:\n\n- Click on a token to view its details.\n- Right-click a token to display its details in the alternate (yellow) text area.\n\n- Enter a term in the blue box followed by a return to search all visible tokens.\n\n- Drag the divider bar to change the text areas' viewing sizes.\n- Right-click a text area to swap their arrangement.\n\n- Use the slider bar above to change the viewing scale.\n- See the menus for more options.";

    public ViewerPanel(LogViewer v) {
        this.viewer = v;
        JPanel lp = new JPanel();
        lp.setLayout(new BorderLayout());
        this.lc = new LegendCanvas(this.viewer);
        this.search = new JTextField();
        this.search.setBackground(this.searchcolor);
        this.search.setText("Search Text");
        lp.add(this.lc);
        lp.add((Component)this.search, "South");
        this.tcscroll = new JScrollPane();
        this.tcscroll.setHorizontalScrollBarPolicy(32);
        this.tcscroll.setVerticalScrollBarPolicy(21);
        this.tc = new TimelineCanvas(this.viewer);
        this.tcscroll.getViewport().add(this.tc);
        this.widthslider = new JSlider(1, 10, this.TICKWIDTH);
        this.widthslider.addChangeListener(this);
        this.foot = new JLabel(this.blank);
        JPanel tp = new JPanel();
        tp.setLayout(new GridLayout(1, 2));
        tp.add(this.foot);
        tp.add(this.widthslider);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)lp, "West");
        p.add(this.tcscroll);
        p.add((Component)tp, "South");
        this.textscroll1 = new JScrollPane();
        this.text1 = new JTextArea("\n\n\n");
        this.text1.setLineWrap(true);
        this.text1.setWrapStyleWord(true);
        this.text1.setEditable(false);
        this.text1.setBackground(this.althilightcolor);
        this.textscroll1.getViewport().add(this.text1);
        this.textscroll2 = new JScrollPane();
        this.text2 = new JTextArea("\n\n\n");
        this.text2.setLineWrap(true);
        this.text2.setWrapStyleWord(true);
        this.text2.setEditable(false);
        this.text2.setBackground(this.hilightcolor);
        this.textscroll2.getViewport().add(this.text2);
        this.text2.setText(this.helpText);
        this.textsplit = new JSplitPane(1, this.textscroll1, this.textscroll2);
        MouseAdapter switcher = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    int o = ViewerPanel.this.textsplit.getOrientation();
                    ViewerPanel.this.textsplit.setOrientation(o == 0 ? 1 : 0);
                    ViewerPanel.this.textsplit.setDividerLocation((ViewerPanel.this.textsplit.getMinimumDividerLocation() + ViewerPanel.this.textsplit.getMaximumDividerLocation()) / 2);
                }
            }
        };
        this.textsplit.addMouseListener(switcher);
        this.text1.addMouseListener(switcher);
        this.text2.addMouseListener(switcher);
        JPanel sp = new JPanel();
        sp.setLayout(new BorderLayout());
        sp.add((Component)p, "North");
        sp.add(this.textsplit);
        this.setLayout(new BorderLayout());
        this.add(sp);
        this.tc.addMouseMotionListener(this);
        this.tc.addMouseListener(this);
        this.tc.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
            }
        });
        this.search.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (ViewerPanel.this.search.getText().length() > 0) {
                        int count = ViewerPanel.this.hilightMatches(ViewerPanel.this.search.getText());
                    } else {
                        int n = ViewerPanel.this.hilightMatches(null);
                    }
                }
            }
        });
        this.tc.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (ViewerPanel.this.resizescroll) {
                    JScrollBar scroll = ViewerPanel.this.tcscroll.getHorizontalScrollBar();
                    scroll.setValue(scroll.getMaximum());
                }
            }
        });
        this.search.addFocusListener(new FocusAdapter(){
            boolean first = true;

            public void focusGained(FocusEvent e) {
                if (this.first) {
                    ViewerPanel.this.search.setText("");
                }
                this.first = false;
            }
        });
        this.setSize(300, 100);
        this.revalidate();
        Thread t = new Thread(){

            public void run() {
                try {
                    URL foo = new URL("http://shakti.trincoll.edu/~bhorling/quotes");
                    URLConnection con = foo.openConnection();
                    con.connect();
                    Object o = con.getContent();
                    if (o instanceof InputStream) {
                        String line;
                        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)o));
                        Vector<String> lines = new Vector<String>();
                        while ((line = r.readLine()) != null) {
                            lines.addElement(line);
                        }
                        if (lines.size() != 0) {
                            ViewerPanel.this.blank = (String)lines.elementAt(new Random().nextInt(lines.size()));
                            ViewerPanel.this.blank = ViewerPanel.this.blank.trim();
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.start();
    }

    public JPanel makeTokenLegend() {
        return new TokenCanvas(this.viewer);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.widthslider && this.TICKWIDTH != this.widthslider.getValue()) {
            Rectangle r = this.tcscroll.getViewport().getViewRect();
            r.x = (r.x + r.width) / 2;
            r.width = 1;
            this.TICKWIDTH = this.widthslider.getValue();
            this.TICKINC = 50 / this.TICKWIDTH;
            this.tc.revalidate();
            this.tc.repaint();
            this.tcscroll.getViewport().scrollRectToVisible(r);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        LogViewerEntrySlot v;
        int time = this.tc.calculateTime(e.getX());
        LogViewerFilter filter = this.tc.calculateFilter(e.getY());
        String agent = this.tc.calculateAgent(e.getY());
        int num = -1;
        if (filter != null && (v = filter.getEntry(new Integer(time), agent)) != null) {
            num = v.size();
        }
        this.foot.setText(" Time: " + (time >= 0 ? String.valueOf(time) : "-") + "  Filter: " + (filter != null ? filter.getLabel() : "-") + "  Agent: " + (agent != null ? agent : "-") + (num > 0 ? "  Entries: " + num : ""));
    }

    public void mouseClicked(MouseEvent e) {
        block8: {
            String agent;
            LogViewerFilter filter;
            int time;
            block7: {
                time = this.tc.calculateTime(e.getX());
                filter = this.tc.calculateFilter(e.getY());
                agent = this.tc.calculateAgent(e.getY());
                boolean alt = false;
                if ((e.getModifiers() & 8) == 0 && (e.getModifiers() & 4) == 0) break block7;
                if (this.selectAltEntry(filter, time, agent)) break block8;
                int i = 1;
                while ((double)i < 1.0 + Math.ceil(10 / this.TICKWIDTH)) {
                    if (this.selectAltEntry(filter, time - i, agent)) {
                        return;
                    }
                    if (this.selectAltEntry(filter, time + i, agent)) {
                        return;
                    }
                    ++i;
                }
                break block8;
            }
            if (!this.selectEntry(filter, time, agent)) {
                int i = 1;
                while ((double)i < 1.0 + Math.ceil(10 / this.TICKWIDTH)) {
                    if (this.selectEntry(filter, time + i, agent)) {
                        return;
                    }
                    if (this.selectEntry(filter, time - i, agent)) {
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.foot.setText(this.blank);
    }

    public void mousePressed(MouseEvent e) {
        this.tc.requestFocus();
        this.spot = e.getPoint();
    }

    public void mouseReleased(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hilightMatches(String text) {
        Enumeration e = this.searched.elements();
        while (e.hasMoreElements()) {
            LogViewerEntrySlot v = (LogViewerEntrySlot)e.nextElement();
            v.setColor(null);
        }
        this.searched.clear();
        if (text != null) {
            e = this.viewer.getFilters();
            while (e.hasMoreElements()) {
                LogViewerFilter f = (LogViewerFilter)e.nextElement();
                if (!f.isActive()) continue;
                LogViewerFilter logViewerFilter = f;
                synchronized (logViewerFilter) {
                    Iterator ie = f.getEntryAgents();
                    while (ie.hasNext()) {
                        String agent = (String)ie.next();
                        TreeMap t = f.getEntries(agent);
                        Iterator i = t.keySet().iterator();
                        block6: while (i.hasNext()) {
                            Integer time = (Integer)i.next();
                            LogViewerEntrySlot v = f.getEntry(time, agent);
                            Enumeration en = v.elements();
                            while (en.hasMoreElements()) {
                                LogViewerEntry le = (LogViewerEntry)en.nextElement();
                                if (le.getData().indexOf(text) < 0) continue;
                                this.searched.addElement(v);
                                continue block6;
                            }
                        }
                    }
                }
            }
        }
        this.tc.repaint();
        this.foot.setText(" " + this.searched.size() + " matches found");
        return this.searched.size();
    }

    public boolean selectAltEntry(LogViewerFilter filter, int time, String agent) {
        LogViewerEntrySlot old = this.althighlighted;
        JTextArea text = this.text1;
        JScrollPane scroll = this.textscroll1;
        if (old != null) {
            old.setColor(null);
        }
        this.althighlighted = null;
        if (time >= 0 && filter != null && agent != null) {
            LogViewerEntrySlot v = filter.getEntry(new Integer(time), agent);
            if (v != null) {
                this.althighlighted = v;
                if (this.althighlighted != old) {
                    text.setText(v.toString());
                }
            } else {
                text.setText("");
            }
        }
        if (old != this.althighlighted) {
            this.tc.repaint();
        }
        return this.althighlighted != null;
    }

    public boolean selectEntry(LogViewerFilter filter, int time, String agent) {
        LogViewerEntrySlot old = this.highlighted;
        if (old != null) {
            old.getFilter().deselect(old, this.viewer);
            old.setColor(null);
        }
        this.highlighted = null;
        if (time >= 0 && filter != null && agent != null) {
            LogViewerEntrySlot v = filter.getEntry(new Integer(time), agent);
            JTextArea text = this.text2;
            JScrollPane scroll = this.textscroll2;
            if (v != null) {
                this.highlighted = v;
                if (this.highlighted != old) {
                    text.setText(v.toString());
                }
                filter.select(v, this.viewer);
            } else {
                text.setText("");
            }
        }
        if (old != this.highlighted) {
            this.tc.repaint();
        }
        return this.highlighted != null;
    }

    public void drawString(Graphics g, String s, int x, int y, int align) {
        FontMetrics metrics = g.getFontMetrics();
        int width = metrics.stringWidth(s);
        y -= metrics.getDescent();
        switch (align) {
            case 0: {
                x += 5;
                break;
            }
            case 1: {
                x -= width / 2;
                break;
            }
            case 2: {
                x -= width + 5;
            }
        }
        g.drawString(s, x, y);
    }

    public int calculateDataHeight() {
        int h = 30;
        Enumeration e = this.viewer.getFilters();
        while (e.hasMoreElements()) {
            LogViewerFilter f = (LogViewerFilter)e.nextElement();
            if (!f.isActive()) continue;
            h += 15 * Math.max(f.getNumAgents(), 1);
        }
        return h;
    }

    class TimelineCanvas
    extends JPanel {
        private int HINSET = 20;
        LogViewer viewer;

        public TimelineCanvas(LogViewer v) {
            this.viewer = v;
            this.setAutoscrolls(true);
        }

        public boolean isOpaque() {
            return true;
        }

        public boolean isFocusable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            int i;
            int y = 30;
            int start = this.getStartTime();
            int finish = this.getFinishTime();
            Rectangle bounds = ViewerPanel.this.tcscroll.getViewport().getViewRect();
            int vstart = this.calculateTime(bounds.x);
            if (vstart < 0) {
                vstart = start;
            }
            vstart -= 5;
            int vfinish = this.calculateTime(bounds.x + bounds.width);
            if (vfinish < 0) {
                vfinish = finish;
            }
            vfinish += 5;
            Color c = g.getColor();
            g.setColor(Color.white);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g.setColor(c);
            if (this.getFinishTime() < 0) {
                ViewerPanel.this.drawString(g, "No Data Found", this.getWidth() / 2, this.getHeight() / 2, 1);
                return;
            }
            g.drawLine(this.HINSET, y - 10, (finish - start) * ViewerPanel.this.TICKWIDTH + this.HINSET, y - 10);
            for (i = finish - start; i >= 0; i -= ViewerPanel.this.TICKINC) {
                if (i + start < vstart - ViewerPanel.this.TICKWIDTH || i + start > vfinish + ViewerPanel.this.TICKWIDTH) continue;
                g.drawLine(this.HINSET + i * ViewerPanel.this.TICKWIDTH, y - 5, this.HINSET + i * ViewerPanel.this.TICKWIDTH, y - 15 + 2);
                ViewerPanel.this.drawString(g, String.valueOf(i + start), this.HINSET + i * ViewerPanel.this.TICKWIDTH, y - 15, 1);
            }
            c = g.getColor();
            g.setColor(Color.lightGray);
            for (i = (int)(Math.floor(finish / 100) * 100.0) - start; i >= 0; i -= 100) {
                g.drawLine(this.HINSET + i * ViewerPanel.this.TICKWIDTH, y, this.HINSET + i * ViewerPanel.this.TICKWIDTH, y + this.getHeight());
            }
            g.setColor(c);
            Enumeration e = this.viewer.getFilters();
            y += 15;
            while (e.hasMoreElements()) {
                LogViewerFilter f = (LogViewerFilter)e.nextElement();
                if (!f.isActive()) {
                    y -= 15;
                } else {
                    LogViewerFilter logViewerFilter = f;
                    synchronized (logViewerFilter) {
                        Iterator ie = f.getEntryAgents();
                        while (ie.hasNext()) {
                            String agent = (String)ie.next();
                            TreeMap t = f.getEntries(agent);
                            Iterator i2 = t.keySet().iterator();
                            while (i2.hasNext()) {
                                Integer time = (Integer)i2.next();
                                if (time < vstart || time > vfinish) continue;
                                LogViewerEntrySlot v = (LogViewerEntrySlot)t.get(time);
                                Color back = null;
                                if (v == ViewerPanel.this.highlighted) {
                                    back = ViewerPanel.this.hilightcolor;
                                } else if (v == ViewerPanel.this.althighlighted) {
                                    back = ViewerPanel.this.althilightcolor;
                                } else if (v.getColor() != null) {
                                    back = v.getColor();
                                } else if (ViewerPanel.this.searched.contains(v)) {
                                    back = ViewerPanel.this.searchcolor;
                                }
                                if (back != null) {
                                    c = g.getColor();
                                    g.setColor(Color.lightGray);
                                    g.drawRect(this.HINSET - 3 + (time - start) * ViewerPanel.this.TICKWIDTH - ViewerPanel.this.TICKWIDTH / 2, y - 15 - 1, ViewerPanel.this.TICKWIDTH + 5, 16);
                                    g.setColor(back);
                                    g.fillRect(this.HINSET - 2 + (time - start) * ViewerPanel.this.TICKWIDTH - ViewerPanel.this.TICKWIDTH / 2, y - 15, ViewerPanel.this.TICKWIDTH + 4, 15);
                                    g.setColor(c);
                                }
                                f.drawToken(g, this.HINSET + (time - start) * ViewerPanel.this.TICKWIDTH, y, f.getEntry(time, agent));
                            }
                            if (!ie.hasNext()) continue;
                            y += 15;
                        }
                    }
                    if (e.hasMoreElements()) {
                        c = g.getColor();
                        g.setColor(Color.lightGray);
                        g.drawLine(0, y, this.getWidth(), y);
                        g.setColor(c);
                    }
                }
                y += 15;
            }
        }

        public int calculateTime(int x) {
            int time = (x - this.HINSET + ViewerPanel.this.TICKWIDTH / 2) / ViewerPanel.this.TICKWIDTH + this.getStartTime();
            if (time < this.getStartTime() || time > this.getFinishTime()) {
                return -1;
            }
            return time;
        }

        public LogViewerFilter calculateFilter(int y) {
            int h = 30;
            Enumeration e = this.viewer.getFilters();
            while (y > h && e.hasMoreElements()) {
                LogViewerFilter f = (LogViewerFilter)e.nextElement();
                if (!f.isActive() || y >= (h += 15 * Math.max(f.getNumAgents(), 1))) continue;
                return f;
            }
            return null;
        }

        public String calculateAgent(int y) {
            int h = 30;
            Enumeration e = this.viewer.getFilters();
            while (y > h && e.hasMoreElements()) {
                LogViewerFilter f = (LogViewerFilter)e.nextElement();
                if (!f.isActive()) continue;
                if (y < h + 15 * Math.max(f.getNumAgents(), 1)) {
                    if (f.getNumAgents() <= 0) {
                        return null;
                    }
                    h += 15;
                    Iterator ie = f.getEntryAgents();
                    while (ie.hasNext()) {
                        String s = (String)ie.next();
                        if (y < h) {
                            return s;
                        }
                        h += 15;
                    }
                    continue;
                }
                h += 15 * Math.max(f.getNumAgents(), 1);
            }
            return null;
        }

        public int getStartTime() {
            int time = this.viewer.getStartTime();
            return time - time % ViewerPanel.this.TICKINC;
        }

        public int getFinishTime() {
            int time = this.viewer.getFinishTime();
            return time + ViewerPanel.this.TICKINC - time % ViewerPanel.this.TICKINC;
        }

        public Dimension getPreferredSize() {
            int w = Math.max((this.getFinishTime() - this.getStartTime()) * ViewerPanel.this.TICKWIDTH + this.HINSET * 2, 100);
            return new Dimension(w, ViewerPanel.this.calculateDataHeight());
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    class LegendCanvas
    extends JPanel {
        LogViewer viewer;
        Graphics lastg = null;

        public LegendCanvas(LogViewer v) {
            this.viewer = v;
        }

        public boolean isOpaque() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            int y = 15 + ViewerPanel.this.tcscroll.getInsets().top;
            this.lastg = g;
            Color c = g.getColor();
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(c);
            ViewerPanel.this.drawString(g, "Time", this.getWidth(), y, 2);
            y += 15;
            Enumeration e = this.viewer.getFilters();
            y += 15;
            while (e.hasMoreElements()) {
                LogViewerFilter f = (LogViewerFilter)e.nextElement();
                if (!f.isActive()) {
                    y -= 15;
                } else {
                    ViewerPanel.this.drawString(g, f.getLabel(), 0, y, 0);
                    c = g.getColor();
                    LogViewerFilter logViewerFilter = f;
                    synchronized (logViewerFilter) {
                        Iterator ie = f.getEntryAgents();
                        while (ie.hasNext()) {
                            String agent = (String)ie.next();
                            g.setColor(LogViewer.getColor(agent));
                            ViewerPanel.this.drawString(g, agent, this.getWidth() - 1, y, 2);
                            if (!ie.hasNext()) continue;
                            y += 15;
                        }
                    }
                    g.setColor(c);
                    if (e.hasMoreElements()) {
                        c = g.getColor();
                        g.setColor(Color.lightGray);
                        g.drawLine(0, y, this.getWidth(), y);
                        g.setColor(c);
                    }
                }
                y += 15;
            }
        }

        public Dimension getPreferredSize() {
            int w = 125;
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            Enumeration e = this.viewer.getFilters();
            while (e.hasMoreElements()) {
                LogViewerFilter f = (LogViewerFilter)e.nextElement();
                Iterator ie = f.getEntryAgents();
                while (ie.hasNext()) {
                    String agent = (String)ie.next();
                    w = Math.max(w, 20 + metrics.stringWidth(f.getLabel()) + metrics.stringWidth(agent));
                }
            }
            return new Dimension(w, ViewerPanel.this.calculateDataHeight());
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    class TokenCanvas
    extends JPanel {
        LogViewer viewer;

        public TokenCanvas(LogViewer v) {
            this.viewer = v;
        }

        public boolean isOpaque() {
            return true;
        }

        public void paintComponent(Graphics g) {
            int y = 0;
            int x = 100;
            Color c = g.getColor();
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(c);
            Enumeration e = this.viewer.getFilters();
            y += 15;
            while (e.hasMoreElements()) {
                LogViewerFilter f = (LogViewerFilter)e.nextElement();
                ViewerPanel.this.drawString(g, f.getLabel(), 0, y, 0);
                c = g.getColor();
                int type = 0;
                while (f.getTokenType(type) != null) {
                    f.drawTokenType(g, x, y, type);
                    ViewerPanel.this.drawString(g, f.getTokenType(type), x + 10, y, 0);
                    if (f.getTokenType(type + 1) != null) {
                        y += 15;
                    }
                    ++type;
                }
                g.setColor(c);
                if (e.hasMoreElements()) {
                    c = g.getColor();
                    g.setColor(Color.lightGray);
                    g.drawLine(0, y, this.getWidth(), y);
                    g.setColor(c);
                }
                y += 15;
            }
        }

        public Dimension getPreferredSize() {
            int w = 150;
            int h = 0;
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            Enumeration e = this.viewer.getFilters();
            while (e.hasMoreElements()) {
                LogViewerFilter f = (LogViewerFilter)e.nextElement();
                if (f.getTokenType(0) == null) {
                    h += 15;
                }
                int type = 0;
                while (f.getTokenType(type) != null) {
                    h += 15;
                    w = Math.max(w, 120 + metrics.stringWidth(f.getTokenType(type)));
                    ++type;
                }
            }
            return new Dimension(w, h);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

