/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.simplest.Control;
import agent.simplest.LogViewer;
import agent.simplest.LogViewerFilter;
import agent.simplest.State;
import agent.simplest.ViewerPanel;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

class ViewerFrame
extends JFrame {
    LogViewer viewer;
    JMenu logfiles;
    JMenu filters;
    JMenu help;
    ViewerPanel panel;

    public ViewerFrame(LogViewer v) {
        super("Log Viewer");
        this.viewer = v;
        JMenuBar mbar = new JMenuBar();
        this.logfiles = new JMenu("Logfiles");
        mbar.add(this.logfiles);
        this.filters = new JMenu("Filters");
        mbar.add(this.filters);
        this.help = new JMenu("Help");
        mbar.add(this.help);
        this.setJMenuBar(mbar);
        this.panel = new ViewerPanel(this.viewer);
        this.getContentPane().add(this.panel);
        this.updateMenus();
        if (this.viewer.standalone) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    Control control = (Control)State.findComponent("Control");
                    if (control != null) {
                        control.quit();
                    }
                }

                public void windowClosed(WindowEvent e) {
                    Control control = (Control)State.findComponent("Control");
                    if (control != null) {
                        control.quit();
                    }
                }
            });
        }
    }

    public void updateMenus() {
        Object lf;
        Enumeration en;
        this.logfiles.removeAll();
        JMenuItem item = new JMenuItem("Add Logfiles...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String dir = System.getProperty("user.dir");
                if (dir == null) {
                    dir = ".";
                }
                JFileChooser choose = new JFileChooser(dir);
                choose.setMultiSelectionEnabled(true);
                choose.setDialogTitle("Select one or more JAF logfiles...");
                int ret = choose.showOpenDialog(ViewerFrame.this.panel);
                if (ret == 0) {
                    File[] files = choose.getSelectedFiles();
                    for (int i = 0; i < files.length; ++i) {
                        ViewerFrame.this.viewer.addLogfile(files[i].getAbsolutePath());
                    }
                }
            }
        });
        this.logfiles.add(item);
        if (this.viewer.getLogfiles().hasMoreElements()) {
            item = new JMenuItem("Refresh All");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewerFrame.this.viewer.clearAllLogfileData();
                    ViewerFrame.this.viewer.parseAllLogfiles(null);
                }
            });
            this.logfiles.add(item);
            this.logfiles.addSeparator();
            item = new JCheckBoxMenuItem("Continuous Read");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JCheckBoxMenuItem i = (JCheckBoxMenuItem)e.getSource();
                    if (i.getState()) {
                        ViewerFrame.this.viewer.startReader();
                    } else {
                        ViewerFrame.this.viewer.stopReader();
                    }
                }
            });
            if (this.viewer.readerIsActive()) {
                ((JCheckBoxMenuItem)item).setState(true);
            }
            this.logfiles.add(item);
            item = new JCheckBoxMenuItem("Scroll On Update");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JCheckBoxMenuItem i = (JCheckBoxMenuItem)e.getSource();
                    ViewerFrame.this.panel.resizescroll = i.getState();
                }
            });
            if (this.panel != null && this.panel.resizescroll) {
                ((JCheckBoxMenuItem)item).setState(true);
            }
            this.logfiles.add(item);
            this.logfiles.addSeparator();
            en = this.viewer.getLogfiles();
            while (en.hasMoreElements()) {
                lf = (String)en.nextElement();
                item = new JMenuItem((String)lf);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ViewerFrame.this.viewer.clearLogfileData(((JMenuItem)e.getSource()).getText());
                        ViewerFrame.this.viewer.parseLogfile(((JMenuItem)e.getSource()).getText(), null, true);
                    }
                });
                this.logfiles.add(item);
            }
            this.logfiles.addSeparator();
            JMenu menu = new JMenu("Remove");
            Enumeration en2 = this.viewer.getLogfiles();
            while (en2.hasMoreElements()) {
                String lf2 = (String)en2.nextElement();
                item = new JMenuItem(lf2);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ViewerFrame.this.viewer.removeLogfile(((JMenuItem)e.getSource()).getText());
                    }
                });
                menu.add(item);
            }
            this.logfiles.add(menu);
        }
        if (this.viewer.standalone) {
            this.logfiles.addSeparator();
            item = new JMenuItem("Quit");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewerFrame.this.dispose();
                }
            });
            this.logfiles.add(item);
        }
        this.filters.removeAll();
        item = new JMenuItem("Enable All");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Enumeration en = ViewerFrame.this.viewer.getFilters();
                while (en.hasMoreElements()) {
                    ViewerFrame.this.viewer.activateFilter((LogViewerFilter)en.nextElement());
                }
                ViewerFrame.this.updateMenus();
            }
        });
        this.filters.add(item);
        item = new JMenuItem("Disable All");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Enumeration en = ViewerFrame.this.viewer.getFilters();
                while (en.hasMoreElements()) {
                    ViewerFrame.this.viewer.deactivateFilter((LogViewerFilter)en.nextElement());
                }
                ViewerFrame.this.updateMenus();
            }
        });
        this.filters.add(item);
        this.filters.addSeparator();
        item = new JMenuItem("Show Legend");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDialog tokens = new JDialog((Frame)ViewerFrame.this, "Token Legend");
                tokens.getContentPane().setLayout(new BorderLayout());
                JScrollPane scroller = new JScrollPane();
                scroller.getViewport().add(ViewerFrame.this.panel.makeTokenLegend());
                tokens.getContentPane().add(scroller);
                tokens.pack();
                tokens.setLocation(ViewerFrame.this.getLocation().x + 20, ViewerFrame.this.getLocation().y + 20);
                tokens.setVisible(true);
            }
        });
        this.filters.add(item);
        this.filters.addSeparator();
        en = this.viewer.getFilters();
        while (en.hasMoreElements()) {
            lf = (LogViewerFilter)en.nextElement();
            item = new JCheckBoxMenuItem(((LogViewerFilter)lf).getLabel());
            if (((LogViewerFilter)lf).isActive()) {
                ((JCheckBoxMenuItem)item).setState(true);
            }
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JCheckBoxMenuItem i = (JCheckBoxMenuItem)e.getSource();
                    LogViewerFilter f = ViewerFrame.this.viewer.findFilter(i.getText());
                    if (f != null) {
                        if (i.getState()) {
                            ViewerFrame.this.viewer.activateFilter(f);
                        } else {
                            ViewerFrame.this.viewer.deactivateFilter(f);
                        }
                    }
                }
            });
            this.filters.add(item);
        }
        item = new JMenuItem("About Log Viewer...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "Log Viewer\na Java Agent Framework component\n\nby Bryan Horling\nbhorling@cs.umass.edu\n\nMulti-Agent Systems Lab\nUniversity of Massachusetts\nhttp://mas.cs.umass.edu/", "About the Log Viewer", 1);
            }
        });
        this.help.add(item);
        this.help.addSeparator();
        item = new JMenuItem("Help");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, ViewerFrame.this.panel.helpText, "Log Viewer Help", 1);
            }
        });
        this.help.add(item);
        this.updateDisplay();
    }

    public void updateDisplay() {
        if (this.panel != null) {
            this.panel.tc.invalidate();
            this.panel.lc.invalidate();
            this.panel.revalidate();
            this.panel.repaint();
        }
    }
}

