/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.base.ListenerVector;
import agent.simplest.Control;
import agent.simplest.Log;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.StatePointer;
import java.applet.Applet;
import java.awt.Container;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.applet.AppletSecurityException;
import utilities.Converter;
import utilities.IteratorEnumeration;
import utilities.SortEnumeration;

public class State
extends AgentComponent
implements MouseListener,
ActionListener {
    static final long serialVersionUID = 1234567890L;
    private static boolean collected = false;
    private boolean pauseevents = false;
    private Vector events = new Vector();
    protected int FAC_STATE;
    protected static transient TreeMap components = new TreeMap();
    protected static transient Vector parameters = new Vector(50);
    protected static transient Random random;
    protected ZipFile extFile = null;
    protected static Log log;
    protected ListenerVector listeners = new ListenerVector();
    protected static Hashtable defaults;
    protected Hashtable properties = new Hashtable(100);
    protected boolean pulsetime = false;
    protected int menulen = Integer.MAX_VALUE;
    protected int nextmenustart = 0;
    private static PopupMenu menu;
    public static final String NAME = "Name";
    public static final String TIME = "Time";
    public static final String RANDOMSEED = "RandomSeed";
    public static final String PULSETIME = "PulseTime";
    public static final String EXTCONFIG = "ExtConfig";
    public static final String MASSHOME = "MassHome";
    public static final String STATEMENULENGTH = "StateMenuLength";

    public State() {
        State.addParameterInfo(NAME, "String", "The name of the agent (required)", new String("You need to set a name"));
        State.addParameterInfo(TIME, "Integer", "The agent's local time", new Integer(-1));
        State.addParameterInfo(RANDOMSEED, "Long", "The random number generator seed.  This is used to seed the agent's random number generator to allow more deterministic performance.  See getRandom().");
        State.addParameterInfo(PULSETIME, "Boolean", "If set, the agent will automatically set the time to be the current pulse count.", Boolean.FALSE);
        State.addParameterInfo(EXTCONFIG, "String", "Pathname to the extended configuration file (relative to MassHome, if it exists)");
        State.addParameterInfo(MASSHOME, "String", "Pathname for the Mass home directory");
        State.addParameterInfo(STATEMENULENGTH, "Integer", "Maximum allowed length of State's contextual menu.  Repeated clicks on the component will see the next set of entries.", new Integer(50));
        this.properties.put(TIME, new Integer(-1));
        this.addDependency("Log");
        this.addMouseListener(this);
        this.add(menu);
    }

    public void init() {
        log = (Log)State.findComponent("Log");
        this.FAC_STATE = log.getFacilityID(this);
        if (this.hasProperty(TIME) && (Integer)this.getProperty(TIME) < 0) {
            this.setProperty(TIME, new Integer(0));
        }
        this.getOtherParams();
        this.printParameterInfo();
        log.log("State component initialized", 3, this.FAC_STATE);
        if (this.hasProperty(PULSETIME)) {
            this.pulsetime = (Boolean)this.getProperty(PULSETIME);
        }
    }

    public void reset() {
        this.properties.clear();
        this.setProperty(TIME, new Integer(0));
        collected = false;
        this.getOtherParams();
    }

    public void pulse() {
        if (this.pulsetime) {
            this.setProperty(TIME, new Integer((Integer)this.getProperty(TIME) + 1), PULSETIME);
        }
    }

    public void getOtherParams() {
        int i;
        String[][] params = State.getParameterInfo();
        String[] paramlist = new String[params.length];
        Container p = this;
        if (!Control.hasStarted()) {
            return;
        }
        if (collected) {
            return;
        }
        collected = true;
        this.pauseevents = true;
        if (log == null) {
            log = (Log)State.findComponent("Log");
            this.FAC_STATE = log.getFacilityID(this);
        }
        for (i = 0; i < params.length; ++i) {
            paramlist[i] = params[i][0];
        }
        log.log("Checking applet params", 2, this.FAC_STATE);
        do {
            if (!(p instanceof Applet)) continue;
            Applet a = (Applet)p;
            try {
                a.getParameter("_dum_");
            }
            catch (NullPointerException e) {
                break;
            }
            for (i = 0; i < paramlist.length; ++i) {
                if (a.getParameter(paramlist[i]) == null) continue;
                if (!this.properties.containsKey(paramlist[i])) {
                    this.setProperty(paramlist[i], a.getParameter(paramlist[i]), "Parameters");
                    continue;
                }
                log.log("Ignoring duplicate property " + paramlist[i], 2, this.FAC_STATE);
            }
            break;
        } while (p != this.getParent() && (p = this.getParent()) != null);
        log.log("Checking system properties", 2, this.FAC_STATE);
        try {
            for (int i2 = 0; i2 < paramlist.length; ++i2) {
                if (System.getProperty(paramlist[i2]) == null) continue;
                if (!this.properties.containsKey(paramlist[i2])) {
                    this.setProperty(paramlist[i2], System.getProperty(paramlist[i2]), "System");
                    continue;
                }
                log.log("Ignoring duplicate property " + paramlist[i2], 2, this.FAC_STATE);
            }
        }
        catch (AppletSecurityException e) {
            log.log("Error: Applet security error, can't check system properties", 0, this.FAC_STATE);
        }
        log.log("Checking default params", 2, this.FAC_STATE);
        Enumeration e = defaults.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (this.properties.containsKey(key)) continue;
            this.setProperty(key, defaults.get(key), "Default");
        }
        defaults.clear();
        this.flushEvents();
    }

    public void printParameterInfo() {
        StringBuffer str = new StringBuffer("");
        TreeSet set = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                int i = ((String[])o1)[3].compareTo(((String[])o2)[3]);
                if (i != 0) {
                    return i;
                }
                return ((String[])o1)[0].compareTo(((String[])o2)[0]);
            }
        });
        set.addAll(parameters);
        Iterator it = set.iterator();
        int S_WIDTH = 77;
        int F_ONE = 20;
        int F_TWO = 10;
        boolean ansi = false;
        if (this.hasProperty("UseANSI")) {
            ansi = (Boolean)this.getProperty("UseANSI");
        }
        String lcls = "";
        if (it.hasNext()) {
            int i = 0;
            while (it.hasNext()) {
                int j;
                String[] p = (String[])it.next();
                if (p[3] != null && !p[3].equals(lcls)) {
                    lcls = p[3];
                    if (ansi) {
                        str.append("\n ::: \u001b[36m" + lcls + "\u001b[m" + " :::\n");
                    } else {
                        str.append("\n ::: " + lcls + " :::\n");
                    }
                }
                if (ansi) {
                    str.append("  \u001b[32m" + p[0] + "\u001b[m" + " ");
                } else {
                    str.append("  " + p[0] + " ");
                }
                for (j = 0; j < F_ONE - p[0].length(); ++j) {
                    str.append(" ");
                }
                str.append(p[1] + " ");
                for (j = 0; j < F_TWO - p[1].length(); ++j) {
                    str.append(" ");
                }
                String desc = p[2];
                StringBuffer prep = new StringBuffer("");
                while (desc.length() > 0) {
                    if (desc.length() > S_WIDTH - (F_ONE + F_TWO)) {
                        int index = desc.substring(0, S_WIDTH - (F_ONE + F_TWO)).lastIndexOf(" ");
                        if (index <= 0) {
                            index = S_WIDTH - (F_ONE + F_TWO);
                        }
                        str.append(prep.toString() + desc.substring(0, index) + "\n");
                        if (desc.charAt(index) == ' ') {
                            ++index;
                        }
                        desc = desc.substring(index);
                        prep = new StringBuffer("");
                        for (int j2 = 0; j2 < F_ONE + F_TWO + 4; ++j2) {
                            prep.append(" ");
                        }
                        continue;
                    }
                    str.append(prep.toString() + desc);
                    break;
                }
                str.append("\n");
                if (this.properties.containsKey(p[0])) {
                    if (ansi) {
                        str.append("     == \u001b[35m" + this.getProperty(p[0]).toString() + "\u001b[m" + "\n");
                    } else {
                        str.append("     == " + this.getProperty(p[0]).toString() + "\n");
                    }
                }
                ++i;
            }
        }
        if (log != null) {
            int l = log.getLogLength();
            if (l != 0) {
                log.setLogLength(0);
            }
            log.log("Known properties:\n" + str, 2, this.FAC_STATE);
            if (l != 0) {
                log.setLogLength(l);
            }
        } else {
            utilities.Log.getDefault().log("Known parameters:\n" + str, 2);
        }
    }

    public void printParameterInfo(String param) {
        int j;
        String[] p = State.getParameterInfo(param);
        int F_ONE = 12;
        int F_TWO = 8;
        if (p == null) {
            return;
        }
        StringBuffer str = new StringBuffer();
        str.append("  " + p[0] + " ");
        for (j = 0; j < F_ONE - p[0].length(); ++j) {
            str.append(" ");
        }
        str.append(p[1] + " ");
        for (j = 0; j < F_TWO - p[1].length(); ++j) {
            str.append(" ");
        }
        str.append(p[2]);
        if (log != null) {
            log.log(str.toString(), 2, this.FAC_STATE);
        } else {
            utilities.Log.getDefault().log(str.toString(), 2);
        }
    }

    public static void addParameterInfo(String name, String type, String desc, Object def) {
        State.addParameterInfo(name, type, desc, def, null);
    }

    public static void addParameterInfo(String name, String type, String desc) {
        State.addParameterInfo(name, type, desc, null, null);
    }

    private static void addParameterInfo(String name, String type, String desc, Object def, String cls) {
        if (cls == null) {
            cls = "";
            try {
                cls = SecHack.getCallersClass(3).toString();
                cls = cls.substring(cls.indexOf(" ") + 1);
            }
            catch (Exception e) {
                utilities.Log.getDefault().log("Error determining calling class: " + e, 1);
            }
        }
        if (!State.usesParameter(name)) {
            parameters.addElement(new String[]{name, type, desc, cls});
        } else {
            String[] param = State.getParameterInfo(name);
            if (type != null) {
                param[1] = type;
            }
            if (desc != null) {
                param[2] = desc;
            }
            if (cls != null) {
                param[3] = cls;
            }
        }
        if (def != null) {
            defaults.put(name, def);
        } else {
            defaults.remove(name);
        }
        if (collected) {
            if (log != null) {
                log.log("Dagnabit, someone added parameter information for " + name + " post-collection...recollecting", 2);
            }
            collected = false;
        }
    }

    public static String[][] getParameterInfo() {
        String[][] plist = new String[parameters.size()][4];
        Enumeration e = parameters.elements();
        if (e.hasMoreElements()) {
            int i = 0;
            while (e.hasMoreElements()) {
                String[] p = (String[])e.nextElement();
                plist[i][0] = p[0];
                plist[i][1] = p[1];
                plist[i][2] = p[2];
                ++i;
            }
        }
        return plist;
    }

    public static String[] getParameterInfo(String key) {
        Enumeration e = parameters.elements();
        while (e.hasMoreElements()) {
            String[] info = (String[])e.nextElement();
            if (!info[0].equalsIgnoreCase(key)) continue;
            return info;
        }
        return null;
    }

    public static boolean usesParameter(String key) {
        Enumeration e = parameters.elements();
        while (e.hasMoreElements()) {
            String[] info = (String[])e.nextElement();
            if (!info[0].equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public BufferedReader getExtendedEntryReader(String n) {
        InputStream is = this.getExtendedEntryStream(n);
        if (is != null) {
            return new BufferedReader(new InputStreamReader(is));
        }
        log.log("Error creating reader for " + n, 0, this.FAC_STATE);
        return null;
    }

    public InputStream getExtendedEntryStream(String n) {
        log.log("Getting extended entry " + n, 3, this.FAC_STATE);
        try {
            ZipFile ext = this.getExtendedEntryFile();
            if (ext != null) {
                ZipEntry ent = ext.getEntry(n);
                if (ent != null) {
                    return ext.getInputStream(ent);
                }
                log.log("Error finding entry " + n, 0, this.FAC_STATE);
            } else {
                log.log("Error finding entry file " + n, 0, this.FAC_STATE);
            }
        }
        catch (IOException e) {
            log.log("Error reading extended entry : " + e, 0, this.FAC_STATE);
        }
        try {
            FileInputStream is = new FileInputStream(n);
            log.log("Entry \"" + n + "\" was not found in the extended configuration file, but it was found in the local filesystem.  I'll let you use it, but please add it to your ExtConfig file.", 1, this.FAC_STATE);
            return is;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public ZipFile getExtendedEntryFile() {
        return this.getExtendedEntryFile(true);
    }

    public ZipFile getExtendedEntryFile(boolean cached) {
        if (!this.hasProperty(EXTCONFIG)) {
            log.log("Error: No ExtConfig file specified", 0, this.FAC_STATE);
            return null;
        }
        String extname = this.hasProperty(MASSHOME) ? (String)this.getProperty(MASSHOME) + "/" + (String)this.getProperty(EXTCONFIG) : (String)this.getProperty(EXTCONFIG);
        try {
            if (!cached) {
                log.log("Getting new reference to extended entry file " + extname, 4, this.FAC_STATE);
                return new ZipFile(extname);
            }
            if (this.extFile == null) {
                log.log("Getting new reference to extended entry file " + extname, 4, this.FAC_STATE);
                this.extFile = new ZipFile(extname);
            } else {
                log.log("Getting cached reference to extended entry file " + extname, 4, this.FAC_STATE);
            }
            if (this.extFile == null) {
                log.log("Whoops, extended entry file ref is null", 1, this.FAC_STATE);
            }
            return this.extFile;
        }
        catch (IOException e) {
            log.log("Error reading extended entry : " + e, 0, this.FAC_STATE);
            return null;
        }
    }

    public void addPropertyEventListener(PropertyEventListener l) {
        this.listeners.add(l);
        if (Control.hasStarted()) {
            Enumeration e = this.properties();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                l.propertyAdded(new PropertyEvent(this, o, this.getProperty(o), 0));
            }
        }
    }

    public void removePropertyEventListener(PropertyEventListener l) {
        this.listeners.remove(l);
    }

    protected void fireEvent(AgentEvent event) {
        PropertyEvent e = (PropertyEvent)event;
        Enumeration enumr = this.listeners.elements();
        if (this.pauseevents) {
            this.events.addElement(e);
            return;
        }
        if (log != null) {
            log.log("Firing a property change event", 4, this.FAC_STATE);
        } else {
            utilities.Log.getDefault().log("Firing a property change event", 4);
        }
        block5: while (enumr.hasMoreElements()) {
            PropertyEventListener l = (PropertyEventListener)enumr.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0: {
                    l.propertyAdded(e);
                    continue block5;
                }
                case 1: {
                    l.propertyRemoved(e);
                    continue block5;
                }
                case 2: {
                    l.propertyChanged(e);
                    continue block5;
                }
            }
        }
        if (log != null && log.getLogLevel(this.FAC_STATE) >= 3) {
            log.log(e, 3, this.FAC_STATE);
        }
        if (log != null) {
            log.log("Fired a property change event", 5, this.FAC_STATE);
        } else {
            utilities.Log.getDefault().log("Fired a property change event", 5);
        }
    }

    private void flushEvents() {
        this.pauseevents = false;
        Enumeration e = this.events.elements();
        while (e.hasMoreElements()) {
            this.startFireEvent((PropertyEvent)e.nextElement());
        }
        this.events.removeAllElements();
    }

    public static synchronized void addComponent(AgentComponent a) {
        String[] descriptor = null;
        if (a.getDescriptor() != null) {
            descriptor = a.getDescriptor().value();
        }
        if (descriptor != null) {
            for (int i = 0; i < descriptor.length; ++i) {
                if (components.containsKey(descriptor[i])) {
                    utilities.Log.getDefault().log("Warning: Component " + descriptor[i] + " has been overwritten", 1);
                }
                components.put(descriptor[i], a);
                utilities.Log.getDefault().log("Registered component " + descriptor[i], 2);
            }
        } else {
            utilities.Log.getDefault().log("Warning: Component found with null descriptor", 1);
        }
    }

    public static synchronized void removeComponent(AgentComponent a) {
        String[] descriptor = null;
        if (a.getDescriptor() != null) {
            descriptor = a.getDescriptor().value();
        }
        if (descriptor != null) {
            for (int i = 0; i < descriptor.length; ++i) {
                if (!components.containsKey(descriptor[i])) continue;
                utilities.Log.getDefault().log("Removed component " + descriptor[i], 2);
                components.remove(descriptor[i]);
            }
        }
    }

    public static AgentComponent getComponent(String descriptor) {
        return (AgentComponent)components.get(descriptor);
    }

    public static Enumeration components() {
        return new IteratorEnumeration(components.values().iterator());
    }

    public static AgentComponent findComponent(String descriptor) {
        String key;
        descriptor = descriptor.toLowerCase();
        Iterator it = components.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            if (!key.equalsIgnoreCase(descriptor)) continue;
            return State.getComponent(key);
        }
        it = components.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            if (!key.toLowerCase().endsWith("." + descriptor)) continue;
            return State.getComponent(key);
        }
        it = components.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            if (!key.toLowerCase().endsWith(descriptor)) continue;
            return State.getComponent(key);
        }
        it = components.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            if (key.toLowerCase().indexOf(descriptor) <= -1) continue;
            return State.getComponent(key);
        }
        return null;
    }

    public static boolean hasComponent(String descriptor) {
        return State.findComponent(descriptor) != null;
    }

    public Enumeration properties() {
        if (this.properties == null || !collected) {
            if (log == null) {
                utilities.Log.getDefault().log("Grumble...someone's trying to get the property list before I have it", 2);
            } else {
                log.log("Grumble...someone's trying to get the property list before I have it", 2, this.FAC_STATE);
            }
            this.getProperty("");
        }
        return this.properties.keys();
    }

    public boolean hasProperty(Object key) {
        if (!this.properties.containsKey(key) && !collected) {
            if (log == null) {
                utilities.Log.getDefault().log("Grumble...someone's trying to check property " + key + " before I have it", 2);
            } else {
                log.log("Grumble...someone's trying to check property " + key + " before I have it", 2, this.FAC_STATE);
            }
            this.getProperty(key);
        }
        return this.properties.containsKey(key);
    }

    public Object getProperty(Object key) {
        if (!this.properties.containsKey(key) && !collected) {
            if (log == null) {
                utilities.Log.getDefault().log("We interrupt our normally scheduled programming for this brief message...", 3);
                utilities.Log.getDefault().log("   (some impatient component is looking for " + key + ")", 3);
            } else {
                log.log("We interrupt our normally scheduled programming for this brief message...", 3, this.FAC_STATE);
                log.log("(some impatient component is looking for " + key + ")", 3, this.FAC_STATE);
            }
            this.getOtherParams();
            if (log == null) {
                utilities.Log.getDefault().log("And now back to the show", 3);
            } else {
                log.log("And now back to the show", 3, this.FAC_STATE);
            }
        }
        return this.properties.get(key);
    }

    public void setProperty(Object key, Object property) {
        this.setProperty(key, property, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(Object key, Object property, Object hint) {
        Object oldproperty;
        int id;
        State state = this;
        synchronized (state) {
            StatePointer ptr = new StatePointer(key, property);
            this.propertyPreprocess(ptr);
            key = ptr.key;
            property = ptr.ptr;
            if (this.properties.containsKey(key)) {
                id = 2;
                oldproperty = this.getProperty(key);
            } else {
                id = 0;
                oldproperty = property;
            }
            this.properties.put(key, property);
            this.propertyPostprocess(ptr);
        }
        this.startFireEvent(new PropertyEvent(this, key, oldproperty, property, id, hint));
    }

    public boolean removeProperty(Object key) {
        return this.removeProperty(key, null);
    }

    public boolean removeProperty(Object key, Object hint) {
        if (!this.properties.containsKey(key)) {
            return false;
        }
        Object property = this.properties.get(key);
        this.properties.remove(key);
        this.startFireEvent(new PropertyEvent((Object)this, key, property, 1, hint));
        return true;
    }

    public void propertyPreprocess(StatePointer property) {
        String[] info;
        Object key = property.key;
        String delim = ",";
        if (key instanceof String && property.ptr instanceof String && (info = State.getParameterInfo((String)key)) != null) {
            String type = info[1];
            property.ptr = Converter.reTypeProperty((String)((String)property.ptr), (String)type);
        }
        if (key.equals(NAME) && property.ptr instanceof String) {
            Container c = this;
            while (c.getParent() != null) {
                c = c.getParent();
            }
            if (c != null && c instanceof Frame) {
                ((Frame)c).setTitle("Agent: " + property.ptr);
            }
        }
    }

    public void propertyPostprocess(StatePointer property) {
        Object key = property.key;
        String delim = ",";
        if (this.hasProperty(EXTCONFIG) && this.hasProperty(MASSHOME) && (key.equals(EXTCONFIG) || key.equals(MASSHOME))) {
            log.log("ExtConfig entries:", 2, this.FAC_STATE);
            ZipFile ext = this.getExtendedEntryFile();
            if (ext != null) {
                Enumeration<? extends ZipEntry> e = ext.entries();
                while (e.hasMoreElements()) {
                    log.log("\t" + e.nextElement(), 2, this.FAC_STATE);
                }
            }
        } else if (key.equals(STATEMENULENGTH)) {
            this.menulen = (Integer)this.getProperty(STATEMENULENGTH);
        }
    }

    public static Random getRandom() {
        if (random == null) {
            State state = (State)State.findComponent("State");
            if (state != null && state.hasProperty(RANDOMSEED)) {
                long seed = (Long)state.getProperty(RANDOMSEED);
                if (state.hasProperty(NAME)) {
                    seed += (long)state.getProperty(NAME).hashCode();
                }
                log.log("Generating random number generator with seed " + seed, 3);
                random = new Random(seed);
            } else {
                random = new Random(parameters.size());
                if (log != null) {
                    log.log("Warning, I just created a non-deterministic Random object for you.", 0);
                } else {
                    utilities.Log.getDefault().log("Warning, I just created a non-deterministic Random object for you.", 0);
                }
            }
        }
        return random;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (this.hasProperty(command)) {
            System.err.println(command.toString() + ": " + this.getProperty(command));
        } else {
            log.log("Whoops, can't find property " + command, 1, this.FAC_STATE);
        }
    }

    public boolean hasPopupMenu() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 || e.isPopupTrigger()) {
            try {
                int i = 0;
                while (true) {
                    MenuItem m = menu.getItem(i);
                    m.removeActionListener(this);
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                menu.removeAll();
                MenuItem m = new MenuItem("Print all parameters");
                m.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        State.this.printParameterInfo();
                    }
                });
                menu.add(m);
                menu.addSeparator();
                SortEnumeration en = new SortEnumeration(this.properties());
                for (int i = 0; en.hasMoreElements() && i < this.nextmenustart + this.menulen; ++i) {
                    Object o = en.nextElement();
                    if (i < this.nextmenustart) continue;
                    m = new MenuItem(o.toString());
                    m.addActionListener(this);
                    menu.add(m);
                }
                this.nextmenustart = en.hasMoreElements() ? (this.nextmenustart += this.menulen) : 0;
                menu.show(this, e.getX(), e.getY());
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    static {
        log = null;
        defaults = new Hashtable(100);
        menu = new PopupMenu("State Data");
    }

    static class SecHack
    extends SecurityManager {
        private static SecHack sec = new SecHack();

        SecHack() {
        }

        public static Class getCallersClass(int i) {
            return sec.getClassContext()[i];
        }
    }
}

