/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.base.ListenerVector;
import agent.simplest.Log;
import agent.simplest.SensorEvent;
import agent.simplest.SensorEventListener;
import agent.simplest.State;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import utilities.Converter;

public class Sensor
extends AgentComponent
implements MouseListener {
    static final long serialVersionUID = 1234567890L;
    public static final int TIMEOUT = 20;
    protected ListenerVector listeners = new ListenerVector();
    protected Log log;
    protected State state;
    protected int FAC_SENSOR;
    protected Hashtable sensors = new Hashtable(20);
    protected Hashtable replies = new Hashtable(20);
    protected Hashtable known = new Hashtable(10);
    protected Hashtable age = new Hashtable(10);
    protected PopupMenu menu = new PopupMenu("Known Sensors");
    protected boolean cache = true;
    public static final String SENSORDATA = "SensorData";
    public static final String SENSORCACHE = "SensorCache";

    public Sensor() {
        this.addDependency("Log");
        this.addDependency("State");
        State.addParameterInfo(SENSORDATA, "String", "Name of the sensor data entry");
        State.addParameterInfo(SENSORCACHE, "Boolean", "Try to cache results or always query?", Boolean.FALSE);
        this.add(this.menu);
        this.addMouseListener(this);
    }

    public void addSensorEventListener(SensorEventListener l) {
        this.listeners.add(l);
    }

    public void removeSensorEventListener(SensorEventListener l) {
        this.listeners.remove(l);
    }

    protected void fireEvent(AgentEvent event) {
        SensorEvent e = (SensorEvent)event;
        Enumeration enumr = this.listeners.elements();
        this.log.log("Firing sensor event", 4, this.FAC_SENSOR);
        block3: while (enumr.hasMoreElements()) {
            SensorEventListener l = (SensorEventListener)enumr.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0: {
                    l.sensorAdded(e);
                    continue block3;
                }
            }
        }
        if (this.log != null) {
            this.log.log(e, 2, this.FAC_SENSOR);
        }
        this.log.log("Fired a sensor event", 5, this.FAC_SENSOR);
    }

    public void init() {
        this.log = (Log)State.findComponent("Log");
        this.state = (State)State.findComponent("State");
        this.FAC_SENSOR = this.log.getFacilityID(this);
        super.init();
    }

    public void begin() {
        if (this.state.hasProperty(SENSORCACHE)) {
            this.cache = (Boolean)this.state.getProperty(SENSORCACHE);
        }
        this.readSensorFileData();
    }

    public void reset() {
        this.sensors = new Hashtable(20);
        this.replies = new Hashtable(20);
    }

    protected void readSensorFileData() {
        if (!this.state.hasProperty(SENSORDATA)) {
            return;
        }
        this.log.log("Reading sensor data", 2, this.FAC_SENSOR);
        try {
            BufferedReader file = this.state.getExtendedEntryReader((String)this.state.getProperty(SENSORDATA));
            if (file == null) {
                this.log.log("Error reading from sensor data: " + this.state.getProperty(SENSORDATA), 0, this.FAC_SENSOR);
                return;
            }
            while (file.ready()) {
                String str = file.readLine();
                if (str.indexOf(";") != -1) {
                    str = str.substring(0, str.indexOf(";"));
                }
                if ((str = str.trim()).length() <= 0) continue;
                this.addSensor(str);
            }
            file.close();
        }
        catch (IOException e) {
            this.log.log("Error: Sensor data file error: " + e, 0, this.FAC_SENSOR);
        }
        this.log.log("Finished reading sensor data", 3, this.FAC_SENSOR);
    }

    public Object readSensorData(String sensor, Hashtable data, String type) {
        return this.readSensorData(sensor, type);
    }

    public Object readSensorData(String sensor, String type) {
        Integer time = (Integer)this.state.getProperty("Time");
        if (this.cache && this.age.containsKey(sensor) && ((Integer)this.age.get(sensor)).equals(time) && this.sensors.get(sensor) != null) {
            this.log.log("Using cached data for sensor query \"" + sensor + "\"", 3, this.FAC_SENSOR);
            return this.convertSensorData((String)this.sensors.get(sensor), type);
        }
        if (this.querySensor(sensor) && this.sensors.containsKey(sensor) && this.sensors.get(sensor) != null) {
            this.age.put(sensor, time);
            return this.convertSensorData((String)this.sensors.get(sensor), type);
        }
        return null;
    }

    public Object readOldSensorData(String sensor, Hashtable data, String type) {
        return this.readOldSensorData(sensor, type);
    }

    public Object readOldSensorData(String sensor, String type) {
        if (this.sensors.containsKey(sensor) && this.sensors.get(sensor) != null) {
            return this.convertSensorData((String)this.sensors.get(sensor), type);
        }
        return null;
    }

    protected Object convertSensorData(String data, String type) {
        if (data == null) {
            return null;
        }
        String s = data.trim();
        if (s.equalsIgnoreCase("AccessDenied")) {
            return null;
        }
        if (s.startsWith("Error")) {
            this.log.log("Error: " + data, 0, this.FAC_SENSOR);
            return null;
        }
        return Converter.reTypeProperty((String)s, (String)type);
    }

    protected boolean querySensor(String sensor) {
        this.log.log("Warning, cannot make sensor query for " + sensor, 1, this.FAC_SENSOR);
        return false;
    }

    public void addSensor(String s) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        this.log.log("Adding sensor => " + s, 2, this.FAC_SENSOR);
        StringTokenizer tok = new StringTokenizer(s, ",");
        tok.nextToken();
        tok.nextToken();
        String name = tok.nextToken();
        name = name.trim();
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken().trim();
            if (str.indexOf(":") == -1) {
                hash.put(str, "");
                continue;
            }
            String n = str.substring(0, str.indexOf(":")).trim();
            String v = str.substring(str.indexOf(":") + 1).trim();
            hash.put(n, v);
        }
        String ts = this.findSensor(name);
        if (ts == null) {
            this.known.put(name, hash);
            this.menu.add(new MenuItem(name));
            this.log.log("Sensor added (" + name + ") " + hash, 3, this.FAC_SENSOR);
            this.startFireEvent(new SensorEvent(this, name, 0));
        } else {
            this.log.log("Duplicate sensor name (" + name + ") detected, not added", 1, this.FAC_SENSOR);
        }
    }

    public boolean removeSensor(String n) {
        String s = this.findSensor(n);
        if (s != null) {
            this.known.remove(s);
            for (int i = 0; i < this.menu.getItemCount(); ++i) {
                MenuItem m = this.menu.getItem(i);
                if (!m.getLabel().equals(n)) continue;
                this.menu.remove(m);
                break;
            }
        } else {
            return false;
        }
        this.log.log("Sensor removed (" + n + ")", 2, this.FAC_SENSOR);
        return true;
    }

    public String findSensor(String n) {
        Enumeration e = this.getSensors();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!s.equals(n)) continue;
            return s;
        }
        return null;
    }

    public Enumeration getSensors() {
        return this.known.keys();
    }

    public Hashtable getSensorInfo(String s) {
        return (Hashtable)this.known.get(s);
    }

    public boolean hasPopupMenu() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 || e.isPopupTrigger()) {
            this.menu.show(this, e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

