/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.simplest.Log;
import agent.simplest.LogItem;
import agent.simplest.State;
import agent.simplest.WindowManager;
import java.awt.TextArea;
import javax.swing.JFrame;

public class ScreenLog
extends Log {
    static final long serialVersionUID = 1234567890L;
    private String title = "Screen Log ";
    private static int NUM = 1;
    private transient JFrame window;
    private transient TextArea text;
    private int row = 5;
    private int col = 80;
    private boolean append = true;

    public ScreenLog() {
        this.FAC_LOG = this.getFacilityID("Log");
        this.removeAll();
    }

    protected void finalize() {
        if (this.window != null) {
            this.window.dispose();
        }
    }

    public void init() {
        super.init();
        if (State.hasComponent("WindowManager")) {
            WindowManager wm = (WindowManager)State.findComponent("WindowManager");
            this.window = wm.createWindow(this.title + NUM++);
        } else {
            this.window = new JFrame(this.title + NUM++);
        }
        this.text = new TextArea("", this.row, this.col, 0);
        this.text.setEditable(false);
        this.window.getContentPane().add(this.text);
        this.window.pack();
        if (!State.hasComponent("WindowManager")) {
            this.window.setVisible(true);
        }
    }

    public void reset() {
        this.text.setText("");
    }

    public String getWindowTitle() {
        return this.title;
    }

    public void setWindowTitle(String t) {
        this.title = t;
        if (this.window != null) {
            this.window.setTitle(t);
        }
    }

    public boolean getAppend() {
        return this.append;
    }

    public void setAppend(boolean a) {
        this.append = a;
    }

    public int getRows() {
        return this.row;
    }

    public void setRows(int r) {
        this.row = r;
        if (this.text != null) {
            this.text.setRows(this.row);
        }
    }

    public int getCols() {
        return this.col;
    }

    public void setCols(int c) {
        this.col = c;
        if (this.text != null) {
            this.text.setColumns(this.col);
        }
    }

    protected void log(LogItem i) {
        if (this.text == null) {
            i.setItem(i.getItem() + " #ScreenLog not initialized");
            super.log(i);
        } else {
            i.clip(this.getLogLength());
            if (this.loggable(i)) {
                i.setAux(this.clock + ":" + this.name);
                if (this.append) {
                    this.text.append(i.toString() + "\n");
                } else {
                    this.text.insert(i.toString() + "\n", 0);
                }
            }
        }
    }
}

