/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.base.AgentEvent;
import java.util.Hashtable;

public class Observer {
    public static final int NO_WINDOW = 0;
    protected int count;
    protected int window;
    protected int index;
    protected String description = "Data";
    protected Hashtable exdata = new Hashtable(5);
    protected double[] data;
    protected boolean display;

    public Observer(String d) {
        this(d, 0, true);
    }

    public Observer(String d, boolean display) {
        this(d, 0, display);
    }

    public Observer(String d, int w) {
        this(d, w, true);
    }

    public Observer(String d, int w, boolean dis) {
        this.display = dis;
        this.description = d;
        this.window = w;
        this.index = 0;
        this.data = this.window > 0 ? new double[this.window] : new double[1];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Double.MIN_VALUE;
        }
    }

    public void reset() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Double.MIN_VALUE;
        }
    }

    public void addEvent(AgentEvent e) {
        if (this.checkEvent(e)) {
            this.updateCount(1.0);
        }
    }

    public boolean checkEvent(AgentEvent e) {
        return false;
    }

    public double updateCount(double c) {
        if (this.usesWindow()) {
            this.data[this.index] = c;
        } else {
            if (this.data[this.index] == Double.MIN_VALUE) {
                this.data[this.index] = 0.0;
            }
            int n = this.index;
            this.data[n] = this.data[n] + c;
        }
        return this.data[this.index];
    }

    public void newTime(int time) {
        if (this.usesWindow()) {
            ++this.index;
            if (this.index >= this.window) {
                this.index = 0;
            }
            this.data[this.index] = 0.0;
        }
    }

    public boolean usesEvents() {
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    public double getCount() {
        return this.getSum();
    }

    public double getSum() {
        double count = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == Double.MIN_VALUE) continue;
            count += this.data[i];
        }
        return count;
    }

    public double getAverage() {
        return this.getSum() / (double)this.getCountTotal();
    }

    public double getAverageDifference() {
        int stop;
        double count = 0.0;
        double last = Double.MIN_VALUE;
        int n = stop = this.index != 0 ? this.index - 1 : this.data.length - 1;
        if (this.getCountTotal() <= 1) {
            return 0.0;
        }
        int i = this.index;
        while (true) {
            if (i >= this.data.length) {
                i = 0;
            }
            if (this.data[i] != Double.MIN_VALUE) {
                if (last != Double.MIN_VALUE) {
                    count += this.data[i] - last;
                }
                last = this.data[i];
            }
            if (i == stop) break;
            ++i;
        }
        return count / (double)(this.getCountTotal() - 1);
    }

    public double getCount(int w) {
        double count = 0.0;
        if (w > this.data.length) {
            count = this.getCount();
        } else {
            int i = this.index;
            int j = 0;
            while (j < w) {
                if (i < 0) {
                    i = this.data.length - 1;
                }
                if (this.data[i] != Double.MIN_VALUE) {
                    count += this.data[i];
                }
                ++j;
                --i;
            }
        }
        return count;
    }

    public Hashtable getData() {
        return this.exdata;
    }

    public boolean usesWindow() {
        return this.window != 0;
    }

    public int getWindowSize() {
        return this.window;
    }

    public int getCountTotal() {
        int count = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == Double.MIN_VALUE) continue;
            ++count;
        }
        return count;
    }

    public boolean getDisplay() {
        return this.display;
    }

    public void toggleDisplay() {
        this.display = !this.display;
    }

    public String dumpData() {
        StringBuffer buf = new StringBuffer(this.toString() + "\n");
        int stop = this.index != 0 ? this.index - 1 : this.data.length - 1;
        int i = this.index;
        while (true) {
            if (i >= this.data.length) {
                i = 0;
            }
            buf.append(String.valueOf(i) + ":");
            if (this.data[i] == Double.MIN_VALUE) {
                buf.append("-");
            } else {
                buf.append(String.valueOf(this.data[i]));
            }
            if (i == stop) break;
            buf.append(", ");
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        if (this.usesWindow()) {
            return this.getDescription() + ": " + this.getCount() + " [" + this.getWindowSize() + "]";
        }
        return this.getDescription() + ": " + this.getCount();
    }
}

