/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.simplest.HistogramComponent;
import agent.simplest.Log;
import agent.simplest.LogEvent;
import agent.simplest.LogEventListener;
import agent.simplest.Observer;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import agent.simplest.WindowManager;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;

public class Observe
extends AgentComponent
implements LogEventListener,
PropertyEventListener,
MouseListener {
    static final long serialVersionUID = 1234567890L;
    protected Vector observers = new Vector(25);
    protected Log log;
    protected int FAC_OBSERVE;
    private String title = "Observe";
    private transient JFrame window;
    private HistogramComponent hc;
    private static PopupMenu menu = new PopupMenu("Current Actions");

    public Observe() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addMouseListener(this);
        this.add(menu);
    }

    public void init() {
        this.log = (Log)State.findComponent("Log");
        this.log.addLogEventListener(this);
        this.FAC_OBSERVE = this.log.getFacilityID(this);
        State state = (State)State.findComponent("State");
        state.addPropertyEventListener(this);
        if (this.hasGUI()) {
            if (State.hasComponent("WindowManager")) {
                WindowManager wm = (WindowManager)State.findComponent("WindowManager");
                this.window = wm.createWindow(this.title);
            } else {
                this.window = new JFrame(this.title);
            }
            this.hc = new HistogramComponent(null, 800, 500);
            this.window.setSize(this.window.getInsets().left + this.window.getInsets().right + 800, this.window.getInsets().top + this.window.getInsets().bottom + 500);
            this.window.getContentPane().add(this.hc);
            this.window.pack();
            if (!State.hasComponent("WindowManager")) {
                this.window.setVisible(true);
            }
        }
        super.init();
    }

    public void reset() {
        this.log.log("Removing all registered observers", 2, this.FAC_OBSERVE);
        this.observers.removeAllElements();
    }

    public void end() {
        if (this.window != null) {
            this.window.dispose();
        }
        if (this.log == null) {
            return;
        }
        this.log.log("Observation summary:", 2, this.FAC_OBSERVE);
        Enumeration e = this.getObservers();
        while (e.hasMoreElements()) {
            Observer o = (Observer)e.nextElement();
            StringBuffer pad = new StringBuffer("");
            int len = o.getDescription().length();
            for (int j = 0; j < 25 - len; ++j) {
                pad.insert(0, " ");
            }
            this.log.log(pad + o.toString(), 2, this.FAC_OBSERVE);
        }
    }

    public void addObserver(Observer o) {
        this.observers.addElement(o);
        if (this.log == null) {
            this.log = (Log)State.findComponent("Log");
        }
        if (this.log != null) {
            this.log.log("Observer activated: " + o, 3, this.FAC_OBSERVE);
        } else {
            System.err.println("Observer activated: " + o);
        }
    }

    public void removeObserver(Observer o) {
        this.observers.removeElement(o);
        this.log.log("Observer removed: " + o, 3, this.FAC_OBSERVE);
    }

    public Observer findObserver(String d) {
        Enumeration e = this.getObservers();
        while (e.hasMoreElements()) {
            Observer o = (Observer)e.nextElement();
            if (!o.getDescription().equalsIgnoreCase(d)) continue;
            return o;
        }
        return null;
    }

    public Enumeration getObservers() {
        return this.observers.elements();
    }

    public void addEvent(AgentEvent ev) {
        Enumeration e = this.getObservers();
        while (e.hasMoreElements()) {
            Observer o = (Observer)e.nextElement();
            if (!o.usesEvents()) continue;
            o.addEvent(ev);
        }
    }

    public void pulse() {
        if (this.window != null && this.window.isShowing()) {
            Observer o;
            Enumeration e = this.getObservers();
            int count = 0;
            Vector<Observer> v = new Vector<Observer>();
            while (e.hasMoreElements()) {
                o = (Observer)e.nextElement();
                if (!o.getDisplay()) continue;
                v.insertElementAt(o, count);
                ++count;
            }
            int[] data = new int[count];
            String[] labels = new String[count];
            int max = this.observers.size();
            for (int i = 0; i < count; ++i) {
                o = (Observer)v.elementAt(i);
                data[i] = (int)o.getCount();
                labels[i] = o.getDescription();
            }
            this.hc.setHistogramData(data);
            this.hc.setHistogramLabels(labels);
            this.validate();
            this.hc.drawHisto();
        }
    }

    public void newTime(int time) {
        Enumeration e = this.getObservers();
        while (e.hasMoreElements()) {
            Observer o = (Observer)e.nextElement();
            o.newTime(time);
        }
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyChanged(PropertyEvent e) {
        int time;
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase("Time") && (time = ((Integer)e.getProperty()).intValue()) >= 0) {
            this.newTime(time);
        }
    }

    public void errorLog(LogEvent e) {
    }

    public void eventLog(LogEvent e) {
    }

    public void stringLog(LogEvent e) {
    }

    public void objectLog(LogEvent e) {
    }

    public void eventReflection(AgentEvent e) {
        this.addEvent(e);
    }

    public boolean hasPopupMenu() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 || e.isPopupTrigger()) {
            menu.removeAll();
            Enumeration en = this.getObservers();
            while (en.hasMoreElements()) {
                Observer obs = (Observer)en.nextElement();
                MenuItem item = new MenuItem(obs.toString());
                item.addActionListener(new MyObserverMenuListener(obs));
                menu.add(item);
            }
            menu.show(this, e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    class MyObserverMenuListener
    implements ActionListener {
        Observer obs;

        public MyObserverMenuListener(Observer obs) {
            this.obs = obs;
        }

        public void actionPerformed(ActionEvent event) {
            System.err.println(this.obs.dumpData());
        }
    }
}

