/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.simplest.LogViewer;
import agent.simplest.LogViewerEntrySlot;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public abstract class LogViewerFilter {
    public String label;
    protected boolean active;
    public TreeMap entries = new TreeMap();
    public Vector myhighlights = new Vector();
    protected LogViewer viewer = null;

    public LogViewerFilter(String l) {
        this(l, true);
    }

    public LogViewerFilter(String l, boolean a) {
        this.label = l;
        this.active = a;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isActive() {
        return this.active;
    }

    public LogViewer getLogViewer() {
        return this.viewer;
    }

    public void setLogViewer(LogViewer v) {
        this.viewer = v;
    }

    public void setActive(boolean a) {
        this.active = a;
    }

    public Iterator getEntryAgents() {
        return this.entries.keySet().iterator();
    }

    public synchronized int getNumAgents() {
        return this.entries.size();
    }

    public TreeMap getEntries(String agent) {
        return (TreeMap)this.entries.get(agent);
    }

    protected LogViewerFilter findLogViewerFilter(String name) {
        return this.viewer.findFilter(name);
    }

    public void clearAllEntries() {
        this.entries.clear();
    }

    public void select(LogViewerEntrySlot v, LogViewer viewer) {
    }

    public void deselect(LogViewerEntrySlot v, LogViewer viewer) {
        Enumeration e = this.myhighlights.elements();
        while (e.hasMoreElements()) {
            ((LogViewerEntrySlot)e.nextElement()).setColor(null);
        }
    }

    public synchronized boolean clearEntry(Integer time, String agent, Object data) {
        TreeMap t;
        if (time == null || agent == null || data == null) {
            return false;
        }
        if (this.entries.containsKey(agent) && (t = (TreeMap)this.entries.get(agent)).containsKey(time)) {
            LogViewerEntrySlot v = (LogViewerEntrySlot)t.get(time);
            v.removeElement(data);
            if (v.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public synchronized LogViewerEntrySlot getEntry(Integer time, String agent) {
        TreeMap t;
        if (time == null || agent == null) {
            return null;
        }
        if (this.entries.containsKey(agent) && (t = (TreeMap)this.entries.get(agent)).containsKey(time)) {
            LogViewerEntrySlot v = (LogViewerEntrySlot)t.get(time);
            return v;
        }
        return null;
    }

    public synchronized void addEntry(Integer time, String agent, Object data) {
        LogViewerEntrySlot v;
        TreeMap t;
        if (this.viewer.getTimeMultiplier() != 1.0f) {
            time = new Integer(Math.round(time.floatValue() * this.viewer.getTimeMultiplier()));
        }
        if (!this.entries.containsKey(agent)) {
            t = new TreeMap();
            this.entries.put(agent, t);
        } else {
            t = (TreeMap)this.entries.get(agent);
        }
        if (!t.containsKey(time)) {
            v = new LogViewerEntrySlot(this, time, agent);
            t.put(time, v);
        } else {
            v = (LogViewerEntrySlot)t.get(time);
        }
        v.addElement(data);
    }

    public abstract boolean isMyLogEntry(String var1);

    public String formatMyLogEntry(String s) {
        int end;
        StringBuffer buf = new StringBuffer(s);
        int index = -1;
        while ((index = buf.toString().indexOf("\u001b[")) >= 0 && (end = buf.toString().indexOf(109, index)) >= 0) {
            buf.replace(index, end + 1, "");
        }
        return buf.toString();
    }

    public void drawToken(Graphics g, int x, int y, LogViewerEntrySlot v) {
        this.drawTokenType(g, x, y, 0);
    }

    public void drawTokenType(Graphics g, int x, int y, int type) {
        switch (type) {
            case 0: {
                g.fillOval(x - 2, y - 10, 5, 5);
                break;
            }
            case 1: {
                g.drawLine(x, y - 2, x + 0, y - 13);
                g.drawLine(x, y - 2, x - 2, y - 4);
                g.drawLine(x, y - 2, x + 2, y - 4);
                break;
            }
            case 2: {
                g.drawLine(x, y - 13, x + 0, y - 2);
                g.drawLine(x, y - 13, x - 2, y - 11);
                g.drawLine(x, y - 13, x + 2, y - 11);
                break;
            }
            case 3: {
                g.drawLine(x + 2, y - 11, x - 2, y - 4);
                g.drawLine(x - 2, y - 11, x + 2, y - 4);
                break;
            }
            case 4: {
                g.drawLine(x - 2, y - 10, x + 2, y - 5);
                g.drawLine(x - 2, y - 5, x + 2, y - 10);
                break;
            }
            case 5: {
                g.drawLine(x - 2, y - 7, x + 2, y - 7);
                g.drawLine(x, y - 9, x + 2, y - 7);
                g.drawLine(x, y - 5, x + 2, y - 7);
                break;
            }
            case 6: {
                g.drawLine(x - 2, y - 7, x + 2, y - 7);
                g.drawLine(x - 2, y - 7, x, y - 9);
                g.drawLine(x - 2, y - 7, x, y - 5);
                break;
            }
            case 7: {
                g.drawLine(x, y - 13, x, y - 6);
                g.fillOval(x - 1, y - 4, 3, 3);
                break;
            }
            case 8: {
                g.drawLine(x - 2, y - 7, x, y - 9);
                g.drawLine(x + 2, y - 7, x, y - 9);
                break;
            }
            case 9: {
                g.drawLine(x - 2, y - 9, x, y - 7);
                g.drawLine(x + 2, y - 9, x, y - 7);
                break;
            }
            case 10: {
                g.drawLine(x - 2, y - 8, x + 2, y - 8);
                g.drawLine(x, y - 10, x, y - 6);
                break;
            }
            case 11: {
                g.drawLine(x - 2, y - 8, x + 2, y - 8);
                break;
            }
            case 12: {
                g.drawLine(x + 2, y - 11, x - 2, y - 4);
                break;
            }
            case 13: {
                g.drawLine(x - 2, y - 11, x + 2, y - 4);
                break;
            }
            case 14: {
                g.drawOval(x - 2, y - 10, 4, 4);
                break;
            }
            case 15: {
                g.fillRect(x - 2, y - 10, 4, 4);
                break;
            }
            case 16: {
                g.drawRect(x - 2, y - 10, 4, 4);
                break;
            }
            case 17: {
                g.fillOval(x - 1, y - 9, 3, 3);
                break;
            }
            case 18: {
                g.drawArc(x - 2, y - 13, 4, 4, -90, 270);
                g.drawLine(x, y - 8, x, y - 6);
                g.fillOval(x - 1, y - 4, 3, 3);
                break;
            }
            case 19: {
                g.fillOval(x - 3, y - 11, 7, 7);
            }
        }
    }

    public String getTokenType(int type) {
        return null;
    }

    public String getTime(String s) {
        char[] c = s.toCharArray();
        block0: for (int i = 0; i < c.length; ++i) {
            if (c[i] != '[') continue;
            for (int j = i + 1; j < c.length; ++j) {
                if (c[j] == ':') {
                    if (i + 1 >= j) continue block0;
                    return s.substring(i + 1, j);
                }
                if (!Character.isDigit(c[j])) continue block0;
            }
        }
        return null;
    }

    public String getAgent(String s) {
        char[] c = s.toCharArray();
        block0: for (int i = 0; i < c.length; ++i) {
            if (c[i] != '[') continue;
            for (int j = i + 1; j < c.length; ++j) {
                if (c[j] == ':') {
                    for (int k = j + 1; k < c.length; ++k) {
                        if (c[k] != ':' && c[k] != ']') continue;
                        if (j + 1 >= k) continue block0;
                        return s.substring(j + 1, k);
                    }
                    continue block0;
                }
                if (!Character.isDigit(c[j])) continue block0;
            }
        }
        return null;
    }
}

