/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.base.AgentComponent;
import agent.simplest.Communicate;
import agent.simplest.Control;
import agent.simplest.DependencyFailedException;
import agent.simplest.Execute;
import agent.simplest.Log;
import agent.simplest.LogViewerEntry;
import agent.simplest.LogViewerEntrySlot;
import agent.simplest.LogViewerFilter;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import agent.simplest.ViewerFrame;
import agent.simplest.WindowManager;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import utilities.SafeEnumeration;

public class LogViewer
extends AgentComponent
implements PropertyEventListener,
MouseListener {
    static final long serialVersionUID = 1234567890L;
    protected static int FAC_LOGVIEW;
    protected Log log;
    protected State state;
    protected ViewerFrame window;
    protected Vector logfiles = new Vector();
    protected Hashtable logfilereaders = new Hashtable();
    protected Hashtable logfilelines = new Hashtable();
    protected Vector filters = new Vector();
    protected float timemultiplier = 1.0f;
    protected int start = 0;
    protected int finish = 0;
    protected static Color[] colors;
    protected static Hashtable colorset;
    protected boolean standalone = false;
    protected LogfileReaderThread reader = null;
    public static final String LOGFILES = "Logfiles";
    public static final String LOGFILTERS = "LogFilters";
    public static final String LOGVIEWERUPDATE = "LogViewerUpdate";
    public static final String LOGVIEWERREAD = "LogViewerRead";
    public static final String LOGSCALE = "LogScale";

    public LogViewer() {
        this.addDependency("Log");
        this.addDependency("State");
        State.addParameterInfo(LOGFILES, "Vector", "List of the logfiles to be viewed, these are automatically opened when the component starts", new Vector());
        State.addParameterInfo(LOGFILTERS, "Vector", "List of the log filters to be added", new Vector());
        State.addParameterInfo(LOGVIEWERUPDATE, "Integer", "Time delay between log viewer continuous read updates", new Integer(2000));
        State.addParameterInfo(LOGVIEWERREAD, "Boolean", "If true, continuous reading of log files is enabled", Boolean.TRUE);
        this.addMouseListener(this);
    }

    public void init() {
        this.log = (Log)State.findComponent("Log");
        FAC_LOGVIEW = this.log.getFacilityID(this);
        this.state = (State)State.findComponent("State");
        this.state.addPropertyEventListener(this);
        boolean read = (Boolean)this.state.getProperty(LOGVIEWERREAD);
        if (read) {
            this.startReader();
        }
        super.init();
    }

    public void pulse() {
    }

    public void reset() {
    }

    public int getStartTime() {
        int low = Integer.MAX_VALUE;
        Enumeration e = this.getFilters();
        while (e.hasMoreElements()) {
            LogViewerFilter f = (LogViewerFilter)e.nextElement();
            if (f.getNumAgents() <= 0) continue;
            Iterator ie = f.getEntryAgents();
            while (ie.hasNext()) {
                int i;
                TreeMap t = f.getEntries((String)ie.next());
                if (t.isEmpty() || (i = ((Integer)t.firstKey()).intValue()) >= low) continue;
                low = i;
            }
        }
        return low;
    }

    public int getFinishTime() {
        int hi = Integer.MIN_VALUE;
        Enumeration e = this.getFilters();
        while (e.hasMoreElements()) {
            LogViewerFilter f = (LogViewerFilter)e.nextElement();
            if (f.getNumAgents() <= 0) continue;
            Iterator ie = f.getEntryAgents();
            while (ie.hasNext()) {
                int i;
                TreeMap t = f.getEntries((String)ie.next());
                if (t.isEmpty() || (i = ((Integer)t.lastKey()).intValue()) <= hi) continue;
                hi = i;
            }
        }
        return hi;
    }

    public synchronized void startReader() {
        if (this.readerIsActive()) {
            return;
        }
        this.reader = new LogfileReaderThread();
        this.reader.start();
        if (this.window != null) {
            this.window.updateMenus();
        }
    }

    public synchronized void stopReader() {
        if (!this.readerIsActive()) {
            return;
        }
        this.reader.alive = false;
        this.reader = null;
        if (this.window != null) {
            this.window.updateMenus();
        }
    }

    public boolean readerIsActive() {
        return this.reader != null;
    }

    public synchronized void parseAllLogfiles(LogViewerFilter filter) {
        this.logfilereaders.clear();
        this.logfilelines.clear();
        Enumeration en = this.getLogfiles();
        while (en.hasMoreElements()) {
            this.parseLogfile((String)en.nextElement(), filter, true);
        }
    }

    public int parseLogfile(String filename, LogViewerFilter filter, boolean verbose) {
        try {
            String line;
            BufferedReader br;
            int linenum = 0;
            LogViewerFilter[] fs = null;
            if (filter == null) {
                fs = new LogViewerFilter[this.filters.size()];
                for (int i = 0; i < fs.length; ++i) {
                    LogViewerFilter f = (LogViewerFilter)this.filters.elementAt(i);
                    fs[i] = f.isActive() ? f : null;
                }
            } else {
                fs = new LogViewerFilter[]{filter};
            }
            if (this.logfilereaders.containsKey(filename)) {
                br = (BufferedReader)this.logfilereaders.get(filename);
                linenum = (Integer)this.logfilelines.get(filename);
            } else {
                FileReader fr = new FileReader(filename);
                br = new BufferedReader(fr);
                this.logfilereaders.put(filename, br);
            }
            int start = linenum;
            String lasttime = "0";
            String lastagent = "???";
            while ((line = br.readLine()) != null) {
                if (linenum > 0 && linenum % 500 == 0 && verbose) {
                    this.log.log("Read line " + linenum, 3, FAC_LOGVIEW);
                }
                for (int i = 0; i < fs.length; ++i) {
                    if (fs[i] == null || !fs[i].isMyLogEntry(line)) continue;
                    String time = fs[i].getTime(line);
                    if (time == null) {
                        time = lasttime;
                    }
                    lasttime = time;
                    String agent = fs[i].getAgent(line);
                    if (agent == null) {
                        agent = lastagent;
                    }
                    lastagent = agent;
                    fs[i].addEntry(Integer.valueOf(time), agent, new LogViewerEntry(filename, linenum, line));
                }
                ++linenum;
            }
            if (start != linenum) {
                this.logfilelines.put(filename, new Integer(--linenum));
                if (verbose) {
                    this.log.log("Done parsing " + filename + " - " + (linenum - start) + " lines read", 2, FAC_LOGVIEW);
                }
            }
            return linenum - start;
        }
        catch (IOException e) {
            this.log.log("Logfile " + filename + " not found.", 1, FAC_LOGVIEW);
            return 0;
        }
    }

    public Enumeration getLogfiles() {
        return this.logfiles.elements();
    }

    public boolean hasLogfile(String filename) {
        Enumeration e = this.logfiles.elements();
        while (e.hasMoreElements()) {
            if (!filename.equals((String)e.nextElement())) continue;
            return true;
        }
        return false;
    }

    public void addLogfile(String filename) {
        this.log.log("Adding logfile " + filename, 2, FAC_LOGVIEW);
        if (!this.hasLogfile(filename)) {
            if (this.parseLogfile(filename, null, true) > 0) {
                this.logfiles.add(filename);
                if (this.window != null) {
                    this.window.updateMenus();
                }
            } else {
                this.clearLogfileData(filename);
            }
        } else {
            this.log.log("Logfile " + filename + " not added, it is already being tracked", 1, FAC_LOGVIEW);
        }
    }

    public void removeLogfile(String filename) {
        this.log.log("Removing logfile " + filename, 2, FAC_LOGVIEW);
        if (this.hasLogfile(filename)) {
            this.clearLogfileData(filename);
            this.logfiles.remove(filename);
            if (this.window != null) {
                this.window.updateMenus();
            }
        } else {
            this.log.log("Logfile " + filename + " not removed, it is not being tracked", 1, FAC_LOGVIEW);
        }
    }

    public void removeAllLogfiles() {
        Enumeration en = this.getLogfiles();
        while (en.hasMoreElements()) {
            this.removeLogfile((String)en.nextElement());
        }
    }

    public synchronized void clearAllLogfileData() {
        Enumeration e = this.getFilters();
        while (e.hasMoreElements()) {
            LogViewerFilter f = (LogViewerFilter)e.nextElement();
            f.clearAllEntries();
            this.logfilereaders.clear();
            this.logfilelines.clear();
        }
        if (this.window != null) {
            this.window.updateDisplay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearLogfileData(String filename) {
        this.log.log("Clearing data from " + filename, 2, FAC_LOGVIEW);
        this.logfilereaders.remove(filename);
        this.logfilelines.remove(filename);
        Enumeration e = this.getFilters();
        while (e.hasMoreElements()) {
            LogViewerFilter f;
            LogViewerFilter logViewerFilter = f = (LogViewerFilter)e.nextElement();
            synchronized (logViewerFilter) {
                Iterator ie = f.getEntryAgents();
                while (ie.hasNext()) {
                    String agent = (String)ie.next();
                    TreeMap t = f.getEntries(agent);
                    Iterator i = t.keySet().iterator();
                    block5: while (i.hasNext()) {
                        Integer time = (Integer)i.next();
                        LogViewerEntrySlot v = f.getEntry(time, agent);
                        SafeEnumeration en = new SafeEnumeration(v.elements());
                        while (en.hasMoreElements()) {
                            LogViewerEntry le = (LogViewerEntry)en.nextElement();
                            if (!le.getSource().equals(filename) || !f.clearEntry(time, agent, le)) continue;
                            i.remove();
                            continue block5;
                        }
                    }
                }
            }
        }
        if (this.window != null) {
            this.window.updateDisplay();
        }
    }

    public Enumeration getFilters() {
        return this.filters.elements();
    }

    public boolean hasFilter(LogViewerFilter f) {
        Enumeration e = this.getFilters();
        while (e.hasMoreElements()) {
            if (!f.getLabel().equals(((LogViewerFilter)e.nextElement()).getLabel())) continue;
            return true;
        }
        return false;
    }

    public LogViewerFilter addFilter(String fname) {
        try {
            Class<?> c = Class.forName(fname);
            Object o = c.newInstance();
            if (o instanceof LogViewerFilter) {
                this.addFilter((LogViewerFilter)o);
                return (LogViewerFilter)o;
            }
            this.log.log("Error: Class " + fname + " is not a LogViewerFilter", 0, FAC_LOGVIEW);
        }
        catch (Exception ex) {
            this.log.log("Error: Could not instantiate class " + fname + "\n" + ex, 0, FAC_LOGVIEW);
        }
        return null;
    }

    public void addFilter(LogViewerFilter f) {
        this.log.log("Adding filter " + f.getLabel(), 2, FAC_LOGVIEW);
        if (!this.hasFilter(f)) {
            this.filters.add(f);
            f.setLogViewer(this);
            this.parseAllLogfiles(f);
            if (this.window != null) {
                this.window.updateMenus();
            }
        } else {
            this.log.log("Filter " + f.getLabel() + " not added, it is already present", 1, FAC_LOGVIEW);
        }
    }

    public void removeFilter(LogViewerFilter f) {
        this.log.log("Removing filter " + f.getLabel(), 2, FAC_LOGVIEW);
        if (this.hasFilter(f)) {
            this.filters.remove(f);
            f.setLogViewer(null);
            this.deactivateFilter(f);
            if (this.window != null) {
                this.window.updateMenus();
            }
        } else {
            this.log.log("Filter " + f.getLabel() + " not removed, it is not present", 1, FAC_LOGVIEW);
        }
    }

    public LogViewerFilter findFilter(String n) {
        Enumeration e = this.getFilters();
        while (e.hasMoreElements()) {
            LogViewerFilter f = (LogViewerFilter)e.nextElement();
            if (!n.equals(f.getLabel())) continue;
            return f;
        }
        return null;
    }

    public void activateFilter(LogViewerFilter f) {
        if (f.isActive()) {
            return;
        }
        f.setActive(true);
        this.parseAllLogfiles(f);
        if (this.window != null) {
            this.window.updateMenus();
        }
    }

    public void deactivateFilter(LogViewerFilter f) {
        if (!f.isActive()) {
            return;
        }
        f.setActive(false);
        f.clearAllEntries();
        if (this.window != null) {
            this.window.updateMenus();
        }
    }

    public static Color getColor(int i) {
        return colors[i];
    }

    public void setTimeMultiplier(float t) {
        this.timemultiplier = t;
    }

    public float getTimeMultiplier() {
        return this.timemultiplier;
    }

    public static Color getColor(String s) {
        Integer color = (Integer)colorset.get(s);
        if (color != null) {
            return colors[color];
        }
        color = new Integer(0);
        for (int i = 0; i < colors.length - 1; ++i) {
            Integer num2;
            Integer num1 = (Integer)colorset.get(colors[i]);
            if (num1 == null) {
                num1 = new Integer(0);
                colorset.put(colors[i], num1);
            }
            if ((num2 = (Integer)colorset.get(colors[i + 1])) == null) {
                num2 = new Integer(0);
                colorset.put(colors[i + 1], num2);
            }
            if (num2 >= num1) continue;
            color = new Integer(i + 1);
            break;
        }
        Integer num = (Integer)colorset.get(colors[color]);
        colorset.put(colors[color], new Integer(num + 1));
        colorset.put(s, color);
        return colors[color];
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyChanged(PropertyEvent e) {
        block4: {
            Vector v;
            String key;
            block3: {
                key = e.getKey().toString();
                if (!key.equalsIgnoreCase(LOGFILES)) break block3;
                this.removeAllLogfiles();
                Vector v2 = (Vector)e.getProperty();
                if (v2 == null) break block4;
                Enumeration en = v2.elements();
                while (en.hasMoreElements()) {
                    this.addLogfile((String)en.nextElement());
                }
                break block4;
            }
            if (key.equalsIgnoreCase(LOGFILTERS) && (v = (Vector)e.getProperty()) != null) {
                Enumeration en = v.elements();
                while (en.hasMoreElements()) {
                    this.addFilter((String)en.nextElement());
                }
            }
        }
    }

    public boolean hasClickAction() {
        return true;
    }

    public void handleMouseEvent(MouseEvent e) {
        if (this.window == null) {
            this.window = new ViewerFrame(this);
            this.window.setSize(640, 400);
            if (State.hasComponent("WindowManager")) {
                WindowManager wm = (WindowManager)State.findComponent("WindowManager");
                wm.addWindow(this.window);
            }
        }
        this.window.setVisible(true);
    }

    public void mouseClicked(MouseEvent e) {
        this.handleMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.handleMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public static void main(String[] argv) {
        Control control = new Control(false);
        Log log = new Log();
        State state = new State();
        LogViewer viewer = new LogViewer();
        Communicate communicate = new Communicate();
        Execute execute = new Execute();
        viewer.standalone = true;
        state.setProperty("Name", "LogView");
        try {
            control.setupComponents();
        }
        catch (DependencyFailedException ex) {
            log.log((Object)ex, 0, FAC_LOGVIEW);
        }
        log.setLogLevel(FAC_LOGVIEW, 3);
        log.setLogLevel(2);
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-h")) {
                System.err.println("usage: LogViewer [-t <time multiplier>] [-f class.LogFilter] [-l class.LogFilter] [logfiles]");
                continue;
            }
            if (argv[i].equals("-t")) {
                if (argv.length > ++i) {
                    viewer.setTimeMultiplier(Float.parseFloat(argv[i]));
                    continue;
                }
                log.log("Error: Filter time multiplier must follow -t", 0, FAC_LOGVIEW);
                continue;
            }
            if (argv[i].equals("-f")) {
                if (argv.length > ++i) {
                    viewer.addFilter(argv[i]);
                    continue;
                }
                log.log("Error: Filter class name must follow -f", 0, FAC_LOGVIEW);
                continue;
            }
            if (argv[i].equals("-l")) {
                if (argv.length > ++i) {
                    LogViewerFilter f = viewer.addFilter(argv[i]);
                    if (f == null) {
                        f = viewer.findFilter(argv[i]);
                    }
                    if (f == null) continue;
                    log.log("Deactivating " + f.getLabel(), 3, FAC_LOGVIEW);
                    viewer.deactivateFilter(f);
                    continue;
                }
                log.log("Error: Filter class name must follow -l", 0, FAC_LOGVIEW);
                continue;
            }
            viewer.addLogfile(argv[i]);
        }
        viewer.mouseClicked(null);
    }

    static {
        colorset = new Hashtable();
        colors = new Color[8];
        LogViewer.colors[0] = new Color(255, 0, 0);
        LogViewer.colors[1] = new Color(0, 153, 0);
        LogViewer.colors[2] = new Color(0, 0, 255);
        LogViewer.colors[3] = new Color(153, 0, 204);
        LogViewer.colors[4] = new Color(102, 102, 0);
        LogViewer.colors[5] = new Color(204, 102, 0);
        LogViewer.colors[6] = new Color(255, 51, 255);
        LogViewer.colors[7] = new Color(102, 102, 153);
    }

    class LogfileReaderThread
    extends Thread {
        public boolean alive = true;

        LogfileReaderThread() {
        }

        public void run() {
            int sleep = (Integer)LogViewer.this.state.getProperty(LogViewer.LOGVIEWERUPDATE);
            while (this.alive) {
                try {
                    Thread.currentThread();
                    Thread.sleep(sleep);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (LogViewer.this.window == null || !LogViewer.this.window.isVisible()) continue;
                SafeEnumeration e = new SafeEnumeration(LogViewer.this.logfilereaders.keys());
                while (e.hasMoreElements()) {
                    int total = 0;
                    String filename = (String)e.nextElement();
                    if (LogViewer.this.logfilereaders.containsKey(filename)) {
                        total += LogViewer.this.parseLogfile(filename, null, false);
                    }
                    if (total <= 0 || LogViewer.this.window == null) continue;
                    LogViewer.this.window.updateDisplay();
                }
            }
        }
    }
}

