/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import java.util.Calendar;

public class LogItem {
    public static final String ANSI_S = "\u001b[";
    public static final String ANSI_F = "\u001b[m";
    public static final String ANSI_C_RED = "31m";
    public static final String ANSI_C_GRN = "32m";
    public static final String ANSI_C_YEL = "33m";
    public static final String ANSI_C_BLU = "34m";
    public static final String ANSI_C_PUR = "35m";
    public static final String ANSI_C_CYN = "36m";
    public static final String ANSI_C_PNK = "37m";
    private String proc;
    private String thread;
    private String item;
    private int level;
    private int facility;
    private long time;
    private String aux = "";
    private Object object = null;
    private static Calendar cal = Calendar.getInstance();
    private static boolean ansi = true;

    public LogItem(Object o, int l, int f) {
        this(o.toString(), l, f);
        this.object = o;
    }

    public LogItem(String s, int l, int f) {
        this(cal.getTime().getTime(), s, l, f);
    }

    public LogItem(long t, Object o, int l, int f) {
        this(t, o.toString(), l, f);
        this.object = o;
    }

    public LogItem(long t, String s, int l, int f) {
        this.time = t;
        this.thread = Thread.currentThread().getName();
        this.item = s;
        this.level = l;
        this.facility = f;
    }

    public void clip(int l) {
        if (l <= 0) {
            return;
        }
        if (this.item == null) {
            return;
        }
        if (this.item.length() <= l) {
            return;
        }
        this.item = this.item.substring(0, l) + "... [clipped]";
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long t) {
        this.time = t;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int l) {
        this.level = l;
    }

    public int getFacility() {
        return this.facility;
    }

    public void setFacility(int f) {
        this.facility = f;
    }

    public String getItem() {
        return this.item;
    }

    public void setItem(String s) {
        this.item = s;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object o) {
        this.object = o;
    }

    public String getAux() {
        return this.aux;
    }

    public void setAux(String a) {
        this.aux = a;
    }

    public static boolean getAnsi() {
        return ansi;
    }

    public static void setAnsi(boolean a) {
        ansi = a;
    }

    public String toString() {
        if (ansi) {
            String aitem = this.level == 1 ? "\u001b[35m" + this.item + ANSI_F : (this.level == 0 ? "\u001b[31m" + this.item + ANSI_F : this.item);
            return "\u001b[36m(" + this.thread + ") " + ANSI_F + ANSI_S + ANSI_C_GRN + "[" + this.aux + "] " + ANSI_F + aitem;
        }
        return "(" + this.thread + ") " + "[" + this.aux + "] " + this.item;
    }
}

