/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.base.ListenerVector;
import agent.simplest.Control;
import agent.simplest.LogEvent;
import agent.simplest.LogEventListener;
import agent.simplest.LogItem;
import agent.simplest.LogViewer;
import agent.simplest.LogViewerEntry;
import agent.simplest.LogViewerEntrySlot;
import agent.simplest.LogViewerFilter;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.ScreenLog;
import agent.simplest.State;
import agent.simplest.WindowManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utilities.VFlowLayout;

public class Log
extends AgentComponent
implements PropertyEventListener {
    static final long serialVersionUID = 1234567890L;
    protected ListenerVector listeners = new ListenerVector();
    public static final int LOG_NONE = -1;
    public static final int LOG_EMERG = 0;
    public static final int LOG_ALERT = 0;
    public static final int LOG_CRIT = 0;
    public static final int LOG_ERR = 0;
    public static final int LOG_WARNING = 1;
    public static final int LOG_INFO = 2;
    public static final int LOG_DEBUG = 3;
    public static final int LOG_DEBUG2 = 4;
    public static final int LOG_SPAM = 5;
    public static final int ERROR_THRESH = 0;
    public static final int FLUSH_THRESH = 0;
    private static int ID = 0;
    private int FAC_GENERAL = 0;
    private int FAC_EVENT = 0;
    protected int FAC_LOG = 0;
    private static final int MAX_FAC = 1000;
    public static int LEV_EVENT = 3;
    public static int LEV_GENERAL = 2;
    protected static Hashtable facilities = new Hashtable();
    protected static String[] facnames = new String[1000];
    protected static int[] levels = new int[1000];
    private Container faccon = null;
    Vector factemp = new Vector();
    Hashtable slides = new Hashtable();
    private Label label = new Label("                                                    ", 0);
    private utilities.Log utilitieslog = utilities.Log.getDefault();
    protected transient PrintWriter output;
    private int length;
    protected boolean complex = true;
    protected boolean audible;
    private boolean flush;
    private ScreenLog screenlog = null;
    protected String name = "";
    protected State state = null;
    protected long time = Calendar.getInstance().getTime().getTime();
    protected int clock;
    protected boolean logevents = false;
    protected boolean logmemory = false;
    protected boolean logtime = false;
    protected boolean logcontrolonly = false;
    protected int logdelaythresh = -1;
    protected LogItem lastlogitem = null;
    protected boolean linebreaks = true;
    protected boolean gui = false;
    private Runtime runtime = Runtime.getRuntime();
    private Calendar cal = Calendar.getInstance();
    private long lasttime = 0L;
    private long thistime;
    protected Hashtable files = new Hashtable();
    protected Control control;
    public static final String LOGLEVEL = "LogLevel";
    public static final String LOGFLUSH = "LogFlush";
    public static final String LOGLENGTH = "LogLength";
    public static final String LOGFACILITIES = "LogFacilities";
    public static final String LOGCOMPLEX = "LogComplex";
    public static final String LOGTIME = "LogTime";
    public static final String LOGMEMORY = "LogMemory";
    public static final String LOGEVENTS = "LogEvents";
    public static final String LOGGUI = "LogGUI";
    public static final String AUDIBLEERRORS = "AudibleErrors";
    public static final String USEANSI = "UseANSI";
    public static final String LOGLINEBREAKS = "LogLinebreaks";
    public static final String LOGDELAYTHRESH = "LogDelayThresh";
    public static final String LOGCONTROLONLY = "LogControlOnly";
    String aux;

    public Log() {
        this.setLogStream(System.err);
        State.addParameterInfo(LOGLEVEL, "Integer", "The default log level value, used for the general log level and facilities who's levels' are unspecified", new Integer(2));
        State.addParameterInfo(LOGFLUSH, "Boolean", "If true, the log stream will be flushed after each logging action", Boolean.TRUE);
        State.addParameterInfo(LOGLENGTH, "Integer", "Maximum permitted length for log lines (0 for no limit)", new Integer(500));
        State.addParameterInfo(LOGFACILITIES, "Hashtable", "Per-component facility log specifications (e.g. Execute,2,State,3...)");
        State.addParameterInfo(LOGCOMPLEX, "Boolean", "If true, extra information is prepended to each log message", Boolean.TRUE);
        State.addParameterInfo(LOGTIME, "Boolean", "If true, includes wall clock time with each log message", Boolean.FALSE);
        State.addParameterInfo(LOGMEMORY, "Boolean", "If true, the agent's current memory information is logged with each log message", Boolean.FALSE);
        State.addParameterInfo(LOGEVENTS, "Boolean", "Generate LogEvents for each logging action.", Boolean.FALSE);
        State.addParameterInfo(LOGGUI, "Boolean", "Update Log component GUI with log messages", Boolean.FALSE);
        State.addParameterInfo(AUDIBLEERRORS, "Boolean", "Plays a system beep when an error occurs", Boolean.TRUE);
        State.addParameterInfo(USEANSI, "Boolean", "ANSI-colorize textual output.", Boolean.TRUE);
        State.addParameterInfo(LOGLINEBREAKS, "Boolean", "If true, linebreak are permitted in log events, otherwise logged data will be condensed onto one line", Boolean.TRUE);
        State.addParameterInfo(LOGDELAYTHRESH, "Integer", "If LogTime is true, log items will always be shown if their delay is above this threshold (if > -1)", new Integer(this.logdelaythresh));
        State.addParameterInfo(LOGCONTROLONLY, "Boolean", "If true, only log events from the control thread will be processed", new Boolean(this.logcontrolonly));
        this.addDependency("State");
        if (this.utilitieslog != null) {
            this.utilitieslog.setName("JAF");
        }
        this.add(new Label("Status:", 2));
        this.add(this.label);
        this.setLabel("Un-updated");
        if (this.getClass().getName().equals("agent.simplest.Log")) {
            this.FAC_LOG = this.getFacilityID(this);
            this.FAC_GENERAL = this.getFacilityID("General");
            this.FAC_EVENT = this.getFacilityID("Event");
            this.updateAllLogLevels();
        }
    }

    public void init() {
        this.state = (State)State.findComponent("State");
        if (State.hasComponent("ScreenLog")) {
            this.screenlog = (ScreenLog)State.findComponent("ScreenLog");
        }
        this.control = (Control)State.findComponent("Control");
        this.state.addPropertyEventListener(this);
        this.updateAllLogLevels();
        if (this.hasGUI()) {
            JFrame window;
            if (State.hasComponent("WindowManager")) {
                WindowManager wm = (WindowManager)State.findComponent("WindowManager");
                window = wm.createWindow("Log Facilities");
            } else {
                window = new JFrame("Log Facilities");
            }
            JScrollPane scroll = new JScrollPane();
            this.faccon = new JPanel();
            window.getContentPane().add(scroll);
            scroll.setViewportView(this.faccon);
            this.faccon.setLayout((LayoutManager)new VFlowLayout(true));
            Enumeration e = this.factemp.elements();
            while (e.hasMoreElements()) {
                this.faccon.add((Component)e.nextElement());
            }
            window.setSize(new Dimension(450, 300));
        }
    }

    public void begin() {
        this.printLogLevels();
        if (State.hasComponent("LogViewer")) {
            LogViewer viewer = (LogViewer)State.findComponent("LogViewer");
            viewer.addFilter(new LogViewerFilter("Error/Warn", true){

                public boolean isMyLogEntry(String s) {
                    int level = this.getLogLevel(s);
                    return level == 0 || level == 1;
                }

                public void drawToken(Graphics g, int x, int y, LogViewerEntrySlot v) {
                    Color c = g.getColor();
                    Enumeration e = v.elements();
                    int type = 0;
                    while (e.hasMoreElements()) {
                        LogViewerEntry entry = (LogViewerEntry)e.nextElement();
                        if (this.getLogLevel(entry.getData()) != 0) continue;
                        type = 1;
                        break;
                    }
                    this.drawTokenType(g, x, y, type);
                }

                public void drawTokenType(Graphics g, int x, int y, int type) {
                    Color c = g.getColor();
                    switch (type) {
                        case 1: {
                            g.setColor(LogViewer.getColor(0));
                            g.fillOval(x - 3, y - 11, 7, 7);
                            break;
                        }
                        default: {
                            g.setColor(LogViewer.getColor(6));
                            super.drawTokenType(g, x, y, 0);
                        }
                    }
                    g.setColor(c);
                }

                public String getTokenType(int type) {
                    switch (type) {
                        case 1: {
                            return "Error";
                        }
                        case 0: {
                            return "Warning";
                        }
                    }
                    return null;
                }

                public int getLogLevel(String s) {
                    int i = s.indexOf("]");
                    if ((i = s.lastIndexOf("(", i)) < 0 || i + 1 >= s.length()) {
                        if (s.indexOf("java.lang.") != -1 && (s.indexOf("Exception") != -1 || s.indexOf("Error") != -1)) {
                            return 0;
                        }
                        return -1;
                    }
                    if (s.length() <= i + 3) {
                        return -1;
                    }
                    char c = s.charAt(i + 1);
                    if (s.charAt(i + 2) != ')') {
                        return -1;
                    }
                    if (s.charAt(i + 3) != ']') {
                        return -1;
                    }
                    if (Character.isDigit(c)) {
                        return Character.getNumericValue(c);
                    }
                    return -1;
                }
            });
        }
    }

    protected void finalize() {
        this.closeLogStream();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setLogStream(System.err);
    }

    public void addLogEventListener(LogEventListener l) {
        this.listeners.add(l);
    }

    public void removeLogEventListener(LogEventListener l) {
        this.listeners.remove(l);
    }

    protected void fireEvent(AgentEvent event) {
        LogEvent e = (LogEvent)event;
        Enumeration enumr = this.listeners.elements();
        block6: while (enumr.hasMoreElements()) {
            LogEventListener l = (LogEventListener)enumr.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0: {
                    l.errorLog(e);
                    if (this.screenlog == null) continue block6;
                    this.screenlog.log(e);
                    continue block6;
                }
                case 1: {
                    AgentEvent ae = (AgentEvent)e.getItem().getObject();
                    if (ae.getSource() != l) {
                        l.eventReflection(ae);
                    }
                    l.eventLog(e);
                    continue block6;
                }
                case 2: {
                    l.stringLog(e);
                    continue block6;
                }
                case 3: {
                    l.objectLog(e);
                    continue block6;
                }
            }
        }
    }

    public int getLogLevel() {
        return LEV_GENERAL;
    }

    public void setLogLevel(int l) {
        if (LEV_GENERAL != l) {
            this.setLogLevel(this.FAC_GENERAL, l);
            this.updateAllLogLevels();
            if (this.state != null) {
                this.state.setProperty(LOGLEVEL, new Integer(LEV_GENERAL));
            }
        }
    }

    public void updateAllLogLevels() {
        String fac;
        Hashtable faclevels = null;
        if (this.state == null) {
            this.state = (State)State.findComponent("State");
        }
        if (this.state != null) {
            faclevels = (Hashtable)this.state.getProperty(LOGFACILITIES);
        }
        for (int i = 0; i < levels.length && (fac = this.getFacilityByID(i)) != null; ++i) {
            if (faclevels != null && faclevels.containsKey(fac)) {
                try {
                    int lev = Integer.parseInt((String)faclevels.get(fac));
                    this.setLogLevel(i, lev);
                }
                catch (NullPointerException ee) {
                    this.log("Error setting level for facility \"" + fac + "\"", 0, this.FAC_LOG);
                }
                catch (NumberFormatException ee) {
                    this.log("Error: Facility \"" + fac + "\" did not have a parseable number value", 0, this.FAC_LOG);
                }
                continue;
            }
            if (i == this.FAC_EVENT) {
                this.setLogLevel(i, LEV_EVENT);
                continue;
            }
            this.setLogLevel(i, LEV_GENERAL);
        }
        this.log("All log levels updated (General is " + levels[this.FAC_GENERAL] + ")", 2, this.FAC_LOG);
    }

    public void printLogLevels() {
        this.log("Registered log levels:", 2, this.FAC_LOG);
        if (facilities != null) {
            Enumeration e = facilities.keys();
            while (e.hasMoreElements()) {
                String f = (String)e.nextElement();
                int id = this.getFacilityID(f);
                this.log("  Level[" + f + "(" + id + ")] = " + this.getLogLevel(id), 3, this.FAC_LOG);
            }
        }
    }

    public void setLogLevel(int id, int l) {
        if (levels[id] != l) {
            Log.levels[id] = l;
            this.log("Log level for facility " + id + " is now " + l, 3, this.FAC_LOG);
            if (id == this.FAC_GENERAL && this.utilitieslog != null) {
                LEV_GENERAL = l;
                this.utilitieslog.setLevel(LEV_GENERAL);
            } else if (id == this.FAC_EVENT) {
                LEV_EVENT = l;
            }
            JSlider slide = (JSlider)this.slides.get(new Integer(id));
            if (slide != null && slide.getValue() != l) {
                slide.setValue(l);
            }
        }
    }

    public int getLogLevel(int id) {
        if (id >= 0 && id < levels.length) {
            return levels[id];
        }
        return -1;
    }

    public void setLogLevel(String sid, int l) {
        this.setLogLevel(this.getFacilityID(sid), l);
    }

    public int getLogLevel(String sid) {
        return this.getLogLevel(this.getFacilityID(sid));
    }

    public int getLogLength() {
        return this.length;
    }

    public void setLogLength(int l) {
        this.length = l;
        if (this.state != null) {
            this.state.setProperty(LOGLENGTH, new Integer(this.length));
        }
    }

    public boolean getFlush() {
        return this.flush;
    }

    public void setFlush(boolean f) {
        this.flush = f;
        if (this.state != null) {
            this.state.setProperty(LOGFLUSH, new Boolean(this.flush));
        }
        if (this.flush) {
            this.flush();
        }
    }

    public int getFacilityID(AgentComponent c) {
        return this.getFacilityID((Object)c);
    }

    public int getFacilityID(Object o) {
        String f = o.getClass().getName();
        f = f.substring(f.lastIndexOf(".") + 1);
        return this.getFacilityID(f);
    }

    public synchronized int getFacilityID(String f) {
        Integer key = (Integer)facilities.get(f);
        if (key == null) {
            if (ID >= 999) {
                this.log("Error: Maximum number of facilities exceeded, using General", 0, this.FAC_LOG);
                return this.getFacilityID("General");
            }
            key = new Integer(ID++);
            facilities.put(f, key);
            Log.facnames[key.intValue()] = f;
            Log.levels[key.intValue()] = -999;
            this.updateAllLogLevels();
            if (this.hasGUI()) {
                JPanel item = new JPanel();
                item.setLayout(new FlowLayout(2));
                item.setAlignmentX(1.0f);
                JSlider slide = new JSlider(0, -1, 5, levels[key]);
                slide.setAlignmentX(1.0f);
                slide.setName(f);
                slide.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        Log.this.setLogLevel(((JSlider)e.getSource()).getName(), ((JSlider)e.getSource()).getValue());
                    }
                });
                slide.setSnapToTicks(true);
                slide.setMajorTickSpacing(1);
                slide.setPaintTicks(true);
                slide.setPaintLabels(true);
                Hashtable<Integer, JLabel> d = new Hashtable<Integer, JLabel>();
                ((Dictionary)d).put(new Integer(-1), new JLabel("No"));
                ((Dictionary)d).put(new Integer(0), new JLabel("Er"));
                ((Dictionary)d).put(new Integer(1), new JLabel("Wr"));
                ((Dictionary)d).put(new Integer(2), new JLabel("In"));
                ((Dictionary)d).put(new Integer(3), new JLabel("D1"));
                ((Dictionary)d).put(new Integer(4), new JLabel("D2"));
                ((Dictionary)d).put(new Integer(5), new JLabel("Sp"));
                slide.setLabelTable(d);
                this.slides.put(key, slide);
                item.add(new JLabel(f + " (" + key + ")"));
                item.add(slide);
                if (this.faccon == null) {
                    this.factemp.addElement(item);
                } else {
                    this.faccon.add(item);
                }
            }
            this.log("New log facility created: \"" + f + "\", level " + levels[key], 2, this.FAC_LOG);
        }
        return key;
    }

    public String getFacilityByID(int i) {
        if (facilities != null && i >= 0 && i < facnames.length) {
            return facnames[i];
        }
        return null;
    }

    public void setLogStream(OutputStream s) {
        this.closeLogStream();
        this.output = new PrintWriter(s, false);
    }

    public void closeLogStream() {
        if (this.output != null) {
            this.flush();
            this.output.close();
            this.output = null;
        }
    }

    public void log(AgentEvent e) {
        this.log(e, LEV_EVENT, this.FAC_EVENT);
    }

    public void log(AgentEvent e, int l, int f) {
        if (this.logcontrolonly && this.control != null && Thread.currentThread() != this.control.getControlThread()) {
            return;
        }
        if (this.logevents || this.loggable(l, f)) {
            this.log(new LogItem(e.toString(), l, f));
        }
        if (this.logtime && this.logdelaythresh > 0) {
            this.lastlogitem = new LogItem(e.toString(), l, f);
        }
    }

    public void log(Object o, int l) {
        this.log(o, l, this.FAC_GENERAL);
    }

    public void log(Object o, int l, int f) {
        this.log(o.toString(), l, f);
    }

    public void log(String s, int l) {
        this.log(s, l, this.FAC_GENERAL);
    }

    public void log(String s, int l, int f) {
        if (this.logcontrolonly && this.control != null && Thread.currentThread() != this.control.getControlThread()) {
            return;
        }
        if (this.loggable(l, f)) {
            this.log(new LogItem(s, l, f));
        }
        if (this.logtime && this.logdelaythresh > 0) {
            this.lastlogitem = new LogItem(s, l, f);
        }
    }

    public void setLabel(String l) {
        this.label.setText(l);
    }

    public boolean loggable(int l, int f) {
        if (l < 0 || l > 5) {
            this.log("Error: Log attempt by " + this.getFacilityByID(l) + " level " + l + " out of range", 0, this.FAC_LOG);
            new Exception().printStackTrace();
        }
        if (this.logtime && this.logdelaythresh > 0) {
            this.thistime = System.currentTimeMillis();
            if (this.thistime - this.lasttime > (long)this.logdelaythresh && this.lastlogitem != null) {
                this.lastlogitem.setAux(this.getFacilityByID(this.lastlogitem.getFacility()) + "(" + this.lastlogitem.getLevel() + ")");
                this.output.println(this.lastlogitem + " (LogDelayThresh " + (this.thistime - this.lasttime) + ")");
                return true;
            }
        }
        return l <= levels[f];
    }

    protected boolean loggable(LogItem i) {
        return this.loggable(i.getLevel(), i.getFacility());
    }

    protected void log(LogItem i) {
        i.clip(this.length);
        if (this.complex) {
            this.aux = this.clock + ":" + this.name;
            if (this.logmemory) {
                this.aux = this.aux + ":" + this.runtime.freeMemory() + "/" + this.runtime.totalMemory();
            }
            if (this.logtime) {
                this.thistime = System.currentTimeMillis();
                this.aux = this.aux + ":" + this.thistime + "(" + (this.thistime - this.lasttime) + ")";
                this.lasttime = this.thistime;
            }
            this.aux = this.aux + ":" + this.getFacilityByID(i.getFacility()) + "(" + i.getLevel() + ")";
            i.setAux(this.aux);
        }
        if (this.linebreaks) {
            this.output.println(i);
        } else {
            this.output.println(i.toString().replace('\n', ' '));
        }
        if (this.gui) {
            this.setLabel(i.getItem());
        }
        if (this.flush || i.getLevel() <= 0) {
            this.flush();
        }
        if (i.getLevel() <= 0) {
            if (this.audible && this.hasGUI()) {
                Toolkit.getDefaultToolkit().beep();
            }
            this.flush();
        }
        if (this.logevents) {
            if (i.getLevel() <= 0) {
                this.startFireEvent(new LogEvent(this, i, 0));
            }
            if (i.getObject() == null) {
                this.startFireEvent(new LogEvent(this, i, 2));
            } else if (i.getObject() instanceof AgentEvent) {
                this.startFireEvent(new LogEvent(this, i, 1));
            } else {
                this.startFireEvent(new LogEvent(this, i, 3));
            }
        }
    }

    protected OutputStream getFileOutputStream(String filename, boolean append) {
        OutputStream stream = (OutputStream)this.files.get(filename);
        if (stream == null) {
            try {
                stream = new FileOutputStream(filename, append);
                this.files.put(filename, stream);
            }
            catch (IOException e) {
                this.log("Error opening file output stream for " + filename + ":" + e, 0, this.FAC_LOG);
            }
        }
        return stream;
    }

    public void log(Object o, String filename) {
        this.log(o, filename, false);
    }

    public void log(Object o, String filename, boolean append) {
        OutputStream stream = this.getFileOutputStream(filename, append);
        if (stream != null) {
            try {
                String s = o.toString();
                stream.write(s.getBytes());
                stream.flush();
            }
            catch (IOException e) {
                this.log("Error using output stream for " + filename + ":" + e, 0, this.FAC_LOG);
            }
        }
    }

    public void flush() {
        this.output.flush();
    }

    public void propertyChanged(PropertyEvent e) {
        this.propertyAdded(e);
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyAdded(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equals("Time")) {
            this.clock = (Integer)e.getProperty();
        } else if (key.equals("Name")) {
            this.name = (String)e.getProperty();
            this.utilitieslog.setName(this.name);
        } else if (key.equals(AUDIBLEERRORS)) {
            this.audible = (Boolean)e.getProperty();
        } else if (key.equals(USEANSI)) {
            LogItem.setAnsi((Boolean)e.getProperty());
        } else if (key.startsWith("Log")) {
            if (key.equals(LOGLEVEL)) {
                LEV_GENERAL = (Integer)e.getProperty();
                this.utilitieslog.setLevel(LEV_GENERAL);
                this.updateAllLogLevels();
            } else if (key.equals(LOGFLUSH)) {
                this.flush = (Boolean)e.getProperty();
                if (this.flush) {
                    this.flush();
                }
            } else if (key.equals(LOGDELAYTHRESH)) {
                this.logdelaythresh = (Integer)e.getProperty();
            } else if (key.equals(LOGLENGTH)) {
                this.length = (Integer)e.getProperty();
            } else if (key.equals(LOGEVENTS)) {
                this.logevents = (Boolean)e.getProperty();
            } else if (key.equals(LOGLINEBREAKS)) {
                this.linebreaks = (Boolean)e.getProperty();
            } else if (key.equals(LOGCONTROLONLY)) {
                this.logcontrolonly = (Boolean)e.getProperty();
            } else if (key.equals(LOGFACILITIES)) {
                this.updateAllLogLevels();
            } else if (key.equals(LOGCOMPLEX)) {
                this.complex = (Boolean)e.getProperty();
            } else if (key.equals(LOGMEMORY)) {
                this.logmemory = (Boolean)e.getProperty();
            } else if (key.equals(LOGTIME)) {
                this.logtime = (Boolean)e.getProperty();
            } else if (key.equals(LOGGUI)) {
                this.gui = (Boolean)e.getProperty();
            }
        }
    }
}

