/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.io.Serializable;
import java.util.Vector;

public class HistogramComponent
extends Panel {
    protected int[] data;
    protected String[] labels;
    protected Graphics graphics;
    protected Vector lines;
    protected String zero_label;
    protected String x_label;
    protected String y_label;
    protected int width;
    protected int height;
    protected int histo_width;
    protected int histo_height;
    protected Image offscreen;

    public HistogramComponent() {
        this(null, 300, 100);
    }

    public HistogramComponent(int[] data, int width, int height) {
        this.data = data;
        this.labels = null;
        this.width = width != 0 ? width : 1000;
        if (height != 0) {
            this.height = height;
        } else {
            this.width = 700;
        }
        this.histo_width = (int)Math.round((double)this.width * 0.8);
        this.histo_height = (int)Math.round((double)this.height * 0.8);
        this.lines = new Vector(this.histo_width, this.histo_width);
        this.zero_label = new String("0");
        this.x_label = new String("X");
        this.y_label = new String("Y");
        this.setBounds(0, 0, width, height);
        this.makeOffscreen();
    }

    public String getXLabel(int classe) {
        if (this.labels != null && classe <= this.labels.length) {
            return this.labels[classe];
        }
        return "" + classe;
    }

    public int getMax(int[] data) {
        if (data.length != 0) {
            int max = data[0];
            for (int index = 1; index < data.length; ++index) {
                max = Math.max(max, data[index]);
            }
            return max;
        }
        return 0;
    }

    public synchronized void drawHisto() {
        this.makeOffscreen();
        int x_start_axis = (int)Math.round((double)this.width * 0.1);
        int y_end_axis = (int)Math.round((double)this.height * 0.1);
        int x_end_axis = this.histo_width + x_start_axis;
        int y_start_axis = this.histo_height + y_end_axis;
        if (this.data != null) {
            int mode = this.getMax(this.data);
            Graphics graph = this.offscreen.getGraphics();
            graph.setColor(Color.red);
            if (mode != 0) {
                for (int index = 0; index < this.data.length; ++index) {
                    int x = index * this.histo_width / this.data.length + x_start_axis;
                    float tmp = (float)this.histo_height * (float)this.data[index] / (float)mode;
                    int y = (int)((float)y_start_axis - tmp);
                    this.lines.addElement(new Line(x, y_start_axis, x, y, Color.red, "" + this.data[index], this.getXLabel(index), Color.black));
                }
            }
        }
        this.lines.addElement(new Line(x_start_axis, y_start_axis, x_start_axis, y_end_axis, Color.black, "", Color.black));
        this.lines.addElement(new Line(x_start_axis, y_start_axis, x_end_axis, y_start_axis, Color.black, "", Color.black));
        this.zero_label = new String("0");
        this.x_label = new String("Observer");
        this.y_label = new String("Count");
        this.updateOffscreen(this.offscreen.getGraphics());
        this.repaint();
    }

    public synchronized void setHistogramData(int[] d) {
        this.data = d;
        this.resetHistogramLines();
    }

    public synchronized void setHistogramLabels(String[] l) {
        this.labels = l;
    }

    public void resetHistogramLines() {
        this.lines.removeAllElements();
        this.lines.trimToSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(Dimension d) {
        this.width = d.width;
        this.height = d.height;
        this.histo_width = (int)Math.round((double)this.width * 0.8);
        this.histo_height = (int)Math.round((double)this.height * 0.8);
        this.lines = new Vector(this.histo_width, this.histo_width);
        this.setBounds(0, 0, this.width, this.height);
        this.makeOffscreen(true);
        this.drawHisto();
    }

    public void makeOffscreen() {
        this.makeOffscreen(false);
    }

    public void makeOffscreen(boolean force) {
        if (this.getSize().width != this.width || this.getSize().height != this.height) {
            this.setSize(this.getSize());
        }
        if (force || this.offscreen == null) {
            this.offscreen = this.createImage(this.width, this.height);
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        this.makeOffscreen();
        g.drawImage(this.offscreen, 0, 0, null);
    }

    public void update(Graphics g) {
        this.updateOffscreen(this.offscreen.getGraphics());
        this.paint(g);
    }

    public synchronized void updateOffscreen(Graphics g) {
        if (this.lines.size() != 0) {
            Line l;
            int index;
            int offset = this.histo_width / (2 * this.lines.size());
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.width, this.height);
            for (index = 1; index < this.lines.size() - 2; ++index) {
                l = (Line)this.lines.elementAt(index);
                g.setColor(l.color);
                g.fillRect(l.x1 - offset, l.y2, 2 * offset, l.y1 - l.y2);
                g.setColor(l.lc);
                if (l.value != null) {
                    g.setFont(new Font("Helvetica", 0, 14));
                    g.drawString(l.value, l.x2 - g.getFontMetrics().stringWidth(l.value) / 2, l.y2 - 10);
                }
                g.setFont(new Font("Helvetica", 0, 8));
                if (index >= this.lines.size() - 2) continue;
                if (l.label != null) {
                    if (g.getFontMetrics().stringWidth(l.label) <= 2 * (this.histo_width / this.lines.size())) {
                        int y_pos = index % 2 == 0 ? l.y1 + 20 : l.y1 + 30;
                        g.drawString(l.label, l.x2 - g.getFontMetrics().stringWidth(l.label) / 2, y_pos);
                        continue;
                    }
                    g.drawString("" + index, l.x2 - g.getFontMetrics().stringWidth("" + index) / 2, l.y1 + 20);
                    continue;
                }
                g.drawString("" + index, l.x2 - g.getFontMetrics().stringWidth("" + index) / 2, l.y1 + 20);
            }
            for (index = this.lines.size() - 2; index < this.lines.size(); ++index) {
                l = (Line)this.lines.elementAt(index);
                g.setColor(l.color);
                g.drawLine(l.x1, l.y1, l.x2, l.y2);
            }
            g.setColor(Color.red);
            g.setFont(new Font("Helvetica", 0, 14));
            int x_start_axis = (int)Math.round((double)this.width * 0.1);
            int y_end_axis = (int)Math.round((double)this.height * 0.1);
            int x_end_axis = this.histo_width + x_start_axis;
            int y_start_axis = this.histo_height + y_end_axis;
            g.drawString(this.y_label, x_start_axis - g.getFontMetrics().stringWidth(this.y_label) / 2, y_end_axis);
            g.drawString(this.zero_label, x_start_axis - 20, y_start_axis);
            g.drawString(this.x_label, x_end_axis, y_start_axis);
        }
    }

    static class Line
    implements Serializable {
        public int x1;
        public int y1;
        public int x2;
        public int y2;
        public Color color;
        public String value;
        public String label;
        public Color lc;

        public Line(int x1, int y1, int x2, int y2, Color c, String v, String l, Color lc) {
            this(x1, y1, x2, y2, c, v, lc);
            this.label = l;
        }

        public Line(int x1, int y1, int x2, int y2, Color c, String v, Color lc) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.color = c;
            this.value = v;
            this.lc = lc;
        }
    }
}

