/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.simplest.Log;
import agent.simplest.LogItem;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class FileLog
extends Log {
    static final long serialVersionUID = 1234567890L;
    private String filename = "logfile-agent";
    private boolean append = false;

    protected void finalize() {
        this.closeFile();
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String f) {
        this.filename = f;
    }

    public boolean getAppend() {
        return this.append;
    }

    public void setAppend(boolean a) {
        this.append = a;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.openFile();
    }

    public void init() {
        super.init();
        this.openFile();
    }

    public void reset() {
        this.closeFile();
        this.openFile();
    }

    public void openFile() {
        try {
            this.setLogStream(new FileOutputStream(this.filename, this.append));
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void closeFile() {
        this.closeLogStream();
        this.log("Log file " + this.filename + " closed", 3, this.FAC_LOG);
    }

    protected void log(LogItem i) {
        if (this.output == null) {
            i.setItem(i.getItem() + " #Log file not initialized");
        }
        super.log(i);
    }
}

