/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.base.ListenerVector;
import agent.simplest.Action;
import agent.simplest.ActionEvent;
import agent.simplest.ActionEventListener;
import agent.simplest.Log;
import agent.simplest.LogViewer;
import agent.simplest.LogViewerEntry;
import agent.simplest.LogViewerEntrySlot;
import agent.simplest.LogViewerFilter;
import agent.simplest.Observe;
import agent.simplest.Observer;
import agent.simplest.State;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class Execute
extends AgentComponent
implements MouseListener,
ActionListener {
    static final long serialVersionUID = 1234567890L;
    private static final int NUM_ACTIONS = 10;
    protected int FAC_EXECUTE;
    protected ListenerVector listeners = new ListenerVector();
    protected Log log;
    protected State state;
    protected Vector actions;
    private static PopupMenu menu = new PopupMenu("Current Actions");

    public Execute() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addMouseListener(this);
        this.add(menu);
    }

    public void init() {
        this.log = (Log)State.findComponent("Log");
        this.state = (State)State.findComponent("State");
        this.FAC_EXECUTE = this.log.getFacilityID(this);
        if (State.hasComponent("Observe")) {
            Observe observe = (Observe)State.findComponent("Observe");
            observe.addObserver(new Observer("Methods Started"){

                public boolean checkEvent(AgentEvent e) {
                    return e instanceof ActionEvent && e.getID() == 0;
                }
            });
            observe.addObserver(new Observer("Methods Completed"){

                public boolean checkEvent(AgentEvent e) {
                    return e instanceof ActionEvent && e.getID() == 1;
                }
            });
            observe.addObserver(new Observer("Methods Aborted"){

                public boolean checkEvent(AgentEvent e) {
                    return e instanceof ActionEvent && e.getID() == 2;
                }
            });
        } else {
            this.log.log("Observe not found, long term observations not instantiated.", 1, this.FAC_EXECUTE);
        }
        this.actions = new Vector(10);
    }

    public void begin() {
        if (State.hasComponent("LogViewer")) {
            LogViewer viewer = (LogViewer)State.findComponent("LogViewer");
            viewer.addFilter(new LogViewerFilter("Actions", false){

                public boolean isMyLogEntry(String s) {
                    return s.indexOf("Action Start: ") != -1 || s.indexOf("Action Complete: ") != -1 || s.indexOf("Action Abort: ") != -1;
                }

                public void drawToken(Graphics g, int x, int y, LogViewerEntrySlot v) {
                    if (v.size() == 1) {
                        LogViewerEntry e = (LogViewerEntry)v.firstElement();
                        int type = this.getType(e.getData());
                        if (type == 1) {
                            this.drawTokenType(g, x, y, 1);
                        } else if (type == 0) {
                            this.drawTokenType(g, x, y, 0);
                        } else if (type == 2) {
                            this.drawTokenType(g, x, y, 2);
                        }
                    } else {
                        this.drawTokenType(g, x, y, 3);
                    }
                }

                public void drawTokenType(Graphics g, int x, int y, int type) {
                    Color c = g.getColor();
                    switch (type) {
                        case 0: {
                            g.setColor(LogViewer.getColor(1));
                            super.drawTokenType(g, x, y, 0);
                            break;
                        }
                        case 1: {
                            g.setColor(LogViewer.getColor(0));
                            super.drawTokenType(g, x, y, 0);
                            break;
                        }
                        case 2: {
                            g.setColor(LogViewer.getColor(0));
                            super.drawTokenType(g, x, y, 4);
                            break;
                        }
                        case 3: {
                            super.drawTokenType(g, x, y, 0);
                        }
                    }
                    g.setColor(c);
                }

                public String getTokenType(int type) {
                    switch (type) {
                        case 0: {
                            return "Action Started";
                        }
                        case 1: {
                            return "Action Completed";
                        }
                        case 2: {
                            return "Action Aborted";
                        }
                    }
                    return null;
                }

                public void select(LogViewerEntrySlot v, LogViewer viewer) {
                    Enumeration e = v.elements();
                    while (e.hasMoreElements()) {
                        LogViewerEntrySlot s;
                        Integer time;
                        String stime;
                        LogViewerEntry entry = (LogViewerEntry)e.nextElement();
                        int type = this.getType(entry.getData());
                        String agent = this.getAgent(entry.getData());
                        if (type == 1 || type == 2) {
                            stime = this.getStart(entry.getData());
                            time = Integer.valueOf(stime);
                            s = this.findAction(agent, this.getAction(entry.getData()), 0, time);
                            if (s == null || s.getColor() != null) continue;
                            s.setColor(Color.green);
                            this.myhighlights.addElement(s);
                            continue;
                        }
                        if (type != 0) continue;
                        stime = this.getTime(entry.getData());
                        time = Integer.valueOf(stime);
                        s = this.findAction(agent, this.getAction(entry.getData()), 1, time);
                        if (s != null && s.getColor() == null) {
                            s.setColor(Color.pink);
                            this.myhighlights.addElement(s);
                            continue;
                        }
                        if (s != null || (s = this.findAction(agent, this.getAction(entry.getData()), 2, time)) == null || s.getColor() != null) continue;
                        s.setColor(Color.red);
                        this.myhighlights.addElement(s);
                    }
                }

                public LogViewerEntrySlot findAction(String agent, String action, int type, Integer time) {
                    TreeMap t = this.getEntries(agent);
                    SortedMap map = type == 1 || type == 2 ? t.tailMap(time) : t.subMap(time, new Integer(time + 1));
                    Iterator i = map.values().iterator();
                    while (i.hasNext()) {
                        LogViewerEntrySlot v = (LogViewerEntrySlot)i.next();
                        Enumeration e = v.elements();
                        while (e.hasMoreElements()) {
                            LogViewerEntry entry = (LogViewerEntry)e.nextElement();
                            if (!this.getAction(entry.getData()).equals(action) || this.getType(entry.getData()) != type) continue;
                            return v;
                        }
                    }
                    return null;
                }

                public String getStart(String s) {
                    int i = s.indexOf("(S:") + 3;
                    return s.substring(i, s.indexOf(32, i));
                }

                public String getAction(String s) {
                    int i = s.indexOf("[Action") + 1;
                    return s.substring(i, s.indexOf(93, i));
                }

                public int getType(String s) {
                    int i = s.indexOf("Action ") + 7;
                    if ((s = s.substring(i, s.indexOf(58, i))).equals("Complete")) {
                        return 1;
                    }
                    if (s.equals("Start")) {
                        return 0;
                    }
                    if (s.equals("Abort")) {
                        return 2;
                    }
                    return -1;
                }
            });
        }
    }

    public void reset() {
        this.cancelAllActions("Reset");
    }

    public void end() {
    }

    public void pulse() {
        if (this.isExecuting()) {
            this.log.log("Executing current actions:", 4, this.FAC_EXECUTE);
            Enumeration e = this.actions();
            while (e.hasMoreElements()) {
                Action a = (Action)e.nextElement();
                this.log.log("Executing " + a, 4, this.FAC_EXECUTE);
                a.execute();
            }
        } else {
            this.log.log("I'm not executing anything right now.", 5, this.FAC_EXECUTE);
        }
    }

    public void addActionEventListener(ActionEventListener l) {
        this.listeners.add(l);
    }

    public void removeActionEventListener(ActionEventListener l) {
        this.listeners.remove(l);
    }

    protected void fireEvent(AgentEvent event) {
        ActionEvent e = (ActionEvent)event;
        Enumeration enumr = this.listeners.elements();
        this.log.log("Firing action event", 4, this.FAC_EXECUTE);
        block5: while (enumr.hasMoreElements()) {
            ActionEventListener l = (ActionEventListener)enumr.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0: {
                    l.actionStarted(e);
                    continue block5;
                }
                case 1: {
                    l.actionCompleted(e);
                    continue block5;
                }
                case 2: {
                    l.actionAborted(e);
                    continue block5;
                }
            }
        }
        if (this.log != null) {
            this.log.log(e, 2, this.FAC_EXECUTE);
        }
        this.log.log("Fired an action event", 5, this.FAC_EXECUTE);
    }

    public void executeAction(Action a) {
        this.log.log("Trying to execute action " + a, 3, this.FAC_EXECUTE);
        this.actions.insertElementAt(a, 0);
        a.setData("Status", "Running");
        a.setData("State", this.state);
        if (a.getStart() < 0) {
            a.setStart((Integer)this.state.getProperty("Time"));
        }
        a.start();
        this.startFireEvent(new ActionEvent(this, a, 0));
        this.log.log("Action " + a + " started", 3, this.FAC_EXECUTE);
    }

    public void completeAction(Action a) {
        boolean status = false;
        this.log.log("Trying to complete action " + a, 3, this.FAC_EXECUTE);
        status = this.actions.removeElement(a);
        if (status) {
            a.complete();
            a.setData("Status", "Completed");
            if (a.getFinish() < 0) {
                a.setFinish((Integer)this.state.getProperty("Time"));
            }
            a.setTime(a.getDuration());
            this.startFireEvent(new ActionEvent(this, a, 1));
        } else {
            this.log.log("Error: Tried to complete an action I don't know about", 0, this.FAC_EXECUTE);
        }
        this.log.log("Action " + a + " completed", 3, this.FAC_EXECUTE);
    }

    public Action statusAction(Action a) {
        a.setData("Status", "Unknown");
        a.setData("Update", this.state.getProperty("Time"));
        this.log.log("statusAction does not do anything right now", 0, this.FAC_EXECUTE);
        return a;
    }

    public boolean cancelAction(Action a, String reason) {
        boolean status = false;
        if (a == null) {
            return false;
        }
        this.log.log("Trying to cancel action " + a + " (" + reason + ")", 1, this.FAC_EXECUTE);
        status = this.actions.removeElement(a);
        if (status) {
            status = this.finishCancelAction(a, reason);
            if (status) {
                this.log.log("Action " + a + " cancelled", 2, this.FAC_EXECUTE);
            } else {
                this.log.log("Action " + a + " not cancelled", 1, this.FAC_EXECUTE);
            }
        } else {
            this.log.log("Error: Tried to cancel an action I don't know about", 0, this.FAC_EXECUTE);
        }
        return status;
    }

    protected boolean finishCancelAction(Action a, String reason) {
        boolean status = false;
        if (a == null) {
            return false;
        }
        a.cancel();
        a.setData("Status", "Aborted");
        a.setData("AbortReason", reason);
        a.setFinish((Integer)this.state.getProperty("Time"));
        a.setTime(a.getDuration());
        this.startFireEvent(new ActionEvent(this, a, 2));
        return true;
    }

    public void cancelAllActions(String reason) {
        Enumeration e = this.actions.elements();
        this.log.log("Cancelling all actions", 1, this.FAC_EXECUTE);
        while (e.hasMoreElements()) {
            this.cancelAction((Action)e.nextElement(), reason);
        }
        this.log.log("All actions should be cancelled now", 2, this.FAC_EXECUTE);
    }

    public Action findAction(String name) {
        Enumeration e = this.actions.elements();
        while (e.hasMoreElements()) {
            Action a = (Action)e.nextElement();
            if (!a.getName().equalsIgnoreCase(name)) continue;
            return a;
        }
        return null;
    }

    public Action findAction(long id) {
        Enumeration e = this.actions.elements();
        while (e.hasMoreElements()) {
            Action a = (Action)e.nextElement();
            if (a.getID() != id) continue;
            return a;
        }
        return null;
    }

    public Enumeration actions() {
        return this.actions.elements();
    }

    public boolean isExecuting() {
        return !this.actions.isEmpty();
    }

    public boolean isDone() {
        return !this.isExecuting();
    }

    public void actionPerformed(java.awt.event.ActionEvent e) {
        Object item = e.getSource();
        String command = e.getActionCommand();
        Action a = null;
        a = item instanceof ActionMenuItem ? ((ActionMenuItem)item).getAction() : this.findAction(command.toString());
        if (a == null) {
            System.err.println("Whoops, couldn't find action " + command.toString());
        } else {
            System.err.println(a.toString());
        }
    }

    public boolean hasPopupMenu() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 || e.isPopupTrigger()) {
            try {
                int i = 0;
                while (true) {
                    MenuItem m = menu.getItem(i);
                    m.removeActionListener(this);
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                menu.removeAll();
                if (this.isExecuting()) {
                    Enumeration en = this.actions();
                    while (en.hasMoreElements()) {
                        Action a = (Action)en.nextElement();
                        ActionMenuItem m = new ActionMenuItem(a);
                        m.addActionListener(this);
                        menu.add(m);
                    }
                } else {
                    MenuItem m = new MenuItem("None");
                    menu.add(m);
                }
                menu.show(this, e.getX(), e.getY());
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    class ActionMenuItem
    extends MenuItem {
        Action action;

        public ActionMenuItem(Action a) {
            super(a.getName());
            this.action = a;
            this.setLabel(this.getLabel() + " (" + this.action.getStart() + ")");
        }

        public Action getAction() {
            return this.action;
        }
    }
}

