/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.base.AgentComponent;
import agent.base.AgentFrame;
import agent.simplest.DependencyFailedException;
import agent.simplest.Log;
import agent.simplest.LogViewer;
import agent.simplest.LogViewerEntry;
import agent.simplest.LogViewerEntrySlot;
import agent.simplest.LogViewerFilter;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import utilities.Converter;

public class Control
extends AgentComponent
implements Runnable,
ActionListener,
MouseListener,
PropertyEventListener {
    static final long serialVersionUID = 4712010406850428679L;
    protected boolean dopulsing = true;
    protected boolean dopulse = false;
    protected int pulsedelay = 50;
    protected Log log;
    protected State state;
    protected int FAC_CTRL = -1;
    private transient Vector threads = new Vector(20);
    private transient Thread setup = null;
    private transient Thread controlthread = null;
    private static transient boolean started = false;
    private transient boolean hasQuit = false;
    private boolean paused = false;
    private int quittime = -1;
    private int pulsewarninglength = -1;
    private long lastpulseduration = -1L;
    private PopupMenu menu = new PopupMenu("Control Functions");
    private MenuItem pauseitem;
    private static Frame agentframe;
    private static Thread shutdownHook;
    public static final String AUTOPULSE = "AutoPulse";
    public static final String PULSEWARNINGLENGTH = "PulseWarningLength";
    public static final String AUTOPULSEDELAY = "AutoPulseDelay";
    public static final String QUITTIME = "QuitTime";
    public static final String COMPONENTS = "Components";

    public Control() {
        this(true);
    }

    public Control(boolean run) {
        this.addDependency("Log");
        this.addDependency("State");
        State.addParameterInfo(AUTOPULSE, "Boolean", "If true, Control will automatically pulse components.  This should be turned off if the agent's pulse cycle is driven by an external entity", Boolean.TRUE);
        State.addParameterInfo(AUTOPULSEDELAY, "Integer", "The amount of time to pause after a pulse cycle is complete", new Integer(50));
        State.addParameterInfo(QUITTIME, "Integer", "If set, the agent will quit when this time is reached");
        State.addParameterInfo(PULSEWARNINGLENGTH, "Integer", "Control will flag pulse log messages who's duration is greater that this value (-1 for no flagging)", new Integer(this.pulsewarninglength));
        try {
            shutdownHook = new Thread(){

                public void run() {
                    Control control = (Control)State.findComponent("Control");
                    Control.this.log("Shutdownhook is quitting the agent...", 2, Control.this.FAC_CTRL);
                    control.quit();
                }
            };
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        catch (NoSuchMethodError ex) {
            this.log("Failed to addShutdownHook, you may be running an older version of java", 1, this.FAC_CTRL);
        }
        if (run) {
            this.setup = Thread.currentThread();
            this.setup.setName("Setup");
        } else {
            this.setup = null;
        }
        this.addMouseListener(this);
        MenuItem m = new MenuItem("Pulse");
        m.addActionListener(this);
        this.menu.add(m);
        this.pauseitem = m = new MenuItem("Pause");
        m.addActionListener(this);
        this.menu.add(m);
        m = new MenuItem("Threads");
        m.addActionListener(this);
        this.menu.add(m);
        m = new MenuItem("Quit");
        m.addActionListener(this);
        this.menu.add(m);
        this.menu.addActionListener(this);
        this.add(this.menu);
        if (agentframe != null) {
            agentframe.addWindowListener(new WindowListener(){

                public void windowActivated(WindowEvent e) {
                }

                public void windowClosed(WindowEvent e) {
                }

                public void windowClosing(WindowEvent e) {
                    Control.this.quit();
                }

                public void windowDeactivated(WindowEvent e) {
                }

                public void windowDeiconified(WindowEvent e) {
                }

                public void windowIconified(WindowEvent e) {
                }

                public void windowOpened(WindowEvent e) {
                }
            });
        }
        if (run) {
            this.controlthread = new Thread(this);
            this.controlthread.setName("Control");
            this.controlthread.start();
        } else {
            started = true;
        }
    }

    public void run() {
        block18: {
            boolean wait = false;
            this.log("Waiting for setup thread " + this.setup.getName() + " to die...", 3, this.FAC_CTRL);
            try {
                this.setup.join();
            }
            catch (InterruptedException e) {
                this.log("Got exception while waiting for setup to die." + e, 0, this.FAC_CTRL);
                e.printStackTrace();
            }
            this.setup = null;
            started = true;
            try {
                this.setupComponents();
                if (this.dopulsing) {
                    while (this.dopulsing) {
                        if (!this.isPaused()) {
                            int time;
                            if (this.quittime > 0 && (time = ((Integer)this.state.getProperty("Time")).intValue()) > this.quittime) {
                                this.log.log("Quit time of " + this.quittime + " reached, quitting", 2, this.FAC_CTRL);
                                this.quit();
                            }
                            this.pulseComponents();
                        } else {
                            try {
                                Thread.currentThread();
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                        Thread.currentThread();
                        Thread.yield();
                    }
                    break block18;
                }
                while (!this.hasQuit) {
                    int time;
                    if (this.quittime > 0 && (time = ((Integer)this.state.getProperty("Time")).intValue()) > this.quittime) {
                        this.log.log("Quit time of " + this.quittime + " reached, quitting", 2, this.FAC_CTRL);
                        this.quit();
                    }
                    if (this.dopulse) {
                        this.pulseComponents();
                        this.dopulse = false;
                    } else {
                        try {
                            Thread.currentThread();
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    Thread.currentThread();
                    Thread.yield();
                }
            }
            catch (DependencyFailedException e) {
                this.log("Error: " + e.toString(), 0, this.FAC_CTRL);
            }
            catch (Exception e) {
                this.log("Error: " + e, 0, this.FAC_CTRL);
                e.printStackTrace();
            }
        }
        this.log("Control.run has ended.", 2, this.FAC_CTRL);
    }

    protected Thread getControlThread() {
        return this.controlthread;
    }

    public void doPulse() {
        if (this.dopulsing) {
            this.log.log("Warning doPulse called while auto-executing", 1, this.FAC_CTRL);
        }
        this.dopulse = true;
    }

    public void init() {
        this.log = (Log)State.findComponent("Log");
        this.state = (State)State.findComponent("State");
        this.state.addPropertyEventListener(this);
        this.FAC_CTRL = this.log.getFacilityID(this);
    }

    public void begin() {
        if (State.hasComponent("LogViewer")) {
            LogViewer viewer = (LogViewer)State.findComponent("LogViewer");
            viewer.addFilter(new LogViewerFilter("Heartbeat", false){

                public boolean isMyLogEntry(String s) {
                    return s.indexOf("Pulsing components") > 0;
                }

                public void drawToken(Graphics g, int x, int y, LogViewerEntrySlot v) {
                    Color c = g.getColor();
                    int type = 0;
                    LogViewerEntry e = (LogViewerEntry)v.firstElement();
                    if (e.getData().indexOf("excessive") > 0) {
                        type = 1;
                    }
                    this.drawTokenType(g, x, y, type);
                }

                public void drawTokenType(Graphics g, int x, int y, int type) {
                    Color c = g.getColor();
                    switch (type) {
                        default: {
                            g.setColor(Color.black);
                            super.drawTokenType(g, x, y, 17);
                            break;
                        }
                        case 1: {
                            g.setColor(Color.red);
                            super.drawTokenType(g, x, y, 19);
                        }
                    }
                    g.setColor(c);
                }

                public String getTokenType(int type) {
                    switch (type) {
                        case 0: {
                            return "Pulse";
                        }
                        case 1: {
                            return "Long Pulse";
                        }
                    }
                    return null;
                }
            });
        }
    }

    public void pulse() {
    }

    public void reset() {
        this.killThreads();
    }

    protected void finalize() {
        this.quit();
    }

    public void setupComponents() throws DependencyFailedException {
        this.checkDependencies();
        this.initComponents();
        this.startComponents();
    }

    public void checkDependencies() throws DependencyFailedException {
        int i;
        Enumeration c = State.components();
        String failed = "";
        String[] required = new String[]{"Control", "State"};
        for (i = 0; i < required.length; ++i) {
            if (State.hasComponent(required[i])) continue;
            throw new DependencyFailedException("Couldn't find required component " + required[i]);
        }
        while (c.hasMoreElements()) {
            AgentComponent component = (AgentComponent)c.nextElement();
            String[] dependencies = component.getDependencies();
            for (i = 0; i < dependencies.length; ++i) {
                if (State.hasComponent(dependencies[i])) continue;
                failed = failed + dependencies[i] + " ";
            }
        }
        if (!failed.equals("")) {
            throw new DependencyFailedException("Couldn't find dependency target(s) " + failed);
        }
    }

    public void initComponents() {
        Enumeration c = State.components();
        String components = "";
        if (this.log == null) {
            this.log = (Log)State.findComponent("Log");
        }
        this.log("Initing components", 2, this.FAC_CTRL);
        while (c.hasMoreElements()) {
            AgentComponent comp = (AgentComponent)c.nextElement();
            try {
                this.log("Initializing " + comp.getDescriptor(), 2, this.FAC_CTRL);
                comp.init();
                this.log(comp.getDescriptor() + " initialized", 2, this.FAC_CTRL);
            }
            catch (Exception e) {
                this.log("Exception thrown while initializing " + comp.getDescriptor() + ": " + e, 0, this.FAC_CTRL);
                e.printStackTrace();
            }
        }
    }

    public void startComponents() {
        Enumeration c = State.components();
        this.log("Starting components", 2, this.FAC_CTRL);
        while (c.hasMoreElements()) {
            AgentComponent comp = (AgentComponent)c.nextElement();
            try {
                this.log("Starting " + comp.getDescriptor(), 2, this.FAC_CTRL);
                comp.begin();
                this.log(comp.getDescriptor() + " started", 3, this.FAC_CTRL);
            }
            catch (Exception e) {
                this.log("Exception thrown while starting " + comp.getDescriptor() + ": " + e, 0, this.FAC_CTRL);
                e.printStackTrace();
            }
        }
    }

    public void stopComponents() {
        Enumeration c = State.components();
        this.log("Stopping components", 2, this.FAC_CTRL);
        while (c.hasMoreElements()) {
            AgentComponent comp = (AgentComponent)c.nextElement();
            try {
                this.log("Stopping " + comp.getDescriptor(), 2, this.FAC_CTRL);
                comp.end();
                this.log(comp.getDescriptor() + " stopped", 3, this.FAC_CTRL);
            }
            catch (Exception e) {
                this.log("Exception thrown while stopping " + comp.getDescriptor() + ": " + e, 0, this.FAC_CTRL);
                e.printStackTrace();
            }
        }
    }

    public void resetComponents() {
        Enumeration c = State.components();
        this.log("Resetting components", 2, this.FAC_CTRL);
        while (c.hasMoreElements()) {
            AgentComponent comp = (AgentComponent)c.nextElement();
            try {
                this.log("Resetting " + comp.getDescriptor(), 2, this.FAC_CTRL);
                comp.reset();
                this.log(comp.getDescriptor() + " reset", 3, this.FAC_CTRL);
            }
            catch (Exception e) {
                this.log("Exception thrown while resetting " + comp.getDescriptor() + ": " + e, 0, this.FAC_CTRL);
                e.printStackTrace();
            }
        }
    }

    public void pulseComponents() {
        Enumeration c = State.components();
        this.log("Pulsing components (last pulse " + this.lastpulseduration + (this.lastpulseduration > 0L && this.pulsewarninglength > 0 && this.lastpulseduration > (long)this.pulsewarninglength ? " was excessive" : "") + ")", 3, this.FAC_CTRL);
        long start = System.currentTimeMillis();
        if (this.pulsePreprocess()) {
            while (c.hasMoreElements()) {
                AgentComponent comp = (AgentComponent)c.nextElement();
                comp.pulse();
                this.log(comp.getDescriptor() + " pulsed", 5, this.FAC_CTRL);
            }
            this.pulsePostprocess();
        }
        this.lastpulseduration = System.currentTimeMillis() - start;
    }

    public boolean pulsePreprocess() {
        return true;
    }

    public void pulsePostprocess() {
        if (this.pulsedelay > 0) {
            try {
                Thread.currentThread();
                Thread.sleep(this.pulsedelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void restartComponents() {
        this.log("Restarting components", 2, this.FAC_CTRL);
        this.resetComponents();
        this.startComponents();
    }

    public void registerThread(Thread t) {
        this.threads.addElement(t);
    }

    public boolean unregisterThread(Thread t) {
        return this.threads.removeElement(t);
    }

    public void suspendThreads() {
        Enumeration e = this.threads.elements();
        this.log("Not suspending threads", 1, this.FAC_CTRL);
    }

    public void resumeThreads() {
        Enumeration e = this.threads.elements();
        this.log("Not resuming threads", 1, this.FAC_CTRL);
    }

    public void killThreads() {
        Enumeration e = this.threads.elements();
        this.log("Not killing threads", 1, this.FAC_CTRL);
        while (e.hasMoreElements()) {
            Thread t = (Thread)e.nextElement();
        }
    }

    public void dumpThreads() {
        int count = Thread.activeCount();
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        for (int i = 0; i < threads.length; ++i) {
            Thread t = threads[i];
            if (t == null) continue;
            System.err.println(t.toString());
        }
    }

    public void quit() {
        if (!(this.setup != null && this.setup.isAlive() || this.hasQuit)) {
            this.hasQuit = true;
            this.log("Quitting", 2, this.FAC_CTRL);
            this.dopulsing = false;
            try {
                this.stopComponents();
            }
            catch (Exception e) {
                this.log("Exception thrown while stopping components: " + e, 0, this.FAC_CTRL);
                e.printStackTrace();
            }
            if (Thread.currentThread() != shutdownHook) {
                System.runFinalization();
                System.exit(0);
            }
        } else if (this.setup != null && this.setup.isAlive()) {
            this.log("Error, cannot quit while setup thread is still active", 0, this.FAC_CTRL);
        }
    }

    public static boolean hasStarted() {
        return started;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean p) {
        if (p != this.isPaused()) {
            this.paused = p;
            if (this.isPaused()) {
                if (this.pauseitem != null) {
                    this.pauseitem.setLabel("Unpause");
                }
                this.log("Pausing...", 2, this.FAC_CTRL);
            } else if (this.pauseitem != null) {
                this.pauseitem.setLabel("Pause");
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Quit")) {
            this.quit();
        } else if (command.equals("Restart")) {
            this.restartComponents();
        } else if (command.equals("Pulse")) {
            this.pulseComponents();
        } else if (command.equals("Pause")) {
            this.setPaused(true);
        } else if (command.equals("Threads")) {
            this.dumpThreads();
        } else if (command.equals("Unpause")) {
            this.setPaused(false);
        }
    }

    public boolean hasPopupMenu() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 || e.isPopupTrigger()) {
            this.menu.show(this, e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyChanged(PropertyEvent e) {
    }

    public void propertyAdded(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase(AUTOPULSE)) {
            this.dopulsing = (Boolean)e.getProperty();
        } else if (key.equalsIgnoreCase(AUTOPULSEDELAY)) {
            this.pulsedelay = (Integer)e.getProperty();
        } else if (key.equalsIgnoreCase(PULSEWARNINGLENGTH)) {
            this.pulsewarninglength = (Integer)e.getProperty();
        } else if (key.equalsIgnoreCase(QUITTIME)) {
            this.quittime = (Integer)e.getProperty();
        }
    }

    protected void log(String str, int level, int fac) {
        if (this.log != null && fac >= 0) {
            this.log.log(str, level, fac);
        } else {
            utilities.Log.getDefault().log(str, level);
        }
    }

    protected static void parseConfigFile(BufferedReader r) throws IOException {
        String s;
        while ((s = r.readLine()) != null) {
            if ((s = s.trim()).startsWith("#") || s.startsWith(";") || s.length() == 0) continue;
            if (s.indexOf(":") > 0) {
                String name = s.substring(0, s.indexOf(":")).trim();
                String value = s.substring(s.indexOf(":") + 1).trim();
                if (System.getProperty(name) == null) {
                    utilities.Log.getDefault().log("Setting " + name + ":" + value, 4);
                    System.setProperty(name, value);
                    continue;
                }
                utilities.Log.getDefault().log("Keeping existing " + name + ":" + System.getProperty(name), 4);
                continue;
            }
            utilities.Log.getDefault().log("Unknown configuration line: " + s, 1);
        }
    }

    public static void main(String[] args) {
        Vector v = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--config") && i + 1 < args.length) {
                try {
                    FileReader file = new FileReader(args[i + 1]);
                    Control.parseConfigFile(new BufferedReader(file));
                }
                catch (IOException e) {
                    utilities.Log.getDefault().log("Error reading from file " + args[i + 1] + "\n" + e, 0);
                }
                ++i;
                continue;
            }
            if (args[i].equals("--jarconfig") && i + 2 < args.length) {
                try {
                    ZipFile jarfile = new ZipFile(args[i + 1]);
                    ZipEntry jarentry = jarfile.getEntry(args[i + 2]);
                    Control.parseConfigFile(new BufferedReader(new InputStreamReader(jarfile.getInputStream(jarentry))));
                }
                catch (IOException e) {
                    utilities.Log.getDefault().log("Error reading from jar file " + args[i + 1] + "\n" + e, 0);
                }
                i += 2;
                continue;
            }
            if (args[i].equals("--help") || args[i].equals("-h")) {
                Control.usage();
                continue;
            }
            utilities.Log.getDefault().log("Unknown argument " + args[i], 0);
            Control.usage();
        }
        if (System.getProperty(COMPONENTS) != null && v == null) {
            String s = System.getProperty(COMPONENTS);
            v = (Vector)Converter.reTypeProperty((String)s, (String)"Vector");
        }
        if (v != null && !v.isEmpty()) {
            AgentFrame f = new AgentFrame("Agent", v);
            agentframe = f;
            Thread t = new Thread(f);
            t.setName("Setup");
            t.start();
        } else {
            utilities.Log.getDefault().log("Error: no components found to load", 0);
            Control.usage();
        }
        utilities.Log.getDefault().log("Control main ending", 3);
        utilities.Log.getDefault().log("Threads I know about:", 3);
        Thread[] list = new Thread[20];
        int i = Thread.enumerate(list);
        --i;
        while (i >= 0) {
            utilities.Log.getDefault().log("  " + list[i].getName(), 3);
            --i;
        }
    }

    public static void usage() {
        System.err.println("usage: java Control [--config config.file] [--jarconfig file.jar config.file]");
        System.err.println(" --config    : Read configuration from config.file");
        System.err.println(" --jarconfig : Read configuration from config.file in file.jar");
        System.err.println(" --help      : Print this help message");
        System.err.println("The Components line in the config file specifies the components to load.");
        System.exit(0);
    }
}

