/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.base.ListenerVector;
import agent.simplest.Control;
import agent.simplest.Log;
import agent.simplest.LogViewer;
import agent.simplest.LogViewerEntry;
import agent.simplest.LogViewerEntrySlot;
import agent.simplest.LogViewerFilter;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.Observe;
import agent.simplest.Observer;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import utilities.Connection;
import utilities.KQMLMessage;
import utilities.LengthPrefixMessage;
import utilities.Message;

public class Communicate
extends AgentComponent
implements PropertyEventListener,
Runnable,
MouseListener {
    static final long serialVersionUID = 1234567890L;
    protected static final int RECIEVE_DELAY = 50;
    public static final String SEQUENCE = "sequence";
    protected ListenerVector listeners = new ListenerVector();
    protected transient ServerSocket servsocket;
    protected transient Vector oqueue;
    protected transient Vector iqueue;
    protected transient Vector connections = new Vector();
    protected transient int thread = 0;
    protected int FAC_COM;
    protected Hashtable remotes = new Hashtable();
    protected Thread recv;
    protected Thread acpt;
    private static PopupMenu menu = new PopupMenu("Communicate");
    protected Log log;
    protected State state;
    protected Control control;
    private String remoteaddr = null;
    private int remoteport = -1;
    private int serverport = -1;
    protected int send = 0;
    protected int receive = 0;
    protected boolean queue = false;
    protected boolean ready = false;
    protected int deftype = 1;
    public static final String HOST = "Host";
    public static final String PORT = "Port";
    public static final String SERVERPORT = "ServerPort";
    public static final String REMOTEHOSTS = "RemoteHosts";
    public static final String CONNECTIONS = "Connections";
    public static final String QUEUEMESSAGES = "QueueMessages";
    private static final Integer tlock = new Integer(0);

    public Communicate() {
        this.oqueue = new Vector(10);
        this.iqueue = new Vector(10);
        State.addParameterInfo(HOST, "String", "If specified, the agent will automatically connect to this host address when it starts up");
        State.addParameterInfo(PORT, "Integer", "The port number of the Host to connect to (-1 = don't connect)", new Integer(-1));
        State.addParameterInfo(SERVERPORT, "Integer", "The port number this agent should listen on for new connections (-1 = don't listen)", new Integer(-1));
        State.addParameterInfo(REMOTEHOSTS, "Hashtable", "Listing of remote agent's host addresses and ports.  If a message's destination agent is in this list, the respective host address and port are used for delivery. (e.g. AgentA,foo.bar.org:5000,AgentB,foo.bar.org:5001...)");
        State.addParameterInfo(CONNECTIONS, "Hashtable", "Connection type specifications (see addConnection)");
        State.addParameterInfo(QUEUEMESSAGES, "Boolean", "If true, incoming messages will be queued and locally delivered only at pulse time in the primary control thread.  Otherwise they are delived directly from the message receiving thread.", Boolean.TRUE);
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Control");
        this.addMouseListener(this);
        this.add(menu);
    }

    public void end() {
        this.flushOQueue();
        this.closeAllConnections();
        this.closeserver();
        if (this.log == null) {
            return;
        }
        this.log.log("Communication Summary:", 2, this.FAC_COM);
        this.log.log("           Sent: " + this.send, 2, this.FAC_COM);
        this.log.log("       Received: " + this.receive, 2, this.FAC_COM);
    }

    public String getRemoteHostAddr() {
        return this.remoteaddr;
    }

    public void setRemoteHostAddr(String ra) {
        this.remoteaddr = ra;
        if (this.state != null) {
            this.state.setProperty(HOST, ra);
        }
    }

    public int getRemoteHostPort() {
        return this.remoteport;
    }

    public void setRemoteHostPort(int rp) {
        this.remoteport = rp;
        if (this.state != null) {
            this.state.setProperty(PORT, new Integer(rp));
        }
    }

    public int getServerPort() {
        return this.serverport;
    }

    public void setServerPort(int sp) {
        this.serverport = sp;
        if (this.state != null) {
            this.state.setProperty(SERVERPORT, new Integer(sp));
        }
    }

    public void init() {
        this.log = (Log)State.findComponent("Log");
        this.state = (State)State.findComponent("State");
        this.control = (Control)State.findComponent("Control");
        this.FAC_COM = this.log.getFacilityID(this);
        this.state.addPropertyEventListener(this);
        if (State.hasComponent("Observe")) {
            Observe observe = (Observe)State.findComponent("Observe");
            observe.addObserver(new Observer("Messages Sent"){

                public boolean checkEvent(AgentEvent e) {
                    return e instanceof MessageEvent && e.getID() == 0;
                }
            });
            observe.addObserver(new Observer("Messages Received"){

                public boolean checkEvent(AgentEvent e) {
                    return e instanceof MessageEvent && e.getID() == 1;
                }
            });
        }
        this.log.log("Communicate component initialized", 4, this.FAC_COM);
    }

    public void begin() {
        this.log.log("Communicate component starting", 4, this.FAC_COM);
        if (State.hasComponent("LogViewer")) {
            LogViewer viewer = (LogViewer)State.findComponent("LogViewer");
            viewer.addFilter(new LogViewerFilter("Msg Sent", false){

                public boolean isMyLogEntry(String s) {
                    return s.indexOf("Message Sent: ") != -1;
                }

                public String formatMyLogEntry(String s) {
                    return "From: " + this.getAgent(s) + "\n" + "To: " + this.getTo(s) + "\n" + "Mesg: " + s.substring(s.indexOf(34));
                }

                public void drawToken(Graphics g, int x, int y, LogViewerEntrySlot v) {
                    Color c = g.getColor();
                    if (v.size() == 1) {
                        LogViewerEntry e = (LogViewerEntry)v.firstElement();
                        String to = this.getTo(e.getData());
                        g.setColor(LogViewer.getColor(to));
                    }
                    this.drawTokenType(g, x, y, 0);
                    g.setColor(c);
                }

                public void drawTokenType(Graphics g, int x, int y, int type) {
                    super.drawTokenType(g, x, y, 2);
                }

                public String getTokenType(int type) {
                    switch (type) {
                        case 0: {
                            return "Message Sent (color is destination)";
                        }
                    }
                    return null;
                }

                public String getTo(String s) {
                    int i = s.indexOf("(to ") + 4;
                    return s.substring(i, s.indexOf(41, i));
                }

                public String getUID(String s) {
                    int i = s.indexOf(":uid ") + 5;
                    if (i < 0) {
                        return null;
                    }
                    return s.substring(i, s.indexOf(32, i));
                }

                public void select(LogViewerEntrySlot v, LogViewer viewer) {
                    Enumeration e = v.elements();
                    LogViewerFilter msgrecv = this.findLogViewerFilter("Msg Recv");
                    if (msgrecv == null || !msgrecv.isActive()) {
                        return;
                    }
                    while (e.hasMoreElements()) {
                        String agent;
                        TreeMap t;
                        LogViewerEntry entry = (LogViewerEntry)e.nextElement();
                        String uid = this.getUID(entry.getData());
                        if (uid == null || (t = msgrecv.getEntries(agent = this.getTo(entry.getData()))) == null) continue;
                        Iterator i = t.values().iterator();
                        block1: while (i.hasNext()) {
                            LogViewerEntrySlot s = (LogViewerEntrySlot)i.next();
                            Enumeration se = s.elements();
                            while (se.hasMoreElements()) {
                                LogViewerEntry sentry = (LogViewerEntry)se.nextElement();
                                String euid = this.getUID(sentry.getData());
                                if (euid == null || !uid.equals(euid)) continue;
                                s.setColor(Color.pink);
                                this.myhighlights.addElement(s);
                                continue block1;
                            }
                        }
                    }
                }
            });
            viewer.addFilter(new LogViewerFilter("Msg Recv"){

                public boolean isMyLogEntry(String s) {
                    return s.indexOf("Message Received: ") != -1;
                }

                public String formatMyLogEntry(String s) {
                    return "From: " + this.getFrom(s) + "\n" + "To: " + this.getAgent(s) + "\n" + "Mesg: " + s.substring(s.indexOf(34));
                }

                public void drawToken(Graphics g, int x, int y, LogViewerEntrySlot v) {
                    Color c = g.getColor();
                    if (v.size() == 1) {
                        LogViewerEntry e = (LogViewerEntry)v.firstElement();
                        String from = this.getFrom(e.getData());
                        g.setColor(LogViewer.getColor(from));
                    }
                    this.drawTokenType(g, x, y, 1);
                    g.setColor(c);
                }

                public void drawTokenType(Graphics g, int x, int y, int type) {
                    super.drawTokenType(g, x, y, 1);
                }

                public String getTokenType(int type) {
                    switch (type) {
                        case 0: {
                            return "Message Received (color is source)";
                        }
                    }
                    return null;
                }

                public String getFrom(String s) {
                    int i = s.indexOf("(from ") + 6;
                    return s.substring(i, s.indexOf(41, i));
                }

                public String getUID(String s) {
                    int i = s.indexOf(":uid ") + 5;
                    if (i < 0) {
                        return null;
                    }
                    return s.substring(i, s.indexOf(32, i));
                }

                public void select(LogViewerEntrySlot v, LogViewer viewer) {
                    Enumeration e = v.elements();
                    LogViewerFilter msgrecv = this.findLogViewerFilter("Msg Sent");
                    if (msgrecv == null || !msgrecv.isActive()) {
                        return;
                    }
                    while (e.hasMoreElements()) {
                        String agent;
                        TreeMap t;
                        LogViewerEntry entry = (LogViewerEntry)e.nextElement();
                        String uid = this.getUID(entry.getData());
                        if (uid == null || (t = msgrecv.getEntries(agent = this.getFrom(entry.getData()))) == null) continue;
                        Iterator i = t.values().iterator();
                        block1: while (i.hasNext()) {
                            LogViewerEntrySlot s = (LogViewerEntrySlot)i.next();
                            Enumeration se = s.elements();
                            while (se.hasMoreElements()) {
                                LogViewerEntry sentry = (LogViewerEntry)se.nextElement();
                                String euid = this.getUID(sentry.getData());
                                if (euid == null || !uid.equals(euid)) continue;
                                s.setColor(Color.green);
                                this.myhighlights.addElement(s);
                                continue block1;
                            }
                        }
                    }
                }
            });
        }
        if (this.serverport > -1) {
            this.openserver(this.serverport);
        }
        if (this.remoteaddr != null && this.remoteport > -1) {
            this.open(this.remoteaddr, this.remoteport, this.deftype);
        }
        this.recv = new Thread(this);
        this.recv.setName("Msg Receiver");
        this.recv.setDaemon(true);
        this.control.registerThread(this.recv);
        this.recv.start();
        Thread.yield();
        this.acpt = new Thread(this);
        this.acpt.setName("Con Listener");
        this.acpt.setDaemon(true);
        this.acpt.setPriority(this.acpt.getPriority() - 1);
        this.control.registerThread(this.acpt);
        this.acpt.start();
        this.log.log("Communicate component started", 5, this.FAC_COM);
        this.ready = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.closeAllConnections();
        this.closeserver();
        Vector vector = this.oqueue;
        synchronized (vector) {
            this.oqueue.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean mess = false;
        Integer n = tlock;
        synchronized (n) {
            if (this.thread++ == 0) {
                mess = true;
            }
        }
        if (mess) {
            this.log.log("Starting message receive loop", 3, this.FAC_COM);
            while (true) {
                try {
                    if (!this.control.isPaused()) {
                        this.flushOQueue();
                        this.receiveMessage();
                    }
                }
                catch (Exception e) {
                    this.log.log("Error: " + e, 0, this.FAC_COM);
                    e.printStackTrace();
                }
                try {
                    Thread.yield();
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
        this.log.log("Starting connection acceptance loop", 3, this.FAC_COM);
        while (true) {
            try {
                if (!this.control.isPaused()) {
                    this.accept();
                }
            }
            catch (Exception e) {
                this.log.log("Error: " + e, 0, this.FAC_COM);
                e.printStackTrace();
            }
            try {
                Thread.yield();
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                this.log.log(e.toString(), 0, this.FAC_COM);
                continue;
            }
            break;
        }
    }

    public void pulse() {
        this.flushIQueue();
    }

    public void addMessageEventListener(MessageEventListener l) {
        this.listeners.add(l);
    }

    public void removeMessageEventListener(MessageEventListener l) {
        this.listeners.remove(l);
    }

    protected void fireEvent(AgentEvent event) {
        MessageEvent e = (MessageEvent)event;
        this.log.log("Firing a message event", 4, this.FAC_COM);
        Enumeration enumr = this.listeners.elements();
        block4: while (enumr.hasMoreElements()) {
            MessageEventListener l = (MessageEventListener)enumr.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0: {
                    l.messageSent(e);
                    continue block4;
                }
                case 1: {
                    l.messageReceived(e);
                    continue block4;
                }
            }
        }
        if (this.log != null) {
            this.log.log(e, 2, this.FAC_COM);
        }
        this.log.log("Fired a message event", 5, this.FAC_COM);
    }

    public void open(String host, int port, int type) {
        if (port < 0) {
            return;
        }
        this.log.log("Trying to connect to " + host + " at port " + port, 2, this.FAC_COM);
        try {
            Socket socket;
            String alth = this.getAlternateHostAddr(host);
            int altp = this.getAlternateHostPort(host);
            if (alth != null) {
                host = alth;
            }
            if (altp > -1) {
                port = altp;
            }
            if ((socket = new Socket(InetAddress.getByName(host), port)) != null) {
                this.addConnection(new Connection(socket, type, false));
                this.log.log("Connected to " + host + " at port " + port, 3, this.FAC_COM);
            } else {
                this.log.log("Error connecting to host " + host + " at port " + port, 0, this.FAC_COM);
            }
        }
        catch (Exception e) {
            this.log.log("Error connecting to host " + host + " at port " + port + ": " + e, 0, this.FAC_COM);
            e.printStackTrace();
        }
    }

    public String getAlternateHostAddr(String host) {
        if (this.remotes.containsKey(host) && (host = (String)this.remotes.get(host)).indexOf(":") != -1) {
            return host.substring(0, host.indexOf(":"));
        }
        return null;
    }

    public int getAlternateHostPort(String host) {
        if (this.remotes.containsKey(host) && (host = (String)this.remotes.get(host)).indexOf(":") != -1) {
            return Integer.parseInt(host.substring(host.indexOf(":") + 1));
        }
        return -1;
    }

    public void closeAllConnections() {
        Enumeration e = this.connections.elements();
        while (e.hasMoreElements()) {
            this.close((Connection)e.nextElement());
        }
        this.connections.removeAllElements();
    }

    public synchronized void close(Connection c) {
        this.log.log("Closing the socket ", 3, this.FAC_COM);
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                this.log.log((Object)e, 0, this.FAC_COM);
            }
        }
    }

    public void openserver(int port) {
        if (port <= 0) {
            return;
        }
        this.log.log("Trying to open server at port " + port, 2, this.FAC_COM);
        if (this.servsocket == null) {
            try {
                this.servsocket = new ServerSocket(port);
                this.log.log("Opened a server at port " + port, 3, this.FAC_COM);
            }
            catch (IOException e) {
                this.log.log("Error opening server port at " + port + ": " + e, 0, this.FAC_COM);
                e.printStackTrace();
            }
        } else {
            this.log.log("Error: Server socket already established", 0, this.FAC_COM);
        }
    }

    public void accept() {
        if (this.servsocket == null) {
            return;
        }
        this.log.log("Trying to accept a connection", 4, this.FAC_COM);
        if (this.servsocket != null) {
            try {
                Socket socket = this.servsocket.accept();
                Connection c = new Connection(socket, this.deftype, true);
                this.addConnection(c);
                this.log.log("Got a connection", 3, this.FAC_COM);
            }
            catch (SocketException e) {
                this.log.log("Got a socket exception, exiting connection accept: " + e, 2, this.FAC_COM);
            }
            catch (IOException e) {
                this.log.log("Error accepting connections: " + e, 0, this.FAC_COM);
                e.printStackTrace();
            }
        } else {
            this.log.log("Error: attempt to accept with no server listening", 0, this.FAC_COM);
        }
    }

    public synchronized void closeserver() {
        if (this.servsocket != null) {
            try {
                this.servsocket.close();
                this.log.log("Server (listen) connection closed.", 2, this.FAC_COM);
                this.servsocket = null;
            }
            catch (IOException e) {
                this.log.log("Error closing the server: " + e, 0, this.FAC_COM);
                e.printStackTrace();
            }
        }
    }

    public Enumeration getConnections() {
        return this.connections.elements();
    }

    public Connection findConnection(String host) {
        Enumeration e = this.connections.elements();
        while (e.hasMoreElements()) {
            Connection c = (Connection)e.nextElement();
            String name = c.getRemoteHostName();
            int port = c.getRemotePort();
            if (name != null && name.equalsIgnoreCase(host)) {
                return c;
            }
            String altn = this.getAlternateHostAddr(host);
            int altp = this.getAlternateHostPort(host);
            if (name == null || altn == null || !name.equalsIgnoreCase(altn) || port != altp) continue;
            return c;
        }
        return null;
    }

    public Connection findDefaultConnection() {
        Enumeration e = this.connections.elements();
        while (e.hasMoreElements()) {
            Connection c = (Connection)e.nextElement();
            if (!c.isDefault()) continue;
            return c;
        }
        return null;
    }

    public void setDefaultConnection(Connection c) {
        Enumeration e = this.connections.elements();
        while (e.hasMoreElements()) {
            ((Connection)e.nextElement()).setDefault(false);
        }
        c.setDefault(true);
        this.log.log("Connection [" + c + "] set to default.", 2, this.FAC_COM);
    }

    public void addConnection(Connection c) {
        if (this.state.hasProperty(CONNECTIONS)) {
            Hashtable connections = (Hashtable)this.state.getProperty(CONNECTIONS);
            String host = c.getRemoteHostName();
            int type = -1;
            if (host == null) {
                host = "???";
            }
            int port = c.wasAccepted() ? c.getLocalPort() : c.getRemotePort();
            if (connections.containsKey(host + ":" + port)) {
                type = Integer.parseInt((String)connections.get(host + ":" + port));
            } else if (c.wasAccepted() && connections.containsKey("" + port)) {
                type = Integer.parseInt((String)connections.get("" + port));
            } else if (connections.containsKey(host)) {
                type = Integer.parseInt((String)connections.get(host));
            } else if (connections.containsKey("*")) {
                type = Integer.parseInt((String)connections.get("*"));
            }
            if (type >= 0) {
                c.setType(type);
                this.log.log("Reset type of connection [" + c + "]", 4, this.FAC_COM);
            } else {
                this.log.log("Unspecified type for connection [" + c + "]", 1, this.FAC_COM);
            }
        }
        this.connections.addElement(c);
        this.log.log("Added connection " + c, 2, this.FAC_COM);
    }

    public void removeConnection(Connection c, boolean close) {
        if (this.connections.removeElement(c) && close) {
            this.close(c);
        }
        this.log.log("Removed connection " + c, 2, this.FAC_COM);
    }

    public boolean ready() {
        return this.ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(Message m) {
        boolean success = false;
        this.log.log("Trying to send a message to " + m.getDestAddr(), 3, this.FAC_COM);
        if (this.ready()) {
            this.log.log("Sending message \"" + m.getData() + "\"", 4, this.FAC_COM);
            Connection c = this.findConnection(m.getDestAddr());
            if (c == null) {
                this.open(m.getDestAddr(), m.getDestPort(), this.deftype);
                c = this.findConnection(m.getDestAddr());
            }
            if (c == null) {
                c = this.findDefaultConnection();
            }
            if (c != null) {
                this.log.log("Using connection [" + c + "] to send message.", 5, this.FAC_COM);
                if (m.getSourceAddr() == null || m.getSourceAddr().equals("")) {
                    m.setSourceAddr(c.getLocalHostName());
                }
                if (m.getSourcePort() == 0) {
                    m.setSourcePort(c.getLocalPort());
                }
                BufferedWriter bufferedWriter = c.getOutput();
                synchronized (bufferedWriter) {
                    success = m.send(c.getOutput(), c.getDelim());
                }
            } else {
                this.log.log("Error, could not find appropriate connection to send message on.", 0, this.FAC_COM);
            }
            if (success) {
                ++this.send;
                m.setSendTime(((Integer)this.state.getProperty("Time")).intValue());
                this.startFireEvent(new MessageEvent(this, m, c, 0));
            } else {
                this.log.log("Failed sending message: " + m, 0, this.FAC_COM);
            }
        } else {
            this.log.log("Attempted to send message before connection was established, queueing", 1, this.FAC_COM);
            Vector vector = this.oqueue;
            synchronized (vector) {
                this.oqueue.addElement(m);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushIQueue() {
        this.log.log("Flushing incoming message queue (size" + this.iqueue.size() + ")", 3, this.FAC_COM);
        while (!this.iqueue.isEmpty()) {
            MessageEvent e = null;
            Vector vector = this.iqueue;
            synchronized (vector) {
                e = (MessageEvent)this.iqueue.firstElement();
                if (!this.iqueue.removeElement(e)) {
                    this.log.log("Error removing message event from input queue", 0, this.FAC_COM);
                }
            }
            if (e == null) continue;
            this.startFireEvent(e);
        }
        this.log.log("Done flushing incoming message queue", 5, this.FAC_COM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushOQueue() {
        if (!this.ready()) {
            return;
        }
        this.log.log("Flushing outgoing message queue (size " + this.oqueue.size() + ")", 3, this.FAC_COM);
        Vector vector = this.oqueue;
        synchronized (vector) {
            Enumeration e = this.oqueue.elements();
            Vector<Message> remove = new Vector<Message>();
            while (e.hasMoreElements()) {
                Message m = (Message)e.nextElement();
                if (!this.sendMessage(m)) {
                    this.log.log("Warning, could not send message", 0, this.FAC_COM);
                    continue;
                }
                remove.addElement(m);
            }
            e = remove.elements();
            while (e.hasMoreElements()) {
                this.oqueue.removeElement(e.nextElement());
            }
        }
        this.log.log("Done flushing outgoing message queue", 5, this.FAC_COM);
    }

    public void receiveMessage() {
        this.receiveMessage(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveMessage(boolean ret) {
        boolean gotone = false;
        this.log.log("Looking for incoming messages...", 5, this.FAC_COM);
        try {
            Enumeration e = this.connections.elements();
            while (e.hasMoreElements()) {
                LengthPrefixMessage m;
                Connection c = (Connection)e.nextElement();
                BufferedReader input = c.getInput();
                if (input == null || !input.ready()) continue;
                this.log.log("Trying to receive a message on connection " + c, 3, this.FAC_COM);
                BufferedReader bufferedReader = input;
                synchronized (bufferedReader) {
                    switch (c.getType()) {
                        case 1: {
                            m = new KQMLMessage(KQMLMessage.receive((BufferedReader)input, (String)c.getDelim()));
                            break;
                        }
                        case 2: {
                            m = new LengthPrefixMessage(LengthPrefixMessage.receive((BufferedReader)input));
                            break;
                        }
                        default: {
                            m = new Message((Object)Message.receive((BufferedReader)input, (String)c.getDelim()));
                        }
                    }
                }
                this.log.log("Finished getting message, " + m.getData().length() + " bytes read", 5, this.FAC_COM);
                ++this.receive;
                gotone = true;
                this.messagePreprocess((Message)m, c);
                this.messagePostprocess((Message)m, c);
                if (!ret) continue;
                return m;
            }
        }
        catch (IOException e) {
            this.log.log("Error receiving message: " + e, 0, this.FAC_COM);
            e.printStackTrace();
        }
        if (!gotone) {
            try {
                Thread.currentThread();
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean messagePreprocess(Message m, Connection c) {
        m.setReceiveTime(((Integer)this.state.getProperty("Time")).intValue());
        if (m.getSourceAddr() == null || m.getSourceAddr().equals("")) {
            m.setSourceAddr(c.getRemoteHostName());
        }
        if (m.getSourcePort() == 0) {
            m.setSourcePort(c.getRemotePort());
        }
        if (m.getDestAddr() == null || m.getDestAddr().equals("")) {
            m.setDestAddr(c.getLocalHostName());
        }
        if (m.getDestPort() == 0) {
            m.setDestPort(c.getLocalPort());
        }
        if (c == null) {
            this.log.log("Warning: No connection specified for message", 1, this.FAC_COM);
        } else {
            m.setConnection(c);
        }
        if (!this.queue) {
            this.startFireEvent(new MessageEvent(this, m, c, 1));
            return true;
        }
        this.log.log("Queing incoming message", 5, this.FAC_COM);
        Vector vector = this.iqueue;
        synchronized (vector) {
            this.iqueue.addElement(new MessageEvent(this, m, c, 1));
        }
        return false;
    }

    public void messagePostprocess(Message m, Connection c) {
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyChanged(PropertyEvent e) {
        this.propertyAdded(e);
    }

    public void propertyAdded(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equals(PORT)) {
            this.remoteport = (Integer)e.getProperty();
        } else if (key.equals(HOST)) {
            this.remoteaddr = (String)e.getProperty();
        } else if (key.equals(SERVERPORT)) {
            this.serverport = (Integer)e.getProperty();
        } else if (key.equals(QUEUEMESSAGES)) {
            this.queue = (Boolean)e.getProperty();
        } else if (key.equals(REMOTEHOSTS)) {
            this.remotes = (Hashtable)e.getProperty();
        }
    }

    public boolean hasPopupMenu() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if ((e.getID() == 501 || e.isPopupTrigger()) && (e.getID() == 501 || e.isPopupTrigger())) {
            menu.removeAll();
            MenuItem item = new MenuItem("Print Incoming Messages");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Enumeration e = Communicate.this.iqueue.elements();
                    while (e.hasMoreElements()) {
                        Message m = (Message)e.nextElement();
                        System.err.println(m);
                    }
                }
            });
            menu.add(item);
            item = new MenuItem("Print Outgoing Messages");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Enumeration e = Communicate.this.oqueue.elements();
                    while (e.hasMoreElements()) {
                        Message m = (Message)e.nextElement();
                        System.err.println(m);
                    }
                }
            });
            menu.add(item);
            Enumeration en = this.getConnections();
            if (en.hasMoreElements()) {
                while (en.hasMoreElements()) {
                    Connection c = (Connection)en.nextElement();
                    item = new MenuItem(c.getRemoteHostName());
                    item.addActionListener(new MyConnectionMenuListener(c));
                    menu.add(item);
                }
            } else {
                item = new MenuItem("None");
                menu.add(item);
                item.setEnabled(false);
            }
            menu.show(this, e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    class MyConnectionMenuListener
    implements ActionListener {
        Connection c;

        public MyConnectionMenuListener(Connection c) {
            this.c = c;
        }

        public void actionPerformed(ActionEvent event) {
            System.err.println(this.c.toString());
        }
    }
}

