/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.base.AgentComponent;
import agent.simplest.Action;
import agent.simplest.ActionEvent;
import agent.simplest.ActionEventListener;
import agent.simplest.Execute;
import agent.simplest.Log;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import utilities.Converter;
import utilities.Distribution;
import utilities.SortedIterator;

public class ActionMonitor
extends AgentComponent
implements ActionEventListener,
PropertyEventListener,
MouseListener {
    static final long serialVersionUID = 1234567890L;
    protected static final int AVERAGE = 0;
    protected static final int MAXIMUM = 1;
    protected Log log;
    protected Execute execute;
    protected State state;
    protected int FAC_AM;
    private static PopupMenu menu = new PopupMenu("Actions");
    private Hashtable durations = new Hashtable();
    private int datasize = 5;
    private int mode = 0;
    public static final String DATASIZE = "DataSize";
    public static final String DATACACHE = "DataCache";
    public static final String DATAMODE = "DataMode";

    public ActionMonitor() {
        this.addDependency("Log");
        this.addDependency("Execute");
        this.addDependency("State");
        State.addParameterInfo(DATASIZE, "Integer", "Size of the data list to be used for learning", new Integer(5));
        State.addParameterInfo(DATACACHE, "String", "Location of the data cache file for historical results");
        State.addParameterInfo(DATAMODE, "String", "Data calculation mode (average,max)", new String("average"));
        this.addMouseListener(this);
        this.add(menu);
    }

    public void init() {
        this.log = (Log)State.findComponent("Log");
        this.FAC_AM = this.log.getFacilityID(this);
        this.execute = (Execute)State.findComponent("Execute");
        this.execute.addActionEventListener(this);
        this.state = (State)State.findComponent("State");
        this.state.addPropertyEventListener(this);
        this.readConfigFile();
        super.init();
    }

    public void pulse() {
    }

    public void reset() {
        this.log.log("Clearing action table", 2, this.FAC_AM);
        this.durations.clear();
    }

    public void end() {
    }

    public void readConfigFile() {
        String filename = (String)this.state.getProperty(DATACACHE);
        if (filename == null) {
            return;
        }
        this.log.log("Reading data cache entries", 2, this.FAC_AM);
        try {
            BufferedReader file = this.state.getExtendedEntryReader(filename);
            if (file == null) {
                this.log.log("Error reading from directory file: " + filename, 0, this.FAC_AM);
                return;
            }
            int type = 0;
            while (file.ready()) {
                String str = file.readLine().trim();
                if (str.startsWith("#") || str.equals("")) continue;
                if (str.equals("Duration")) {
                    type = 0;
                    continue;
                }
                String action = str.substring(0, str.indexOf(":"));
                String data = str.substring(str.indexOf(":") + 1);
                Vector v = (Vector)Converter.reTypeProperty((String)data, (String)"Vector");
                if (v == null) {
                    this.log.log("Error parsing data cache line: " + str, 1, this.FAC_AM);
                    continue;
                }
                try {
                    Enumeration e = v.elements();
                    while (e.hasMoreElements()) {
                        if (type == 0) {
                            float value = Float.parseFloat((String)e.nextElement());
                            this.addDurationPoint(action, value);
                            continue;
                        }
                        this.log.log("Unknown data cache type " + type, 0, this.FAC_AM);
                    }
                }
                catch (NumberFormatException ex) {
                    this.log.log("Error parsing data cache line: " + str + "\n" + ex, 1, this.FAC_AM);
                }
            }
            file.close();
        }
        catch (IOException e) {
            this.log.log("Error: Data cache file error: " + e, 0, this.FAC_AM);
        }
    }

    public void addDurationPoint(String action, float p) {
        if (!this.durations.containsKey(action)) {
            this.durations.put(action, new Vector());
        }
        Vector v = this.getDurationData(action);
        while (v.size() >= this.datasize && !v.isEmpty()) {
            v.remove(v.firstElement());
        }
        v.add(new Float(p));
        if (this.log.getLogLevel(this.FAC_AM) >= 4) {
            this.log.log("Learned duration for " + action + " is now: " + this.getDuration(action), 4, this.FAC_AM);
        }
    }

    public Vector getDurationData(String action) {
        return (Vector)this.durations.get(action);
    }

    public Distribution getDuration(String action) {
        return this.calculate(this.getDurationData(action));
    }

    protected Distribution calculate(Vector v) {
        switch (this.mode) {
            case 0: {
                return this.calculateMiddleAverage(v);
            }
            case 1: {
                return this.calculateMaximum(v);
            }
        }
        return null;
    }

    protected Distribution calculateMiddleAverage(Vector v) {
        if (v == null) {
            return null;
        }
        if (v.isEmpty()) {
            return null;
        }
        TreeSet set = new TreeSet(v);
        set.remove(set.first());
        if (set.isEmpty()) {
            return null;
        }
        set.remove(set.last());
        if (!set.isEmpty()) {
            float sum = 0.0f;
            Iterator i = set.iterator();
            while (i.hasNext()) {
                sum += ((Float)i.next()).floatValue();
            }
            Distribution d = new Distribution(sum / (float)set.size(), 1.0f);
            return d;
        }
        return null;
    }

    protected Distribution calculateMaximum(Vector v) {
        if (v == null) {
            return null;
        }
        if (v.isEmpty()) {
            return null;
        }
        TreeSet set = new TreeSet(v);
        set.remove(set.first());
        if (set.isEmpty()) {
            return null;
        }
        set.remove(set.last());
        if (!set.isEmpty()) {
            float max = ((Float)set.last()).floatValue();
            Distribution d = new Distribution(max, 1.0f);
            return d;
        }
        return null;
    }

    public Enumeration getActions() {
        return this.durations.keys();
    }

    public void dumpDataCache() {
        System.err.println("# Duration values");
        System.err.println("Duration");
        Enumeration e = this.getActions();
        while (e.hasMoreElements()) {
            StringBuffer buf = new StringBuffer("");
            String action = (String)e.nextElement();
            Vector v = this.getDurationData(action);
            System.err.println(action + ":" + Converter.unTypeProperty((Object)v, null));
        }
    }

    public void actionStarted(ActionEvent e) {
    }

    public void actionAborted(ActionEvent e) {
    }

    public void actionCompleted(ActionEvent e) {
        Action a = e.getAction();
        this.addDurationPoint(a.getName(), a.getDuration());
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase(DATASIZE)) {
            this.datasize = (Integer)e.getProperty();
        } else if (key.equalsIgnoreCase(DATAMODE)) {
            String str = (String)e.getProperty();
            if (str.equalsIgnoreCase("average")) {
                this.mode = 0;
            } else if (str.equalsIgnoreCase("max")) {
                this.mode = 1;
            } else {
                this.log.log("Error, unknown DataMode " + str + " was ignored", 0, this.FAC_AM);
            }
        }
    }

    public boolean hasPopupMenu() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 || e.isPopupTrigger()) {
            menu.removeAll();
            MenuItem item = new MenuItem("Dump Data Cache");
            menu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(java.awt.event.ActionEvent event) {
                    ActionMonitor.this.dumpDataCache();
                }
            });
            item = new MenuItem("- Durations -");
            menu.add(item);
            item.setEnabled(false);
            SortedIterator en = new SortedIterator(this.getActions());
            while (en.hasMoreElements()) {
                String action = (String)en.nextElement();
                item = new MenuItem(action + ": " + this.getDuration(action));
                menu.add(item);
                item.addActionListener(new MyActionMonitorMenuListener(action));
            }
            menu.show(this, e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    class MyActionMonitorMenuListener
    implements ActionListener {
        String action;

        public MyActionMonitorMenuListener(String action) {
            this.action = action;
        }

        public void actionPerformed(java.awt.event.ActionEvent event) {
            System.err.println(this.action + " duration: " + ActionMonitor.this.getDuration(this.action));
            if (ActionMonitor.this.getDurationData(this.action) != null) {
                System.err.println(" " + ActionMonitor.this.getDurationData(this.action).toString());
            } else {
                System.err.println(" [no data available]");
            }
        }
    }
}

