/*
 * Decompiled with CFR 0.152.
 */
package agent.simplest;

import agent.simplest.State;
import java.io.Serializable;
import java.util.Hashtable;

public class Action
implements Serializable,
Cloneable {
    private long id;
    protected boolean done = false;
    protected String name;
    protected Hashtable data = new Hashtable(25);

    public Action() {
        this("");
    }

    public Action(String n) {
        this.setID(State.getRandom().nextLong());
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void start() {
        this.done = false;
    }

    public void execute() {
    }

    public void cancel() {
        this.done = true;
    }

    public void complete() {
        this.done = true;
    }

    public Hashtable getDataTable() {
        return this.data;
    }

    public synchronized Object getData(Object key) {
        return this.data.get(key);
    }

    public synchronized boolean hasData(Object key) {
        return this.data.containsKey(key);
    }

    public synchronized void setData(Object key, Object d) {
        this.data.put(key, d);
    }

    public int getStart() {
        Integer i = (Integer)this.getData("Start");
        if (i == null) {
            return -1;
        }
        return i;
    }

    public void setStart(int s) {
        this.setData("Start", new Integer(s));
    }

    public int getFinish() {
        Integer i = (Integer)this.getData("Finish");
        if (i == null) {
            return -1;
        }
        return i;
    }

    public void setFinish(int f) {
        this.setData("Finish", new Integer(f));
    }

    public int getTime() {
        Integer i = (Integer)this.getData("Time");
        if (i == null) {
            return -1;
        }
        return i;
    }

    public void setTime(int t) {
        this.setData("Time", new Integer(t));
    }

    public int getDuration() {
        int start = this.getStart();
        int finish = this.getFinish();
        if (start != -1 && finish != -1) {
            return finish - start;
        }
        return -1;
    }

    public float getQuality() {
        Float f = (Float)this.getData("Quality");
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    public void setQuality(float q) {
        this.setData("Quality", new Float(q));
    }

    public float getCost() {
        Float f = (Float)this.getData("Cost");
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    public void setCost(float c) {
        this.setData("Cost", new Float(c));
    }

    public boolean isDone() {
        return this.done;
    }

    public long getID() {
        return this.id;
    }

    public void setID(long i) {
        this.id = i;
    }

    public Object clone() {
        Action cloned = null;
        try {
            cloned = (Action)super.clone();
        }
        catch (Exception e) {
            System.err.println("Clone Error: " + e);
        }
        if (this.getName() != null) {
            cloned.name = new String(this.getName());
        }
        if (this.getDataTable() != null) {
            cloned.data = (Hashtable)this.getDataTable().clone();
        }
        return cloned;
    }

    public String toString() {
        return "[Action-" + this.id + "] " + this.name + " (S:" + this.getStart() + " F:" + this.getFinish() + ")";
    }
}

