/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.simplest.Action;
import java.io.Serializable;
import taems.Method;
import taems.Schedule;
import taems.ScheduleElement;

public class TaemsAction
extends Action
implements Serializable,
Cloneable {
    protected Method method = null;
    protected ScheduleElement schedelem = null;
    protected Schedule sched = null;

    public TaemsAction(Method m) {
        super(m.getLabel());
        this.setMethod(m);
    }

    public TaemsAction(Action a) {
        super(a.getName());
        this.setID(a.getID());
        this.setMethod(null);
    }

    public TaemsAction(ScheduleElement se, Schedule s) {
        this(se.getMethod());
        if (se.hasStarted()) {
            this.setStart(se.getActualStart());
        }
        if (se.hasFinished()) {
            this.setFinish(se.getFinish());
            this.setQuality(se.getQuality());
            this.setTime(se.getDuration());
        }
        this.setScheduleElement(se);
        this.setSchedule(s);
    }

    public int getStart() {
        if (this.getMethod() == null) {
            return super.getStart();
        }
        return this.getMethod().getStartTime();
    }

    public void setStart(int s) {
        if (this.getMethod() != null) {
            this.getMethod().setStartTime(s);
        }
        if (this.getScheduleElement() != null) {
            this.getScheduleElement().setActualStart(s);
        }
        super.setStart(s);
    }

    public int getFinish() {
        if (this.getMethod() == null) {
            return super.getFinish();
        }
        return this.getMethod().getFinishTime();
    }

    public void setFinish(int f) {
        if (this.getMethod() != null) {
            this.getMethod().setFinishTime(f);
        }
        if (this.getScheduleElement() != null) {
            this.getScheduleElement().setActualFinish(f);
        }
        super.setFinish(f);
    }

    public int getTime() {
        if (this.getMethod() == null) {
            return super.getTime();
        }
        return this.getMethod().getAccruedTime();
    }

    public void setTime(int t) {
        if (this.getMethod() != null) {
            this.getMethod().setAccruedTime(t);
            this.getMethod().setCurrentDuration((float)t);
        }
        super.setTime(t);
    }

    public float getQuality() {
        if (this.getMethod() == null) {
            return -1.0f;
        }
        return this.getMethod().getCurrentQuality();
    }

    public void setQuality(float q) {
        if (this.getMethod() != null) {
            this.getMethod().setCurrentQuality(q);
        }
        super.setQuality(q);
    }

    public float getCost() {
        if (this.getMethod() == null) {
            return -1.0f;
        }
        return this.getMethod().getCurrentCost();
    }

    public void setCost(float c) {
        if (this.getMethod() != null) {
            this.getMethod().setCurrentCost(c);
        }
        super.setCost(c);
    }

    public Object clone() {
        TaemsAction cloned = null;
        try {
            cloned = (TaemsAction)super.clone();
        }
        catch (Exception e) {
            System.err.println("Clone Error: " + e);
        }
        cloned.setMethod(this.getMethod());
        cloned.setScheduleElement(this.getScheduleElement());
        cloned.setSchedule(this.getSchedule());
        return cloned;
    }

    public synchronized Object getData(Object key) {
        Object o = super.getData(key);
        if (o == null && this.getMethod() != null) {
            return this.getMethod().getAttribute(key);
        }
        return o;
    }

    public synchronized void setData(Object key, Object d) {
        super.setData(key, d);
        if (this.getMethod() != null) {
            this.getMethod().setAttribute(key, d);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method m) {
        this.method = m;
    }

    public ScheduleElement getScheduleElement() {
        return this.schedelem;
    }

    public void setScheduleElement(ScheduleElement s) {
        this.schedelem = s;
    }

    public Schedule getSchedule() {
        return this.sched;
    }

    public void setSchedule(Schedule s) {
        this.sched = s;
    }

    public String toString() {
        return super.toString();
    }
}

