/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.mass.Communicate;
import agent.mass.Constraint;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.StatePointer;
import java.util.StringTokenizer;
import java.util.Vector;
import utilities.KQMLMessage;
import utilities.Message;

public class State
extends agent.simplest.State
implements MessageEventListener {
    static final long serialVersionUID = 1234567890L;
    protected Communicate communicate;
    public static final String LOCATION = "Location";

    public State() {
        this.addDependency("Communicate");
        State.addParameterInfo(LOCATION, "String", "The pysical location of the agent, changing this value will move the agent within the local provided by Mass");
        State.addParameterInfo("Constraints", "Vector", "The environmental constraints on the agent");
    }

    public void init() {
        this.communicate = (Communicate)State.findComponent("Communicate");
        this.communicate.addMessageEventListener(this);
        super.init();
    }

    public void propertyPreprocess(StatePointer property) {
        Object key = property.key;
        super.propertyPreprocess(property);
        if (key instanceof String) {
            StringTokenizer tok;
            String skey = (String)key;
            if (skey.equalsIgnoreCase("Constraints") && property.ptr instanceof Vector) {
                if (!(((Vector)property.ptr).lastElement() instanceof Constraint)) {
                    if (State.getRandom() != null) {
                        Vector temp = (Vector)property.ptr;
                        for (int i = 0; i < temp.size(); ++i) {
                            temp.setElementAt(Constraint.parseConstraint((String)temp.elementAt(i)), i);
                        }
                    } else {
                        property.key = "TempConstraints";
                    }
                }
            } else if (skey.equalsIgnoreCase("RandomSeed") && this.hasProperty("TempConstraints")) {
                Vector temp = (Vector)this.getProperty("TempConstraints");
                for (int i = 0; i < temp.size(); ++i) {
                    temp.setElementAt(Constraint.parseConstraint((String)temp.elementAt(i)), i);
                }
                this.removeProperty("TempConstraints");
                this.setProperty("Constraints", temp);
            } else if (skey.equalsIgnoreCase(LOCATION) || skey.equalsIgnoreCase("Display")) {
                if (property.ptr != null) {
                    this.communicate.sendMessage((Message)new KQMLMessage((Object)("(" + key + " " + (String)property.ptr + ")"), "simulator"));
                }
            } else if (skey.startsWith("DisplayImage") && (tok = new StringTokenizer(skey, "-")).countTokens() == 2) {
                String cmd = tok.nextToken();
                String id = tok.nextToken();
                if (property.ptr != null) {
                    String data = property.ptr.toString();
                } else {
                    String data = "null";
                }
                this.communicate.sendMessage((Message)new KQMLMessage((Object)("(" + cmd + " " + id + " " + (String)property.ptr + ")"), "simulator"));
            }
        }
    }

    public void messageSent(MessageEvent me) {
    }

    public void messageReceived(MessageEvent me) {
        if (me.getConnection().getType() != 1) {
            return;
        }
        KQMLMessage m = (KQMLMessage)me.getMessage();
        String perf = m.getPerformative();
        if (perf.equalsIgnoreCase("tell")) {
            String key = m.contentWord();
            String data = m.contentData();
            if (key != null && key.length() > 0 && (this.hasProperty(key) || State.usesParameter(key))) {
                this.setProperty(key, data);
                log.log("Changed \"" + key + "\" to \"" + data + "\"", 2, this.FAC_STATE);
            }
        } else if (perf.equalsIgnoreCase("ask")) {
            String key = m.contentWord();
            String ID = "ask";
            if (this.hasProperty(key)) {
                KQMLMessage reply = new KQMLMessage("reply", (Object)("(" + key + " " + (String)this.getProperty(key) + ")"), m.getSourceAddr());
                if (m.getField("reply-with") != null) {
                    ID = m.getField("reply-with");
                }
                reply.addField("in-reply-to", ID);
                this.communicate.sendMessage((Message)reply);
            }
        }
    }
}

