/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.base.AgentComponent;
import agent.mass.CondRule;
import agent.mass.State;
import agent.simplest.Communicate;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.WindowManager;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import taems.Agent;
import taems.Commitment;
import taems.Node;
import taems.Resource;
import taems.Taems;
import taems.TaskBase;
import taems.VirtualTaskBase;
import taems.parser.ReadTTaems;
import utilities.KQMLMessage;
import utilities.Message;

public class SimpleTaemsReader
extends AgentComponent
implements PropertyEventListener,
MessageEventListener {
    static final long serialVersionUID = 1234567890L;
    protected static int NUM = 0;
    private Hashtable olabels = new Hashtable();
    public static String CONTAEMS = "ConTaemsTask";
    public static String SUBTAEMS = "SubTaemsTask";
    public static String OBJTAEMS = "ObjTaemsTask";
    protected agent.simplest.State state;
    protected Log log;
    protected Communicate communicate;
    protected int FAC_ORGDES;
    private JFrame sdisplay;
    private JFrame cdisplay;
    private JFrame odisplay;
    private int nextUpdate;
    protected ReadTTaems reader = new ReadTTaems(utilities.Log.getDefault());
    private boolean setname;
    private boolean commits;
    private boolean multitaems;
    private boolean retattrib;
    public Vector allstructs = new Vector();
    public static final String SETTAEMSNAME = "SetTaemsName";
    public static final String STOREOBJTASK = "StoreObjTask";
    public static final String MULTITAEMS = "MultiTaems";
    public static final String KEEPCOMMITS = "KeepCommits";
    public static final String DISPLAYTAEMS = "DisplayTaems";
    public static final String RETARGETATTRIBUTES = "RetargetAttributes";
    boolean first = true;

    public SimpleTaemsReader() {
        this.addDependency("State");
        this.addDependency("Log");
        this.addDependency("Communicate");
        State.addParameterInfo("ObjTaems", "String", "Objective Taems definition file.  If specified, the file will be used to automatically generate and disseminate the objective view.");
        State.addParameterInfo("SubTaems", "String", "Subjective Taems definition file.  If specified, the file will be used to create a local subjective view.");
        State.addParameterInfo("ConTaems", "String", "Conditioned Taems definition file.  If specified, the file will be used to create a local conditioned view.");
        State.addParameterInfo(SETTAEMSNAME, "Boolean", "If true, re-sets Taems agent name for all local nodes of a task structure marked with the original primary agent name after its generation", Boolean.TRUE);
        State.addParameterInfo(STOREOBJTASK, "Boolean", "If true, a copy of the objective view is stored locally (normally the agent would not have access to this)", Boolean.FALSE);
        State.addParameterInfo(MULTITAEMS, "Boolean", "If true, the agent is assumed to be able to handle multiple independant structures concurrently.  Taems structure types are stored in Hashtables.  See the storeTaems procedure for more info.", Boolean.FALSE);
        State.addParameterInfo(KEEPCOMMITS, "Boolean", "If true, commitments are appended onto new Taems structures from a previously existing one (if their labels match) if is it found", Boolean.TRUE);
        State.addParameterInfo(DISPLAYTAEMS, "Boolean", "If true, Taems task structures are automatically displayed in a window when they are created", Boolean.TRUE);
        State.addParameterInfo(RETARGETATTRIBUTES, "Boolean", "If true, calls retargetAttributes on all new Taems task structures", Boolean.FALSE);
    }

    public void init() {
        this.state = (agent.simplest.State)State.findComponent("State");
        CondRule.log = this.log = (Log)State.findComponent("Log");
        this.communicate = (Communicate)State.findComponent("Communicate");
        this.FAC_ORGDES = this.log.getFacilityID("TaemsReader");
        this.state.addPropertyEventListener(this);
        this.communicate.addMessageEventListener(this);
        super.init();
    }

    public void begin() {
    }

    public void reset() {
        this.makeAllStructures();
    }

    public void pulse() {
        if (this.first && NUM == 0) {
            this.first = false;
            String obj = (String)this.state.getProperty("ObjTaems");
            String con = (String)this.state.getProperty("ConTaems");
            String sub = (String)this.state.getProperty("SubTaems");
            if (obj != null || con != null || sub != null) {
                this.makeAllStructures();
            }
        }
    }

    public void setKeepCommits(boolean s) {
        this.commits = s;
    }

    public boolean getKeepCommits() {
        return this.commits;
    }

    public void setRetargetAttributes(boolean r) {
        this.retattrib = r;
    }

    public boolean getRetargetAttributes() {
        return this.retattrib;
    }

    public void setSetName(boolean s) {
        this.setname = s;
    }

    public boolean getSetName() {
        return this.setname;
    }

    public void setMultiTaems(boolean s) {
        this.multitaems = s;
        if (this.getMultiTaems()) {
            CONTAEMS = "ConTaemsTasks";
            SUBTAEMS = "SubTaemsTasks";
            OBJTAEMS = "ObjTaemsTasks";
        } else {
            CONTAEMS = "ConTaemsTask";
            SUBTAEMS = "SubTaemsTask";
            OBJTAEMS = "ObjTaemsTask";
        }
    }

    public boolean getMultiTaems() {
        return this.multitaems;
    }

    public ReadTTaems getReader() {
        return this.reader;
    }

    public synchronized Taems readTTaems(String name) {
        Taems taems = null;
        this.log.log("Reading Taems file entry " + name, 3, this.FAC_ORGDES);
        try {
            BufferedReader file = this.state.getExtendedEntryReader(name);
            if (file == null) {
                this.log.log("Error reading from ttaems file: " + name, 0, this.FAC_ORGDES);
                return null;
            }
            this.log.log("Starting Taems parse", 5, this.FAC_ORGDES);
            taems = this.reader.readTTaems((Reader)file);
            this.log.log("Finished Taems parse", 5, this.FAC_ORGDES);
            file.close();
            if (taems != null) {
                if (this.getRetargetAttributes()) {
                    taems.retargetAttributes();
                }
                if (this.getSetName()) {
                    this.updateTaemsAgentName(taems);
                }
            }
        }
        catch (IOException e) {
            this.log.log("Error: Taems file error: " + e, 0, this.FAC_ORGDES);
        }
        this.log.log("Finished reading Taems file", 5, this.FAC_ORGDES);
        return taems;
    }

    public synchronized Taems readTTaems(StringReader read) {
        Taems taems = null;
        this.log.log("Starting Taems parse", 5, this.FAC_ORGDES);
        taems = this.reader.readTTaems((Reader)read);
        this.log.log("Finished Taems parse", 5, this.FAC_ORGDES);
        if (taems != null) {
            if (this.getRetargetAttributes()) {
                taems.retargetAttributes();
            }
            if (this.getSetName()) {
                this.updateTaemsAgentName(taems);
            }
        }
        this.log.log("Finished reading Taems file", 5, this.FAC_ORGDES);
        return taems;
    }

    public void updateTaemsAgentName(Taems taems) {
        if (taems == null) {
            this.log.log("Warning: updateTaemsAgentName given null task structure", 0, this.FAC_ORGDES);
            return;
        }
        String agentname = (String)this.state.getProperty("Name");
        Agent agent = new Agent(agentname);
        Agent oldagent = taems.getAgent();
        if (oldagent != null) {
            if (oldagent.matches(agent)) {
                this.log.log("New name " + oldagent.getLabel() + " matches old, no update performed.", 5, this.FAC_ORGDES);
                return;
            }
        } else {
            this.log.log("Warning, original agent name is not set in Taems object " + taems.getLabel() + ", aborting SetTaemsName", 2, this.FAC_ORGDES);
            return;
        }
        this.log.log("Updating taems name from " + oldagent.getLabel() + " to " + agent.getLabel(), 5, this.FAC_ORGDES);
        taems.setAgent(agent);
        Enumeration e = taems.getAllNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (n.getAgent() == null) {
                if (n instanceof Resource) continue;
                this.log.log("Warning, node " + n.getLabel() + " has no agent specified.", 1, this.FAC_ORGDES);
                continue;
            }
            if (n instanceof TaskBase && ((TaskBase)n).isNonLocal() || !n.getAgent().matches(oldagent)) continue;
            n.setAgent(agent);
        }
    }

    public void copyOldCommitments(Taems ot, Taems nt) {
        if (ot == null) {
            return;
        }
        if (nt == null) {
            return;
        }
        Enumeration oe = ot.getCommitments();
        while (oe.hasMoreElements()) {
            Commitment oc = (Commitment)oe.nextElement();
            boolean found = false;
            Enumeration ne = nt.getCommitments();
            while (ne.hasMoreElements()) {
                Commitment nc = (Commitment)ne.nextElement();
                if (!oc.matches(nc)) continue;
                found = true;
                break;
            }
            if (found) continue;
            Commitment clone = (Commitment)oc.clone();
            Vector<Node> v = new Vector<Node>();
            Enumeration cv = clone.getTasks();
            while (cv.hasMoreElements()) {
                Node n = (Node)cv.nextElement();
                n = new VirtualTaskBase(n.getLabel(), n.getAgent());
                v.addElement(n);
            }
            clone.setTaskVector(v);
            nt.addCommitment(clone);
        }
    }

    public void makeAllStructures() {
        ++NUM;
        String obj = (String)this.state.getProperty("ObjTaems");
        String con = (String)this.state.getProperty("ConTaems");
        String sub = (String)this.state.getProperty("SubTaems");
        Taems t = null;
        if (obj != null) {
            t = this.makeObjectiveStructure(true);
        }
        if (t != null) {
            this.allstructs.addElement(t);
        }
        if (sub != null) {
            t = this.makeSubjectiveStructure(true);
        }
        if (t != null) {
            this.allstructs.addElement(t);
        }
        if (con != null) {
            t = this.makeConditionalStructure(true);
        }
        if (t != null) {
            this.allstructs.addElement(t);
        }
    }

    public void removeAllStructures() {
        Enumeration e = this.allstructs.elements();
        while (e.hasMoreElements()) {
            Taems t = (Taems)e.nextElement();
            this.removeTaems(t);
        }
        this.allstructs.removeAllElements();
    }

    public void setTaems(Taems t) {
        ++NUM;
        if (t != null) {
            if (this.getRetargetAttributes()) {
                t.retargetAttributes();
            }
            if (this.getSetName()) {
                this.updateTaemsAgentName(t);
            }
            if (t.getLabel() == null || t.getLabel().equals("")) {
                t.setLabel("Structure_" + NUM);
            }
            Taems cond = (Taems)t.clone();
            this.storeTaems(CONTAEMS, cond);
            Taems subj = (Taems)t.clone();
            this.storeTaems(SUBTAEMS, cond);
            this.handleNewObjectiveStructure(t, true);
        } else {
            this.log.log("setTaems called with null task structure", 0, this.FAC_ORGDES);
        }
    }

    public Taems makeConditionalStructure(boolean set) {
        this.log.log("Generating conditional task structure", 2, this.FAC_ORGDES);
        String name = (String)this.state.getProperty("ConTaems");
        if (name != null) {
            Taems task = this.readTTaems(name);
            if (task.getLabel() == null || task.getLabel().equals("")) {
                task.setLabel("Structure_" + NUM);
            }
            if (set) {
                task = this.storeTaems(CONTAEMS, task);
            }
            this.log.log("Generated conditioned task structure", 5, this.FAC_ORGDES);
            return task;
        }
        this.log.log("Warning: no conditioned view specified.", 1, this.FAC_ORGDES);
        this.log.log("Conditioned generation failed", 1, this.FAC_ORGDES);
        return null;
    }

    public Taems makeSubjectiveStructure(boolean set) {
        this.log.log("Generating subjective task structure", 2, this.FAC_ORGDES);
        String name = (String)this.state.getProperty("SubTaems");
        if (name != null) {
            Taems task = this.readTTaems(name);
            if (task.getLabel() == null || task.getLabel().equals("")) {
                task.setLabel("Structure_" + NUM);
            }
            if (set) {
                task = this.storeTaems(SUBTAEMS, task);
            }
            this.log.log("Generated subjective task structure", 5, this.FAC_ORGDES);
            return task;
        }
        this.log.log("Warning: no subjective view specified.", 1, this.FAC_ORGDES);
        this.log.log("Subjective generation failed", 1, this.FAC_ORGDES);
        return null;
    }

    public Taems makeObjectiveStructure(boolean send) {
        this.log.log("Generating objective task structure", 2, this.FAC_ORGDES);
        String name = (String)this.state.getProperty("ObjTaems");
        if (name != null) {
            Taems task = this.readTTaems(name);
            if (task.getLabel() == null || task.getLabel().equals("")) {
                task.setLabel("Structure_" + NUM);
            }
            task = this.handleNewObjectiveStructure(task, send);
            this.log.log("Generated objective task structure", 5, this.FAC_ORGDES);
            return task;
        }
        this.log.log("Warning: no objective view specified.", 1, this.FAC_ORGDES);
        this.log.log("Objective generation failed", 1, this.FAC_ORGDES);
        return null;
    }

    public Taems handleNewObjectiveStructure(Taems obj, boolean send) {
        if (send) {
            if (!this.getMultiTaems() && !this.olabels.containsKey(obj.getLabel())) {
                this.handleRemoveObjectiveStructure(null);
            }
            KQMLMessage m = new KQMLMessage("tell", (Object)("(AddTaems " + obj.toString() + ")"), "simulator");
            this.log.log("Sending objective task structure to simulator", 3, this.FAC_ORGDES);
            this.communicate.sendMessage((Message)m);
            this.olabels.put(obj.getLabel(), new Boolean(true));
        }
        if (this.state.hasProperty(STOREOBJTASK) && ((Boolean)this.state.getProperty(STOREOBJTASK)).booleanValue()) {
            obj = this.storeTaems(OBJTAEMS, obj);
        }
        return obj;
    }

    public void handleRemoveObjectiveStructure(String l) {
        KQMLMessage m;
        this.log.log("Removing objective task structure " + l + " from simulator", 3, this.FAC_ORGDES);
        if (l == null) {
            m = new KQMLMessage("tell", (Object)"(RemoveTaems)", "simulator");
        } else {
            m = new KQMLMessage("tell", (Object)("(RemoveTaems " + l + ")"), "simulator");
            this.olabels.remove(l);
        }
        this.communicate.sendMessage((Message)m);
    }

    public Taems storeTaems(String type, Taems taems) {
        Taems exist = null;
        this.log.log("Storing task structure " + type, 3, this.FAC_ORGDES);
        if (this.getMultiTaems()) {
            Hashtable<String, Taems> ht;
            if (taems.getLabel() == null) {
                this.log.log("Warning: Taems structure has no label", 1, this.FAC_ORGDES);
                taems.setLabel("Unknown");
            }
            if ((ht = (Hashtable<String, Taems>)this.state.getProperty(type)) == null) {
                ht = new Hashtable<String, Taems>();
            }
            if ((exist = (Taems)ht.get(taems.getLabel())) != null && exist instanceof Taems) {
                if (this.getKeepCommits()) {
                    this.copyOldCommitments(exist, taems);
                }
                if (exist.getLabel() != null && exist.getLabel().equals(taems.getLabel())) {
                    this.log.log("Importing new task structure into existing table entry for " + exist.getLabel(), 4, this.FAC_ORGDES);
                    exist.importTaems(taems);
                } else {
                    this.log.log("Adding new task structure into hashtable", 4, this.FAC_ORGDES);
                    exist = taems;
                }
            } else {
                this.log.log("Adding new task structure into hashtable", 4, this.FAC_ORGDES);
                exist = taems;
            }
            ht.put(exist.getLabel(), exist);
            this.state.setProperty(type, ht, exist.getLabel());
        } else {
            exist = (Taems)this.state.getProperty(type);
            if (exist != null && exist instanceof Taems) {
                if (this.getKeepCommits()) {
                    this.copyOldCommitments(exist, taems);
                }
                if (exist.getLabel() != null && exist.getLabel().equals(taems.getLabel())) {
                    this.log.log("Importing new task structure into existing " + exist.getLabel(), 4, this.FAC_ORGDES);
                    exist.importTaems(taems);
                } else {
                    this.log.log("Adding new task structure to state", 4, this.FAC_ORGDES);
                    exist = taems;
                }
            } else {
                this.log.log("Adding new task structure to state", 4, this.FAC_ORGDES);
                exist = taems;
            }
            this.state.setProperty(type, exist, exist.getLabel());
        }
        return exist;
    }

    public void removeTaems(Taems taems) {
        String[] types = new String[]{CONTAEMS, SUBTAEMS, OBJTAEMS};
        this.log.log("Removing task structure " + taems.getLabel(), 3, this.FAC_ORGDES);
        if (this.getMultiTaems()) {
            block0: for (int i = 0; i < types.length; ++i) {
                Hashtable ht = (Hashtable)this.state.getProperty(types[i]);
                if (ht == null) continue;
                Enumeration e = ht.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    Taems t = (Taems)ht.get(key);
                    if (t != taems) continue;
                    ht.remove(key);
                    this.state.setProperty(types[i], ht);
                    continue block0;
                }
            }
        } else {
            for (int i = 0; i < types.length; ++i) {
                Taems t = (Taems)this.state.getProperty(types[i]);
                if (t == null || t != taems) continue;
                this.state.removeProperty(types[i]);
                break;
            }
        }
    }

    public Taems findTaems(Node n) {
        Taems taems;
        int i;
        String[] types = new String[]{CONTAEMS, SUBTAEMS, OBJTAEMS};
        Vector<Object> v = new Vector<Object>();
        this.log.log("Looking for the structure containing node " + n.getLabel(), 3, this.FAC_ORGDES);
        if (this.getMultiTaems()) {
            for (i = 0; i < types.length; ++i) {
                Hashtable ht = (Hashtable)this.state.getProperty(types[i]);
                if (ht == null) continue;
                Enumeration e = ht.elements();
                while (e.hasMoreElements()) {
                    v.addElement(e.nextElement());
                }
            }
        } else {
            for (i = 0; i < types.length; ++i) {
                taems = (Taems)this.state.getProperty(types[i]);
                if (taems == null) continue;
                v.addElement(taems);
            }
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            taems = (Taems)e.nextElement();
            this.log.log("Looking at " + taems.getLabel(), 4, this.FAC_ORGDES);
            Enumeration en = taems.findNodes(n);
            while (en.hasMoreElements()) {
                if (n == en.nextElement()) {
                    this.log.log("Found node in " + taems.getLabel(), 3, this.FAC_ORGDES);
                    return taems;
                }
                this.log.log("Found matching but not equal node in " + taems.getLabel() + ": " + n, 4, this.FAC_ORGDES);
            }
        }
        this.log.log("Could not find node.", 3, this.FAC_ORGDES);
        return null;
    }

    public JFrame displayTaems(JFrame f, Object taems, String title) {
        if (!this.hasGUI() || !((Boolean)this.state.getProperty(DISPLAYTAEMS)).booleanValue()) {
            return f;
        }
        this.log.log("Displaying Taems: " + title, 3, this.FAC_ORGDES);
        if (f == null) {
            this.log.log("Creating new window for " + title, 3, this.FAC_ORGDES);
            if (State.hasComponent("WindowManager")) {
                WindowManager wm = (WindowManager)agent.simplest.State.findComponent("WindowManager");
                f = wm.createWindow(title + " Taems Views");
            } else {
                f = new JFrame(title + " Taems Views");
            }
            f.setJMenuBar(new JMenuBar());
            f.getContentPane().setLayout(new BorderLayout());
            f.setSize(new Dimension(640, 460));
            JPanel p = new JPanel();
            p.setLayout(new CardLayout());
            f.getContentPane().add(p, "Center", 0);
            if (!agent.simplest.State.hasComponent("WindowManager")) {
                f.setVisible(true);
            }
        }
        Hashtable structs = null;
        if (taems instanceof Taems) {
            structs = new Hashtable(1);
            structs.put(title, taems);
        } else if (taems instanceof Hashtable) {
            structs = (Hashtable)taems;
        } else {
            this.log.log("Warning, attempt to add unknown object to Taems Views: " + taems, 1, this.FAC_ORGDES);
            return f;
        }
        JMenu menu = null;
        for (int i = 0; i < f.getJMenuBar().getMenuCount() && !(menu = f.getJMenuBar().getMenu(i)).getText().equals(title); ++i) {
            menu = null;
        }
        if (menu == null) {
            menu = new JMenu(title);
            f.getJMenuBar().add(menu);
        }
        menu.removeAll();
        JPanel p = (JPanel)f.getContentPane().getComponent(0);
        p.removeAll();
        Enumeration e = structs.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Taems t = (Taems)structs.get(key);
            p.add(title + key, (Component)t);
            JMenuItem item = new JMenuItem(key);
            item.addMenuDragMouseListener(new myMenuDragMouseListener(p, title + key));
            menu.add(item);
        }
        f.validate();
        return f;
    }

    public void messageSent(MessageEvent e) {
    }

    public void messageReceived(MessageEvent e) {
        String key;
        if (e.getConnection().getType() != 1) {
            return;
        }
        KQMLMessage m = (KQMLMessage)e.getMessage();
        String perf = m.getPerformative();
        if (perf.equalsIgnoreCase("tell") && (key = m.contentWord()).equalsIgnoreCase("GenerateTaskStructure")) {
            String data = m.contentData();
            if (data.equalsIgnoreCase("All")) {
                this.makeAllStructures();
            } else if (data.equalsIgnoreCase("Objective")) {
                this.makeObjectiveStructure(true);
            } else if (data.equalsIgnoreCase("Subjective")) {
                this.makeSubjectiveStructure(true);
            } else if (data.equalsIgnoreCase("Conditional")) {
                this.makeConditionalStructure(true);
            } else {
                this.log.log("Unknown view " + data + " cannot be generated", 1, this.FAC_ORGDES);
            }
        }
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase(SUBTAEMS)) {
            if (this.getMultiTaems()) {
                Hashtable h = (Hashtable)e.getProperty();
                Enumeration en = this.olabels.keys();
                while (en.hasMoreElements()) {
                    Object k = en.nextElement();
                    if (h.containsKey(k)) continue;
                    this.handleRemoveObjectiveStructure((String)k);
                }
            }
            this.sdisplay = this.displayTaems(this.sdisplay, e.getProperty(), "Subjective");
        }
        if (key.equalsIgnoreCase(CONTAEMS)) {
            this.cdisplay = this.displayTaems(this.cdisplay, e.getProperty(), "Conditioned");
        }
        if (key.equalsIgnoreCase(OBJTAEMS)) {
            this.odisplay = this.displayTaems(this.odisplay, e.getProperty(), "Objective");
        }
        if (key.equalsIgnoreCase(SETTAEMSNAME)) {
            this.setSetName((Boolean)e.getProperty());
        }
        if (key.equalsIgnoreCase(MULTITAEMS)) {
            this.setMultiTaems((Boolean)e.getProperty());
        }
        if (key.equalsIgnoreCase(KEEPCOMMITS)) {
            this.setKeepCommits((Boolean)e.getProperty());
        }
        if (key.equalsIgnoreCase(RETARGETATTRIBUTES)) {
            this.setRetargetAttributes((Boolean)e.getProperty());
        }
    }

    public void propertyRemoved(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    class myMenuDragMouseListener
    implements MenuDragMouseListener {
        JPanel panel;
        String key;

        public myMenuDragMouseListener(JPanel p, String k) {
            this.panel = p;
            this.key = k;
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            ((CardLayout)this.panel.getLayout()).show(this.panel, this.key);
        }
    }
}

