/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.mass.State;
import agent.simplest.Communicate;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.SensorEvent;
import java.awt.MenuItem;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import utilities.Converter;
import utilities.KQMLMessage;
import utilities.Message;

public class Sensor
extends agent.simplest.Sensor
implements MessageEventListener {
    static final long serialVersionUID = 1234567890L;
    public static final int TIMEOUT = 20;
    protected Communicate communicate;

    public Sensor() {
        this.addDependency("Communicate");
    }

    public void init() {
        super.init();
        this.communicate = (Communicate)State.findComponent("Communicate");
        this.communicate.addMessageEventListener(this);
    }

    protected String makeSensorQuery(String sensor, Hashtable data) {
        StringBuffer buf = new StringBuffer(sensor);
        if (data == null) {
            return buf.toString();
        }
        Vector<String> v = new Vector<String>();
        Enumeration e = data.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            for (int i = 0; i < v.size(); ++i) {
                String cmp = (String)v.elementAt(i);
                if (s.compareTo(cmp) >= 0) continue;
                v.insertElementAt(s, i);
                s = null;
                break;
            }
            if (s == null) continue;
            v.addElement(s);
        }
        for (int i = 0; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            buf.append(", " + s + ":" + Converter.unTypeProperty(data.get(s), (String)";"));
        }
        return buf.toString();
    }

    public Object readSensorData(String sensor, Hashtable data, String type) {
        sensor = this.makeSensorQuery(sensor, data);
        return super.readSensorData(sensor, data, type);
    }

    public Object readOldSensorData(String sensor, Hashtable data, String type) {
        sensor = this.makeSensorQuery(sensor, data);
        return super.readOldSensorData(sensor, data, type);
    }

    protected boolean querySensor(String sensor) {
        if (!this.communicate.ready()) {
            return false;
        }
        this.log.log("Sending sensor query for " + sensor, 2, this.FAC_SENSOR);
        KQMLMessage message = new KQMLMessage("ask", (Object)("(Sensor " + sensor + ")"), "simulator");
        Long id = new Long(State.getRandom().nextLong());
        message.addField("reply-with", id.toString());
        this.sensors.remove(sensor);
        this.replies.remove(id);
        this.communicate.sendMessage((Message)message);
        int timeout = 200;
        while (!this.replies.containsKey(id)) {
            if (--timeout <= 0) {
                this.log.log("Timeout waiting for sensor data from simulator (" + sensor + ")", 0, this.FAC_SENSOR);
                break;
            }
            Message m = this.communicate.receiveMessage(true);
            if (m != null) {
                this.log.log("Intercepted message on connection " + m.getConnection() + ": " + m, 3, this.FAC_SENSOR);
                this.messageReceived(new MessageEvent(this.communicate, m, m.getConnection(), 1));
            }
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        if (this.replies.containsKey(id)) {
            this.sensors.put(sensor, this.replies.get(id));
            this.replies.remove(id);
            return true;
        }
        return false;
    }

    public void addSensor(String s) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        this.log.log("Adding sensor => " + s, 2, this.FAC_SENSOR);
        StringTokenizer tok = new StringTokenizer(s, ",");
        tok.nextToken();
        tok.nextToken();
        String name = tok.nextToken();
        name = name.trim();
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken().trim();
            if (str.indexOf(":") == -1) {
                hash.put(str, "");
                continue;
            }
            String n = str.substring(0, str.indexOf(":")).trim();
            String v = str.substring(str.indexOf(":") + 1).trim();
            hash.put(n, v);
        }
        String ts = this.findSensor(name);
        if (ts == null) {
            KQMLMessage message = new KQMLMessage("tell", (Object)("(NewSensor " + s + ")"), "simulator");
            message.addField("type", "control");
            this.communicate.sendMessage((Message)message);
            this.known.put(name, hash);
            this.menu.add(new MenuItem(name));
            this.log.log("Sensor added (" + name + ") " + hash, 3, this.FAC_SENSOR);
            this.startFireEvent(new SensorEvent(this, name, 0));
        } else {
            this.log.log("Duplicate sensor name (" + name + ") detected, not added", 1, this.FAC_SENSOR);
        }
    }

    public void messageSent(MessageEvent me) {
    }

    public void messageReceived(MessageEvent me) {
        String key;
        if (me.getConnection().getType() != 1) {
            return;
        }
        KQMLMessage m = (KQMLMessage)me.getMessage();
        String perf = m.getPerformative();
        if (perf.equalsIgnoreCase("reply")) {
            String key2 = m.contentWord();
            if (key2 != null && key2.equals("SensorData")) {
                String data = m.contentData();
                Long id = Long.valueOf(m.getField("in-reply-to"));
                this.replies.put(id, data);
            }
        } else if (perf.equalsIgnoreCase("tell") && (key = m.contentWord()) != null && key.equals("NewSensor")) {
            String data = m.contentData();
            this.addSensor(data);
        }
    }
}

