/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.base.AgentComponent;
import agent.mass.Communicate;
import agent.mass.State;
import agent.simplest.Log;
import java.io.BufferedReader;
import java.io.IOException;
import utilities.KQMLMessage;
import utilities.Message;

public class Scripter
extends AgentComponent {
    static final long serialVersionUID = 1234567890L;
    protected Log log;
    protected State state;
    protected Communicate communicate;
    protected int FAC_SCRIPT;
    public static final String SCRIPTDATA = "ScriptData";

    public Scripter() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Communicate");
        State.addParameterInfo(SCRIPTDATA, "String", "Name of the extended configuration entry that contains the script data.  This is read in and sent to the Mass simulator");
    }

    public void init() {
        this.log = (Log)State.findComponent("Log");
        this.state = (State)State.findComponent("State");
        this.communicate = (Communicate)State.findComponent("Communicate");
        this.FAC_SCRIPT = this.log.getFacilityID(this);
        super.init();
    }

    public void begin() {
        this.readScriptData();
    }

    public void readScriptData() {
        if (!this.state.hasProperty(SCRIPTDATA)) {
            return;
        }
        this.log.log("Reading script data", 2, this.FAC_SCRIPT);
        try {
            BufferedReader file = this.state.getExtendedEntryReader((String)this.state.getProperty(SCRIPTDATA));
            if (file == null) {
                this.log.log("Error reading from script data: " + this.state.getProperty(SCRIPTDATA), 0, this.FAC_SCRIPT);
                return;
            }
            StringBuffer buf = new StringBuffer("");
            while (file.ready()) {
                String str = file.readLine();
                if (str.indexOf(";") != -1) {
                    str = str.substring(0, str.indexOf(";"));
                }
                if ((str = str.trim()).length() <= 0) continue;
                buf.append(str + "\n");
            }
            file.close();
            this.addScript(buf);
        }
        catch (IOException e) {
            this.log.log("Error: Script data file error: " + e, 0, this.FAC_SCRIPT);
        }
        this.log.log("Finished reading script data", 3, this.FAC_SCRIPT);
    }

    public void pauseSimulator() {
        StringBuffer buf = new StringBuffer("");
        buf.append("Script, AndScript, Agent Pause, Fire:1\n");
        buf.append("  Assertion, True\n");
        buf.append("  Reaction, StopSim\n");
        this.addScript(buf);
    }

    public void addScript(StringBuffer buf) {
        this.log.log("Adding script:\n" + buf.toString(), 5, this.FAC_SCRIPT);
        KQMLMessage message = new KQMLMessage("tell", (Object)("(NewScript " + buf.toString() + ")"), "simulator");
        message.addField("type", "control");
        this.communicate.sendMessage((Message)message);
    }

    public void removeScript(String s) {
        this.log.log("Removing script: " + s, 5, this.FAC_SCRIPT);
        KQMLMessage message = new KQMLMessage("tell", (Object)("(RemoveScript " + s + ")"), "simulator");
        message.addField("type", "control");
        this.communicate.sendMessage((Message)message);
    }
}

