/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.base.ListenerVector;
import agent.mass.DTCNative;
import agent.mass.ScheduleErrorException;
import agent.mass.ScheduleEvent;
import agent.mass.ScheduleEventListener;
import agent.mass.SimpleTaemsReader;
import agent.mass.State;
import agent.simplest.Observe;
import agent.simplest.Observer;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.ConsumesInterrelationship;
import taems.Criteria;
import taems.Interrelationship;
import taems.LastQAF;
import taems.LimitsInterrelationship;
import taems.Method;
import taems.Node;
import taems.ProducesInterrelationship;
import taems.QAF;
import taems.Resource;
import taems.Schedule;
import taems.ScheduleElement;
import taems.SeqLastQAF;
import taems.SumQAF;
import taems.Taems;
import taems.Task;
import taems.TaskBase;
import taems.parser.ReadTTaems;
import utilities.Log;
import utilities.SafeEnumeration;

public class Scheduler
extends AgentComponent
implements PropertyEventListener,
MouseListener {
    static final long serialVersionUID = 1234567890L;
    protected ListenerVector listeners = new ListenerVector();
    public static final int CRITERIA_SIZE = 22;
    public static final int LABEL_SIZE = 6;
    protected Criteria criteria = new Criteria(22);
    protected String[] defaultLabels = new String[]{"Q", "C", "D", "Q", "C", "D", "Q", "C", "D", "Q", "C", "D", "R", "T", "C", "C"};
    protected int[] defaultSliders = new int[]{60, 40, 0, 45, 45, 5, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0};
    protected int[] defaultValues = new int[]{50, 100, 200, 0, 0, 0};
    protected Frame controls = null;
    protected ScrollbarPanel[] sliders;
    protected TextField[] values;
    protected ReadTTaems parser = null;
    protected boolean override = false;
    protected int FAC_SCHED;
    protected String SCHEDULER;
    protected String SCHED_DIR;
    protected agent.simplest.State state;
    protected agent.simplest.Log log;
    protected boolean autoschedule;
    protected boolean cacheschedules;
    protected boolean autosetstarttime;
    protected int cachelimit = -1;
    protected int numschedules = 15;
    protected int maxschedules = -1;
    protected Hashtable cache = new Hashtable();
    protected Observer obsched;
    protected Observer obcache;
    protected Observer obschedtime;
    protected Reader lastreader;
    protected DTCNative dtc_native;
    public static final String AUTOSCHEDULE = "AutoSchedule";
    public static final String SCHEDULERCRITERIA = "SchedulerCriteria";
    public static final String DTC = "DTC";
    public static final String DTCOVERRIDE = "DTCOverride";
    public static final String NUMSCHEDULES = "NumSchedules";
    public static final String CACHESCHEDULES = "CacheSchedules";
    public static final String CACHELIMIT = "CacheLimit";
    public static final String AUTOSETSTARTTIME = "AutoSetStartTime";
    public static final String MAXREADSCHEDULES = "MaxReadSchedules";
    public static final String USEDTCNATIVE = "UseDTCNative";
    public static final String DTCLIBNAME = "DTCLibName";
    public static final String SCHEDULE = "Schedule";

    public Scheduler() {
        int i;
        this.addDependency("State");
        this.addDependency("Log");
        State.addParameterInfo(AUTOSCHEDULE, "Boolean", "If true, automacticly reschedule if the TAEMS structure changes", Boolean.TRUE);
        State.addParameterInfo(SCHEDULERCRITERIA, "Vector", "The default scheduler evaluation criteria");
        State.addParameterInfo(DTC, "String", "Pathname of the DTC scheduler.", new String("modules/scheduler/dtc"));
        State.addParameterInfo(DTCOVERRIDE, "String", "DTC execution string, used in place of existing default.  The taems file and output directory will be appended to this to create the full execution command.  This overrides DTC and NumSchedules.  It does not currently work with UseDTCNative.");
        State.addParameterInfo(NUMSCHEDULES, "Integer", "Maximum number of schedules for DTC to return", new Integer(2));
        State.addParameterInfo(CACHESCHEDULES, "Boolean", "If true, tries to used cached results in place of running DTC", Boolean.TRUE);
        State.addParameterInfo(CACHELIMIT, "Integer", "If set and positive, sets a maximum limit on the number of cached schedules", new Integer(15));
        State.addParameterInfo(AUTOSETSTARTTIME, "Boolean", "If true, set the starting time of the schedule to now instead of 0 (DTC's default)", Boolean.TRUE);
        State.addParameterInfo(MAXREADSCHEDULES, "Integer", "Maximum number of schedules to read at a time (0 for all)", new Integer(0));
        State.addParameterInfo(USEDTCNATIVE, "Boolean", "Use native DTC code if available", Boolean.TRUE);
        State.addParameterInfo(DTCLIBNAME, "String", "Path to the DTC native interface library", "bin/libdtc-java.so");
        this.addMouseListener(this);
        this.sliders = new ScrollbarPanel[16];
        this.values = new TextField[6];
        for (i = 0; i < 6; ++i) {
            this.criteria.insertElementAt((Object)new Float(this.defaultValues[i]), i);
        }
        for (i = 6; i < 22; ++i) {
            this.criteria.insertElementAt((Object)new Float(this.defaultSliders[i - 6]), i);
        }
    }

    public void init() {
        super.init();
        this.override = false;
        this.log = (agent.simplest.Log)State.findComponent("Log");
        this.state = (agent.simplest.State)State.findComponent("State");
        this.FAC_SCHED = this.log.getFacilityID(this);
        this.SCHEDULER = this.state.hasProperty("MassHome") ? (String)this.state.getProperty("MassHome") + "/" + (String)this.state.getProperty(DTC) : (String)this.state.getProperty(DTC);
        this.log.log("Scheduler is " + this.SCHEDULER, 2, this.FAC_SCHED);
        if (this.SCHEDULER != null) {
            this.SCHED_DIR = this.SCHEDULER.substring(0, this.SCHEDULER.lastIndexOf("/")) + "/";
            this.log.log("Scheduler output directory is " + this.SCHED_DIR, 2, this.FAC_SCHED);
        } else {
            this.log.log("Warning: Could not find path to scheduler", 1, this.FAC_SCHED);
        }
        this.state.addPropertyEventListener(this);
        if (this.hasGUI()) {
            this.controls = new Frame("Scheduler Evaluation Criteria");
            this.controls.setLayout(new BorderLayout());
            this.openCriteriaFrame((Vector)this.criteria);
            this.controls.pack();
        }
        this.dtc_native = new DTCNative();
        if (DTCNative.isNativeAvailable()) {
            this.log.log("DTC Native interface is in use.", 2, this.FAC_SCHED);
        } else {
            this.log.log("DTC Native interface is disabled.", 2, this.FAC_SCHED);
        }
        if (State.hasComponent("Observe")) {
            Observe observe = (Observe)State.findComponent("Observe");
            this.obsched = new Observer("Scheduler Calls"){

                public boolean usesEvents() {
                    return false;
                }
            };
            observe.addObserver(this.obsched);
            this.obschedtime = new Observer("Scheduler Run Time"){

                public boolean usesEvents() {
                    return false;
                }
            };
            observe.addObserver(this.obschedtime);
            this.obcache = new Observer("Schedule Cache Hits"){

                public boolean usesEvents() {
                    return false;
                }
            };
            observe.addObserver(this.obcache);
        }
    }

    public void reset() {
        int i;
        this.override = false;
        this.criteria.removeAllElements();
        for (i = 0; i < 6; ++i) {
            this.criteria.insertElementAt((Object)new Float(this.defaultValues[i]), i);
        }
        for (i = 6; i < 22; ++i) {
            this.criteria.insertElementAt((Object)new Float(this.defaultSliders[i - 6]), i);
        }
    }

    public void end() {
        if (this.controls != null) {
            this.controls.dispose();
        }
    }

    public void addScheduleEventListener(ScheduleEventListener l) {
        this.listeners.add(l);
    }

    public void removeScheduleEventListener(ScheduleEventListener l) {
        this.listeners.remove(l);
    }

    protected void fireEvent(AgentEvent event) {
        ScheduleEvent e = (ScheduleEvent)event;
        Enumeration enumr = this.listeners.elements();
        this.log.log("Firing schedule event", 4, this.FAC_SCHED);
        block4: while (enumr.hasMoreElements()) {
            ScheduleEventListener l = (ScheduleEventListener)enumr.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0: {
                    l.scheduleAdded(e);
                    continue block4;
                }
                case 1: {
                    l.scheduleException(e);
                    continue block4;
                }
            }
        }
        if (this.log != null && this.log.getLogLevel(this.FAC_SCHED) >= 2) {
            this.log.log(e, 2, this.FAC_SCHED);
        }
        this.log.log("Fired a schedule event", 5, this.FAC_SCHED);
    }

    public void openCriteriaFrame(Vector vect) {
        this.controls.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.controls.setLayout(gridbag);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.insets = new Insets(3, 5, 3, 5);
        Panel p = new Panel();
        GridBagLayout gridbag4 = new GridBagLayout();
        GridBagConstraints c4 = new GridBagConstraints();
        Label l = new Label();
        boolean begin = false;
        boolean end = false;
        for (int i = 6; i < 22; ++i) {
            if (i == 6) {
                l = new Label("Raw-Goodness");
                begin = true;
            } else if (i == 9) {
                l = new Label("Threshold/Limits");
                begin = true;
            } else if (i == 12) {
                l = new Label("Raw-Certainty");
                begin = true;
            } else if (i == 15) {
                l = new Label("Certainty Threshold");
                begin = true;
            } else if (i == 18) {
                l = new Label("Meta");
                begin = true;
            }
            if (begin) {
                p = new Panel();
                gridbag4 = new GridBagLayout();
                c4 = new GridBagConstraints();
                p.setLayout(gridbag4);
                c4.weightx = 1.0;
                c4.fill = 11;
                c4.gridwidth = 0;
                gridbag4.setConstraints(l, c4);
                p.add(l);
                begin = false;
            }
            c4.gridwidth = 1;
            c4.weightx = 1.0;
            c4.weighty = 1.0;
            c4.fill = 1;
            this.sliders[i - 6] = new ScrollbarPanel(((Float)vect.elementAt(i)).floatValue(), this.defaultLabels[i - 6]);
            gridbag4.setConstraints(this.sliders[i - 6], c4);
            if (i == 8 || i == 14 || i == 21) {
                c4.gridwidth = 0;
                gridbag4.setConstraints(this.sliders[i - 6], c4);
                p.add(this.sliders[i - 6]);
                end = true;
            } else if (i == 17 || i == 11) {
                c4.gridwidth = 0;
                gridbag4.setConstraints(this.sliders[i - 6], c4);
                p.add(this.sliders[i - 6]);
                c4.weightx = 0.0;
                c4.weighty = 0.0;
                c4.fill = 10;
                c4.gridwidth = 1;
                int min = 0;
                int max = 3;
                if (i == 17) {
                    min = 3;
                    max = 6;
                }
                for (int j = min; j < max; ++j) {
                    this.values[j] = new TextField("" + ((Float)vect.elementAt(j)).intValue(), 3);
                    if (j == 2) {
                        c4.gridwidth = 0;
                    }
                    gridbag4.setConstraints(this.values[j], c4);
                    p.add(this.values[j]);
                }
                end = true;
            } else {
                gridbag4.setConstraints(this.sliders[i - 6], c4);
                p.add(this.sliders[i - 6]);
            }
            if (!end) continue;
            if (i == 21) {
                c.gridwidth = 0;
            }
            gridbag.setConstraints(p, c);
            this.controls.add(p);
            end = false;
        }
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        Panel buttonPanel = new Panel();
        c4.fill = 10;
        c4.weightx = 0.0;
        c4.weighty = 0.0;
        c4.gridwidth = 1;
        c4.insets = new Insets(3, 10, 3, 10);
        buttonPanel.setLayout(gridbag4);
        Button ApplyButton = new Button("Apply");
        ApplyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scheduler.this.applyCriteriaFrame();
            }
        });
        gridbag4.setConstraints(ApplyButton, c4);
        buttonPanel.add(ApplyButton);
        Button CloseButton = new Button("Close");
        CloseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scheduler.this.end();
            }
        });
        c4.gridwidth = 0;
        gridbag4.setConstraints(CloseButton, c4);
        buttonPanel.add(CloseButton);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridheight = 4;
        c.gridwidth = 0;
        c.gridheight = 0;
        gridbag.setConstraints(buttonPanel, c);
        this.controls.add(buttonPanel);
        this.controls.setVisible(false);
    }

    public void applyCriteriaFrame() {
        int i;
        Vector c = new Vector(22);
        this.override = true;
        for (i = 0; i < 6; ++i) {
            this.criteria.insertElementAt((Object)new Float(this.values[i].getText()), i);
        }
        for (i = 6; i < 22; ++i) {
            this.criteria.insertElementAt((Object)new Float(this.sliders[i - 6].getValue()), i);
        }
        this.controls.setVisible(false);
    }

    public void cancelCriteriaFrame() {
        if (this.controls != null) {
            this.controls.setVisible(false);
        }
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria v) {
        if (this.controls != null && this.controls.isVisible()) {
            this.openCriteriaFrame((Vector)v);
        }
        this.criteria = v;
    }

    public synchronized void updateResourceModeler(ScheduleElement se, int offset) {
        this.log.log("Warning This method does nothing it's an abstract for the PartialOrderScheduler", 1, this.FAC_SCHED);
    }

    public Schedule delayFinishTime(Schedule s, ScheduleElement se, int offset) throws ScheduleErrorException {
        s.delayFinishTime(se, offset);
        return s;
    }

    public Schedule delayStartTime(Schedule s, ScheduleElement se, int offset) throws ScheduleErrorException {
        s.delayStartTime(se, offset);
        return s;
    }

    public Schedule setStartTime(Schedule s, int offset) throws ScheduleErrorException {
        s.setStartTime(offset);
        return s;
    }

    public boolean hasClickAction() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 500 && this.controls != null) {
            this.openCriteriaFrame((Vector)this.criteria);
            this.controls.setVisible(!this.controls.isVisible());
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void propertyChanged(PropertyEvent e) {
        block6: {
            String key;
            block13: {
                Object t;
                Schedule s;
                block14: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block5: {
                                                key = e.getKey().toString();
                                                if (!key.equals(AUTOSCHEDULE)) break block5;
                                                this.autoschedule = (Boolean)e.getProperty();
                                                break block6;
                                            }
                                            if (!key.equals(CACHESCHEDULES)) break block7;
                                            this.cacheschedules = (Boolean)e.getProperty();
                                            break block6;
                                        }
                                        if (!key.equals(CACHELIMIT)) break block8;
                                        this.cachelimit = (Integer)e.getProperty();
                                        break block6;
                                    }
                                    if (!key.equals(NUMSCHEDULES)) break block9;
                                    this.numschedules = (Integer)e.getProperty();
                                    break block6;
                                }
                                if (!key.equals(MAXREADSCHEDULES)) break block10;
                                this.maxschedules = (Integer)e.getProperty();
                                break block6;
                            }
                            if (!key.equals(AUTOSETSTARTTIME)) break block11;
                            this.autosetstarttime = (Boolean)e.getProperty();
                            break block6;
                        }
                        if (!key.equals(SCHEDULERCRITERIA)) break block12;
                        Vector v = (Vector)this.state.getProperty(SCHEDULERCRITERIA);
                        this.setCriteria((Criteria)v);
                        break block6;
                    }
                    if (!key.equals(SCHEDULE)) break block13;
                    s = (Schedule)e.getProperty();
                    t = this.state.getProperty(SimpleTaemsReader.CONTAEMS);
                    if (!(t instanceof Hashtable)) break block14;
                    Enumeration en = ((Hashtable)t).elements();
                    while (en.hasMoreElements()) {
                        t = en.nextElement();
                        ((Taems)t).setDisplayedSchedule(s);
                    }
                    break block6;
                }
                if (!(t instanceof Taems)) break block6;
                ((Taems)t).setDisplayedSchedule(s);
                break block6;
            }
            if (key.equals(SimpleTaemsReader.CONTAEMS) && this.autoschedule) {
                this.log.log("Autoscheduling...", 3, this.FAC_SCHED);
                Hashtable<String, Taems> h = null;
                if (e.getProperty() instanceof Taems) {
                    Taems t = (Taems)e.getProperty();
                    h = new Hashtable<String, Taems>();
                    h.put(t.getLabel(), t);
                } else {
                    h = (Hashtable<String, Taems>)e.getProperty();
                }
                Enumeration enumr = h.elements();
                while (enumr.hasMoreElements()) {
                    Vector v;
                    Taems t = (Taems)enumr.nextElement();
                    if (t.numSchedules() != 0 || (v = this.scheduleTaems(t, false, true)) != null) continue;
                    this.log.log("Autoschedule failed, running evaluateTaems", 1, this.FAC_SCHED);
                    this.evaluateTaems(t, false, true);
                }
            }
        }
    }

    public void propertyRemoved(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public Vector evaluateTaems(Taems taems) {
        return this.evaluateTaems(taems, false);
    }

    public Vector evaluateTaems(Taems taems, boolean rescheduling) {
        return this.evaluateTaems(taems, false, true);
    }

    public Vector evaluateTaems(Taems taems, boolean rescheduling, boolean set) {
        Vector sv;
        Taems local = (Taems)taems.clone();
        local.removeAllSchedules();
        TaskBase tb = new TaskBase();
        tb.setNonLocal(true);
        Enumeration NLM = local.findNodes((Node)tb);
        Agent agent = local.getAgent();
        while (NLM.hasMoreElements()) {
            tb = (TaskBase)NLM.nextElement();
            this.log.log("Un-nonlocl'ing " + tb.getLabel(), 3, this.FAC_SCHED);
            tb.setNonLocal(false);
            tb.setAgent(agent);
        }
        Enumeration enumr = local.findNodes((Node)new ConsumesInterrelationship());
        while (enumr.hasMoreElements()) {
            ConsumesInterrelationship NLE = (ConsumesInterrelationship)enumr.nextElement();
            if (NLE.getTo().getAgent() != null && NLE.getTo().getAgent().getLabel().equals(agent.getLabel())) continue;
            this.log.log("Excising " + NLE.getLabel(), 3, this.FAC_SCHED);
            local.exciseNode((Node)NLE);
        }
        enumr = local.findNodes((Node)new ProducesInterrelationship());
        while (enumr.hasMoreElements()) {
            ProducesInterrelationship NLEProduces = (ProducesInterrelationship)enumr.nextElement();
            if (NLEProduces.getTo().getAgent() != null && NLEProduces.getTo().getAgent().getLabel().equals(agent.getLabel())) continue;
            this.log.log("Excising " + NLEProduces.getLabel(), 3, this.FAC_SCHED);
            local.exciseNode((Node)NLEProduces);
        }
        enumr = local.findNodes((Node)new LimitsInterrelationship());
        while (enumr.hasMoreElements()) {
            LimitsInterrelationship NLELimits = (LimitsInterrelationship)enumr.nextElement();
            this.log.log("Excising " + NLELimits.getLabel(), 3, this.FAC_SCHED);
            local.exciseNode((Node)NLELimits);
        }
        enumr = local.findNodes((Node)new Task());
        while (enumr.hasMoreElements()) {
            Task t = (Task)enumr.nextElement();
            if (t.getQAF() instanceof LastQAF) {
                this.log.log("Switching QAF of " + t.getLabel(), 3, this.FAC_SCHED);
                t.getQAF().setLabel("q_seq");
                continue;
            }
            if (!(t.getQAF() instanceof SeqLastQAF)) continue;
            this.log.log("Switching QAF of " + t.getLabel(), 3, this.FAC_SCHED);
            t.getQAF().setLabel("q_seq");
        }
        enumr = new SafeEnumeration(local.getCommitments());
        while (enumr.hasMoreElements()) {
            Commitment c = (Commitment)enumr.nextElement();
            if (!c.isSpecialType()) continue;
            this.log.log("Removing commitment " + c.getLabel(), 3, this.FAC_SCHED);
            local.removeCommitment(c);
        }
        enumr = local.getNodes();
        int num = 0;
        while (enumr.hasMoreElements()) {
            Node n = (Node)enumr.nextElement();
            if (!(n instanceof Resource)) {
                ++num;
            }
            if (!(n instanceof TaskBase) || !((TaskBase)n).hasSupertasks()) continue;
            --num;
        }
        if (num > 1) {
            enumr = new SafeEnumeration(local.getNodes());
            Task mn = new Task("MasterNode", agent, (QAF)new SumQAF());
            Task task = (Task)local.findNode((Node)mn);
            if (task == null) {
                this.log.log("Adding master node task group", 3, this.FAC_SCHED);
                task = mn;
                local.addNode((Node)task);
            } else {
                this.log.log("Using existing master node", 3, this.FAC_SCHED);
            }
            while (enumr.hasMoreElements()) {
                Object o = enumr.nextElement();
                if (!(o instanceof TaskBase) || ((TaskBase)o).hasSupertasks()) continue;
                tb = (TaskBase)o;
                task.addSubtask(tb);
                if (tb.getDeadline() != Integer.MIN_VALUE) {
                    if (task.getDeadline() == Integer.MIN_VALUE) {
                        this.log.log("Migrating deadline on task " + tb.getLabel() + " to " + task.getLabel(), 3, this.FAC_SCHED);
                        task.setDeadline(tb.getDeadline());
                    } else {
                        this.log.log("Warning, ignoring deadline on task " + tb.getLabel(), 1, this.FAC_SCHED);
                    }
                    tb.unsetDeadline();
                }
                if (tb.getEarliestStartTime() != Integer.MIN_VALUE) {
                    if (task.getEarliestStartTime() == Integer.MIN_VALUE) {
                        this.log.log("Migrating earliest start time on task " + tb.getLabel() + " to " + task.getLabel(), 3, this.FAC_SCHED);
                        task.setEarliestStartTime(tb.getEarliestStartTime());
                    } else {
                        this.log.log("Warning, ignoring earliest start time on task " + tb.getLabel(), 1, this.FAC_SCHED);
                    }
                    tb.setEarliestStartTime(Integer.MIN_VALUE);
                }
                local.removeNode((Node)tb);
            }
        }
        enumr = local.findNodes((Node)new Method());
        boolean found = false;
        while (enumr.hasMoreElements()) {
            Method m = (Method)enumr.nextElement();
            if (m.hasFinished()) continue;
            found = true;
            if (!m.hasStarted()) continue;
            this.log.log("Adding finish time to running method " + m.getLabel(), 3, this.FAC_SCHED);
            m.setFinishTime(m.getStartTime() + 1);
        }
        if (!found) {
            this.log.log("Warning, no unexecuted methods found in task structure (no schedule produced)", 1, this.FAC_SCHED);
            sv = new Vector();
        } else {
            sv = this.scheduleTaems(local, rescheduling, false);
        }
        if (set) {
            if (sv != null && sv.size() > 0) {
                taems.setScheduleVector(sv);
                this.startFireEvent(new ScheduleEvent(this, (Schedule)sv.firstElement(), taems, 0));
            } else {
                this.startFireEvent(new ScheduleEvent(this, null, taems, new ScheduleErrorException("No schedule generated"), 1));
            }
        }
        return sv;
    }

    public Vector scheduleTaems(Taems taems) {
        return this.scheduleTaems(taems, false);
    }

    public Vector scheduleTaems(Taems taems, boolean rescheduling) {
        return this.scheduleTaems(taems, rescheduling, true);
    }

    public synchronized Vector scheduleTaems(Taems taems, boolean rescheduling, boolean set) {
        int exit_value;
        Vector sv = null;
        Object cachekey = null;
        if (this.obsched != null) {
            this.obsched.updateCount(1.0);
        }
        this.log.log("Schedule taems start on " + taems.getLabel(), 5, this.FAC_SCHED);
        if (this.cacheschedules) {
            cachekey = this.generateCacheKey(taems);
            if (this.cache.containsKey(cachekey)) {
                this.log.log("Using cached copy of schedule with key " + cachekey, 3, this.FAC_SCHED);
                if (this.obcache != null) {
                    this.obcache.updateCount(1.0);
                }
                StringBuffer buf = (StringBuffer)this.cache.get(cachekey);
                sv = this.readSchedules(new StringReader(buf.toString()));
                if (set) {
                    taems.setScheduleVector(sv);
                    this.startFireEvent(new ScheduleEvent(this, (Schedule)sv.firstElement(), taems, 0));
                }
                this.log.log("Schedule taems cache end on " + taems.getLabel(), 5, this.FAC_SCHED);
                return sv;
            }
            this.log.log("No cached copy found for key " + cachekey, 3, this.FAC_SCHED);
        }
        if (!this.override) {
            if (taems.getScheduleCriteria() != null) {
                this.setCriteria(taems.getScheduleCriteria());
            } else {
                taems.setScheduleCriteria(this.criteria);
            }
        } else {
            taems.setScheduleCriteria(this.criteria);
        }
        String name = (String)this.state.getProperty("Name");
        String DTCparameters = "";
        if (rescheduling) {
            int time = (Integer)this.state.getProperty("Time");
            float cost = taems.getNode().getCurrentCost();
            DTCparameters = DTCparameters + "(spec_attributes\n";
            DTCparameters = DTCparameters + "   (time_to_schedule_for Float " + time + ")\n";
            DTCparameters = DTCparameters + "   (cost_accrued Float " + cost + ")\n";
            DTCparameters = DTCparameters + ")\n";
        }
        if (DTCNative.isNativeAvailable()) {
            String sched_input = rescheduling ? DTCparameters + taems.toTTaems(1.01f) : taems.toTTaems(1.01f);
            long start = System.currentTimeMillis();
            String result = this.dtc_native.call_dtc(this.numschedules, "p", 50, 100, 0, sched_input, false);
            long finish = System.currentTimeMillis();
            if (this.obschedtime != null) {
                this.obschedtime.updateCount(finish - start);
            }
            if (result == null) {
                exit_value = 1;
            } else {
                exit_value = 0;
                if (this.cacheschedules && cachekey != null) {
                    this.cacheSchedules(cachekey, result);
                    StringBuffer buf = (StringBuffer)this.cache.get(cachekey);
                    if (buf != null) {
                        sv = this.parseSchedules(result);
                    } else {
                        this.log.log("Warning: Apparently cached taems structure isn't actually cached", 1, this.FAC_SCHED);
                        sv = this.parseSchedules(result);
                    }
                } else {
                    sv = this.parseSchedules(result);
                }
            }
        } else {
            if (!this.state.hasProperty(DTC)) {
                this.log.log("Cannot schedule task structure because DTC location has not been specified", 0, this.FAC_SCHED);
                return null;
            }
            this.log.log("Generating schedule", 2, this.FAC_SCHED);
            try {
                String str = this.SCHED_DIR + name + ".ttaems";
                this.log.log("Writing task to " + str, 3, this.FAC_SCHED);
                FileWriter taskfile = new FileWriter(str);
                if (rescheduling) {
                    taskfile.write(DTCparameters);
                }
                taskfile.write(taems.toTTaems(1.01f));
                taskfile.close();
            }
            catch (IOException e) {
                this.log.log("Error:  write TTAEMS " + e, 0, this.FAC_SCHED);
                return null;
            }
            long start = System.currentTimeMillis();
            try {
                String cmd = this.state.hasProperty(DTCOVERRIDE) ? (String)this.state.getProperty(DTCOVERRIDE) : this.SCHEDULER + " " + this.numschedules + " p 50 100 0";
                cmd = cmd + " " + this.SCHED_DIR + name + ".ttaems" + " " + this.SCHED_DIR + name + " 0";
                this.log.log("Running " + cmd, 3, this.FAC_SCHED);
                Process sched = Runtime.getRuntime().exec(cmd);
                BufferedReader schedout = new BufferedReader(new InputStreamReader(sched.getInputStream()));
                BufferedReader schederr = new BufferedReader(new InputStreamReader(sched.getErrorStream()));
                while (true) {
                    try {
                        while (schederr.ready()) {
                            this.log.log("! " + schederr.readLine(), 3, this.FAC_SCHED);
                        }
                        while (schedout.ready()) {
                            this.log.log("> " + schedout.readLine(), 3, this.FAC_SCHED);
                        }
                        exit_value = sched.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        Thread.currentThread();
                        Thread.sleep(100L);
                        continue;
                    }
                    break;
                }
                this.log.log("Scheduler finished with status " + exit_value, 4, this.FAC_SCHED);
            }
            catch (InterruptedException e) {
                this.log.log("Error: " + e, 0, this.FAC_SCHED);
                return null;
            }
            catch (IOException e) {
                this.log.log("Error: Running DTC " + e, 0, this.FAC_SCHED);
                e.printStackTrace();
                return null;
            }
            long finish = System.currentTimeMillis();
            if (this.obschedtime != null) {
                this.obschedtime.updateCount(finish - start);
            }
            if (exit_value == 0) {
                if (this.cacheschedules && cachekey != null) {
                    this.cacheSchedules(cachekey, this.SCHED_DIR, name + ".ttaems_schedules");
                    StringBuffer buf = (StringBuffer)this.cache.get(cachekey);
                    if (buf != null) {
                        sv = this.readSchedules(new StringReader(buf.toString()));
                    } else {
                        this.log.log("Warning: Apparently cached taems structure isn't actually cached", 1, this.FAC_SCHED);
                        sv = this.readSchedules(this.SCHED_DIR, name + ".ttaems_schedules");
                    }
                } else {
                    sv = this.readSchedules(this.SCHED_DIR, name + ".ttaems_schedules");
                }
            }
        }
        if (exit_value == 0) {
            if (sv == null) {
                this.log.log("Error: null schedule was returned", 0, this.FAC_SCHED);
            } else if (sv.size() == 0) {
                this.log.log("Warning: Empty schedule was returned", 1, this.FAC_SCHED);
            } else {
                this.log.log(sv.size() + " schedule(s) were returned", 2, this.FAC_SCHED);
            }
            if (set) {
                if (sv != null && sv.size() > 0) {
                    taems.setScheduleVector(sv);
                    this.startFireEvent(new ScheduleEvent(this, (Schedule)sv.firstElement(), taems, 0));
                } else {
                    this.startFireEvent(new ScheduleEvent(this, null, taems, new ScheduleErrorException("No schedule generated"), 1));
                }
            }
            this.log.log("Schedule taems end on " + taems.getLabel(), 5, this.FAC_SCHED);
            return sv;
        }
        this.log.log("Error: in execution of DTC, exit value was " + exit_value, 0, this.FAC_SCHED);
        this.startFireEvent(new ScheduleEvent(this, null, taems, new ScheduleErrorException("Error in DTC execution"), 1));
        return null;
    }

    protected Vector parseSchedules(String schedules) {
        if (this.parser == null) {
            this.parser = new ReadTTaems(Log.getDefault());
        }
        StringBuffer buf = new StringBuffer();
        int count = 0;
        int loc = 0;
        if (this.maxschedules > 0) {
            try {
                for (count = 0; count < this.maxschedules; ++count) {
                    char c;
                    do {
                        if (loc >= schedules.length()) {
                            throw new EOFException();
                        }
                        c = schedules.charAt(loc++);
                        buf.append(c);
                    } while (c != '(');
                    int parens = 1;
                    while (parens > 0) {
                        if (loc >= schedules.length()) {
                            throw new EOFException();
                        }
                        char c2 = schedules.charAt(loc++);
                        buf.append(c2);
                        if (c2 == ')') {
                            --parens;
                            continue;
                        }
                        if (c2 != '(') continue;
                        ++parens;
                    }
                }
            }
            catch (EOFException e) {
                this.log.log("End of schedule string reached.", 4, this.FAC_SCHED);
            }
            schedules = buf.toString();
        }
        StringReader r = new StringReader(schedules);
        Vector sv = null;
        try {
            Taems task = this.parser.readTTaems((Reader)r);
            sv = task.getScheduleVector();
            this.log.log("" + sv.size() + " schedules(s) read in.", 2, this.FAC_SCHED);
            if (sv != null) {
                Enumeration e = sv.elements();
                while (e.hasMoreElements()) {
                    Schedule schedule = (Schedule)e.nextElement();
                    int time = (Integer)this.state.getProperty("Time");
                    if (this.autosetstarttime && time != 0) {
                        schedule.setStartTime(time);
                    }
                    Enumeration e1 = schedule.getElements();
                    while (e1.hasMoreElements()) {
                        ScheduleElement se = (ScheduleElement)e1.nextElement();
                        if (!se.getLabel().startsWith("Slack_MyTime")) continue;
                        schedule.removeScheduleElement(se);
                    }
                }
            }
        }
        catch (Error e) {
            this.log.log("Error parsing Taems schedule: " + e, 0, this.FAC_SCHED);
            this.log.log("Schedules: " + schedules, 0, this.FAC_SCHED);
        }
        catch (Exception e) {
            this.log.log("Error parsing Taems schedule: " + e, 0, this.FAC_SCHED);
            this.log.log("Schedules: " + schedules, 0, this.FAC_SCHED);
        }
        return sv;
    }

    protected Vector readSchedules(String path, String file) {
        File fd = new File(path, file);
        if (fd.exists()) {
            try {
                String filename = path + file;
                FileInputStream is = new FileInputStream(filename);
                Vector sv = this.readSchedules(new InputStreamReader(is));
                return sv;
            }
            catch (FileNotFoundException e) {
                this.log.log("Error: " + e, 0, this.FAC_SCHED);
                return null;
            }
        }
        this.log.log("Error: " + path + file + " was not created by the scheduler", 0, this.FAC_SCHED);
        return null;
    }

    protected Vector readSchedules(Reader r) {
        if (this.parser == null) {
            this.parser = new ReadTTaems(Log.getDefault());
        }
        if (r != null) {
            this.lastreader = r;
        } else {
            r = this.lastreader;
        }
        if (r == null) {
            this.log.log("Warning: readSchedules called with null Reader.", 1, this.FAC_SCHED);
            return new Vector();
        }
        if (this.maxschedules > 0) {
            StringBuffer buf = new StringBuffer();
            int count = 0;
            try {
                for (count = 0; count < this.maxschedules; ++count) {
                    int c;
                    do {
                        if ((c = r.read()) < 0) {
                            throw new EOFException();
                        }
                        buf.append((char)c);
                    } while (c != 40);
                    int parens = 1;
                    while (parens > 0) {
                        int c2 = r.read();
                        if (c2 < 0) {
                            throw new EOFException();
                        }
                        buf.append((char)c2);
                        if (c2 == 41) {
                            --parens;
                            continue;
                        }
                        if (c2 != 40) continue;
                        ++parens;
                    }
                }
            }
            catch (EOFException e) {
                this.log.log("End of schedule file reached.", 4, this.FAC_SCHED);
            }
            catch (IOException e) {
                this.log.log("Error reading schedules: " + e.toString(), 0, this.FAC_SCHED);
            }
            if (count == 0) {
                return new Vector();
            }
            r = new StringReader(buf.toString());
        }
        try {
            if (!r.ready()) {
                this.log.log("Reader in readSchedules is not ready", 1, this.FAC_SCHED);
                return new Vector();
            }
        }
        catch (IOException e) {
            this.log.log("Reader in readSchedules is not ready: " + e, 1, this.FAC_SCHED);
            return new Vector();
        }
        Taems task = this.parser.readTTaems(r);
        Vector sv = task.getScheduleVector();
        this.log.log("" + sv.size() + " schedules(s) read in.", 2, this.FAC_SCHED);
        if (sv != null) {
            Enumeration e = sv.elements();
            while (e.hasMoreElements()) {
                Schedule schedule = (Schedule)e.nextElement();
                int time = (Integer)this.state.getProperty("Time");
                if (this.autosetstarttime && time != 0) {
                    schedule.setStartTime(time);
                }
                Enumeration e1 = schedule.getElements();
                while (e1.hasMoreElements()) {
                    ScheduleElement se = (ScheduleElement)e1.nextElement();
                    if (!se.getLabel().startsWith("Slack_MyTime")) continue;
                    schedule.removeScheduleElement(se);
                }
            }
        }
        return sv;
    }

    public Vector readMoreSchedules() {
        return this.readSchedules(null);
    }

    protected Object generateCacheKey(Taems taems) {
        StringBuffer buf = new StringBuffer("");
        Enumeration e = taems.getNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (!(n instanceof Task)) continue;
            Task t = (Task)n;
            buf.append(t.getLabel());
            buf.append(String.valueOf(t.getEarliestStartTime()));
            buf.append(String.valueOf(t.getDeadline()));
        }
        e = taems.findNodes((Node)new Method());
        while (e.hasMoreElements()) {
            Method m = (Method)e.nextElement();
            buf.append(m.getLabel());
            buf.append(String.valueOf(m.getEarliestStartTime()));
            buf.append(String.valueOf(m.getDeadline()));
            buf.append(m.getGlobalOutcome().getDuration().calculateMax());
            buf.append(m.getCurrentQuality());
        }
        e = taems.findNodes((Node)new Interrelationship());
        while (e.hasMoreElements()) {
            Interrelationship i = (Interrelationship)e.nextElement();
            buf.append(i.getLabel());
            if (i.getQuality() != null) {
                buf.append(i.getQuality().calculateMax());
            }
            if (i.getCost() != null) {
                buf.append(i.getCost().calculateMax());
            }
            if (i.getDuration() == null) continue;
            buf.append(i.getDuration().calculateMax());
        }
        return buf.toString();
    }

    protected void cacheSchedules(Object key, String schedules) {
        while (this.cachelimit > 0 && this.cache.size() > this.cachelimit) {
            Object k = this.cache.keys().nextElement();
            this.log.log("Cache limit reached, removing key " + k.toString(), 4, this.FAC_SCHED);
            if (this.cache.remove(k) != null) continue;
            break;
        }
        StringBuffer buf = new StringBuffer(schedules);
        this.cache.put(key, buf);
        if (this.log.getLogLevel(this.FAC_SCHED) >= 5) {
            this.log.log("Schedule stored with key " + key, 5, this.FAC_SCHED);
            this.log.log("Number of schedules now cached: " + this.cache.size(), 5, this.FAC_SCHED);
        }
    }

    protected void cacheSchedules(Object key, String path, String file) {
        File fd = new File(path, file);
        if (fd.exists()) {
            try {
                String filename = path + file;
                FileInputStream is = new FileInputStream(filename);
                InputStreamReader ir = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(ir);
                StringBuffer buf = new StringBuffer();
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        buf.append(line);
                    }
                }
                catch (IOException e) {
                    this.log.log("Error reading from schedule: " + e, 0, this.FAC_SCHED);
                    return;
                }
                while (this.cachelimit > 0 && this.cache.size() > this.cachelimit) {
                    Object k = this.cache.keys().nextElement();
                    this.log.log("Cache limit reached, removing key " + k.toString(), 4, this.FAC_SCHED);
                    if (this.cache.remove(k) != null) continue;
                    break;
                }
                this.cache.put(key, buf);
                if (this.log.getLogLevel(this.FAC_SCHED) >= 5) {
                    this.log.log("Schedule stored with key " + key, 5, this.FAC_SCHED);
                    this.log.log("Number of schedules now cached: " + this.cache.size(), 5, this.FAC_SCHED);
                }
            }
            catch (FileNotFoundException e) {
                this.log.log("Error: " + e, 0, this.FAC_SCHED);
                return;
            }
        }
    }

    class ScrollbarPanel
    extends Panel {
        private Label display;
        private Label l;
        private Scrollbar scroll;

        public ScrollbarPanel(float val, String label) {
            this((int)(val * 100.0f), label);
        }

        public ScrollbarPanel(int val, String label) {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            this.display = new Label("0000");
            this.l = new Label(label);
            this.scroll = new Scrollbar(1, val, 1, 0, 101);
            this.scroll.addAdjustmentListener(new AdjustmentListener(this){
                private final /* synthetic */ ScrollbarPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    ScrollbarPanel.access$100(this.this$1).setText(String.valueOf(ScrollbarPanel.access$000(this.this$1).getValue()));
                }
            });
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridheight = 2;
            gridbag.setConstraints(this.scroll, c);
            this.add(this.scroll);
            c.weighty = 0.0;
            c.gridwidth = 0;
            c.gridheight = 1;
            gridbag.setConstraints(this.l, c);
            this.add(this.l);
            gridbag.setConstraints(this.display, c);
            this.add(this.display);
            this.display.setText(String.valueOf(this.scroll.getValue()));
        }

        public int getValue() {
            return this.scroll.getValue();
        }

        static /* synthetic */ Scrollbar access$000(ScrollbarPanel x0) {
            return x0.scroll;
        }

        static /* synthetic */ Label access$100(ScrollbarPanel x0) {
            return x0.display;
        }
    }
}

