/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.mass.Scheduler;
import agent.simplest.PropertyEvent;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Taems;
import utilities.Distribution;

public class RandomScheduler
extends Scheduler {
    protected Random rand;

    public RandomScheduler() {
        RandomScheduler randomScheduler = this;
        this.rand = randomScheduler.state.getRandom();
    }

    public void init() {
        super.init();
    }

    public void reset() {
        super.init();
    }

    public void end() {
        super.end();
    }

    public Vector scheduleTaems(Taems taems, boolean rescheduling, boolean set) {
        this.log.log("Scheduling... ", 2, this.FAC_SCHED);
        Vector<Method> tmpvec = new Vector<Method>();
        Vector<String> schedule = new Vector<String>();
        Vector<ScheduleElement> schedVec = new Vector<ScheduleElement>();
        if (taems != null) {
            taems.setScheduleVector(null);
            int time = 0;
            Enumeration e = taems.findNodes((Node)new Method());
            while (e.hasMoreElements()) {
                tmpvec.addElement((Method)e.nextElement());
            }
            int sizemax = tmpvec.size();
            for (int i = 0; i < sizemax; ++i) {
                int pos = 0;
                if (tmpvec.size() > 1) {
                    pos = Math.abs(this.rand.nextInt()) % tmpvec.size();
                }
                Method tmpelem = (Method)tmpvec.elementAt(pos);
                Outcome outcome = tmpelem.getGlobalOutcome();
                tmpvec.removeElement(tmpelem);
                ScheduleElement schElement = new ScheduleElement(tmpelem, new Distribution(new Float(time), new Float(1.0)), new Distribution(new Float((float)time + outcome.getDuration().calculateAvg()), new Float(1.0)), outcome.getQuality(), outcome.getDuration(), outcome.getCost(), null, null);
                time += (int)outcome.getDuration().calculateAvg();
                schedVec.addElement(schElement);
                schedule.addElement(schElement.getLabel());
            }
            Schedule s = new Schedule();
            s.setScheduleElements(schedVec);
            Vector<Schedule> sV = new Vector<Schedule>();
            sV.addElement(s);
            if (set) {
                taems.setScheduleVector(sV);
            }
            this.log.log("Done Scheduling ", 2, this.FAC_SCHED);
            return sV;
        }
        this.log.log("The TAEMS structure was empty ! ", 0, this.FAC_SCHED);
        return null;
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase("RandomSeed")) {
            RandomScheduler randomScheduler = this;
            this.rand = randomScheduler.state.getRandom();
            this.log.log("New Random Seed = " + this.rand, 5, this.FAC_SCHED);
        } else {
            super.propertyChanged(e);
        }
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }
}

