/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.base.AgentComponent;
import agent.mass.Communicate;
import agent.mass.Control;
import agent.mass.Execute;
import agent.mass.Scheduler;
import agent.mass.State;
import agent.simplest.ActionEvent;
import agent.simplest.ActionEventListener;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import java.awt.Frame;
import java.util.Vector;
import taems.Taems;

public class ProblemSolver
extends AgentComponent
implements MessageEventListener,
PropertyEventListener,
ActionEventListener {
    static final long serialVersionUID = 1234567890L;
    protected Communicate communicate;
    protected State state;
    protected Log log;
    protected Execute execute;
    protected int FAC_PS;
    private Frame display;

    public ProblemSolver() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Communicate");
        this.addDependency("Execute");
        State.addParameterInfo("MassHome", "String", "Pathname for the Mass home directory");
    }

    public void init() {
        this.log = (Log)State.findComponent("Log");
        this.state = (State)State.findComponent("State");
        this.communicate = (Communicate)State.findComponent("Communicate");
        this.execute = (Execute)State.findComponent("Execute");
        this.FAC_PS = this.log.getFacilityID("ProblemSolver");
        this.state.addPropertyEventListener(this);
        this.communicate.addMessageEventListener(this);
        this.execute.addActionEventListener(this);
    }

    public void begin() {
    }

    public void messageSent(MessageEvent e) {
    }

    public void messageReceived(MessageEvent e) {
    }

    public void propertyChanged(PropertyEvent e) {
        Taems taems;
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase("ConTaemsTask") && this.getClass().getSuperclass().getName().equalsIgnoreCase("agent.base.AgentComponent") && ((taems = (Taems)e.getProperty()).getFirstSchedule() == null || taems.getFirstSchedule().size() == 0)) {
            this.log.log("New task structure detected, generating schedule", 2, this.FAC_PS);
            Scheduler scheduler = (Scheduler)State.findComponent("Scheduler");
            if (scheduler != null) {
                Vector v = scheduler.scheduleTaems(taems);
                this.log.log("Got " + v.size() + " schedules, selecting the first one", 0, this.FAC_PS);
                taems.setScheduleVector(v);
                this.log.log("Schedule: " + taems.getFirstSchedule(), 3, this.FAC_PS);
                this.state.setProperty("ConTaemsTask", taems);
            } else {
                this.log.log("Error, scheduler not found", 0, this.FAC_PS);
            }
        }
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void actionStarted(ActionEvent e) {
    }

    public void actionAborted(ActionEvent e) {
    }

    public void actionCompleted(ActionEvent e) {
        Taems conditional;
        if (this.getClass().getSuperclass().getName().equalsIgnoreCase("agent.base.AgentComponent") && (conditional = (Taems)this.state.getProperty("ConTaemsTask")).getFirstSchedule() != null && conditional.getFirstSchedule().isCompleted() && !this.execute.isExecuting()) {
            ((Control)State.findComponent("Control")).quit();
        }
    }
}

