/*
 * Decompiled with CFR 0.152.
 */
package agent.mass;

import agent.mass.SimpleTaemsReader;
import agent.mass.State;
import agent.simplest.MessageEvent;
import agent.simplest.PropertyEvent;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import taems.Taems;
import taems.preprocessor.PreProcessor;
import taems.preprocessor.PreProcessorParser;
import utilities.KQMLMessage;

public class PreprocessTaemsReader
extends SimpleTaemsReader {
    static final long serialVersionUID = 1234567890L;
    protected String defaultPreprocessor = null;
    protected Hashtable defaultHT = new Hashtable();
    protected Hashtable preprocessorList = new Hashtable();
    public static final String PRETAEMS = "PreTaems";

    public PreprocessTaemsReader() {
        State.addParameterInfo(PRETAEMS, "String", "Preprocessor-style Taems definition file");
    }

    public void init() {
        super.init();
        String name = (String)this.state.getProperty(PRETAEMS);
        if (name != null && this.getPreprocessor(name) != null) {
            this.defaultPreprocessor = name;
        }
    }

    public PreProcessor getPreprocessor(String name) {
        if (this.preprocessorList.contains(name)) {
            return (PreProcessor)this.preprocessorList.get(name);
        }
        BufferedReader file = this.state.getExtendedEntryReader(name);
        PreProcessor preprocessor = null;
        if (file != null) {
            try {
                PreProcessorParser parser = new PreProcessorParser((Reader)file);
                preprocessor = parser.Input();
                this.preprocessorList.put(name, preprocessor);
            }
            catch (Exception e) {
                this.log.log("Error finding preprocessor input file " + name, 0, this.FAC_ORGDES);
                e.printStackTrace();
            }
        } else {
            this.log.log("Error accessing PreTaems file: " + name, 0, this.FAC_ORGDES);
            return null;
        }
        return preprocessor;
    }

    public void begin() {
        super.begin();
    }

    public void reset() {
        this.defaultHT = new Hashtable();
        if (this.state.hasProperty("RandomSeed")) {
            this.defaultHT.put("RandomSeed", (Long)this.state.getProperty("RandomSeed"));
        }
        Enumeration e = this.preprocessorList.keys();
        while (e.hasMoreElements()) {
            PreProcessor pre = (PreProcessor)this.preprocessorList.get(e.nextElement());
            pre.reset();
        }
        super.reset();
    }

    public void setDefaultHashtable(Hashtable ht) {
        this.defaultHT = ht;
    }

    public Enumeration getHashtableKeys() {
        return this.defaultHT.keys();
    }

    public Object getHashtableValue(Object k) {
        return this.defaultHT.get(k);
    }

    public void setHashtableKey(Object k, Object v) {
        if (k == null) {
            this.log.log("Warning: null key hashtable add attempted", 1, this.FAC_ORGDES);
            return;
        }
        if (v != null) {
            this.log.log("Adding hashtable key [" + k + ":" + v + "]", 3, this.FAC_ORGDES);
            this.defaultHT.put(k, v);
        } else {
            this.removeHashtableKey(k);
        }
    }

    public void removeHashtableKey(Object k) {
        if (k == null) {
            this.log.log("Warning: null key hashtable remove attempted", 1, this.FAC_ORGDES);
            return;
        }
        this.log.log("Removing hashtable key [" + k + "]", 3, this.FAC_ORGDES);
        this.defaultHT.remove(k);
    }

    public Taems makeTaemsStructure(Hashtable ht) {
        return this.makeTaemsStructure(ht, this.defaultPreprocessor);
    }

    public Taems makeTaemsStructure(Hashtable ht, String file) {
        PreProcessor preprocessor = this.getPreprocessor(file);
        if (preprocessor == null) {
            this.log.log("Warning: No preprocessor found", 0, this.FAC_ORGDES);
            return null;
        }
        this.setHashtableKey("Time", (Integer)this.state.getProperty("Time"));
        Enumeration e = this.getHashtableKeys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ht.put(key, this.getHashtableValue(key));
        }
        this.log.log("Generating task structure", 3, this.FAC_ORGDES);
        if (preprocessor != null) {
            preprocessor.reset();
            try {
                Taems task = this.readTTaems(new StringReader(preprocessor.toTTaems(ht)));
                return task;
            }
            catch (Throwable e2) {
                this.log.log("Error reading taems structure: " + e2, 0, this.FAC_ORGDES);
                e2.printStackTrace();
                System.err.println(preprocessor.toTTaems(ht));
                return null;
            }
        }
        this.log.log("Error, no PreProcessor file read.", 0, this.FAC_ORGDES);
        return null;
    }

    public void makeAllStructures(Hashtable ht) {
        ++NUM;
        this.makeObjectiveStructure(ht, true);
        this.makeSubjectiveStructure(ht, true);
        this.makeConditionalStructure(ht, true);
    }

    public Taems makeConditionalStructure(Hashtable ht, boolean set) {
        return this.makeConditionalStructure(this.defaultPreprocessor, ht, set);
    }

    public Taems makeConditionalStructure(String file, Hashtable ht, boolean set) {
        if (this.defaultPreprocessor != null) {
            this.setHashtableKey("View", "Conditional");
            this.log.log("Generating conditional task structure", 2, this.FAC_ORGDES);
            Taems task = this.makeTaemsStructure(ht, file);
            this.removeHashtableKey("View");
            if (task != null) {
                if (task.getLabel() == null || task.getLabel().equals("")) {
                    task.setLabel("Structure_" + NUM);
                }
                if (set) {
                    task = this.storeTaems(CONTAEMS, task);
                }
                this.log.log("Generated conditioned task structure", 5, this.FAC_ORGDES);
                return task;
            }
        } else {
            return super.makeConditionalStructure(true);
        }
        this.log.log("Error, taems generation failed.", 0, this.FAC_ORGDES);
        this.log.log("Conditioned generation failed", 1, this.FAC_ORGDES);
        return null;
    }

    public Taems makeConditionalStructure(boolean set) {
        return this.makeConditionalStructure(this.defaultPreprocessor, new Hashtable(), set);
    }

    public Taems makeSubjectiveStructure(Hashtable ht, boolean set) {
        return this.makeSubjectiveStructure(this.defaultPreprocessor, ht, set);
    }

    public Taems makeSubjectiveStructure(String file, Hashtable ht, boolean set) {
        if (this.defaultPreprocessor != null) {
            this.setHashtableKey("View", "Subjective");
            this.log.log("Generating subjective task structure", 2, this.FAC_ORGDES);
            Taems task = this.makeTaemsStructure(ht, file);
            this.removeHashtableKey("View");
            if (task != null) {
                if (task.getLabel() == null || task.getLabel().equals("")) {
                    task.setLabel("Structure_" + NUM);
                }
                if (set) {
                    task = this.storeTaems(SUBTAEMS, task);
                }
                this.log.log("Generated subjective task structure", 5, this.FAC_ORGDES);
                return task;
            }
        } else {
            return super.makeSubjectiveStructure(true);
        }
        this.log.log("Error, taems generation failed.", 0, this.FAC_ORGDES);
        this.log.log("Subjective generation failed", 1, this.FAC_ORGDES);
        return null;
    }

    public Taems makeSubjectiveStructure(boolean set) {
        return this.makeSubjectiveStructure(this.defaultPreprocessor, new Hashtable(), set);
    }

    public Taems makeObjectiveStructure(String file, Hashtable ht, boolean send) {
        if (this.defaultPreprocessor != null) {
            this.setHashtableKey("View", "Objective");
            this.log.log("Generating objective task structure", 2, this.FAC_ORGDES);
            Taems task = this.makeTaemsStructure(ht, file);
            this.removeHashtableKey("View");
            if (task != null) {
                if (task.getLabel() == null || task.getLabel().equals("")) {
                    task.setLabel("Structure_" + NUM);
                }
                task = this.handleNewObjectiveStructure(task, send);
                this.log.log("Generated objective task structure", 5, this.FAC_ORGDES);
                return task;
            }
        } else {
            return super.makeObjectiveStructure(true);
        }
        this.log.log("Error, taems generation failed.", 0, this.FAC_ORGDES);
        this.log.log("Objective generation failed", 1, this.FAC_ORGDES);
        return null;
    }

    public Taems makeObjectiveStructure(Hashtable ht, boolean send) {
        return this.makeObjectiveStructure(this.defaultPreprocessor, ht, send);
    }

    public Taems makeObjectiveStructure(boolean send) {
        return this.makeObjectiveStructure(this.defaultPreprocessor, new Hashtable(), send);
    }

    public void messageReceived(MessageEvent e) {
        String word;
        super.messageReceived(e);
        if (e.getConnection().getType() != 1) {
            return;
        }
        KQMLMessage m = (KQMLMessage)e.getMessage();
        String perf = m.getPerformative();
        if (perf.equalsIgnoreCase("tell") && (word = m.contentWord()).equalsIgnoreCase("PreprocessKey")) {
            String key = m.contentData();
            String value = key.substring(key.indexOf(" ") + 1);
            key = key.substring(0, key.indexOf(" "));
            if (value == null || value.equalsIgnoreCase("null")) {
                this.removeHashtableKey(key);
            } else {
                this.setHashtableKey(key, value);
            }
        }
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase("RandomSeed")) {
            this.setHashtableKey("RandomSeed", (Long)e.getProperty());
        } else if (key.equalsIgnoreCase("Name")) {
            this.setHashtableKey("Name", e.getProperty());
        }
        super.propertyChanged(e);
    }
}

